note

	description:

		"Cursors for bilinked list traversals"

	library: "Gobo Eiffel Structures Library"
	copyright: "Copyright (c) 1999-2001, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2012-08-22 12:54:13 -0700 (Wed, 22 Aug 2012) $"
	revision: "$Revision: 89387 $"

class DS_BILINKED_LIST_CURSOR [G]

inherit

	DS_LINKED_LIST_CURSOR [G]
		redefine
			container,
			current_cell,
			next_cursor
		end

create

	make

feature -- Access

	container: DS_BILINKED_LIST [G]
			-- List traversed

feature {DS_LINKED_LIST, DS_LINKED_LIST_CURSOR} -- Implementation

	current_cell: DS_BILINKABLE [G]
			-- Cell at cursor position

feature {DS_BILINKED_LIST} -- Implementation

	next_cursor: DS_BILINKED_LIST_CURSOR [G]
			-- Next cursor
			-- (Used by `container' to keep track of traversing
			-- cursors (i.e. cursors associated with `container'
			-- and which are not currently `off').)

end
