note

	description:

		"ECF Eiffel system parsers"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2008-2012, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2013-01-21 22:56:33 -0800 (Mon, 21 Jan 2013) $"
	revision: "$Revision: 90776 $"

class ET_ECF_SYSTEM_PARSER

inherit

	ET_ECF_PARSER
		redefine
			parse_file
		end

create

	make, make_standard, make_with_factory

feature -- Status report

	finalize_mode: BOOLEAN
			-- Is system to be compiled in finalize mode?

feature -- Status setting

	set_finalize_mode (b: BOOLEAN)
			-- Set `finalize_mode' to `b'.
		do
			finalize_mode := b
		ensure
			finalize_mode_set: finalize_mode = b
		end

feature -- Access

	last_system: ET_ECF_SYSTEM
			-- Eiffel system being parsed

feature -- Parsing

	parse_file (a_file: KI_CHARACTER_INPUT_STREAM)
			-- Parse ECF file `a_file'.
		do
			last_system := Void
			precursor (a_file)
			parsed_libraries.wipe_out
			parsed_dotnet_assemblies.wipe_out
		end

feature {NONE} -- Element change

	build_system_config (an_element: XM_ELEMENT; a_position_table: XM_POSITION_TABLE; a_filename: STRING)
			-- Build system config from `an_element'.
		local
			l_system: ET_ECF_SYSTEM
			l_state: ET_ECF_STATE
			l_targets: ET_ECF_TARGETS
			l_target: ET_ECF_TARGET
		do
			l_system := new_system (an_element, a_position_table, a_filename)
			l_targets := l_system.targets
-- TODO: we need to be able to select the target.
			if l_targets /= Void and then not l_targets.is_empty then
					-- Use last target as default target.
				l_target := l_targets.target (l_targets.count)
			else
					-- No target found in the ECF file.
					-- Error already reported in `fill_system_config'.
			end
			if l_target /= Void then
				create l_state.make (l_target, ise_version)
				l_state.set_finalize_mode (finalize_mode)
				l_target.update_state (l_state)
				l_system.select_target (l_target, l_state)
				parse_libraries (l_system, l_state)
				from parsed_libraries.start until parsed_libraries.after loop
					parse_libraries (parsed_libraries.item_for_iteration, l_state)
					parsed_libraries.forth
				end
				l_system.libraries.do_adapted (agent {ET_ADAPTED_LIBRARY}.propagate_read_only)
				l_target.fill_root (l_system)
				l_target.fill_settings (l_system)
				l_target.fill_options (l_system)
				parse_dotnet_assemblies (l_system, l_state)
				from parsed_libraries.start until parsed_libraries.after loop
					parse_dotnet_assemblies (parsed_libraries.item_for_iteration, l_state)
					parsed_libraries.forth
				end
				last_system := l_system
			end
		end

end
