note

	description:

		"Shared ECF version numbers"

	library: "Gobo Eiffel Utility Library"
	copyright: "Copyright (c) 2009, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2012-08-22 12:54:13 -0700 (Wed, 22 Aug 2012) $"
	revision: "$Revision: 89387 $"

class UT_SHARED_ECF_VERSIONS

feature -- Access

	ecf_1_0_0: UT_VERSION
			-- ECF 1.0.0
			-- Corresponding to ISE 5.7
		once
			create Result.make_major_minor (1, 0)
		ensure
			ecf_1_0_0_not_void: Result /= Void
		end

	ecf_1_2_0: UT_VERSION
			-- ECF 1.2.0
			-- Corresponding to ISE 6.0
		once
			create Result.make_major_minor (1, 2)
		ensure
			ecf_1_2_0_not_void: Result /= Void
		end

	ecf_1_3_0: UT_VERSION
			-- ECF 1.3.0
			-- Corresponding to ISE 6.1
		once
			create Result.make_major_minor (1, 3)
		ensure
			ecf_1_3_0_not_void: Result /= Void
		end

	ecf_1_4_0: UT_VERSION
			-- ECF 1.4.0
			-- Corresponding to ISE 6.2
		once
			create Result.make_major_minor (1, 4)
		ensure
			ecf_1_4_0_not_void: Result /= Void
		end

	ecf_1_5_0: UT_VERSION
			-- ECF 1.5.0
			-- Corresponding to ISE 6.4
		once
			create Result.make_major_minor (1, 5)
		ensure
			ecf_1_5_0_not_void: Result /= Void
		end

	ecf_latest: UT_VERSION
			-- After the last ECF version
		once
			create Result.make_latest
		ensure
			ecma_latest_not_void: Result /= Void
		end

end
