note

	description:

		"Objects that compare text strings"

	library: "Gobo Eiffel XSLT Library"
	copyright: "Copyright (c) 2004, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2012-08-22 12:54:13 -0700 (Wed, 22 Aug 2012) $"
	revision: "$Revision: 89387 $"

class XM_XSLT_TEXT_COMPARER

inherit

	KL_PART_COMPARATOR [XM_XPATH_ITEM]


create

	make, make_from_collator

feature {NONE} -- Initialiaztion

	make (a_comparer: KL_PART_COMPARATOR [XM_XPATH_ITEM])
			-- Establish invariant.
		require
			comparer_not_void: a_comparer /= Void
		do
			comparer := a_comparer
		ensure
			comparer_set: comparer = a_comparer
		end

	make_from_collator (a_collator: ST_COLLATOR)
			-- Establish invariant
		require
			collator_not_void: a_collator /= Void
		do
			collator := a_collator
		ensure
			collator_set: collator = a_collator
		end

feature -- Comparison

	less_than (u, v: XM_XPATH_ITEM): BOOLEAN
			-- Is `u' considered less than `v'?
		local
			s1, s2: STRING
		do
			if collator /= Void then
				s1 := u.string_value
				s2 := v.string_value
				Result := collator.less_than (s1, s2)
			else
				Result := comparer.less_than (u, v)
			end
		end

feature {NONE} -- Implementation

	collator: ST_COLLATOR
			-- Collator used to perform string comparisons

	comparer: KL_PART_COMPARATOR [XM_XPATH_ITEM]
			-- Comparator used to perform string comparisons

invariant

	collator_or_comparer: collator /= Void xor comparer /= Void

end
