/*
 * Code for class PROCESS_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr181.h"
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include "eif_process.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F227_2806
static void inline_F227_2806 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F227_2806
#endif
#ifndef INLINE_F227_2807
static void inline_F227_2807 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F227_2807
#endif
#ifndef INLINE_F227_2810
static void inline_F227_2810 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F227_2810
#endif
#ifndef INLINE_F227_2824
static void inline_F227_2824 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	{
				  char ** arguments;
 				  arguments = (char **) arg1;
				  arguments[arg2] = (char *) arg3;
				}
	;
}
#define INLINE_F227_2824
#endif
#ifndef INLINE_F227_2822
static void inline_F227_2822 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	{
				  int max_descriptors;
				  int k, rc;
  				  if (arg4 == EIF_TRUE) {
				    max_descriptors = getdtablesize();
					for (k = 3; k < max_descriptors; k++) {
					    rc = fcntl(k, F_SETFD, 1);
					    if (rc == -1 && errno != EBADF) {
						      eraise(Strerror(errno), EN_SYS);
					    }
			  	    }
				  }
				  if (arg3 == NULL) {
				    (void) execv((char *) arg1, (char **) arg2);
				  } else {
				    (void) execve((char *) arg1, (char **) arg2, (char **) arg3);
				  }
				  eraise(Strerror(errno), EN_SYS);
				}
	;
}
#define INLINE_F227_2822
#endif
#ifndef INLINE_F227_2821
static void inline_F227_2821 (EIF_INTEGER_32* arg1)
{
	{
  pid_t pid;
  pid = fork();
  *arg1 = (EIF_INTEGER)pid;
}
	;
}
#define INLINE_F227_2821
#endif
#ifndef INLINE_F227_2817
static void inline_F227_2817 (EIF_POINTER arg1, EIF_POINTER* arg2)
{
	{
	  char *result;
	  result = (char *) malloc((unsigned) (strlen((char *) arg1) + 1));
	  if (result == NULL) {
    	enomem();
	  }
	  strcpy(result, arg1);
	  *arg2 = result;
	}
	;
}
#define INLINE_F227_2817
#endif
#ifndef INLINE_F227_2823
static void inline_F227_2823 (EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	{
	EIF_POINTER result;
	result = (EIF_POINTER) malloc((size_t) (arg1 * sizeof(char *)));
	if (result == NULL) {
		enomem();
	}
	*arg2 = result;
}
	;
}
#define INLINE_F227_2823
#endif
#ifndef INLINE_F227_2818
static void inline_F227_2818 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	{
  int rc;
  int fd[2];
  EIF_INTEGER * read_ptr;
  EIF_INTEGER * write_ptr;
  rc = pipe(fd);
  if (rc != 0) {
    eraise(Strerror(errno), EN_SYS);
  }
  read_ptr = (EIF_INTEGER *) arg1;
  write_ptr = (EIF_INTEGER *) arg2;
  *read_ptr = fd[0];
  *write_ptr = fd[1];
}
	;
}
#define INLINE_F227_2818
#endif
#ifndef INLINE_F227_2820
static void inline_F227_2820 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F227_2820
#endif
#ifndef INLINE_F227_2825
static void inline_F227_2825 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F227_2825
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_OS}.duplicate_file_descriptor */
void F227_2806 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("duplicate_file_descriptor", 226, Current, 0, 2, 2859);
	inline_F227_2806 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.close_file_descriptor */
void F227_2807 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("close_file_descriptor", 226, Current, 0, 1, 2860);
	inline_F227_2807 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.fork_process */
EIF_INTEGER_32 F227_2809 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 226, Current, 0, 0, 2862);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) F227_2814(Current);
}

/* {PROCESS_UNIX_OS}.new_process_group */
void F227_2810 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("new_process_group", 226, Current, 0, 0, 2863);
	inline_F227_2810 ();
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.exec_process */
void F227_2811 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3, EIF_POINTER arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_POINTER loc4 = (EIF_POINTER) 0;
	EIF_POINTER loc5 = (EIF_POINTER) 0;
	EIF_POINTER loc6 = (EIF_POINTER) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg2);
	RTLR(1,Current);
	RTLR(2,loc7);
	RTLR(3,tr1);
	RTLR(4,arg1);
	
	RTEAA("exec_process", 226, Current, 7, 4, 2864);
	RTGC;
	RTHOOK(1);
	loc2 = F716_5529(RTCV(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCV(arg2)+ _LNGOFF_1_1_0_0_);
	RTHOOK(3);
	loc4 = F227_2816(Current, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(4);
	tr1 = RTLNS(629, 629, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F630_4773(RTCV(tr1), ((EIF_INTEGER_32) 0L));
	loc7 = (EIF_REFERENCE) tr1;
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		tr1 = F716_5523(RTCV(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		F630_4787(RTCV(loc7), tr1);
		RTHOOK(8);
		tp1 = F630_4779(RTCV(loc7));
		loc5 = F227_2815(Current, tp1);
		RTHOOK(9);
		inline_F227_2824(loc4, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), loc5);
		RTHOOK(10);
		loc1++;
	}
	RTHOOK(11);
	inline_F227_2824(loc4, loc2, loc6);
	RTHOOK(12);
	tr1 = RTLNS(629, 629, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F630_4772(RTCV(tr1), arg1);
	loc7 = (EIF_REFERENCE) tr1;
	RTHOOK(13);
	tp1 = F630_4779(RTCV(loc7));
	inline_F227_2822(tp1, loc4, arg4, arg3);
	RTHOOK(14);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_fork_process */
EIF_INTEGER_32 F227_2814 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTEAA("unix_fork_process", 226, Current, 0, 0, 2867);
	RTHOOK(1);
	inline_F227_2821((EIF_INTEGER_32 *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.str_dup */
EIF_POINTER F227_2815 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("str_dup", 226, Current, 0, 1, 2868);
	RTHOOK(1);
	inline_F227_2817(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.unix_allocate_arg_memory */
EIF_POINTER F227_2816 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("unix_allocate_arg_memory", 226, Current, 0, 1, 2869);
	RTHOOK(1);
	inline_F227_2823(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.c_str_dup */
void F227_2817 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_str_dup", 226, Current, 0, 2, 2870);
	inline_F227_2817 ((EIF_POINTER) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_pipe */
void F227_2818 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_pipe", 226, Current, 0, 2, 2871);
	inline_F227_2818 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_waitpid */
void F227_2820 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_waitpid", 226, Current, 0, 5, 2873);
	EIF_ENTER_C;
	inline_F227_2820 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_BOOLEAN*) arg3, (EIF_INTEGER_32*) arg4, (EIF_BOOLEAN*) arg5);
	EIF_EXIT_C;
	RTGC;
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_fork_process */
void F227_2821 (EIF_REFERENCE Current, EIF_INTEGER_32* arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_unix_fork_process", 226, Current, 0, 1, 2853);
	inline_F227_2821 ((EIF_INTEGER_32*) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_exec_process */
void F227_2822 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_exec_process", 226, Current, 0, 4, 2854);
	inline_F227_2822 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_allocate_arg_memory */
void F227_2823 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_unix_allocate_arg_memory", 226, Current, 0, 2, 2855);
	inline_F227_2823 ((EIF_INTEGER_32) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_set_arg_value */
void F227_2824 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_set_arg_value", 226, Current, 0, 3, 2856);
	inline_F227_2824 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.attach_terminals */
void F227_2825 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("attach_terminals", 226, Current, 0, 1, 2857);
	inline_F227_2825 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit181 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
