// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoVelocity.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef EOVELOCITY_H
#define EOVELOCITY_H

//-----------------------------------------------------------------------------
#include <eoFunctor.h>
#include <utils/eoRNG.h>
#include <eoPop.h>
//-----------------------------------------------------------------------------

/**
 * Abstract class for PSO velocities calculation.
 * All the velocities must derivated from eoVelocity.
 */
template < class POT > class eoVelocity:public eoBF < POT &,unsigned , void >
{
public:

    /**
     * Apply the velocity computation to a whole given population.
     * Used for synchronous PSO.
     */
    virtual void apply (eoPop < POT > &_pop)
    {
        for (unsigned i = 0; i < _pop.size (); i++)
        {
            operator  ()(_pop[i],i);
        }

    }

    /**
     * Update the neighborhood of the given particle.
     */
    virtual void updateNeighborhood(POT & ,unsigned _indice){}


    /**
    * Apply the neighborhood with a whole population (used for distributed or synchronous PSO).
    */
    virtual void updateNeighborhood (eoPop < POT > &_pop)
    {
        for (unsigned i = 0; i < _pop.size (); i++)
        {
            updateNeighborhood(_pop[i],i);
        }

    }
};

#endif /*EOVELOCITY_H_H */

