// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`CopyObject`](crate::operation::copy_object::builders::CopyObjectFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(ObjectCannedAcl)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::acl) / [`set_acl(Option<ObjectCannedAcl>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_acl):<br>required: **false**<br><p>The canned access control list (ACL) to apply to the object.</p> <p>When you copy an object, the ACL metadata is not preserved and is set to <code>private</code> by default. Only the owner has full access control. To override the default ACL setting, specify a new ACL when you generate a copy request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>.</p> <p>If the destination bucket that you're copying objects to uses the bucket owner enforced setting for S3 Object Ownership, ACLs are disabled and no longer affect permissions. Buckets that use this setting only accept <code>PUT</code> requests that don't specify an ACL or <code>PUT</code> requests that specify bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of objects and disabling ACLs</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <ul>   <li>    <p>If your destination bucket uses the bucket owner enforced setting for Object Ownership, all objects written to the bucket by any account will be owned by the bucket owner.</p></li>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`bucket(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the destination bucket.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`cache_control(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::cache_control) / [`set_cache_control(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_cache_control):<br>required: **false**<br><p>Specifies the caching behavior along the request/reply chain.</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>When you copy an object, if the source object has a checksum, that checksum value will be copied to the new object by default. If the <code>CopyObject</code> request does not include this <code>x-amz-checksum-algorithm</code> header, the checksum algorithm will be copied from the source object to the destination object (if it's present on the source object). You can optionally specify a different checksum algorithm to use with the <code>x-amz-checksum-algorithm</code> header. Unrecognized or unsupported values will respond with the HTTP status code <code>400 Bad Request</code>.</p><note>  <p>For directory buckets, when you use Amazon Web Services SDKs, <code>CRC32</code> is the default checksum algorithm that's used for performance.</p> </note><br>
    ///   - [`content_disposition(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::content_disposition) / [`set_content_disposition(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_content_disposition):<br>required: **false**<br><p>Specifies presentational information for the object. Indicates whether an object should be displayed in a web browser or downloaded as a file. It allows specifying the desired filename for the downloaded file.</p><br>
    ///   - [`content_encoding(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::content_encoding) / [`set_content_encoding(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_content_encoding):<br>required: **false**<br><p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>  <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p> </note><br>
    ///   - [`content_language(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::content_language) / [`set_content_language(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_content_language):<br>required: **false**<br><p>The language the content is in.</p><br>
    ///   - [`content_type(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::content_type) / [`set_content_type(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_content_type):<br>required: **false**<br><p>A standard MIME type that describes the format of the object data.</p><br>
    ///   - [`copy_source(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::copy_source) / [`set_copy_source(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_copy_source):<br>required: **true**<br><p>Specifies the source object for the copy operation. The source object can be up to 5 GB. If the source object is an object that was uploaded by using a multipart upload, the object copy will be a single part object after the source object is copied to the destination bucket.</p> <p>You specify the value of the copy source in one of two formats, depending on whether you want to access the source object through an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">access point</a>:</p> <ul>  <li>   <p>For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object <code>reports/january.pdf</code> from the general purpose bucket <code>awsexamplebucket</code>, use <code>awsexamplebucket/reports/january.pdf</code>. The value must be URL-encoded. To copy the object <code>reports/january.pdf</code> from the directory bucket <code>awsexamplebucket--use1-az5--x-s3</code>, use <code>awsexamplebucket--use1-az5--x-s3/reports/january.pdf</code>. The value must be URL-encoded.</p></li>  <li>   <p>For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format <code>arn:aws:s3:<region>      :      <account-id>       :accesspoint/       <access-point-name>        /object/        <key></key>       </access-point-name>      </account-id>     </region></code>. For example, to copy the object <code>reports/january.pdf</code> through access point <code>my-access-point</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf</code>. The value must be URL encoded.</p><note>    <ul>     <li>      <p>Amazon S3 supports copy operations using Access points only when the source and destination buckets are in the same Amazon Web Services Region.</p></li>     <li>      <p>Access points are not supported by directory buckets.</p></li>    </ul>   </note>   <p>Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format <code>arn:aws:s3-outposts:<region>      :      <account-id>       :outpost/       <outpost-id>        /object/        <key></key>       </outpost-id>      </account-id>     </region></code>. For example, to copy the object <code>reports/january.pdf</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf</code>. The value must be URL-encoded.</p></li> </ul> <p>If your source bucket versioning is enabled, the <code>x-amz-copy-source</code> header by default identifies the current version of an object to copy. If the current version is a delete marker, Amazon S3 behaves as if the object was deleted. To copy a different version, use the <code>versionId</code> query parameter. Specifically, append <code>?versionId=<version-id></version-id></code> to the value (for example, <code>awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893</code>). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.</p> <p>If you enable versioning on the destination bucket, Amazon S3 generates a unique version ID for the copied object. This version ID is different from the version ID of the source object. Amazon S3 returns the version ID of the copied object in the <code>x-amz-version-id</code> response header in the response.</p> <p>If you do not enable versioning or suspend it on the destination bucket, the version ID that Amazon S3 generates in the <code>x-amz-version-id</code> response header is always null.</p><note>  <p><b>Directory buckets</b> - S3 Versioning isn't enabled and supported for directory buckets.</p> </note><br>
    ///   - [`copy_source_if_match(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::copy_source_if_match) / [`set_copy_source_if_match(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_copy_source_if_match):<br>required: **false**<br><p>Copies the object if its entity tag (ETag) matches the specified tag.</p> <p>If both the <code>x-amz-copy-source-if-match</code> and <code>x-amz-copy-source-if-unmodified-since</code> headers are present in the request and evaluate as follows, Amazon S3 returns <code>200 OK</code> and copies the data:</p> <ul>  <li>   <p><code>x-amz-copy-source-if-match</code> condition evaluates to true</p></li>  <li>   <p><code>x-amz-copy-source-if-unmodified-since</code> condition evaluates to false</p></li> </ul><br>
    ///   - [`copy_source_if_modified_since(DateTime)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::copy_source_if_modified_since) / [`set_copy_source_if_modified_since(Option<DateTime>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_copy_source_if_modified_since):<br>required: **false**<br><p>Copies the object if it has been modified since the specified time.</p> <p>If both the <code>x-amz-copy-source-if-none-match</code> and <code>x-amz-copy-source-if-modified-since</code> headers are present in the request and evaluate as follows, Amazon S3 returns the <code>412 Precondition Failed</code> response code:</p> <ul>  <li>   <p><code>x-amz-copy-source-if-none-match</code> condition evaluates to false</p></li>  <li>   <p><code>x-amz-copy-source-if-modified-since</code> condition evaluates to true</p></li> </ul><br>
    ///   - [`copy_source_if_none_match(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::copy_source_if_none_match) / [`set_copy_source_if_none_match(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_copy_source_if_none_match):<br>required: **false**<br><p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p> <p>If both the <code>x-amz-copy-source-if-none-match</code> and <code>x-amz-copy-source-if-modified-since</code> headers are present in the request and evaluate as follows, Amazon S3 returns the <code>412 Precondition Failed</code> response code:</p> <ul>  <li>   <p><code>x-amz-copy-source-if-none-match</code> condition evaluates to false</p></li>  <li>   <p><code>x-amz-copy-source-if-modified-since</code> condition evaluates to true</p></li> </ul><br>
    ///   - [`copy_source_if_unmodified_since(DateTime)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::copy_source_if_unmodified_since) / [`set_copy_source_if_unmodified_since(Option<DateTime>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_copy_source_if_unmodified_since):<br>required: **false**<br><p>Copies the object if it hasn't been modified since the specified time.</p> <p>If both the <code>x-amz-copy-source-if-match</code> and <code>x-amz-copy-source-if-unmodified-since</code> headers are present in the request and evaluate as follows, Amazon S3 returns <code>200 OK</code> and copies the data:</p> <ul>  <li>   <p><code>x-amz-copy-source-if-match</code> condition evaluates to true</p></li>  <li>   <p><code>x-amz-copy-source-if-unmodified-since</code> condition evaluates to false</p></li> </ul><br>
    ///   - [`expires(DateTime)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::expires) / [`set_expires(Option<DateTime>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_expires):<br>required: **false**<br><p>The date and time at which the object is no longer cacheable.</p><br>
    ///   - [`grant_full_control(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_grant_full_control):<br>required: **false**<br><p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`grant_read(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::grant_read) / [`set_grant_read(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_grant_read):<br>required: **false**<br><p>Allows grantee to read the object data and its metadata.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_grant_read_acp):<br>required: **false**<br><p>Allows grantee to read the object ACL.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_grant_write_acp):<br>required: **false**<br><p>Allows grantee to write the ACL for the applicable object.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`key(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_key):<br>required: **true**<br><p>The key of the destination object.</p><br>
    ///   - [`metadata(impl Into<String>, impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::metadata) / [`set_metadata(Option<HashMap::<String, String>>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_metadata):<br>required: **false**<br><p>A map of metadata to store with the object in S3.</p><br>
    ///   - [`metadata_directive(MetadataDirective)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::metadata_directive) / [`set_metadata_directive(Option<MetadataDirective>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_metadata_directive):<br>required: **false**<br><p>Specifies whether the metadata is copied from the source object or replaced with metadata that's provided in the request. When copying an object, you can preserve all metadata (the default) or specify new metadata. If this header isn’t specified, <code>COPY</code> is the default behavior.</p> <p><b>General purpose bucket</b> - For general purpose buckets, when you grant permissions, you can use the <code>s3:x-amz-metadata-directive</code> condition key to enforce certain metadata behavior when objects are uploaded. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html">Amazon S3 condition key examples</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p><code>x-amz-website-redirect-location</code> is unique to each object and is not copied when using the <code>x-amz-metadata-directive</code> header. To copy the value, you must specify <code>x-amz-website-redirect-location</code> in the request header.</p> </note><br>
    ///   - [`tagging_directive(TaggingDirective)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::tagging_directive) / [`set_tagging_directive(Option<TaggingDirective>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_tagging_directive):<br>required: **false**<br><p>Specifies whether the object tag-set is copied from the source object or replaced with the tag-set that's provided in the request.</p> <p>The default value is <code>COPY</code>.</p><note>  <p><b>Directory buckets</b> - For directory buckets in a <code>CopyObject</code> operation, only the empty tag-set is supported. Any requests that attempt to write non-empty tags into directory buckets will receive a <code>501 Not Implemented</code> status code. When the destination bucket is a directory bucket, you will receive a <code>501 Not Implemented</code> response in any of the following situations:</p>  <ul>   <li>    <p>When you attempt to <code>COPY</code> the tag-set from an S3 source object that has non-empty tags.</p></li>   <li>    <p>When you attempt to <code>REPLACE</code> the tag-set of a source object and set a non-empty value to <code>x-amz-tagging</code>.</p></li>   <li>    <p>When you don't set the <code>x-amz-tagging-directive</code> header and the source object has non-empty tags. This is because the default value of <code>x-amz-tagging-directive</code> is <code>COPY</code>.</p></li>  </ul>  <p>Because only the empty tag-set is supported for directory buckets in a <code>CopyObject</code> operation, the following situations are allowed:</p>  <ul>   <li>    <p>When you attempt to <code>COPY</code> the tag-set from a directory bucket source object that has no tags to a general purpose bucket. It copies an empty tag-set to the destination object.</p></li>   <li>    <p>When you attempt to <code>REPLACE</code> the tag-set of a directory bucket source object and set the <code>x-amz-tagging</code> value of the directory bucket destination object to empty.</p></li>   <li>    <p>When you attempt to <code>REPLACE</code> the tag-set of a general purpose bucket source object that has non-empty tags and set the <code>x-amz-tagging</code> value of the directory bucket destination object to empty.</p></li>   <li>    <p>When you attempt to <code>REPLACE</code> the tag-set of a directory bucket source object and don't set the <code>x-amz-tagging</code> value of the directory bucket destination object. This is because the default value of <code>x-amz-tagging</code> is the empty value.</p></li>  </ul> </note><br>
    ///   - [`server_side_encryption(ServerSideEncryption)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::server_side_encryption) / [`set_server_side_encryption(Option<ServerSideEncryption>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_server_side_encryption):<br>required: **false**<br><p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>, <code>aws:kms:dsse</code>). Unrecognized or unsupported values won’t write a destination object and will receive a <code>400 Bad Request</code> response.</p> <p>Amazon S3 automatically encrypts all new objects that are copied to an S3 bucket. When copying an object, if you don't specify encryption information in your copy request, the encryption setting of the target object is set to the default encryption configuration of the destination bucket. By default, all buckets have a base level of encryption configuration that uses server-side encryption with Amazon S3 managed keys (SSE-S3). If the destination bucket has a default encryption configuration that uses server-side encryption with Key Management Service (KMS) keys (SSE-KMS), dual-layer server-side encryption with Amazon Web Services KMS keys (DSSE-KMS), or server-side encryption with customer-provided encryption keys (SSE-C), Amazon S3 uses the corresponding KMS key, or a customer-provided key to encrypt the target object copy.</p> <p>When you perform a <code>CopyObject</code> operation, if you want to use a different type of encryption setting for the target object, you can specify appropriate encryption-related headers to encrypt the target object with an Amazon S3 managed key, a KMS key, or a customer-provided key. If the encryption setting in your request is different from the default encryption configuration of the destination bucket, the encryption setting in your request takes precedence.</p> <p>With server-side encryption, Amazon S3 encrypts your data as it writes your data to disks in its data centers and decrypts the data when you access it. For more information about server-side encryption, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Using Server-Side Encryption</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p> </note><br>
    ///   - [`storage_class(StorageClass)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::storage_class) / [`set_storage_class(Option<StorageClass>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_storage_class):<br>required: **false**<br><p>If the <code>x-amz-storage-class</code> header is not used, the copied object will be stored in the <code>STANDARD</code> Storage Class by default. The <code>STANDARD</code> storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class.</p><note>  <ul>   <li>    <p><b>Directory buckets </b> - For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects. Unsupported storage class values won't write a destination object and will respond with the HTTP status code <code>400 Bad Request</code>.</p></li>   <li>    <p><b>Amazon S3 on Outposts </b> - S3 on Outposts only uses the <code>OUTPOSTS</code> Storage Class.</p></li>  </ul> </note> <p>You can use the <code>CopyObject</code> action to change the storage class of an object that is already stored in Amazon S3 by using the <code>x-amz-storage-class</code> header. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p> <p>Before using an object as a source object for the copy operation, you must restore a copy of it if it meets any of the following conditions:</p> <ul>  <li>   <p>The storage class of the source object is <code>GLACIER</code> or <code>DEEP_ARCHIVE</code>.</p></li>  <li>   <p>The storage class of the source object is <code>INTELLIGENT_TIERING</code> and it's <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intelligent-tiering-overview.html#intel-tiering-tier-definition">S3 Intelligent-Tiering access tier</a> is <code>Archive Access</code> or <code>Deep Archive Access</code>.</p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjectsExamples.html">Copying Objects</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`website_redirect_location(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::website_redirect_location) / [`set_website_redirect_location(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_website_redirect_location):<br>required: **false**<br><p>If the destination bucket is configured as a website, redirects requests for this object copy to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. This value is unique to each object and is not copied when using the <code>x-amz-metadata-directive</code> header. Instead, you may opt to provide this header in combination with the <code>x-amz-metadata-directive</code> header.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_sse_customer_algorithm):<br>required: **false**<br><p>Specifies the algorithm to use when encrypting the object (for example, <code>AES256</code>).</p> <p>When you perform a <code>CopyObject</code> operation, if you want to use a different type of encryption setting for the target object, you can specify appropriate encryption-related headers to encrypt the target object with an Amazon S3 managed key, a KMS key, or a customer-provided key. If the encryption setting in your request is different from the default encryption configuration of the destination bucket, the encryption setting in your request takes precedence.</p><note>  <p>This functionality is not supported when the destination bucket is a directory bucket.</p> </note><br>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_sse_customer_key):<br>required: **false**<br><p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded. Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>  <p>This functionality is not supported when the destination bucket is a directory bucket.</p> </note><br>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_sse_customer_key_md5):<br>required: **false**<br><p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>  <p>This functionality is not supported when the destination bucket is a directory bucket.</p> </note><br>
    ///   - [`ssekms_key_id(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::ssekms_key_id) / [`set_ssekms_key_id(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_ssekms_key_id):<br>required: **false**<br><p>Specifies the KMS ID (Key ID, Key ARN, or Key Alias) to use for object encryption. All GET and PUT requests for an object protected by KMS will fail if they're not made via SSL or using SigV4. For information about configuring any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported when the destination bucket is a directory bucket.</p> </note><br>
    ///   - [`ssekms_encryption_context(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::ssekms_encryption_context) / [`set_ssekms_encryption_context(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_ssekms_encryption_context):<br>required: **false**<br><p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs. This value must be explicitly added to specify encryption context for <code>CopyObject</code> requests.</p><note>  <p>This functionality is not supported when the destination bucket is a directory bucket.</p> </note><br>
    ///   - [`bucket_key_enabled(bool)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::bucket_key_enabled) / [`set_bucket_key_enabled(Option<bool>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_bucket_key_enabled):<br>required: **false**<br><p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). If a target object uses SSE-KMS, you can enable an S3 Bucket Key for the object.</p> <p>Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported when the destination bucket is a directory bucket.</p> </note><br>
    ///   - [`copy_source_sse_customer_algorithm(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::copy_source_sse_customer_algorithm) / [`set_copy_source_sse_customer_algorithm(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_copy_source_sse_customer_algorithm):<br>required: **false**<br><p>Specifies the algorithm to use when decrypting the source object (for example, <code>AES256</code>).</p> <p>If the source object for the copy is stored in Amazon S3 using SSE-C, you must provide the necessary encryption information in your request so that Amazon S3 can decrypt the object for copying.</p><note>  <p>This functionality is not supported when the source object is in a directory bucket.</p> </note><br>
    ///   - [`copy_source_sse_customer_key(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::copy_source_sse_customer_key) / [`set_copy_source_sse_customer_key(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_copy_source_sse_customer_key):<br>required: **false**<br><p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be the same one that was used when the source object was created.</p> <p>If the source object for the copy is stored in Amazon S3 using SSE-C, you must provide the necessary encryption information in your request so that Amazon S3 can decrypt the object for copying.</p><note>  <p>This functionality is not supported when the source object is in a directory bucket.</p> </note><br>
    ///   - [`copy_source_sse_customer_key_md5(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::copy_source_sse_customer_key_md5) / [`set_copy_source_sse_customer_key_md5(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_copy_source_sse_customer_key_md5):<br>required: **false**<br><p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p> <p>If the source object for the copy is stored in Amazon S3 using SSE-C, you must provide the necessary encryption information in your request so that Amazon S3 can decrypt the object for copying.</p><note>  <p>This functionality is not supported when the source object is in a directory bucket.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`tagging(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::tagging) / [`set_tagging(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_tagging):<br>required: **false**<br><p>The tag-set for the object copy in the destination bucket. This value must be used in conjunction with the <code>x-amz-tagging-directive</code> if you choose <code>REPLACE</code> for the <code>x-amz-tagging-directive</code>. If you choose <code>COPY</code> for the <code>x-amz-tagging-directive</code>, you don't need to set the <code>x-amz-tagging</code> header, because the tag-set will be copied from the source object directly. The tag-set must be encoded as URL Query parameters.</p> <p>The default value is the empty value.</p><note>  <p><b>Directory buckets</b> - For directory buckets in a <code>CopyObject</code> operation, only the empty tag-set is supported. Any requests that attempt to write non-empty tags into directory buckets will receive a <code>501 Not Implemented</code> status code. When the destination bucket is a directory bucket, you will receive a <code>501 Not Implemented</code> response in any of the following situations:</p>  <ul>   <li>    <p>When you attempt to <code>COPY</code> the tag-set from an S3 source object that has non-empty tags.</p></li>   <li>    <p>When you attempt to <code>REPLACE</code> the tag-set of a source object and set a non-empty value to <code>x-amz-tagging</code>.</p></li>   <li>    <p>When you don't set the <code>x-amz-tagging-directive</code> header and the source object has non-empty tags. This is because the default value of <code>x-amz-tagging-directive</code> is <code>COPY</code>.</p></li>  </ul>  <p>Because only the empty tag-set is supported for directory buckets in a <code>CopyObject</code> operation, the following situations are allowed:</p>  <ul>   <li>    <p>When you attempt to <code>COPY</code> the tag-set from a directory bucket source object that has no tags to a general purpose bucket. It copies an empty tag-set to the destination object.</p></li>   <li>    <p>When you attempt to <code>REPLACE</code> the tag-set of a directory bucket source object and set the <code>x-amz-tagging</code> value of the directory bucket destination object to empty.</p></li>   <li>    <p>When you attempt to <code>REPLACE</code> the tag-set of a general purpose bucket source object that has non-empty tags and set the <code>x-amz-tagging</code> value of the directory bucket destination object to empty.</p></li>   <li>    <p>When you attempt to <code>REPLACE</code> the tag-set of a directory bucket source object and don't set the <code>x-amz-tagging</code> value of the directory bucket destination object. This is because the default value of <code>x-amz-tagging</code> is the empty value.</p></li>  </ul> </note><br>
    ///   - [`object_lock_mode(ObjectLockMode)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::object_lock_mode) / [`set_object_lock_mode(Option<ObjectLockMode>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_object_lock_mode):<br>required: **false**<br><p>The Object Lock mode that you want to apply to the object copy.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`object_lock_retain_until_date(DateTime)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::object_lock_retain_until_date) / [`set_object_lock_retain_until_date(Option<DateTime>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_object_lock_retain_until_date):<br>required: **false**<br><p>The date and time when you want the Object Lock of the object copy to expire.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`object_lock_legal_hold_status(ObjectLockLegalHoldStatus)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::object_lock_legal_hold_status) / [`set_object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_object_lock_legal_hold_status):<br>required: **false**<br><p>Specifies whether you want to apply a legal hold to the object copy.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected destination bucket owner. If the account ID that you provide does not match the actual owner of the destination bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`expected_source_bucket_owner(impl Into<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::expected_source_bucket_owner) / [`set_expected_source_bucket_owner(Option<String>)`](crate::operation::copy_object::builders::CopyObjectFluentBuilder::set_expected_source_bucket_owner):<br>required: **false**<br><p>The account ID of the expected source bucket owner. If the account ID that you provide does not match the actual owner of the source bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`CopyObjectOutput`](crate::operation::copy_object::CopyObjectOutput) with field(s):
    ///   - [`copy_object_result(Option<CopyObjectResult>)`](crate::operation::copy_object::CopyObjectOutput::copy_object_result): <p>Container for all response elements.</p>
    ///   - [`expiration(Option<String>)`](crate::operation::copy_object::CopyObjectOutput::expiration): <p>If the object expiration is configured, the response includes this header.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`copy_source_version_id(Option<String>)`](crate::operation::copy_object::CopyObjectOutput::copy_source_version_id): <p>Version ID of the source object that was copied.</p><note>  <p>This functionality is not supported when the source object is in a directory bucket.</p> </note>
    ///   - [`version_id(Option<String>)`](crate::operation::copy_object::CopyObjectOutput::version_id): <p>Version ID of the newly created copy.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::operation::copy_object::CopyObjectOutput::server_side_encryption): <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>, <code>aws:kms:dsse</code>).</p><note>  <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p> </note>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::operation::copy_object::CopyObjectOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to confirm the encryption algorithm that's used.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::operation::copy_object::CopyObjectOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide the round-trip message integrity verification of the customer-provided encryption key.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`ssekms_key_id(Option<String>)`](crate::operation::copy_object::CopyObjectOutput::ssekms_key_id): <p>If present, indicates the ID of the Key Management Service (KMS) symmetric encryption customer managed key that was used for the object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`ssekms_encryption_context(Option<String>)`](crate::operation::copy_object::CopyObjectOutput::ssekms_encryption_context): <p>If present, indicates the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`bucket_key_enabled(Option<bool>)`](crate::operation::copy_object::CopyObjectOutput::bucket_key_enabled): <p>Indicates whether the copied object uses an S3 Bucket Key for server-side encryption with Key Management Service (KMS) keys (SSE-KMS).</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::copy_object::CopyObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    /// - On failure, responds with [`SdkError<CopyObjectError>`](crate::operation::copy_object::CopyObjectError)
    pub fn copy_object(&self) -> crate::operation::copy_object::builders::CopyObjectFluentBuilder {
        crate::operation::copy_object::builders::CopyObjectFluentBuilder::new(self.handle.clone())
    }
}
