// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`DeleteObject`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name of the bucket containing the object.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::set_key):<br>required: **true**<br><p>Key name of the object to delete.</p><br>
    ///   - [`mfa(impl Into<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::mfa) / [`set_mfa(Option<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::set_mfa):<br>required: **false**<br><p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`version_id(impl Into<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::version_id) / [`set_version_id(Option<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::set_version_id):<br>required: **false**<br><p>Version ID used to reference a specific version of the object.</p><note>  <p>For directory buckets in this API operation, only the <code>null</code> value of the version ID is supported.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`bypass_governance_retention(bool)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::bypass_governance_retention) / [`set_bypass_governance_retention(Option<bool>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::set_bypass_governance_retention):<br>required: **false**<br><p>Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation. To use this header, you must have the <code>s3:BypassGovernanceRetention</code> permission.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::delete_object::builders::DeleteObjectFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`DeleteObjectOutput`](crate::operation::delete_object::DeleteObjectOutput) with field(s):
    ///   - [`delete_marker(Option<bool>)`](crate::operation::delete_object::DeleteObjectOutput::delete_marker): <p>Indicates whether the specified object version that was permanently deleted was (true) or was not (false) a delete marker before deletion. In a simple DELETE, this header indicates whether (true) or not (false) the current version of the object is a delete marker.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`version_id(Option<String>)`](crate::operation::delete_object::DeleteObjectOutput::version_id): <p>Returns the version ID of the delete marker created as a result of the DELETE operation.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::delete_object::DeleteObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    /// - On failure, responds with [`SdkError<DeleteObjectError>`](crate::operation::delete_object::DeleteObjectError)
    pub fn delete_object(&self) -> crate::operation::delete_object::builders::DeleteObjectFluentBuilder {
        crate::operation::delete_object::builders::DeleteObjectFluentBuilder::new(self.handle.clone())
    }
}
