// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetObjectAttributes`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket that contains the object.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_key):<br>required: **true**<br><p>The object key.</p><br>
    ///   - [`version_id(impl Into<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::version_id) / [`set_version_id(Option<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_version_id):<br>required: **false**<br><p>The version ID used to reference a specific version of the object.</p><note>  <p>S3 Versioning isn't enabled and supported for directory buckets. For this API operation, only the <code>null</code> value of the version ID is supported by directory buckets. You can only specify <code>null</code> to the <code>versionId</code> query parameter in the request.</p> </note><br>
    ///   - [`max_parts(i32)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::max_parts) / [`set_max_parts(Option<i32>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_max_parts):<br>required: **false**<br><p>Sets the maximum number of parts to return.</p><br>
    ///   - [`part_number_marker(impl Into<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::part_number_marker) / [`set_part_number_marker(Option<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_part_number_marker):<br>required: **false**<br><p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p><br>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_sse_customer_algorithm):<br>required: **false**<br><p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_sse_customer_key):<br>required: **false**<br><p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_sse_customer_key_md5):<br>required: **false**<br><p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`object_attributes(ObjectAttributes)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::object_attributes) / [`set_object_attributes(Option<Vec::<ObjectAttributes>>)`](crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::set_object_attributes):<br>required: **true**<br><p>Specifies the fields at the root level that you want returned in the response. Fields that you do not specify are not returned.</p><br>
    /// - On success, responds with [`GetObjectAttributesOutput`](crate::operation::get_object_attributes::GetObjectAttributesOutput) with field(s):
    ///   - [`delete_marker(Option<bool>)`](crate::operation::get_object_attributes::GetObjectAttributesOutput::delete_marker): <p>Specifies whether the object retrieved was (<code>true</code>) or was not (<code>false</code>) a delete marker. If <code>false</code>, this response header does not appear in the response.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`last_modified(Option<DateTime>)`](crate::operation::get_object_attributes::GetObjectAttributesOutput::last_modified): <p>The creation date of the object.</p>
    ///   - [`version_id(Option<String>)`](crate::operation::get_object_attributes::GetObjectAttributesOutput::version_id): <p>The version ID of the object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::get_object_attributes::GetObjectAttributesOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`e_tag(Option<String>)`](crate::operation::get_object_attributes::GetObjectAttributesOutput::e_tag): <p>An ETag is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    ///   - [`checksum(Option<Checksum>)`](crate::operation::get_object_attributes::GetObjectAttributesOutput::checksum): <p>The checksum or digest of the object.</p>
    ///   - [`object_parts(Option<GetObjectAttributesParts>)`](crate::operation::get_object_attributes::GetObjectAttributesOutput::object_parts): <p>A collection of parts associated with a multipart upload.</p>
    ///   - [`storage_class(Option<StorageClass>)`](crate::operation::get_object_attributes::GetObjectAttributesOutput::storage_class): <p>Provides the storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p><note>  <p><b>Directory buckets</b> - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.</p> </note>
    ///   - [`object_size(Option<i64>)`](crate::operation::get_object_attributes::GetObjectAttributesOutput::object_size): <p>The size of the object in bytes.</p>
    /// - On failure, responds with [`SdkError<GetObjectAttributesError>`](crate::operation::get_object_attributes::GetObjectAttributesError)
    pub fn get_object_attributes(&self) -> crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder {
        crate::operation::get_object_attributes::builders::GetObjectAttributesFluentBuilder::new(self.handle.clone())
    }
}
