// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`HeadBucket`](crate::operation::head_bucket::builders::HeadBucketFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::head_bucket::builders::HeadBucketFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::head_bucket::builders::HeadBucketFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Object Lambda access points</b> - When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error code <code>InvalidAccessPointAliasError</code> is returned. For more information about <code>InvalidAccessPointAliasError</code>, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::head_bucket::builders::HeadBucketFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::head_bucket::builders::HeadBucketFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`HeadBucketOutput`](crate::operation::head_bucket::HeadBucketOutput) with field(s):
    ///   - [`bucket_location_type(Option<LocationType>)`](crate::operation::head_bucket::HeadBucketOutput::bucket_location_type): <p>The type of location where the bucket is created.</p><note>  <p>This functionality is only supported by directory buckets.</p> </note>
    ///   - [`bucket_location_name(Option<String>)`](crate::operation::head_bucket::HeadBucketOutput::bucket_location_name): <p>The name of the location where the bucket will be created.</p> <p>For directory buckets, the AZ ID of the Availability Zone where the bucket is created. An example AZ ID value is <code>usw2-az2</code>.</p><note>  <p>This functionality is only supported by directory buckets.</p> </note>
    ///   - [`bucket_region(Option<String>)`](crate::operation::head_bucket::HeadBucketOutput::bucket_region): <p>The Region that the bucket is located.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`access_point_alias(Option<bool>)`](crate::operation::head_bucket::HeadBucketOutput::access_point_alias): <p>Indicates whether the bucket name used in the request is an access point alias.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    /// - On failure, responds with [`SdkError<HeadBucketError>`](crate::operation::head_bucket::HeadBucketError)
    pub fn head_bucket(&self) -> crate::operation::head_bucket::builders::HeadBucketFluentBuilder {
        crate::operation::head_bucket::builders::HeadBucketFluentBuilder::new(self.handle.clone())
    }
}
