// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ListMultipartUploads`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket to which the multipart upload was initiated.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`delimiter(impl Into<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::delimiter) / [`set_delimiter(Option<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::set_delimiter):<br>required: **false**<br><p>Character you use to group keys.</p> <p>All keys that contain the same string between the prefix, if specified, and the first occurrence of the delimiter after the prefix are grouped under a single result element, <code>CommonPrefixes</code>. If you don't specify the prefix parameter, then the substring starts at the beginning of the key. The keys that are grouped under <code>CommonPrefixes</code> result element are not returned elsewhere in the response.</p><note>  <p><b>Directory buckets</b> - For directory buckets, <code>/</code> is the only supported delimiter.</p> </note><br>
    ///   - [`encoding_type(EncodingType)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::encoding_type) / [`set_encoding_type(Option<EncodingType>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::set_encoding_type):<br>required: **false**<br><p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key can contain any Unicode character; however, the XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p><br>
    ///   - [`key_marker(impl Into<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::key_marker) / [`set_key_marker(Option<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::set_key_marker):<br>required: **false**<br><p>Specifies the multipart upload after which listing should begin.</p><note>  <ul>   <li>    <p><b>General purpose buckets</b> - For general purpose buckets, <code>key-marker</code> is an object key. Together with <code>upload-id-marker</code>, this parameter specifies the multipart upload after which listing should begin.</p>    <p>If <code>upload-id-marker</code> is not specified, only the keys lexicographically greater than the specified <code>key-marker</code> will be included in the list.</p>    <p>If <code>upload-id-marker</code> is specified, any multipart uploads for a key equal to the <code>key-marker</code> might also be included, provided those multipart uploads have upload IDs lexicographically greater than the specified <code>upload-id-marker</code>.</p></li>   <li>    <p><b>Directory buckets</b> - For directory buckets, <code>key-marker</code> is obfuscated and isn't a real object key. The <code>upload-id-marker</code> parameter isn't supported by directory buckets. To list the additional multipart uploads, you only need to set the value of <code>key-marker</code> to the <code>NextKeyMarker</code> value from the previous response.</p>    <p>In the <code>ListMultipartUploads</code> response, the multipart uploads aren't sorted lexicographically based on the object keys.</p></li>  </ul> </note><br>
    ///   - [`max_uploads(i32)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::max_uploads) / [`set_max_uploads(Option<i32>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::set_max_uploads):<br>required: **false**<br><p>Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the maximum number of uploads that can be returned in a response.</p><br>
    ///   - [`prefix(impl Into<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::prefix) / [`set_prefix(Option<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::set_prefix):<br>required: **false**<br><p>Lists in-progress uploads only for those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different grouping of keys. (You can think of using <code>prefix</code> to make groups in the same way that you'd use a folder in a file system.)</p><note>  <p><b>Directory buckets</b> - For directory buckets, only prefixes that end in a delimiter (<code>/</code>) are supported.</p> </note><br>
    ///   - [`upload_id_marker(impl Into<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::upload_id_marker) / [`set_upload_id_marker(Option<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::set_upload_id_marker):<br>required: **false**<br><p>Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not specified, the upload-id-marker parameter is ignored. Otherwise, any multipart uploads for a key equal to the key-marker might be included in the list only if they have an upload ID lexicographically greater than the specified <code>upload-id-marker</code>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    /// - On success, responds with [`ListMultipartUploadsOutput`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput) with field(s):
    ///   - [`bucket(Option<String>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::bucket): <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    ///   - [`key_marker(Option<String>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::key_marker): <p>The key at or after which the listing began.</p>
    ///   - [`upload_id_marker(Option<String>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::upload_id_marker): <p>Upload ID after which listing began.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`next_key_marker(Option<String>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::next_key_marker): <p>When a list is truncated, this element specifies the value that should be used for the key-marker request parameter in a subsequent request.</p>
    ///   - [`prefix(Option<String>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::prefix): <p>When a prefix is provided in the request, this field contains the specified prefix. The result contains only keys starting with the specified prefix.</p><note>  <p><b>Directory buckets</b> - For directory buckets, only prefixes that end in a delimiter (<code>/</code>) are supported.</p> </note>
    ///   - [`delimiter(Option<String>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::delimiter): <p>Contains the delimiter you specified in the request. If you don't specify a delimiter in your request, this element is absent from the response.</p><note>  <p><b>Directory buckets</b> - For directory buckets, <code>/</code> is the only supported delimiter.</p> </note>
    ///   - [`next_upload_id_marker(Option<String>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::next_upload_id_marker): <p>When a list is truncated, this element specifies the value that should be used for the <code>upload-id-marker</code> request parameter in a subsequent request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`max_uploads(Option<i32>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::max_uploads): <p>Maximum number of multipart uploads that could have been included in the response.</p>
    ///   - [`is_truncated(Option<bool>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::is_truncated): <p>Indicates whether the returned list of multipart uploads is truncated. A value of true indicates that the list was truncated. The list can be truncated if the number of multipart uploads exceeds the limit allowed or specified by max uploads.</p>
    ///   - [`uploads(Option<Vec::<MultipartUpload>>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::uploads): <p>Container for elements related to a particular multipart upload. A response can contain zero or more <code>Upload</code> elements.</p>
    ///   - [`common_prefixes(Option<Vec::<CommonPrefix>>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::common_prefixes): <p>If you specify a delimiter in the request, then the result returns each distinct key prefix containing the delimiter in a <code>CommonPrefixes</code> element. The distinct key prefixes are returned in the <code>Prefix</code> child element.</p><note>  <p><b>Directory buckets</b> - For directory buckets, only prefixes that end in a delimiter (<code>/</code>) are supported.</p> </note>
    ///   - [`encoding_type(Option<EncodingType>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::encoding_type): <p>Encoding type used by Amazon S3 to encode object keys in the response.</p> <p>If you specify the <code>encoding-type</code> request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:</p> <p><code>Delimiter</code>, <code>KeyMarker</code>, <code>Prefix</code>, <code>NextKeyMarker</code>, <code>Key</code>.</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::list_multipart_uploads::ListMultipartUploadsOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    /// - On failure, responds with [`SdkError<ListMultipartUploadsError>`](crate::operation::list_multipart_uploads::ListMultipartUploadsError)
    pub fn list_multipart_uploads(&self) -> crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder {
        crate::operation::list_multipart_uploads::builders::ListMultipartUploadsFluentBuilder::new(self.handle.clone())
    }
}
