// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutObject`](crate::operation::put_object::builders::PutObjectFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(ObjectCannedAcl)`](crate::operation::put_object::builders::PutObjectFluentBuilder::acl) / [`set_acl(Option<ObjectCannedAcl>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_acl):<br>required: **false**<br><p>The canned ACL to apply to the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p> <p>When adding a new object, you can use headers to grant ACL-based permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the ACL on the object. By default, all objects are private. Only the owner has full access control. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html">Managing ACLs Using the REST API</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If the bucket that you're uploading objects to uses the bucket owner enforced setting for S3 Object Ownership, ACLs are disabled and no longer affect permissions. Buckets that use this setting only accept PUT requests that don't specify an ACL or PUT requests that specify bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format. PUT requests that contain other ACLs (for example, custom grants to certain Amazon Web Services accounts) fail and return a <code>400</code> error with the error code <code>AccessControlListNotSupported</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html"> Controlling ownership of objects and disabling ACLs</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`body(ByteStream)`](crate::operation::put_object::builders::PutObjectFluentBuilder::body) / [`set_body(ByteStream)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_body):<br>required: **false**<br><p>Object data.</p><br>
    ///   - [`bucket(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name to which the PUT action was initiated.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`cache_control(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::cache_control) / [`set_cache_control(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_cache_control):<br>required: **false**<br><p>Can be used to specify caching behavior along the request/reply chain. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p><br>
    ///   - [`content_disposition(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::content_disposition) / [`set_content_disposition(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_content_disposition):<br>required: **false**<br><p>Specifies presentational information for the object. For more information, see <a href="https://www.rfc-editor.org/rfc/rfc6266#section-4">https://www.rfc-editor.org/rfc/rfc6266#section-4</a>.</p><br>
    ///   - [`content_encoding(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::content_encoding) / [`set_content_encoding(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_content_encoding):<br>required: **false**<br><p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. For more information, see <a href="https://www.rfc-editor.org/rfc/rfc9110.html#field.content-encoding">https://www.rfc-editor.org/rfc/rfc9110.html#field.content-encoding</a>.</p><br>
    ///   - [`content_language(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::content_language) / [`set_content_language(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_content_language):<br>required: **false**<br><p>The language the content is in.</p><br>
    ///   - [`content_length(i64)`](crate::operation::put_object::builders::PutObjectFluentBuilder::content_length) / [`set_content_length(Option<i64>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_content_length):<br>required: **false**<br><p>Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically. For more information, see <a href="https://www.rfc-editor.org/rfc/rfc9110.html#name-content-length">https://www.rfc-editor.org/rfc/rfc9110.html#name-content-length</a>.</p><br>
    ///   - [`content_md5(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::content_md5) / [`set_content_md5(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_content_md5):<br>required: **false**<br><p>The base64-encoded 128-bit MD5 digest of the message (without the headers) according to RFC 1864. This header can be used as a message integrity check to verify that the data is the same data that was originally sent. Although it is optional, we recommend using the Content-MD5 mechanism as an end-to-end integrity check. For more information about REST request authentication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>.</p><note>  <p>The <code>Content-MD5</code> header is required for any request to upload an object with a retention period configured using Amazon S3 Object Lock. For more information about Amazon S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html">Amazon S3 Object Lock Overview</a> in the <i>Amazon S3 User Guide</i>.</p> </note> <note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`content_type(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::content_type) / [`set_content_type(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_content_type):<br>required: **false**<br><p>A standard MIME type describing the format of the contents. For more information, see <a href="https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type">https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type</a>.</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::put_object::builders::PutObjectFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum-<i>algorithm</i> </code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>.</p> <p>For the <code>x-amz-checksum-<i>algorithm</i> </code> header, replace <code> <i>algorithm</i> </code> with the supported algorithm from the following list:</p> <ul>  <li>   <p>CRC32</p></li>  <li>   <p>CRC32C</p></li>  <li>   <p>SHA1</p></li>  <li>   <p>SHA256</p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If the individual checksum value you provide through <code>x-amz-checksum-<i>algorithm</i> </code> doesn't match the checksum algorithm you set through <code>x-amz-sdk-checksum-algorithm</code>, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter and uses the checksum algorithm that matches the provided value in <code>x-amz-checksum-<i>algorithm</i> </code>.</p><note>  <p>For directory buckets, when you use Amazon Web Services SDKs, <code>CRC32</code> is the default checksum algorithm that's used for performance.</p> </note><br>
    ///   - [`checksum_crc32(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::checksum_crc32) / [`set_checksum_crc32(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_checksum_crc32):<br>required: **false**<br><p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 32-bit CRC32 checksum of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`checksum_crc32_c(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::checksum_crc32_c) / [`set_checksum_crc32_c(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_checksum_crc32_c):<br>required: **false**<br><p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 32-bit CRC32C checksum of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`checksum_sha1(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::checksum_sha1) / [`set_checksum_sha1(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_checksum_sha1):<br>required: **false**<br><p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 160-bit SHA-1 digest of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`checksum_sha256(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::checksum_sha256) / [`set_checksum_sha256(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_checksum_sha256):<br>required: **false**<br><p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 256-bit SHA-256 digest of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`expires(DateTime)`](crate::operation::put_object::builders::PutObjectFluentBuilder::expires) / [`set_expires(Option<DateTime>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_expires):<br>required: **false**<br><p>The date and time at which the object is no longer cacheable. For more information, see <a href="https://www.rfc-editor.org/rfc/rfc7234#section-5.3">https://www.rfc-editor.org/rfc/rfc7234#section-5.3</a>.</p><br>
    ///   - [`grant_full_control(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_grant_full_control):<br>required: **false**<br><p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`grant_read(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::grant_read) / [`set_grant_read(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_grant_read):<br>required: **false**<br><p>Allows grantee to read the object data and its metadata.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_grant_read_acp):<br>required: **false**<br><p>Allows grantee to read the object ACL.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_grant_write_acp):<br>required: **false**<br><p>Allows grantee to write the ACL for the applicable object.</p><note>  <ul>   <li>    <p>This functionality is not supported for directory buckets.</p></li>   <li>    <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>  </ul> </note><br>
    ///   - [`key(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_key):<br>required: **true**<br><p>Object key for which the PUT action was initiated.</p><br>
    ///   - [`metadata(impl Into<String>, impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::metadata) / [`set_metadata(Option<HashMap::<String, String>>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_metadata):<br>required: **false**<br><p>A map of metadata to store with the object in S3.</p><br>
    ///   - [`server_side_encryption(ServerSideEncryption)`](crate::operation::put_object::builders::PutObjectFluentBuilder::server_side_encryption) / [`set_server_side_encryption(Option<ServerSideEncryption>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_server_side_encryption):<br>required: **false**<br><p>The server-side encryption algorithm that was used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>, <code>aws:kms:dsse</code>).</p> <p><b>General purpose buckets </b> - You have four mutually exclusive options to protect data using server-side encryption in Amazon S3, depending on how you choose to manage the encryption keys. Specifically, the encryption key options are Amazon S3 managed keys (SSE-S3), Amazon Web Services KMS keys (SSE-KMS or DSSE-KMS), and customer-provided keys (SSE-C). Amazon S3 encrypts data with server-side encryption by using Amazon S3 managed keys (SSE-S3) by default. You can optionally tell Amazon S3 to encrypt data at rest by using server-side encryption with other key options. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Using Server-Side Encryption</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Directory buckets </b> - For directory buckets, only the server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) value is supported.</p><br>
    ///   - [`storage_class(StorageClass)`](crate::operation::put_object::builders::PutObjectFluentBuilder::storage_class) / [`set_storage_class(Option<StorageClass>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_storage_class):<br>required: **false**<br><p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <ul>   <li>    <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>   <li>    <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>  </ul> </note><br>
    ///   - [`website_redirect_location(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::website_redirect_location) / [`set_website_redirect_location(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_website_redirect_location):<br>required: **false**<br><p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. For information about object metadata, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata</a> in the <i>Amazon S3 User Guide</i>.</p> <p>In the following example, the request header sets the redirect to an object (anotherPage.html) in the same bucket:</p> <p><code>x-amz-website-redirect-location: /anotherPage.html</code></p> <p>In the following example, the request header sets the object redirect to another website:</p> <p><code>x-amz-website-redirect-location: http://www.example.com/</code></p> <p>For more information about website hosting in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html">How to Configure Website Page Redirects</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_sse_customer_algorithm):<br>required: **false**<br><p>Specifies the algorithm to use when encrypting the object (for example, <code>AES256</code>).</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_sse_customer_key):<br>required: **false**<br><p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_sse_customer_key_md5):<br>required: **false**<br><p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`ssekms_key_id(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::ssekms_key_id) / [`set_ssekms_key_id(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_ssekms_key_id):<br>required: **false**<br><p>If <code>x-amz-server-side-encryption</code> has a valid value of <code>aws:kms</code> or <code>aws:kms:dsse</code>, this header specifies the ID (Key ID, Key ARN, or Key Alias) of the Key Management Service (KMS) symmetric encryption customer managed key that was used for the object. If you specify <code>x-amz-server-side-encryption:aws:kms</code> or <code>x-amz-server-side-encryption:aws:kms:dsse</code>, but do not provide<code> x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the Amazon Web Services managed key (<code>aws/s3</code>) to protect the data. If the KMS key does not exist in the same account that's issuing the command, you must use the full ARN and not just the ID.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`ssekms_encryption_context(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::ssekms_encryption_context) / [`set_ssekms_encryption_context(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_ssekms_encryption_context):<br>required: **false**<br><p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs. This value is stored as object metadata and automatically gets passed on to Amazon Web Services KMS for future <code>GetObject</code> or <code>CopyObject</code> operations on this object. This value must be explicitly added during <code>CopyObject</code> operations.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`bucket_key_enabled(bool)`](crate::operation::put_object::builders::PutObjectFluentBuilder::bucket_key_enabled) / [`set_bucket_key_enabled(Option<bool>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_bucket_key_enabled):<br>required: **false**<br><p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p> <p>Specifying this header with a PUT action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::put_object::builders::PutObjectFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`tagging(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::tagging) / [`set_tagging(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_tagging):<br>required: **false**<br><p>The tag-set for the object. The tag-set must be encoded as URL Query parameters. (For example, "Key1=Value1")</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`object_lock_mode(ObjectLockMode)`](crate::operation::put_object::builders::PutObjectFluentBuilder::object_lock_mode) / [`set_object_lock_mode(Option<ObjectLockMode>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_object_lock_mode):<br>required: **false**<br><p>The Object Lock mode that you want to apply to this object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`object_lock_retain_until_date(DateTime)`](crate::operation::put_object::builders::PutObjectFluentBuilder::object_lock_retain_until_date) / [`set_object_lock_retain_until_date(Option<DateTime>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_object_lock_retain_until_date):<br>required: **false**<br><p>The date and time when you want this object's Object Lock to expire. Must be formatted as a timestamp parameter.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`object_lock_legal_hold_status(ObjectLockLegalHoldStatus)`](crate::operation::put_object::builders::PutObjectFluentBuilder::object_lock_legal_hold_status) / [`set_object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_object_lock_legal_hold_status):<br>required: **false**<br><p>Specifies whether a legal hold will be applied to this object. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::put_object::builders::PutObjectFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`PutObjectOutput`](crate::operation::put_object::PutObjectOutput) with field(s):
    ///   - [`expiration(Option<String>)`](crate::operation::put_object::PutObjectOutput::expiration): <p>If the expiration is configured for the object (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a>) in the <i>Amazon S3 User Guide</i>, the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs that provide information about object expiration. The value of the <code>rule-id</code> is URL-encoded.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`e_tag(Option<String>)`](crate::operation::put_object::PutObjectOutput::e_tag): <p>Entity tag for the uploaded object.</p> <p><b>General purpose buckets </b> - To ensure that data is not corrupted traversing the network, for objects where the ETag is the MD5 digest of the object, you can calculate the MD5 while putting an object to Amazon S3 and compare the returned ETag to the calculated MD5 value.</p> <p><b>Directory buckets </b> - The ETag for the object in a directory bucket isn't the MD5 digest of the object.</p>
    ///   - [`checksum_crc32(Option<String>)`](crate::operation::put_object::PutObjectOutput::checksum_crc32): <p>The base64-encoded, 32-bit CRC32 checksum of the object. This will only be present if it was uploaded with the object. When you use an API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_crc32_c(Option<String>)`](crate::operation::put_object::PutObjectOutput::checksum_crc32_c): <p>The base64-encoded, 32-bit CRC32C checksum of the object. This will only be present if it was uploaded with the object. When you use an API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_sha1(Option<String>)`](crate::operation::put_object::PutObjectOutput::checksum_sha1): <p>The base64-encoded, 160-bit SHA-1 digest of the object. This will only be present if it was uploaded with the object. When you use the API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_sha256(Option<String>)`](crate::operation::put_object::PutObjectOutput::checksum_sha256): <p>The base64-encoded, 256-bit SHA-256 digest of the object. This will only be present if it was uploaded with the object. When you use an API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::operation::put_object::PutObjectOutput::server_side_encryption): <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>, <code>aws:kms:dsse</code>).</p><note>  <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p> </note>
    ///   - [`version_id(Option<String>)`](crate::operation::put_object::PutObjectOutput::version_id): <p>Version ID of the object.</p> <p>If you enable versioning for a bucket, Amazon S3 automatically generates a unique version ID for the object being stored. Amazon S3 returns this ID in the response. When you enable versioning for a bucket, if Amazon S3 receives multiple write requests for the same object simultaneously, it stores all of the objects. For more information about versioning, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html">Adding Objects to Versioning-Enabled Buckets</a> in the <i>Amazon S3 User Guide</i>. For information about returning the versioning state of a bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::operation::put_object::PutObjectOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to confirm the encryption algorithm that's used.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::operation::put_object::PutObjectOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide the round-trip message integrity verification of the customer-provided encryption key.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`ssekms_key_id(Option<String>)`](crate::operation::put_object::PutObjectOutput::ssekms_key_id): <p>If <code>x-amz-server-side-encryption</code> has a valid value of <code>aws:kms</code> or <code>aws:kms:dsse</code>, this header indicates the ID of the Key Management Service (KMS) symmetric encryption customer managed key that was used for the object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`ssekms_encryption_context(Option<String>)`](crate::operation::put_object::PutObjectOutput::ssekms_encryption_context): <p>If present, indicates the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs. This value is stored as object metadata and automatically gets passed on to Amazon Web Services KMS for future <code>GetObject</code> or <code>CopyObject</code> operations on this object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`bucket_key_enabled(Option<bool>)`](crate::operation::put_object::PutObjectOutput::bucket_key_enabled): <p>Indicates whether the uploaded object uses an S3 Bucket Key for server-side encryption with Key Management Service (KMS) keys (SSE-KMS).</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::put_object::PutObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    /// - On failure, responds with [`SdkError<PutObjectError>`](crate::operation::put_object::PutObjectError)
    pub fn put_object(&self) -> crate::operation::put_object::builders::PutObjectFluentBuilder {
        crate::operation::put_object::builders::PutObjectFluentBuilder::new(self.handle.clone())
    }
}
