// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`UploadPart`](crate::operation::upload_part::builders::UploadPartFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`body(ByteStream)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::body) / [`set_body(ByteStream)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_body):<br>required: **false**<br><p>Object data.</p><br>
    ///   - [`bucket(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket to which the multipart upload was initiated.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`content_length(i64)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::content_length) / [`set_content_length(Option<i64>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_content_length):<br>required: **false**<br><p>Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically.</p><br>
    ///   - [`content_md5(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::content_md5) / [`set_content_md5(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_content_md5):<br>required: **false**<br><p>The base64-encoded 128-bit MD5 digest of the part data. This parameter is auto-populated when using the command from the CLI. This parameter is required if object lock parameters are specified.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p> <p>This checksum algorithm must be the same for all parts and it match the checksum value supplied in the <code>CreateMultipartUpload</code> request.</p><br>
    ///   - [`checksum_crc32(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::checksum_crc32) / [`set_checksum_crc32(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_checksum_crc32):<br>required: **false**<br><p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 32-bit CRC32 checksum of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`checksum_crc32_c(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::checksum_crc32_c) / [`set_checksum_crc32_c(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_checksum_crc32_c):<br>required: **false**<br><p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 32-bit CRC32C checksum of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`checksum_sha1(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::checksum_sha1) / [`set_checksum_sha1(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_checksum_sha1):<br>required: **false**<br><p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 160-bit SHA-1 digest of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`checksum_sha256(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::checksum_sha256) / [`set_checksum_sha256(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_checksum_sha256):<br>required: **false**<br><p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the base64-encoded, 256-bit SHA-256 digest of the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_key):<br>required: **true**<br><p>Object key for which the multipart upload was initiated.</p><br>
    ///   - [`part_number(i32)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::part_number) / [`set_part_number(Option<i32>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_part_number):<br>required: **true**<br><p>Part number of part being uploaded. This is a positive integer between 1 and 10,000.</p><br>
    ///   - [`upload_id(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::upload_id) / [`set_upload_id(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_upload_id):<br>required: **true**<br><p>Upload ID identifying the multipart upload whose part is being uploaded.</p><br>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_sse_customer_algorithm):<br>required: **false**<br><p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_sse_customer_key):<br>required: **false**<br><p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm header</code>. This must be the same encryption key specified in the initiate multipart upload request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_sse_customer_key_md5):<br>required: **false**<br><p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::upload_part::builders::UploadPartFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`UploadPartOutput`](crate::operation::upload_part::UploadPartOutput) with field(s):
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::operation::upload_part::UploadPartOutput::server_side_encryption): <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>  <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p> </note>
    ///   - [`e_tag(Option<String>)`](crate::operation::upload_part::UploadPartOutput::e_tag): <p>Entity tag for the uploaded object.</p>
    ///   - [`checksum_crc32(Option<String>)`](crate::operation::upload_part::UploadPartOutput::checksum_crc32): <p>The base64-encoded, 32-bit CRC32 checksum of the object. This will only be present if it was uploaded with the object. When you use an API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_crc32_c(Option<String>)`](crate::operation::upload_part::UploadPartOutput::checksum_crc32_c): <p>The base64-encoded, 32-bit CRC32C checksum of the object. This will only be present if it was uploaded with the object. When you use an API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_sha1(Option<String>)`](crate::operation::upload_part::UploadPartOutput::checksum_sha1): <p>The base64-encoded, 160-bit SHA-1 digest of the object. This will only be present if it was uploaded with the object. When you use the API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`checksum_sha256(Option<String>)`](crate::operation::upload_part::UploadPartOutput::checksum_sha256): <p>The base64-encoded, 256-bit SHA-256 digest of the object. This will only be present if it was uploaded with the object. When you use an API operation on an object that was uploaded using multipart uploads, this value may not be a direct checksum value of the full object. Instead, it's a calculation based on the checksum values of each individual part. For more information about how checksums are calculated with multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::operation::upload_part::UploadPartOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to confirm the encryption algorithm that's used.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::operation::upload_part::UploadPartOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide the round-trip message integrity verification of the customer-provided encryption key.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`ssekms_key_id(Option<String>)`](crate::operation::upload_part::UploadPartOutput::ssekms_key_id): <p>If present, indicates the ID of the Key Management Service (KMS) symmetric encryption customer managed key that was used for the object.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`bucket_key_enabled(Option<bool>)`](crate::operation::upload_part::UploadPartOutput::bucket_key_enabled): <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Key Management Service (KMS) keys (SSE-KMS).</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::upload_part::UploadPartOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    /// - On failure, responds with [`SdkError<UploadPartError>`](crate::operation::upload_part::UploadPartError)
    pub fn upload_part(&self) -> crate::operation::upload_part::builders::UploadPartFluentBuilder {
        crate::operation::upload_part::builders::UploadPartFluentBuilder::new(self.handle.clone())
    }
}
