// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct CreateMultipartUploadInput {
    /// <p>The canned ACL to apply to the object. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can grant access permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the new object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. One way to grant the permissions using the request headers is to specify a canned ACL with the <code>x-amz-acl</code> request header.</p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub acl: ::std::option::Option<crate::types::ObjectCannedAcl>,
    /// <p>The name of the bucket where the multipart upload is initiated and where the object is uploaded.</p>
    /// <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>Access points and Object Lambda access points are not supported by directory buckets.</p>
    /// </note>
    /// <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub bucket: ::std::option::Option<::std::string::String>,
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub cache_control: ::std::option::Option<::std::string::String>,
    /// <p>Specifies presentational information for the object.</p>
    pub content_disposition: ::std::option::Option<::std::string::String>,
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>
    /// <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p>
    /// </note>
    pub content_encoding: ::std::option::Option<::std::string::String>,
    /// <p>The language that the content is in.</p>
    pub content_language: ::std::option::Option<::std::string::String>,
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub content_type: ::std::option::Option<::std::string::String>,
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub expires: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Specify access permissions explicitly to give the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub grant_full_control: ::std::option::Option<::std::string::String>,
    /// <p>Specify access permissions explicitly to allow grantee to read the object data and its metadata.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub grant_read: ::std::option::Option<::std::string::String>,
    /// <p>Specify access permissions explicitly to allows grantee to read the object ACL.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub grant_read_acp: ::std::option::Option<::std::string::String>,
    /// <p>Specify access permissions explicitly to allows grantee to allow grantee to write the ACL for the applicable object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub grant_write_acp: ::std::option::Option<::std::string::String>,
    /// <p>Object key for which the multipart upload is to be initiated.</p>
    pub key: ::std::option::Option<::std::string::String>,
    /// <p>A map of metadata to store with the object in S3.</p>
    pub metadata: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    /// <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>
    /// <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p>
    /// </note>
    pub server_side_encryption: ::std::option::Option<crate::types::ServerSideEncryption>,
    /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <ul>
    /// <li>
    /// <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>
    /// <li>
    /// <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>
    /// </ul>
    /// </note>
    pub storage_class: ::std::option::Option<crate::types::StorageClass>,
    /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub website_redirect_location: ::std::option::Option<::std::string::String>,
    /// <p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub sse_customer_algorithm: ::std::option::Option<::std::string::String>,
    /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub sse_customer_key: ::std::option::Option<::std::string::String>,
    /// <p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub sse_customer_key_md5: ::std::option::Option<::std::string::String>,
    /// <p>Specifies the ID (Key ID, Key ARN, or Key Alias) of the symmetric encryption customer managed key to use for object encryption.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub ssekms_key_id: ::std::option::Option<::std::string::String>,
    /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub ssekms_encryption_context: ::std::option::Option<::std::string::String>,
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub bucket_key_enabled: ::std::option::Option<bool>,
    /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub request_payer: ::std::option::Option<crate::types::RequestPayer>,
    /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub tagging: ::std::option::Option<::std::string::String>,
    /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub object_lock_mode: ::std::option::Option<crate::types::ObjectLockMode>,
    /// <p>Specifies the date and time when you want the Object Lock to expire.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub object_lock_retain_until_date: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Specifies whether you want to apply a legal hold to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub object_lock_legal_hold_status: ::std::option::Option<crate::types::ObjectLockLegalHoldStatus>,
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub expected_bucket_owner: ::std::option::Option<::std::string::String>,
    /// <p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub checksum_algorithm: ::std::option::Option<crate::types::ChecksumAlgorithm>,
}
impl CreateMultipartUploadInput {
    /// <p>The canned ACL to apply to the object. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can grant access permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the new object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. One way to grant the permissions using the request headers is to specify a canned ACL with the <code>x-amz-acl</code> request header.</p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn acl(&self) -> ::std::option::Option<&crate::types::ObjectCannedAcl> {
        self.acl.as_ref()
    }
    /// <p>The name of the bucket where the multipart upload is initiated and where the object is uploaded.</p>
    /// <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>Access points and Object Lambda access points are not supported by directory buckets.</p>
    /// </note>
    /// <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn bucket(&self) -> ::std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn cache_control(&self) -> ::std::option::Option<&str> {
        self.cache_control.as_deref()
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn content_disposition(&self) -> ::std::option::Option<&str> {
        self.content_disposition.as_deref()
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>
    /// <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p>
    /// </note>
    pub fn content_encoding(&self) -> ::std::option::Option<&str> {
        self.content_encoding.as_deref()
    }
    /// <p>The language that the content is in.</p>
    pub fn content_language(&self) -> ::std::option::Option<&str> {
        self.content_language.as_deref()
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn content_type(&self) -> ::std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn expires(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.expires.as_ref()
    }
    /// <p>Specify access permissions explicitly to give the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_full_control(&self) -> ::std::option::Option<&str> {
        self.grant_full_control.as_deref()
    }
    /// <p>Specify access permissions explicitly to allow grantee to read the object data and its metadata.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_read(&self) -> ::std::option::Option<&str> {
        self.grant_read.as_deref()
    }
    /// <p>Specify access permissions explicitly to allows grantee to read the object ACL.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_read_acp(&self) -> ::std::option::Option<&str> {
        self.grant_read_acp.as_deref()
    }
    /// <p>Specify access permissions explicitly to allows grantee to allow grantee to write the ACL for the applicable object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_write_acp(&self) -> ::std::option::Option<&str> {
        self.grant_write_acp.as_deref()
    }
    /// <p>Object key for which the multipart upload is to be initiated.</p>
    pub fn key(&self) -> ::std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn metadata(&self) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.metadata.as_ref()
    }
    /// <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>
    /// <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p>
    /// </note>
    pub fn server_side_encryption(&self) -> ::std::option::Option<&crate::types::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <ul>
    /// <li>
    /// <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>
    /// <li>
    /// <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>
    /// </ul>
    /// </note>
    pub fn storage_class(&self) -> ::std::option::Option<&crate::types::StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn website_redirect_location(&self) -> ::std::option::Option<&str> {
        self.website_redirect_location.as_deref()
    }
    /// <p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn sse_customer_algorithm(&self) -> ::std::option::Option<&str> {
        self.sse_customer_algorithm.as_deref()
    }
    /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn sse_customer_key(&self) -> ::std::option::Option<&str> {
        self.sse_customer_key.as_deref()
    }
    /// <p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn sse_customer_key_md5(&self) -> ::std::option::Option<&str> {
        self.sse_customer_key_md5.as_deref()
    }
    /// <p>Specifies the ID (Key ID, Key ARN, or Key Alias) of the symmetric encryption customer managed key to use for object encryption.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn ssekms_key_id(&self) -> ::std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn ssekms_encryption_context(&self) -> ::std::option::Option<&str> {
        self.ssekms_encryption_context.as_deref()
    }
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn bucket_key_enabled(&self) -> ::std::option::Option<bool> {
        self.bucket_key_enabled
    }
    /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn request_payer(&self) -> ::std::option::Option<&crate::types::RequestPayer> {
        self.request_payer.as_ref()
    }
    /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn tagging(&self) -> ::std::option::Option<&str> {
        self.tagging.as_deref()
    }
    /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn object_lock_mode(&self) -> ::std::option::Option<&crate::types::ObjectLockMode> {
        self.object_lock_mode.as_ref()
    }
    /// <p>Specifies the date and time when you want the Object Lock to expire.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn object_lock_retain_until_date(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.object_lock_retain_until_date.as_ref()
    }
    /// <p>Specifies whether you want to apply a legal hold to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn object_lock_legal_hold_status(&self) -> ::std::option::Option<&crate::types::ObjectLockLegalHoldStatus> {
        self.object_lock_legal_hold_status.as_ref()
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn expected_bucket_owner(&self) -> ::std::option::Option<&str> {
        self.expected_bucket_owner.as_deref()
    }
    /// <p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn checksum_algorithm(&self) -> ::std::option::Option<&crate::types::ChecksumAlgorithm> {
        self.checksum_algorithm.as_ref()
    }
}
impl ::std::fmt::Debug for CreateMultipartUploadInput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultipartUploadInput");
        formatter.field("acl", &self.acl);
        formatter.field("bucket", &self.bucket);
        formatter.field("cache_control", &self.cache_control);
        formatter.field("content_disposition", &self.content_disposition);
        formatter.field("content_encoding", &self.content_encoding);
        formatter.field("content_language", &self.content_language);
        formatter.field("content_type", &self.content_type);
        formatter.field("expires", &self.expires);
        formatter.field("grant_full_control", &self.grant_full_control);
        formatter.field("grant_read", &self.grant_read);
        formatter.field("grant_read_acp", &self.grant_read_acp);
        formatter.field("grant_write_acp", &self.grant_write_acp);
        formatter.field("key", &self.key);
        formatter.field("metadata", &self.metadata);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("website_redirect_location", &self.website_redirect_location);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("sse_customer_key", &"*** Sensitive Data Redacted ***");
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("ssekms_encryption_context", &"*** Sensitive Data Redacted ***");
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("request_payer", &self.request_payer);
        formatter.field("tagging", &self.tagging);
        formatter.field("object_lock_mode", &self.object_lock_mode);
        formatter.field("object_lock_retain_until_date", &self.object_lock_retain_until_date);
        formatter.field("object_lock_legal_hold_status", &self.object_lock_legal_hold_status);
        formatter.field("expected_bucket_owner", &self.expected_bucket_owner);
        formatter.field("checksum_algorithm", &self.checksum_algorithm);
        formatter.finish()
    }
}
impl CreateMultipartUploadInput {
    /// Creates a new builder-style object to manufacture [`CreateMultipartUploadInput`](crate::operation::create_multipart_upload::CreateMultipartUploadInput).
    pub fn builder() -> crate::operation::create_multipart_upload::builders::CreateMultipartUploadInputBuilder {
        crate::operation::create_multipart_upload::builders::CreateMultipartUploadInputBuilder::default()
    }
}

/// A builder for [`CreateMultipartUploadInput`](crate::operation::create_multipart_upload::CreateMultipartUploadInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
pub struct CreateMultipartUploadInputBuilder {
    pub(crate) acl: ::std::option::Option<crate::types::ObjectCannedAcl>,
    pub(crate) bucket: ::std::option::Option<::std::string::String>,
    pub(crate) cache_control: ::std::option::Option<::std::string::String>,
    pub(crate) content_disposition: ::std::option::Option<::std::string::String>,
    pub(crate) content_encoding: ::std::option::Option<::std::string::String>,
    pub(crate) content_language: ::std::option::Option<::std::string::String>,
    pub(crate) content_type: ::std::option::Option<::std::string::String>,
    pub(crate) expires: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) grant_full_control: ::std::option::Option<::std::string::String>,
    pub(crate) grant_read: ::std::option::Option<::std::string::String>,
    pub(crate) grant_read_acp: ::std::option::Option<::std::string::String>,
    pub(crate) grant_write_acp: ::std::option::Option<::std::string::String>,
    pub(crate) key: ::std::option::Option<::std::string::String>,
    pub(crate) metadata: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    pub(crate) server_side_encryption: ::std::option::Option<crate::types::ServerSideEncryption>,
    pub(crate) storage_class: ::std::option::Option<crate::types::StorageClass>,
    pub(crate) website_redirect_location: ::std::option::Option<::std::string::String>,
    pub(crate) sse_customer_algorithm: ::std::option::Option<::std::string::String>,
    pub(crate) sse_customer_key: ::std::option::Option<::std::string::String>,
    pub(crate) sse_customer_key_md5: ::std::option::Option<::std::string::String>,
    pub(crate) ssekms_key_id: ::std::option::Option<::std::string::String>,
    pub(crate) ssekms_encryption_context: ::std::option::Option<::std::string::String>,
    pub(crate) bucket_key_enabled: ::std::option::Option<bool>,
    pub(crate) request_payer: ::std::option::Option<crate::types::RequestPayer>,
    pub(crate) tagging: ::std::option::Option<::std::string::String>,
    pub(crate) object_lock_mode: ::std::option::Option<crate::types::ObjectLockMode>,
    pub(crate) object_lock_retain_until_date: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) object_lock_legal_hold_status: ::std::option::Option<crate::types::ObjectLockLegalHoldStatus>,
    pub(crate) expected_bucket_owner: ::std::option::Option<::std::string::String>,
    pub(crate) checksum_algorithm: ::std::option::Option<crate::types::ChecksumAlgorithm>,
}
impl CreateMultipartUploadInputBuilder {
    /// <p>The canned ACL to apply to the object. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can grant access permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the new object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. One way to grant the permissions using the request headers is to specify a canned ACL with the <code>x-amz-acl</code> request header.</p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn acl(mut self, input: crate::types::ObjectCannedAcl) -> Self {
        self.acl = ::std::option::Option::Some(input);
        self
    }
    /// <p>The canned ACL to apply to the object. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can grant access permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the new object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. One way to grant the permissions using the request headers is to specify a canned ACL with the <code>x-amz-acl</code> request header.</p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_acl(mut self, input: ::std::option::Option<crate::types::ObjectCannedAcl>) -> Self {
        self.acl = input;
        self
    }
    /// <p>The canned ACL to apply to the object. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can grant access permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the new object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. One way to grant the permissions using the request headers is to specify a canned ACL with the <code>x-amz-acl</code> request header.</p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_acl(&self) -> &::std::option::Option<crate::types::ObjectCannedAcl> {
        &self.acl
    }
    /// <p>The name of the bucket where the multipart upload is initiated and where the object is uploaded.</p>
    /// <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>Access points and Object Lambda access points are not supported by directory buckets.</p>
    /// </note>
    /// <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// This field is required.
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.bucket = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the bucket where the multipart upload is initiated and where the object is uploaded.</p>
    /// <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>Access points and Object Lambda access points are not supported by directory buckets.</p>
    /// </note>
    /// <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.bucket = input;
        self
    }
    /// <p>The name of the bucket where the multipart upload is initiated and where the object is uploaded.</p>
    /// <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>Access points and Object Lambda access points are not supported by directory buckets.</p>
    /// </note>
    /// <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        &self.bucket
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn cache_control(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.cache_control = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn set_cache_control(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.cache_control = input;
        self
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn get_cache_control(&self) -> &::std::option::Option<::std::string::String> {
        &self.cache_control
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn content_disposition(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_disposition = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn set_content_disposition(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_disposition = input;
        self
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn get_content_disposition(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_disposition
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>
    /// <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p>
    /// </note>
    pub fn content_encoding(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_encoding = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>
    /// <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p>
    /// </note>
    pub fn set_content_encoding(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_encoding = input;
        self
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>
    /// <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p>
    /// </note>
    pub fn get_content_encoding(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_encoding
    }
    /// <p>The language that the content is in.</p>
    pub fn content_language(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_language = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The language that the content is in.</p>
    pub fn set_content_language(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_language = input;
        self
    }
    /// <p>The language that the content is in.</p>
    pub fn get_content_language(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_language
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn content_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn set_content_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_type = input;
        self
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn get_content_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_type
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn expires(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.expires = ::std::option::Option::Some(input);
        self
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn set_expires(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.expires = input;
        self
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn get_expires(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.expires
    }
    /// <p>Specify access permissions explicitly to give the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_full_control(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.grant_full_control = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify access permissions explicitly to give the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_grant_full_control(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.grant_full_control = input;
        self
    }
    /// <p>Specify access permissions explicitly to give the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_grant_full_control(&self) -> &::std::option::Option<::std::string::String> {
        &self.grant_full_control
    }
    /// <p>Specify access permissions explicitly to allow grantee to read the object data and its metadata.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_read(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.grant_read = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify access permissions explicitly to allow grantee to read the object data and its metadata.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_grant_read(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.grant_read = input;
        self
    }
    /// <p>Specify access permissions explicitly to allow grantee to read the object data and its metadata.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_grant_read(&self) -> &::std::option::Option<::std::string::String> {
        &self.grant_read
    }
    /// <p>Specify access permissions explicitly to allows grantee to read the object ACL.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_read_acp(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.grant_read_acp = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify access permissions explicitly to allows grantee to read the object ACL.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_grant_read_acp(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.grant_read_acp = input;
        self
    }
    /// <p>Specify access permissions explicitly to allows grantee to read the object ACL.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_grant_read_acp(&self) -> &::std::option::Option<::std::string::String> {
        &self.grant_read_acp
    }
    /// <p>Specify access permissions explicitly to allows grantee to allow grantee to write the ACL for the applicable object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_write_acp(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.grant_write_acp = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify access permissions explicitly to allows grantee to allow grantee to write the ACL for the applicable object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_grant_write_acp(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.grant_write_acp = input;
        self
    }
    /// <p>Specify access permissions explicitly to allows grantee to allow grantee to write the ACL for the applicable object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_grant_write_acp(&self) -> &::std::option::Option<::std::string::String> {
        &self.grant_write_acp
    }
    /// <p>Object key for which the multipart upload is to be initiated.</p>
    /// This field is required.
    pub fn key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Object key for which the multipart upload is to be initiated.</p>
    pub fn set_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key = input;
        self
    }
    /// <p>Object key for which the multipart upload is to be initiated.</p>
    pub fn get_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.key
    }
    /// Adds a key-value pair to `metadata`.
    ///
    /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
    ///
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn metadata(mut self, k: impl ::std::convert::Into<::std::string::String>, v: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut hash_map = self.metadata.unwrap_or_default();
        hash_map.insert(k.into(), v.into());
        self.metadata = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn set_metadata(mut self, input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>) -> Self {
        self.metadata = input;
        self
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn get_metadata(&self) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        &self.metadata
    }
    /// <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>
    /// <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p>
    /// </note>
    pub fn server_side_encryption(mut self, input: crate::types::ServerSideEncryption) -> Self {
        self.server_side_encryption = ::std::option::Option::Some(input);
        self
    }
    /// <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>
    /// <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p>
    /// </note>
    pub fn set_server_side_encryption(mut self, input: ::std::option::Option<crate::types::ServerSideEncryption>) -> Self {
        self.server_side_encryption = input;
        self
    }
    /// <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>
    /// <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p>
    /// </note>
    pub fn get_server_side_encryption(&self) -> &::std::option::Option<crate::types::ServerSideEncryption> {
        &self.server_side_encryption
    }
    /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <ul>
    /// <li>
    /// <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>
    /// <li>
    /// <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>
    /// </ul>
    /// </note>
    pub fn storage_class(mut self, input: crate::types::StorageClass) -> Self {
        self.storage_class = ::std::option::Option::Some(input);
        self
    }
    /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <ul>
    /// <li>
    /// <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>
    /// <li>
    /// <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>
    /// </ul>
    /// </note>
    pub fn set_storage_class(mut self, input: ::std::option::Option<crate::types::StorageClass>) -> Self {
        self.storage_class = input;
        self
    }
    /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <ul>
    /// <li>
    /// <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>
    /// <li>
    /// <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>
    /// </ul>
    /// </note>
    pub fn get_storage_class(&self) -> &::std::option::Option<crate::types::StorageClass> {
        &self.storage_class
    }
    /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn website_redirect_location(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.website_redirect_location = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_website_redirect_location(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.website_redirect_location = input;
        self
    }
    /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_website_redirect_location(&self) -> &::std::option::Option<::std::string::String> {
        &self.website_redirect_location
    }
    /// <p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn sse_customer_algorithm(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sse_customer_algorithm = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_sse_customer_algorithm(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sse_customer_algorithm = input;
        self
    }
    /// <p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_sse_customer_algorithm(&self) -> &::std::option::Option<::std::string::String> {
        &self.sse_customer_algorithm
    }
    /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn sse_customer_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sse_customer_key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_sse_customer_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sse_customer_key = input;
        self
    }
    /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_sse_customer_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.sse_customer_key
    }
    /// <p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn sse_customer_key_md5(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sse_customer_key_md5 = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_sse_customer_key_md5(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sse_customer_key_md5 = input;
        self
    }
    /// <p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_sse_customer_key_md5(&self) -> &::std::option::Option<::std::string::String> {
        &self.sse_customer_key_md5
    }
    /// <p>Specifies the ID (Key ID, Key ARN, or Key Alias) of the symmetric encryption customer managed key to use for object encryption.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn ssekms_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.ssekms_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies the ID (Key ID, Key ARN, or Key Alias) of the symmetric encryption customer managed key to use for object encryption.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_ssekms_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.ssekms_key_id = input;
        self
    }
    /// <p>Specifies the ID (Key ID, Key ARN, or Key Alias) of the symmetric encryption customer managed key to use for object encryption.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_ssekms_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.ssekms_key_id
    }
    /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn ssekms_encryption_context(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.ssekms_encryption_context = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_ssekms_encryption_context(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.ssekms_encryption_context = input;
        self
    }
    /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_ssekms_encryption_context(&self) -> &::std::option::Option<::std::string::String> {
        &self.ssekms_encryption_context
    }
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn bucket_key_enabled(mut self, input: bool) -> Self {
        self.bucket_key_enabled = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_bucket_key_enabled(mut self, input: ::std::option::Option<bool>) -> Self {
        self.bucket_key_enabled = input;
        self
    }
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_bucket_key_enabled(&self) -> &::std::option::Option<bool> {
        &self.bucket_key_enabled
    }
    /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn request_payer(mut self, input: crate::types::RequestPayer) -> Self {
        self.request_payer = ::std::option::Option::Some(input);
        self
    }
    /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_request_payer(mut self, input: ::std::option::Option<crate::types::RequestPayer>) -> Self {
        self.request_payer = input;
        self
    }
    /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_request_payer(&self) -> &::std::option::Option<crate::types::RequestPayer> {
        &self.request_payer
    }
    /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn tagging(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tagging = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_tagging(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tagging = input;
        self
    }
    /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_tagging(&self) -> &::std::option::Option<::std::string::String> {
        &self.tagging
    }
    /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn object_lock_mode(mut self, input: crate::types::ObjectLockMode) -> Self {
        self.object_lock_mode = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_object_lock_mode(mut self, input: ::std::option::Option<crate::types::ObjectLockMode>) -> Self {
        self.object_lock_mode = input;
        self
    }
    /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_object_lock_mode(&self) -> &::std::option::Option<crate::types::ObjectLockMode> {
        &self.object_lock_mode
    }
    /// <p>Specifies the date and time when you want the Object Lock to expire.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn object_lock_retain_until_date(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.object_lock_retain_until_date = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the date and time when you want the Object Lock to expire.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_object_lock_retain_until_date(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.object_lock_retain_until_date = input;
        self
    }
    /// <p>Specifies the date and time when you want the Object Lock to expire.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_object_lock_retain_until_date(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.object_lock_retain_until_date
    }
    /// <p>Specifies whether you want to apply a legal hold to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn object_lock_legal_hold_status(mut self, input: crate::types::ObjectLockLegalHoldStatus) -> Self {
        self.object_lock_legal_hold_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether you want to apply a legal hold to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_object_lock_legal_hold_status(mut self, input: ::std::option::Option<crate::types::ObjectLockLegalHoldStatus>) -> Self {
        self.object_lock_legal_hold_status = input;
        self
    }
    /// <p>Specifies whether you want to apply a legal hold to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_object_lock_legal_hold_status(&self) -> &::std::option::Option<crate::types::ObjectLockLegalHoldStatus> {
        &self.object_lock_legal_hold_status
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn expected_bucket_owner(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.expected_bucket_owner = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn set_expected_bucket_owner(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.expected_bucket_owner = input;
        self
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn get_expected_bucket_owner(&self) -> &::std::option::Option<::std::string::String> {
        &self.expected_bucket_owner
    }
    /// <p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn checksum_algorithm(mut self, input: crate::types::ChecksumAlgorithm) -> Self {
        self.checksum_algorithm = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_checksum_algorithm(mut self, input: ::std::option::Option<crate::types::ChecksumAlgorithm>) -> Self {
        self.checksum_algorithm = input;
        self
    }
    /// <p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_checksum_algorithm(&self) -> &::std::option::Option<crate::types::ChecksumAlgorithm> {
        &self.checksum_algorithm
    }
    /// Consumes the builder and constructs a [`CreateMultipartUploadInput`](crate::operation::create_multipart_upload::CreateMultipartUploadInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::create_multipart_upload::CreateMultipartUploadInput, ::aws_smithy_types::error::operation::BuildError>
    {
        ::std::result::Result::Ok(crate::operation::create_multipart_upload::CreateMultipartUploadInput {
            acl: self.acl,
            bucket: self.bucket,
            cache_control: self.cache_control,
            content_disposition: self.content_disposition,
            content_encoding: self.content_encoding,
            content_language: self.content_language,
            content_type: self.content_type,
            expires: self.expires,
            grant_full_control: self.grant_full_control,
            grant_read: self.grant_read,
            grant_read_acp: self.grant_read_acp,
            grant_write_acp: self.grant_write_acp,
            key: self.key,
            metadata: self.metadata,
            server_side_encryption: self.server_side_encryption,
            storage_class: self.storage_class,
            website_redirect_location: self.website_redirect_location,
            sse_customer_algorithm: self.sse_customer_algorithm,
            sse_customer_key: self.sse_customer_key,
            sse_customer_key_md5: self.sse_customer_key_md5,
            ssekms_key_id: self.ssekms_key_id,
            ssekms_encryption_context: self.ssekms_encryption_context,
            bucket_key_enabled: self.bucket_key_enabled,
            request_payer: self.request_payer,
            tagging: self.tagging,
            object_lock_mode: self.object_lock_mode,
            object_lock_retain_until_date: self.object_lock_retain_until_date,
            object_lock_legal_hold_status: self.object_lock_legal_hold_status,
            expected_bucket_owner: self.expected_bucket_owner,
            checksum_algorithm: self.checksum_algorithm,
        })
    }
}
impl ::std::fmt::Debug for CreateMultipartUploadInputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultipartUploadInputBuilder");
        formatter.field("acl", &self.acl);
        formatter.field("bucket", &self.bucket);
        formatter.field("cache_control", &self.cache_control);
        formatter.field("content_disposition", &self.content_disposition);
        formatter.field("content_encoding", &self.content_encoding);
        formatter.field("content_language", &self.content_language);
        formatter.field("content_type", &self.content_type);
        formatter.field("expires", &self.expires);
        formatter.field("grant_full_control", &self.grant_full_control);
        formatter.field("grant_read", &self.grant_read);
        formatter.field("grant_read_acp", &self.grant_read_acp);
        formatter.field("grant_write_acp", &self.grant_write_acp);
        formatter.field("key", &self.key);
        formatter.field("metadata", &self.metadata);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("website_redirect_location", &self.website_redirect_location);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("sse_customer_key", &"*** Sensitive Data Redacted ***");
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("ssekms_encryption_context", &"*** Sensitive Data Redacted ***");
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("request_payer", &self.request_payer);
        formatter.field("tagging", &self.tagging);
        formatter.field("object_lock_mode", &self.object_lock_mode);
        formatter.field("object_lock_retain_until_date", &self.object_lock_retain_until_date);
        formatter.field("object_lock_legal_hold_status", &self.object_lock_legal_hold_status);
        formatter.field("expected_bucket_owner", &self.expected_bucket_owner);
        formatter.field("checksum_algorithm", &self.checksum_algorithm);
        formatter.finish()
    }
}
