// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::create_multipart_upload::_create_multipart_upload_output::CreateMultipartUploadOutputBuilder;

pub use crate::operation::create_multipart_upload::_create_multipart_upload_input::CreateMultipartUploadInputBuilder;

impl CreateMultipartUploadInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::create_multipart_upload::CreateMultipartUploadOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_multipart_upload::CreateMultipartUploadError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.create_multipart_upload();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `CreateMultipartUpload`.
///
/// <p>This action initiates a multipart upload and returns an upload ID. This upload ID is used to associate all of the parts in the specific multipart upload. You specify this upload ID in each of your subsequent upload part requests (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>). You also include this upload ID in the final request to either complete or abort the multipart upload request. For more information about multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart Upload Overview</a> in the <i>Amazon S3 User Guide</i>.</p><note>
/// <p>After you initiate a multipart upload and upload one or more parts, to stop being charged for storing the uploaded parts, you must either complete or abort the multipart upload. Amazon S3 frees up the space used to store the parts and stops charging you for storing them only after you either complete or abort a multipart upload.</p>
/// </note>
/// <p>If you have configured a lifecycle rule to abort incomplete multipart uploads, the created multipart upload must be completed within the number of days specified in the bucket lifecycle configuration. Otherwise, the incomplete multipart upload becomes eligible for an abort action and Amazon S3 aborts the multipart upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration</a>.</p><note>
/// <ul>
/// <li>
/// <p><b>Directory buckets </b> - S3 Lifecycle is not supported by directory buckets.</p></li>
/// <li>
/// <p><b>Directory buckets </b> - For directory buckets, you must make requests for this API operation to the Zonal endpoint. These endpoints support virtual-hosted-style requests in the format <code>https://<i>bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com/<i>key-name</i> </code>. Path-style requests are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Regions-and-Zones.html">Regional and Zonal endpoints</a> in the <i>Amazon S3 User Guide</i>.</p></li>
/// </ul>
/// </note>
/// <dl>
/// <dt>
/// Request signing
/// </dt>
/// <dd>
/// <p>For request signing, multipart upload is just a series of regular requests. You initiate a multipart upload, send one or more requests to upload parts, and then complete the multipart upload process. You sign each request individually. There is nothing special about signing multipart upload requests. For more information about signing, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests (Amazon Web Services Signature Version 4)</a> in the <i>Amazon S3 User Guide</i>.</p>
/// </dd>
/// <dt>
/// Permissions
/// </dt>
/// <dd>
/// <ul>
/// <li>
/// <p><b>General purpose bucket permissions</b> - For information about the permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart upload and permissions</a> in the <i>Amazon S3 User Guide</i>.</p>
/// <p>To perform a multipart upload with encryption by using an Amazon Web Services KMS key, the requester must have permission to the <code>kms:Decrypt</code> and <code>kms:GenerateDataKey*</code> actions on the key. These permissions are required because Amazon S3 must decrypt and read data from the encrypted file parts before it completes the multipart upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpuAndPermissions">Multipart upload API and permissions</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">Protecting data using server-side encryption with Amazon Web Services KMS</a> in the <i>Amazon S3 User Guide</i>.</p></li>
/// <li>
/// <p><b>Directory bucket permissions</b> - To grant access to this API operation on a directory bucket, we recommend that you use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a> API operation for session-based authorization. Specifically, you grant the <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM identity-based policy. Then, you make the <code>CreateSession</code> API call on the bucket to obtain a session token. With the session token in your request header, you can make API requests to this operation. After the session token expires, you make another <code>CreateSession</code> API call to generate a new session token for use. Amazon Web Services CLI or SDKs create session and refresh the session token automatically to avoid service interruptions when a session expires. For more information about authorization, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>.</p></li>
/// </ul>
/// </dd>
/// <dt>
/// Encryption
/// </dt>
/// <dd>
/// <ul>
/// <li>
/// <p><b>General purpose buckets</b> - Server-side encryption is for data encryption at rest. Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts it when you access it. Amazon S3 automatically encrypts all new objects that are uploaded to an S3 bucket. When doing a multipart upload, if you don't specify encryption information in your request, the encryption setting of the uploaded parts is set to the default encryption configuration of the destination bucket. By default, all buckets have a base level of encryption configuration that uses server-side encryption with Amazon S3 managed keys (SSE-S3). If the destination bucket has a default encryption configuration that uses server-side encryption with an Key Management Service (KMS) key (SSE-KMS), or a customer-provided encryption key (SSE-C), Amazon S3 uses the corresponding KMS key, or a customer-provided key to encrypt the uploaded parts. When you perform a CreateMultipartUpload operation, if you want to use a different type of encryption setting for the uploaded parts, you can request that Amazon S3 encrypts the object with a different encryption key (such as an Amazon S3 managed key, a KMS key, or a customer-provided key). When the encryption setting in your request is different from the default encryption configuration of the destination bucket, the encryption setting in your request takes precedence. If you choose to provide your own encryption key, the request headers you provide in <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a> requests must match the headers you used in the <code>CreateMultipartUpload</code> request.</p>
/// <ul>
/// <li>
/// <p>Use KMS keys (SSE-KMS) that include the Amazon Web Services managed key (<code>aws/s3</code>) and KMS customer managed keys stored in Key Management Service (KMS) – If you want Amazon Web Services to manage the keys used to encrypt data, specify the following headers in the request.</p>
/// <ul>
/// <li>
/// <p><code>x-amz-server-side-encryption</code></p></li>
/// <li>
/// <p><code>x-amz-server-side-encryption-aws-kms-key-id</code></p></li>
/// <li>
/// <p><code>x-amz-server-side-encryption-context</code></p></li>
/// </ul><note>
/// <ul>
/// <li>
/// <p>If you specify <code>x-amz-server-side-encryption:aws:kms</code>, but don't provide <code>x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the Amazon Web Services managed key (<code>aws/s3</code> key) in KMS to protect the data.</p></li>
/// <li>
/// <p>To perform a multipart upload with encryption by using an Amazon Web Services KMS key, the requester must have permission to the <code>kms:Decrypt</code> and <code>kms:GenerateDataKey*</code> actions on the key. These permissions are required because Amazon S3 must decrypt and read data from the encrypted file parts before it completes the multipart upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpuAndPermissions">Multipart upload API and permissions</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">Protecting data using server-side encryption with Amazon Web Services KMS</a> in the <i>Amazon S3 User Guide</i>.</p></li>
/// <li>
/// <p>If your Identity and Access Management (IAM) user or role is in the same Amazon Web Services account as the KMS key, then you must have these permissions on the key policy. If your IAM user or role is in a different account from the key, then you must have the permissions on both the key policy and your IAM user or role.</p></li>
/// <li>
/// <p>All <code>GET</code> and <code>PUT</code> requests for an object protected by KMS fail if you don't make them by using Secure Sockets Layer (SSL), Transport Layer Security (TLS), or Signature Version 4. For information about configuring any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p></li>
/// </ul>
/// </note>
/// <p>For more information about server-side encryption with KMS keys (SSE-KMS), see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">Protecting Data Using Server-Side Encryption with KMS keys</a> in the <i>Amazon S3 User Guide</i>.</p></li>
/// <li>
/// <p>Use customer-provided encryption keys (SSE-C) – If you want to manage your own encryption keys, provide all the following headers in the request.</p>
/// <ul>
/// <li>
/// <p><code>x-amz-server-side-encryption-customer-algorithm</code></p></li>
/// <li>
/// <p><code>x-amz-server-side-encryption-customer-key</code></p></li>
/// <li>
/// <p><code>x-amz-server-side-encryption-customer-key-MD5</code></p></li>
/// </ul>
/// <p>For more information about server-side encryption with customer-provided encryption keys (SSE-C), see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html"> Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a> in the <i>Amazon S3 User Guide</i>.</p></li>
/// </ul></li>
/// <li>
/// <p><b>Directory buckets</b> -For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p></li>
/// </ul>
/// </dd>
/// <dt>
/// HTTP Host header syntax
/// </dt>
/// <dd>
/// <p><b>Directory buckets </b> - The HTTP Host header syntax is <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>.</p>
/// </dd>
/// </dl>
/// <p>The following operations are related to <code>CreateMultipartUpload</code>:</p>
/// <ul>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a></p></li>
/// </ul>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct CreateMultipartUploadFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::create_multipart_upload::builders::CreateMultipartUploadInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::create_multipart_upload::CreateMultipartUploadOutput,
        crate::operation::create_multipart_upload::CreateMultipartUploadError,
    > for CreateMultipartUploadFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::create_multipart_upload::CreateMultipartUploadOutput,
            crate::operation::create_multipart_upload::CreateMultipartUploadError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl CreateMultipartUploadFluentBuilder {
    /// Creates a new `CreateMultipartUpload`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the CreateMultipartUpload as a reference.
    pub fn as_input(&self) -> &crate::operation::create_multipart_upload::builders::CreateMultipartUploadInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::create_multipart_upload::CreateMultipartUploadOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_multipart_upload::CreateMultipartUploadError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::create_multipart_upload::CreateMultipartUpload::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::create_multipart_upload::CreateMultipartUpload::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::create_multipart_upload::CreateMultipartUploadOutput,
        crate::operation::create_multipart_upload::CreateMultipartUploadError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl Into<crate::config::Builder>) -> Self {
        self.set_config_override(Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The canned ACL to apply to the object. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can grant access permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the new object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. One way to grant the permissions using the request headers is to specify a canned ACL with the <code>x-amz-acl</code> request header.</p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn acl(mut self, input: crate::types::ObjectCannedAcl) -> Self {
        self.inner = self.inner.acl(input);
        self
    }
    /// <p>The canned ACL to apply to the object. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can grant access permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the new object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. One way to grant the permissions using the request headers is to specify a canned ACL with the <code>x-amz-acl</code> request header.</p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_acl(mut self, input: ::std::option::Option<crate::types::ObjectCannedAcl>) -> Self {
        self.inner = self.inner.set_acl(input);
        self
    }
    /// <p>The canned ACL to apply to the object. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can grant access permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the new object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. One way to grant the permissions using the request headers is to specify a canned ACL with the <code>x-amz-acl</code> request header.</p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_acl(&self) -> &::std::option::Option<crate::types::ObjectCannedAcl> {
        self.inner.get_acl()
    }
    /// <p>The name of the bucket where the multipart upload is initiated and where the object is uploaded.</p>
    /// <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>Access points and Object Lambda access points are not supported by directory buckets.</p>
    /// </note>
    /// <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.bucket(input.into());
        self
    }
    /// <p>The name of the bucket where the multipart upload is initiated and where the object is uploaded.</p>
    /// <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>Access points and Object Lambda access points are not supported by directory buckets.</p>
    /// </note>
    /// <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_bucket(input);
        self
    }
    /// <p>The name of the bucket where the multipart upload is initiated and where the object is uploaded.</p>
    /// <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code> <i>bucket_base_name</i>--<i>az-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az2</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>Access points and Object Lambda access points are not supported by directory buckets.</p>
    /// </note>
    /// <p><b>S3 on Outposts</b> - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_bucket()
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn cache_control(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.cache_control(input.into());
        self
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn set_cache_control(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_cache_control(input);
        self
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn get_cache_control(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_cache_control()
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn content_disposition(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_disposition(input.into());
        self
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn set_content_disposition(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_disposition(input);
        self
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn get_content_disposition(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_disposition()
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>
    /// <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p>
    /// </note>
    pub fn content_encoding(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_encoding(input.into());
        self
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>
    /// <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p>
    /// </note>
    pub fn set_content_encoding(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_encoding(input);
        self
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p><note>
    /// <p>For directory buckets, only the <code>aws-chunked</code> value is supported in this header field.</p>
    /// </note>
    pub fn get_content_encoding(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_encoding()
    }
    /// <p>The language that the content is in.</p>
    pub fn content_language(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_language(input.into());
        self
    }
    /// <p>The language that the content is in.</p>
    pub fn set_content_language(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_language(input);
        self
    }
    /// <p>The language that the content is in.</p>
    pub fn get_content_language(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_language()
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn content_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_type(input.into());
        self
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn set_content_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_type(input);
        self
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn get_content_type(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_type()
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn expires(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.expires(input);
        self
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn set_expires(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_expires(input);
        self
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn get_expires(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_expires()
    }
    /// <p>Specify access permissions explicitly to give the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_full_control(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_full_control(input.into());
        self
    }
    /// <p>Specify access permissions explicitly to give the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_grant_full_control(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_full_control(input);
        self
    }
    /// <p>Specify access permissions explicitly to give the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_grant_full_control(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_full_control()
    }
    /// <p>Specify access permissions explicitly to allow grantee to read the object data and its metadata.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_read(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_read(input.into());
        self
    }
    /// <p>Specify access permissions explicitly to allow grantee to read the object data and its metadata.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_grant_read(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_read(input);
        self
    }
    /// <p>Specify access permissions explicitly to allow grantee to read the object data and its metadata.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_grant_read(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_read()
    }
    /// <p>Specify access permissions explicitly to allows grantee to read the object ACL.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_read_acp(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_read_acp(input.into());
        self
    }
    /// <p>Specify access permissions explicitly to allows grantee to read the object ACL.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_grant_read_acp(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_read_acp(input);
        self
    }
    /// <p>Specify access permissions explicitly to allows grantee to read the object ACL.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_grant_read_acp(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_read_acp()
    }
    /// <p>Specify access permissions explicitly to allows grantee to allow grantee to write the ACL for the applicable object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn grant_write_acp(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.grant_write_acp(input.into());
        self
    }
    /// <p>Specify access permissions explicitly to allows grantee to allow grantee to write the ACL for the applicable object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn set_grant_write_acp(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_grant_write_acp(input);
        self
    }
    /// <p>Specify access permissions explicitly to allows grantee to allow grantee to write the ACL for the applicable object.</p>
    /// <p>By default, all objects are private. Only the owner has full access control. When uploading an object, you can use this header to explicitly grant access permissions to specific Amazon Web Services accounts or groups. This header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p><code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p></li>
    /// <li>
    /// <p><code>uri</code> – if you are granting permissions to a predefined group</p></li>
    /// <li>
    /// <p><code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p><note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia)</p></li>
    /// <li>
    /// <p>US West (N. California)</p></li>
    /// <li>
    /// <p>US West (Oregon)</p></li>
    /// <li>
    /// <p>Asia Pacific (Singapore)</p></li>
    /// <li>
    /// <p>Asia Pacific (Sydney)</p></li>
    /// <li>
    /// <p>Asia Pacific (Tokyo)</p></li>
    /// <li>
    /// <p>Europe (Ireland)</p></li>
    /// <li>
    /// <p>South America (São Paulo)</p></li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note></li>
    /// </ul>
    /// <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p>
    /// <p><code>x-amz-grant-read: id="11112222333", id="444455556666" </code></p><note>
    /// <ul>
    /// <li>
    /// <p>This functionality is not supported for directory buckets.</p></li>
    /// <li>
    /// <p>This functionality is not supported for Amazon S3 on Outposts.</p></li>
    /// </ul>
    /// </note>
    pub fn get_grant_write_acp(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_grant_write_acp()
    }
    /// <p>Object key for which the multipart upload is to be initiated.</p>
    pub fn key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.key(input.into());
        self
    }
    /// <p>Object key for which the multipart upload is to be initiated.</p>
    pub fn set_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_key(input);
        self
    }
    /// <p>Object key for which the multipart upload is to be initiated.</p>
    pub fn get_key(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_key()
    }
    /// Adds a key-value pair to `Metadata`.
    ///
    /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
    ///
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn metadata(mut self, k: impl ::std::convert::Into<::std::string::String>, v: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.metadata(k.into(), v.into());
        self
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn set_metadata(mut self, input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>) -> Self {
        self.inner = self.inner.set_metadata(input);
        self
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn get_metadata(&self) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.inner.get_metadata()
    }
    /// <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>
    /// <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p>
    /// </note>
    pub fn server_side_encryption(mut self, input: crate::types::ServerSideEncryption) -> Self {
        self.inner = self.inner.server_side_encryption(input);
        self
    }
    /// <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>
    /// <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p>
    /// </note>
    pub fn set_server_side_encryption(mut self, input: ::std::option::Option<crate::types::ServerSideEncryption>) -> Self {
        self.inner = self.inner.set_server_side_encryption(input);
        self
    }
    /// <p>The server-side encryption algorithm used when you store this object in Amazon S3 (for example, <code>AES256</code>, <code>aws:kms</code>).</p><note>
    /// <p>For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (<code>AES256</code>) is supported.</p>
    /// </note>
    pub fn get_server_side_encryption(&self) -> &::std::option::Option<crate::types::ServerSideEncryption> {
        self.inner.get_server_side_encryption()
    }
    /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <ul>
    /// <li>
    /// <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>
    /// <li>
    /// <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>
    /// </ul>
    /// </note>
    pub fn storage_class(mut self, input: crate::types::StorageClass) -> Self {
        self.inner = self.inner.storage_class(input);
        self
    }
    /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <ul>
    /// <li>
    /// <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>
    /// <li>
    /// <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>
    /// </ul>
    /// </note>
    pub fn set_storage_class(mut self, input: ::std::option::Option<crate::types::StorageClass>) -> Self {
        self.inner = self.inner.set_storage_class(input);
        self
    }
    /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <ul>
    /// <li>
    /// <p>For directory buckets, only the S3 Express One Zone storage class is supported to store newly created objects.</p></li>
    /// <li>
    /// <p>Amazon S3 on Outposts only uses the OUTPOSTS Storage Class.</p></li>
    /// </ul>
    /// </note>
    pub fn get_storage_class(&self) -> &::std::option::Option<crate::types::StorageClass> {
        self.inner.get_storage_class()
    }
    /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn website_redirect_location(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.website_redirect_location(input.into());
        self
    }
    /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_website_redirect_location(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_website_redirect_location(input);
        self
    }
    /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_website_redirect_location(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_website_redirect_location()
    }
    /// <p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn sse_customer_algorithm(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.sse_customer_algorithm(input.into());
        self
    }
    /// <p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_sse_customer_algorithm(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_sse_customer_algorithm(input);
        self
    }
    /// <p>Specifies the algorithm to use when encrypting the object (for example, AES256).</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_sse_customer_algorithm(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_sse_customer_algorithm()
    }
    /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn sse_customer_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.sse_customer_key(input.into());
        self
    }
    /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_sse_customer_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_sse_customer_key(input);
        self
    }
    /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_sse_customer_key(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_sse_customer_key()
    }
    /// <p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn sse_customer_key_md5(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.sse_customer_key_md5(input.into());
        self
    }
    /// <p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_sse_customer_key_md5(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_sse_customer_key_md5(input);
        self
    }
    /// <p>Specifies the 128-bit MD5 digest of the customer-provided encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_sse_customer_key_md5(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_sse_customer_key_md5()
    }
    /// <p>Specifies the ID (Key ID, Key ARN, or Key Alias) of the symmetric encryption customer managed key to use for object encryption.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn ssekms_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.ssekms_key_id(input.into());
        self
    }
    /// <p>Specifies the ID (Key ID, Key ARN, or Key Alias) of the symmetric encryption customer managed key to use for object encryption.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_ssekms_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_ssekms_key_id(input);
        self
    }
    /// <p>Specifies the ID (Key ID, Key ARN, or Key Alias) of the symmetric encryption customer managed key to use for object encryption.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_ssekms_key_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_ssekms_key_id()
    }
    /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn ssekms_encryption_context(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.ssekms_encryption_context(input.into());
        self
    }
    /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_ssekms_encryption_context(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_ssekms_encryption_context(input);
        self
    }
    /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_ssekms_encryption_context(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_ssekms_encryption_context()
    }
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn bucket_key_enabled(mut self, input: bool) -> Self {
        self.inner = self.inner.bucket_key_enabled(input);
        self
    }
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_bucket_key_enabled(mut self, input: ::std::option::Option<bool>) -> Self {
        self.inner = self.inner.set_bucket_key_enabled(input);
        self
    }
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Key Management Service (KMS) keys (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_bucket_key_enabled(&self) -> &::std::option::Option<bool> {
        self.inner.get_bucket_key_enabled()
    }
    /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn request_payer(mut self, input: crate::types::RequestPayer) -> Self {
        self.inner = self.inner.request_payer(input);
        self
    }
    /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_request_payer(mut self, input: ::std::option::Option<crate::types::RequestPayer>) -> Self {
        self.inner = self.inner.set_request_payer(input);
        self
    }
    /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_request_payer(&self) -> &::std::option::Option<crate::types::RequestPayer> {
        self.inner.get_request_payer()
    }
    /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn tagging(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.tagging(input.into());
        self
    }
    /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_tagging(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_tagging(input);
        self
    }
    /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_tagging(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_tagging()
    }
    /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn object_lock_mode(mut self, input: crate::types::ObjectLockMode) -> Self {
        self.inner = self.inner.object_lock_mode(input);
        self
    }
    /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_object_lock_mode(mut self, input: ::std::option::Option<crate::types::ObjectLockMode>) -> Self {
        self.inner = self.inner.set_object_lock_mode(input);
        self
    }
    /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_object_lock_mode(&self) -> &::std::option::Option<crate::types::ObjectLockMode> {
        self.inner.get_object_lock_mode()
    }
    /// <p>Specifies the date and time when you want the Object Lock to expire.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn object_lock_retain_until_date(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.object_lock_retain_until_date(input);
        self
    }
    /// <p>Specifies the date and time when you want the Object Lock to expire.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_object_lock_retain_until_date(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_object_lock_retain_until_date(input);
        self
    }
    /// <p>Specifies the date and time when you want the Object Lock to expire.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_object_lock_retain_until_date(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_object_lock_retain_until_date()
    }
    /// <p>Specifies whether you want to apply a legal hold to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn object_lock_legal_hold_status(mut self, input: crate::types::ObjectLockLegalHoldStatus) -> Self {
        self.inner = self.inner.object_lock_legal_hold_status(input);
        self
    }
    /// <p>Specifies whether you want to apply a legal hold to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_object_lock_legal_hold_status(mut self, input: ::std::option::Option<crate::types::ObjectLockLegalHoldStatus>) -> Self {
        self.inner = self.inner.set_object_lock_legal_hold_status(input);
        self
    }
    /// <p>Specifies whether you want to apply a legal hold to the uploaded object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_object_lock_legal_hold_status(&self) -> &::std::option::Option<crate::types::ObjectLockLegalHoldStatus> {
        self.inner.get_object_lock_legal_hold_status()
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn expected_bucket_owner(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.expected_bucket_owner(input.into());
        self
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn set_expected_bucket_owner(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_expected_bucket_owner(input);
        self
    }
    /// <p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p>
    pub fn get_expected_bucket_owner(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_expected_bucket_owner()
    }
    /// <p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn checksum_algorithm(mut self, input: crate::types::ChecksumAlgorithm) -> Self {
        self.inner = self.inner.checksum_algorithm(input);
        self
    }
    /// <p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_checksum_algorithm(mut self, input: ::std::option::Option<crate::types::ChecksumAlgorithm>) -> Self {
        self.inner = self.inner.set_checksum_algorithm(input);
        self
    }
    /// <p>Indicates the algorithm that you want Amazon S3 to use to create the checksum for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_checksum_algorithm(&self) -> &::std::option::Option<crate::types::ChecksumAlgorithm> {
        self.inner.get_checksum_algorithm()
    }
}
