// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CreateSessionInput {
    /// <p>Specifies the mode of the session that will be created, either <code>ReadWrite</code> or <code>ReadOnly</code>. By default, a <code>ReadWrite</code> session is created. A <code>ReadWrite</code> session is capable of executing all the Zonal endpoint APIs on a directory bucket. A <code>ReadOnly</code> session is constrained to execute the following Zonal endpoint APIs: <code>GetObject</code>, <code>HeadObject</code>, <code>ListObjectsV2</code>, <code>GetObjectAttributes</code>, <code>ListParts</code>, and <code>ListMultipartUploads</code>.</p>
    pub session_mode: ::std::option::Option<crate::types::SessionMode>,
    /// <p>The name of the bucket that you create a session for.</p>
    pub bucket: ::std::option::Option<::std::string::String>,
}
impl CreateSessionInput {
    /// <p>Specifies the mode of the session that will be created, either <code>ReadWrite</code> or <code>ReadOnly</code>. By default, a <code>ReadWrite</code> session is created. A <code>ReadWrite</code> session is capable of executing all the Zonal endpoint APIs on a directory bucket. A <code>ReadOnly</code> session is constrained to execute the following Zonal endpoint APIs: <code>GetObject</code>, <code>HeadObject</code>, <code>ListObjectsV2</code>, <code>GetObjectAttributes</code>, <code>ListParts</code>, and <code>ListMultipartUploads</code>.</p>
    pub fn session_mode(&self) -> ::std::option::Option<&crate::types::SessionMode> {
        self.session_mode.as_ref()
    }
    /// <p>The name of the bucket that you create a session for.</p>
    pub fn bucket(&self) -> ::std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl CreateSessionInput {
    /// Creates a new builder-style object to manufacture [`CreateSessionInput`](crate::operation::create_session::CreateSessionInput).
    pub fn builder() -> crate::operation::create_session::builders::CreateSessionInputBuilder {
        crate::operation::create_session::builders::CreateSessionInputBuilder::default()
    }
}

/// A builder for [`CreateSessionInput`](crate::operation::create_session::CreateSessionInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct CreateSessionInputBuilder {
    pub(crate) session_mode: ::std::option::Option<crate::types::SessionMode>,
    pub(crate) bucket: ::std::option::Option<::std::string::String>,
}
impl CreateSessionInputBuilder {
    /// <p>Specifies the mode of the session that will be created, either <code>ReadWrite</code> or <code>ReadOnly</code>. By default, a <code>ReadWrite</code> session is created. A <code>ReadWrite</code> session is capable of executing all the Zonal endpoint APIs on a directory bucket. A <code>ReadOnly</code> session is constrained to execute the following Zonal endpoint APIs: <code>GetObject</code>, <code>HeadObject</code>, <code>ListObjectsV2</code>, <code>GetObjectAttributes</code>, <code>ListParts</code>, and <code>ListMultipartUploads</code>.</p>
    pub fn session_mode(mut self, input: crate::types::SessionMode) -> Self {
        self.session_mode = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the mode of the session that will be created, either <code>ReadWrite</code> or <code>ReadOnly</code>. By default, a <code>ReadWrite</code> session is created. A <code>ReadWrite</code> session is capable of executing all the Zonal endpoint APIs on a directory bucket. A <code>ReadOnly</code> session is constrained to execute the following Zonal endpoint APIs: <code>GetObject</code>, <code>HeadObject</code>, <code>ListObjectsV2</code>, <code>GetObjectAttributes</code>, <code>ListParts</code>, and <code>ListMultipartUploads</code>.</p>
    pub fn set_session_mode(mut self, input: ::std::option::Option<crate::types::SessionMode>) -> Self {
        self.session_mode = input;
        self
    }
    /// <p>Specifies the mode of the session that will be created, either <code>ReadWrite</code> or <code>ReadOnly</code>. By default, a <code>ReadWrite</code> session is created. A <code>ReadWrite</code> session is capable of executing all the Zonal endpoint APIs on a directory bucket. A <code>ReadOnly</code> session is constrained to execute the following Zonal endpoint APIs: <code>GetObject</code>, <code>HeadObject</code>, <code>ListObjectsV2</code>, <code>GetObjectAttributes</code>, <code>ListParts</code>, and <code>ListMultipartUploads</code>.</p>
    pub fn get_session_mode(&self) -> &::std::option::Option<crate::types::SessionMode> {
        &self.session_mode
    }
    /// <p>The name of the bucket that you create a session for.</p>
    /// This field is required.
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.bucket = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the bucket that you create a session for.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.bucket = input;
        self
    }
    /// <p>The name of the bucket that you create a session for.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        &self.bucket
    }
    /// Consumes the builder and constructs a [`CreateSessionInput`](crate::operation::create_session::CreateSessionInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::create_session::CreateSessionInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::create_session::CreateSessionInput {
            session_mode: self.session_mode,
            bucket: self.bucket,
        })
    }
}
