// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results are published.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct InventoryS3BucketDestination {
    /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p><note>
    /// <p>Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes.</p>
    /// </note>
    pub account_id: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>
    pub bucket: ::std::string::String,
    /// <p>Specifies the output format of the inventory results.</p>
    pub format: crate::types::InventoryFormat,
    /// <p>The prefix that is prepended to all inventory results.</p>
    pub prefix: ::std::option::Option<::std::string::String>,
    /// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
    pub encryption: ::std::option::Option<crate::types::InventoryEncryption>,
}
impl InventoryS3BucketDestination {
    /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p><note>
    /// <p>Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes.</p>
    /// </note>
    pub fn account_id(&self) -> ::std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>
    pub fn bucket(&self) -> &str {
        use std::ops::Deref;
        self.bucket.deref()
    }
    /// <p>Specifies the output format of the inventory results.</p>
    pub fn format(&self) -> &crate::types::InventoryFormat {
        &self.format
    }
    /// <p>The prefix that is prepended to all inventory results.</p>
    pub fn prefix(&self) -> ::std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
    pub fn encryption(&self) -> ::std::option::Option<&crate::types::InventoryEncryption> {
        self.encryption.as_ref()
    }
}
impl InventoryS3BucketDestination {
    /// Creates a new builder-style object to manufacture [`InventoryS3BucketDestination`](crate::types::InventoryS3BucketDestination).
    pub fn builder() -> crate::types::builders::InventoryS3BucketDestinationBuilder {
        crate::types::builders::InventoryS3BucketDestinationBuilder::default()
    }
}

/// A builder for [`InventoryS3BucketDestination`](crate::types::InventoryS3BucketDestination).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct InventoryS3BucketDestinationBuilder {
    pub(crate) account_id: ::std::option::Option<::std::string::String>,
    pub(crate) bucket: ::std::option::Option<::std::string::String>,
    pub(crate) format: ::std::option::Option<crate::types::InventoryFormat>,
    pub(crate) prefix: ::std::option::Option<::std::string::String>,
    pub(crate) encryption: ::std::option::Option<crate::types::InventoryEncryption>,
}
impl InventoryS3BucketDestinationBuilder {
    /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p><note>
    /// <p>Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes.</p>
    /// </note>
    pub fn account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p><note>
    /// <p>Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes.</p>
    /// </note>
    pub fn set_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_id = input;
        self
    }
    /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p><note>
    /// <p>Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes.</p>
    /// </note>
    pub fn get_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_id
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>
    /// This field is required.
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.bucket = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.bucket = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        &self.bucket
    }
    /// <p>Specifies the output format of the inventory results.</p>
    /// This field is required.
    pub fn format(mut self, input: crate::types::InventoryFormat) -> Self {
        self.format = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the output format of the inventory results.</p>
    pub fn set_format(mut self, input: ::std::option::Option<crate::types::InventoryFormat>) -> Self {
        self.format = input;
        self
    }
    /// <p>Specifies the output format of the inventory results.</p>
    pub fn get_format(&self) -> &::std::option::Option<crate::types::InventoryFormat> {
        &self.format
    }
    /// <p>The prefix that is prepended to all inventory results.</p>
    pub fn prefix(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.prefix = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The prefix that is prepended to all inventory results.</p>
    pub fn set_prefix(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.prefix = input;
        self
    }
    /// <p>The prefix that is prepended to all inventory results.</p>
    pub fn get_prefix(&self) -> &::std::option::Option<::std::string::String> {
        &self.prefix
    }
    /// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
    pub fn encryption(mut self, input: crate::types::InventoryEncryption) -> Self {
        self.encryption = ::std::option::Option::Some(input);
        self
    }
    /// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
    pub fn set_encryption(mut self, input: ::std::option::Option<crate::types::InventoryEncryption>) -> Self {
        self.encryption = input;
        self
    }
    /// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
    pub fn get_encryption(&self) -> &::std::option::Option<crate::types::InventoryEncryption> {
        &self.encryption
    }
    /// Consumes the builder and constructs a [`InventoryS3BucketDestination`](crate::types::InventoryS3BucketDestination).
    /// This method will fail if any of the following fields are not set:
    /// - [`bucket`](crate::types::builders::InventoryS3BucketDestinationBuilder::bucket)
    /// - [`format`](crate::types::builders::InventoryS3BucketDestinationBuilder::format)
    pub fn build(self) -> ::std::result::Result<crate::types::InventoryS3BucketDestination, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::InventoryS3BucketDestination {
            account_id: self.account_id,
            bucket: self.bucket.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "bucket",
                    "bucket was not specified but it is required when building InventoryS3BucketDestination",
                )
            })?,
            format: self.format.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "format",
                    "format was not specified but it is required when building InventoryS3BucketDestination",
                )
            })?,
            prefix: self.prefix,
            encryption: self.encryption,
        })
    }
}
