// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `ObjectOwnership`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let objectownership = unimplemented!();
/// match objectownership {
///     ObjectOwnership::BucketOwnerEnforced => { /* ... */ },
///     ObjectOwnership::BucketOwnerPreferred => { /* ... */ },
///     ObjectOwnership::ObjectWriter => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `objectownership` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `ObjectOwnership::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `ObjectOwnership::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `ObjectOwnership::NewFeature` is defined.
/// Specifically, when `objectownership` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `ObjectOwnership::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
/// <p>The container element for object ownership for a bucket's ownership controls.</p>
/// <p>
/// <code>BucketOwnerPreferred</code> - Objects uploaded to the bucket change ownership to the bucket
/// owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned
/// ACL.</p>
/// <p>
/// <code>ObjectWriter</code> - The uploading account will own the object if the object is uploaded with
/// the <code>bucket-owner-full-control</code> canned ACL.</p>
/// <p>
/// <code>BucketOwnerEnforced</code> - Access control lists (ACLs) are disabled and no longer affect
/// permissions. The bucket owner automatically owns and has full control over every object in
/// the bucket. The bucket only accepts PUT requests that don't specify an ACL or specify bucket owner
/// full control ACLs (such as the predefined <code>bucket-owner-full-control</code> canned ACL or a custom ACL
/// in XML format that grants the same permissions).</p>
/// <p>By default, <code>ObjectOwnership</code> is set to <code>BucketOwnerEnforced</code> and ACLs are disabled. We recommend
/// keeping ACLs disabled, except in uncommon use cases where you must control access for each object individually. For more information about S3 Object Ownership, see
/// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of objects and disabling ACLs for your bucket</a> in the <i>Amazon S3 User Guide</i>.
/// </p>
/// <note>
/// <p>This functionality is not supported for directory buckets. Directory buckets use the bucket owner enforced setting for S3 Object Ownership.</p>
/// </note>
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum ObjectOwnership {
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerEnforced,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerPreferred,
    #[allow(missing_docs)] // documentation missing in model
    ObjectWriter,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for ObjectOwnership {
    fn from(s: &str) -> Self {
        match s {
            "BucketOwnerEnforced" => ObjectOwnership::BucketOwnerEnforced,
            "BucketOwnerPreferred" => ObjectOwnership::BucketOwnerPreferred,
            "ObjectWriter" => ObjectOwnership::ObjectWriter,
            other => ObjectOwnership::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for ObjectOwnership {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(ObjectOwnership::from(s))
    }
}
impl ObjectOwnership {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectOwnership::BucketOwnerEnforced => "BucketOwnerEnforced",
            ObjectOwnership::BucketOwnerPreferred => "BucketOwnerPreferred",
            ObjectOwnership::ObjectWriter => "ObjectWriter",
            ObjectOwnership::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &["BucketOwnerEnforced", "BucketOwnerPreferred", "ObjectWriter"]
    }
}
impl ::std::convert::AsRef<str> for ObjectOwnership {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl ObjectOwnership {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
