// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#![cfg(feature = "test-util")]
#[::tokio::test]
async fn operation_input_test_get_object_1() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:not-s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Invalid ARN: The ARN was not for the S3 service, found: not-s3 [Invalid access point ARN: Not S3]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The ARN was not for the S3 service, found: not-s3"),
        "expected error to contain `Invalid ARN: The ARN was not for the S3 service, found: not-s3` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_2() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint:more-data".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: The ARN may only contain a single resource component after `accesspoint`. [Invalid access point ARN: invalid resource]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The ARN may only contain a single resource component after `accesspoint`."),
        "expected error to contain `Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_3() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("arn:aws:s3:us-west-2:123456789012:accesspoint:".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided [Invalid access point ARN: invalid no ap name]");
    assert!(
                                            format!("{:?}", error).contains("Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided"),
                                            "expected error to contain `Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_4() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456_789012:accesspoint:apname".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012` [Invalid access point ARN: AccountId is invalid]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012`"),
        "expected error to contain `Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012`` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_5() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:ap_name".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name` [Invalid access point ARN: access point name is invalid]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name`"),
        "expected error to contain `Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name`` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_6() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_7() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Partition does not support FIPS [Access points: partition does not support FIPS]");
    assert!(
        format!("{:?}", error).contains("Partition does not support FIPS"),
        "expected error to contain `Partition does not support FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_8() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west -2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid region in ARN: `us-west -2` (invalid DNS name) [Bucket region is invalid]");
    assert!(
        format!("{:?}", error).contains("Invalid region in ARN: `us-west -2` (invalid DNS name)"),
        "expected error to contain `Invalid region in ARN: `us-west -2` (invalid DNS name)` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_create_bucket_9() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .create_bucket()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Access points are not supported for this operation [Access points when Access points explicitly disabled (used for CreateBucket)]");
    assert!(
        format!("{:?}", error).contains("Access points are not supported for this operation"),
        "expected error to contain `Access points are not supported for this operation` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_10() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("arn:aws:s3:us-west-2:123456789012:".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN [missing arn type]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN"),
        "expected error to contain `Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_11() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://beta.example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://beta.example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err(
        "expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + access point + Dualstack is an error]",
    );
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_12() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_13() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_14() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mfzwi23gnjvgw.mrap.accesspoint.s3-global.amazonaws.com"),
        "expected URI to start with `https://mfzwi23gnjvgw.mrap.accesspoint.s3-global.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_15() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 MRAP does not support FIPS [MRAP does not support FIPS]");
    assert!(
        format!("{:?}", error).contains("S3 MRAP does not support FIPS"),
        "expected error to contain `S3 MRAP does not support FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_16() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 MRAP does not support dual-stack [MRAP does not support DualStack]");
    assert!(
        format!("{:?}", error).contains("S3 MRAP does not support dual-stack"),
        "expected error to contain `S3 MRAP does not support dual-stack` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_17() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 MRAP does not support S3 Accelerate [MRAP does not support S3 Accelerate]");
    assert!(
        format!("{:?}", error).contains("S3 MRAP does not support S3 Accelerate"),
        "expected error to contain `S3 MRAP does not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_18() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::DisableMultiRegionAccessPoints": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.disable_multi_region_access_points(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: Multi-Region Access Point ARNs are disabled. [MRAP explicitly disabled]");
    assert!(
        format!("{:?}", error).contains("Invalid configuration: Multi-Region Access Point ARNs are disabled."),
        "expected error to contain `Invalid configuration: Multi-Region Access Point ARNs are disabled.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_19() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucketname".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-west-2.amazonaws.com/bucketname"),
        "expected URI to start with `https://s3.dualstack.us-west-2.amazonaws.com/bucketname` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_20() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://abc.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://abc.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucketname".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [Dual-stack endpoint + SDK::Host is error]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_21() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + ARN bucket]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with ARN buckets"),
        "expected error to contain `Path-style addressing cannot be used with ARN buckets` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_22() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99_ab".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-west-2.amazonaws.com/99_ab"),
        "expected URI to start with `https://s3.dualstack.us-west-2.amazonaws.com/99_ab` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_23() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "http://abc.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("http://abc.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99_ab".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [implicit path style bucket + dualstack]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_24() {
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("example.com#".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/example.com%23"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/example.com%23` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_25() {
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/bucket%20name"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/bucket%20name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_26() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99_ab".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab"),
        "expected URI to start with `https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_27() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://123.123.0.1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://123.123.0.1");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucketname".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://123.123.0.1/bucketname"),
        "expected URI to start with `https://123.123.0.1/bucketname` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_28() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-east-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [vanilla access point arn with region mismatch and UseArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_29() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_30() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_31() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket.name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-east-1.amazonaws.com/bucket.name"),
        "expected URI to start with `https://s3.us-east-1.amazonaws.com/bucket.name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_32() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("aaa".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://aaa.s3.us-east-1.amazonaws.com"),
        "expected URI to start with `https://aaa.s3.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_33() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("aa".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-east-1.amazonaws.com/aa"),
        "expected URI to start with `https://s3.us-east-1.amazonaws.com/aa` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_34() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("BucketName".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-east-1.amazonaws.com/BucketName"),
        "expected URI to start with `https://s3.us-east-1.amazonaws.com/BucketName` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_35() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "SDK::Endpoint": "http://example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.endpoint_url("http://example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket.name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("http://bucket.name.example.com"),
        "expected URI to start with `http://bucket.name.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_36() {
    /* builtIns: {
        "AWS::Region": "aws-global"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.amazonaws.com"),
        "expected URI to start with `https://s3.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_37() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3-fips.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3-fips.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_38() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3.dualstack.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_39() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3-fips.dualstack.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3-fips.dualstack.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_40() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.amazonaws.com"),
        "expected URI to start with `https://s3.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_41() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "SDK::Endpoint": "https://example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.endpoint_url("https://example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://example.com"),
        "expected URI to start with `https://example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_42() {
    /* builtIns: {
        "AWS::Region": "aws-global"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_objects_43() {
    /* builtIns: {
        "AWS::Region": "aws-global"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .list_objects()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_prefix(::std::option::Option::Some("prefix".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_44() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.us-east-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_45() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.dualstack.us-east-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.dualstack.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_46() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.dualstack.us-east-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.dualstack.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_47() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_48() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "SDK::Endpoint": "https://example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.endpoint_url("https://example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.example.com"),
        "expected URI to start with `https://bucket-name.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_49() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_50() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-east-1.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.dualstack.us-east-1.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_51() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "SDK::Endpoint": "https://example.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.endpoint_url("https://example.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://example.com/bucket-name"),
        "expected URI to start with `https://example.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_52() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com"),
        "expected URI to start with `https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_53() {
    /* builtIns: {
        "AWS::Region": "us-west-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err(
        "expected error: Client was configured for partition `aws` but bucket referred to partition `aws-cn` [cross partition MRAP ARN is an error]",
    );
    assert!(
        format!("{:?}", error).contains("Client was configured for partition `aws` but bucket referred to partition `aws-cn`"),
        "expected error to contain `Client was configured for partition `aws` but bucket referred to partition `aws-cn`` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_54() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "http://beta.example.com:1234"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("http://beta.example.com:1234");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("http://myendpoint-123456789012.beta.example.com:1234"),
        "expected URI to start with `http://myendpoint-123456789012.beta.example.com:1234` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_55() {
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.us-west-2.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_56() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_57() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.dualstack.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.dualstack.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_58() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_59() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.us-west-2.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_60() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_61() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Accelerate cannot be used with FIPS [accelerate + fips = error@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Accelerate cannot be used with FIPS"),
        "expected error to contain `Accelerate cannot be used with FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_62() {
    /* builtIns: {
        "AWS::Region": "cn-north-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.cn-north-1.amazonaws.com.cn"),
        "expected URI to start with `https://bucket-name.s3.cn-north-1.amazonaws.com.cn` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_63() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.dualstack.cn-north-1.amazonaws.com.cn"),
        "expected URI to start with `https://bucket-name.s3.dualstack.cn-north-1.amazonaws.com.cn` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_64() {
    /* builtIns: {
        "AWS::Region": "af-south-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.af-south-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_65() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.dualstack.af-south-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.dualstack.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_66() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseDualStack": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.dualstack.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.dualstack.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_67() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_68() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.af-south-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_69() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.dualstack.af-south-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.dualstack.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_70() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Accelerate cannot be used with FIPS [accelerate + fips = error@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Accelerate cannot be used with FIPS"),
        "expected error to contain `Accelerate cannot be used with FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_71() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_72() {
    /* builtIns: {
        "AWS::Region": "us-gov-west-1",
        "AWS::UseFIPS": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-gov-west-1"));
        let builder = builder.use_fips(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket.with.dots".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3-fips.us-gov-west-1.amazonaws.com/bucket.with.dots"),
        "expected URI to start with `https://s3-fips.us-gov-west-1.amazonaws.com/bucket.with.dots` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_73() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style + accelerate = error@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with S3 Accelerate"),
        "expected error to contain `Path-style addressing cannot be used with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_74() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-west-2.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.dualstack.us-west-2.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_75() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + arn is error@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with ARN buckets"),
        "expected error to contain `Path-style addressing cannot be used with ARN buckets` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_76() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/99a_b"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_77() {
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/99a_b"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_78() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.cn-north-1.amazonaws.com.cn/bucket-name"),
        "expected URI to start with `https://s3.cn-north-1.amazonaws.com.cn/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_79() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseFIPS": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_fips(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Partition does not support FIPS [path style + fips@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Partition does not support FIPS"),
        "expected error to contain `Partition does not support FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_80() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::ForcePathStyle": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.force_path_style(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style + accelerate = error@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with S3 Accelerate"),
        "expected error to contain `Path-style addressing cannot be used with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_81() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.cn-north-1.amazonaws.com.cn/bucket-name"),
        "expected URI to start with `https://s3.dualstack.cn-north-1.amazonaws.com.cn/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_82() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + arn is error@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with ARN buckets"),
        "expected error to contain `Path-style addressing cannot be used with ARN buckets` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_83() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.cn-north-1.amazonaws.com.cn/99a_b"),
        "expected URI to start with `https://s3.cn-north-1.amazonaws.com.cn/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_84() {
    /* builtIns: {
        "AWS::Region": "cn-north-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.cn-north-1.amazonaws.com.cn/99a_b"),
        "expected URI to start with `https://s3.cn-north-1.amazonaws.com.cn/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_85() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.af-south-1.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.af-south-1.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_86() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3-fips.af-south-1.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3-fips.af-south-1.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_87() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::ForcePathStyle": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.force_path_style(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style + accelerate = error@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with S3 Accelerate"),
        "expected error to contain `Path-style addressing cannot be used with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_88() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.af-south-1.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.dualstack.af-south-1.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_89() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + arn is error@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with ARN buckets"),
        "expected error to contain `Path-style addressing cannot be used with ARN buckets` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_90() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.af-south-1.amazonaws.com/99a_b"),
        "expected URI to start with `https://s3.af-south-1.amazonaws.com/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_91() {
    /* builtIns: {
        "AWS::Region": "af-south-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.af-south-1.amazonaws.com/99a_b"),
        "expected URI to start with `https://s3.af-south-1.amazonaws.com/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_92() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("http://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
        "expected URI to start with `http://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_93() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name"),
        "expected URI to start with `https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_94() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: A custom endpoint cannot be combined with FIPS [SDK::Host + FIPS@us-west-2]");
    assert!(
        format!("{:?}", error).contains("A custom endpoint cannot be combined with FIPS"),
        "expected error to contain `A custom endpoint cannot be combined with FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_95() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + DualStack@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_96() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: A custom endpoint cannot be combined with S3 Accelerate [SDK::HOST + accelerate@us-west-2]");
    assert!(
        format!("{:?}", error).contains("A custom endpoint cannot be combined with S3 Accelerate"),
        "expected error to contain `A custom endpoint cannot be combined with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_97() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://beta.example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://beta.example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.beta.example.com"),
        "expected URI to start with `https://myendpoint-123456789012.beta.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_98() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
        "expected URI to start with `https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_99() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name"),
        "expected URI to start with `https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_100() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + DualStack@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_101() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "SDK::Endpoint": "https://beta.example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.endpoint_url("https://beta.example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.beta.example.com"),
        "expected URI to start with `https://myendpoint-123456789012.beta.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_102() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
        "expected URI to start with `https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_103() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name"),
        "expected URI to start with `https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_104() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: A custom endpoint cannot be combined with FIPS [SDK::Host + FIPS@af-south-1]");
    assert!(
        format!("{:?}", error).contains("A custom endpoint cannot be combined with FIPS"),
        "expected error to contain `A custom endpoint cannot be combined with FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_105() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + DualStack@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_106() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: A custom endpoint cannot be combined with S3 Accelerate [SDK::HOST + accelerate@af-south-1]");
    assert!(
        format!("{:?}", error).contains("A custom endpoint cannot be combined with S3 Accelerate"),
        "expected error to contain `A custom endpoint cannot be combined with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_107() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://beta.example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://beta.example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.beta.example.com"),
        "expected URI to start with `https://myendpoint-123456789012.beta.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_108() {
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_109() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_110() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Access Points do not support S3 Accelerate [access point arn + accelerate = error@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Access Points do not support S3 Accelerate"),
        "expected error to contain `Access Points do not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_111() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_112() {
    /* builtIns: {
        "AWS::Region": "cn-north-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.cn-north-1.amazonaws.com.cn"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.cn-north-1.amazonaws.com.cn` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_113() {
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Access Points do not support S3 Accelerate [access point arn + accelerate = error@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Access Points do not support S3 Accelerate"),
        "expected error to contain `Access Points do not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_114() {
    /* builtIns: {
        "AWS::Region": "af-south-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.af-south-1.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_115() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.af-south-1.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_116() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Access Points do not support S3 Accelerate [access point arn + accelerate = error@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Access Points do not support S3 Accelerate"),
        "expected error to contain `Access Points do not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_117() {
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.af-south-1.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_118() {
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://reports-123456789012.op-01234567890123456.s3-outposts.us-west-2.amazonaws.com"),
        "expected URI to start with `https://reports-123456789012.op-01234567890123456.s3-outposts.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_119() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://example.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://example.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://reports-123456789012.op-01234567890123456.example.amazonaws.com"),
        "expected URI to start with `https://reports-123456789012.op-01234567890123456.example.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_120() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [outposts arn with region mismatch and UseArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_121() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://example.com",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://example.com");
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [outposts arn with region mismatch, custom region and UseArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_122() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com"),
        "expected URI to start with `https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_123() {
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com"),
        "expected URI to start with `https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_124() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn` [outposts arn with partition mismatch and UseArnRegion=true]");
    assert!(
                                            format!("{:?}", error).contains("Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn`"),
                                            "expected error to contain `Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_125() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_126() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_127() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_128() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_129() {
    /* builtIns: {
        "AWS::Region": "s3-external-1",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("s3-external-1"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_130() {
    /* builtIns: {
        "AWS::Region": "s3-external-1",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("s3-external-1"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false` [object lambda @us-east-1, client region s3-external-1, useArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_131() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_132() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false` [object lambda @us-east-1, client region aws-global, useArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_133() {
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn` [object lambda @cn-north-1, client region us-west-2 (cross partition), useArnRegion=true]");
    assert!(
                                            format!("{:?}", error).contains("Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn`"),
                                            "expected error to contain `Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_134() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 Object Lambda does not support Dual-stack [object lambda with dualstack]");
    assert!(
        format!("{:?}", error).contains("S3 Object Lambda does not support Dual-stack"),
        "expected error to contain `S3 Object Lambda does not support Dual-stack` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_135() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::Accelerate": true,
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.accelerate(true);
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 Object Lambda does not support S3 Accelerate [object lambda with accelerate]");
    assert!(
        format!("{:?}", error).contains("S3 Object Lambda does not support S3 Accelerate"),
        "expected error to contain `S3 Object Lambda does not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_136() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("arn:aws:sqs:us-west-2:123456789012:someresource".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource) [object lambda with invalid arn - bad service and someresource]");
    assert!(
                                            format!("{:?}", error).contains("Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource)"),
                                            "expected error to contain `Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource)` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_137() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123.45678.9012:accesspoint:mybucket".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012` [object lambda with invalid arn - account id contains invalid characters]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012`"),
        "expected error to contain `Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012`` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_138() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://my-endpoint.com",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://my-endpoint.com");
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.my-endpoint.com"),
        "expected URI to start with `https://mybanner-123456789012.my-endpoint.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_139() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [object lambda arn with region mismatch and UseArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_140() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--use1-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--use1-az1--x-s3.s3express-use1-az1.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybucket--use1-az1--x-s3.s3express-use1-az1.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_141() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--use1-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--use1-az1--x-s3.s3express-fips-use1-az1.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybucket--use1-az1--x-s3.s3express-fips-use1-az1.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_142() {
    /* builtIns: {
        "AWS::Region": "ap-northeast-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("ap-northeast-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--apne1-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--apne1-az1--x-s3.s3express-apne1-az1.ap-northeast-1.amazonaws.com"),
        "expected URI to start with `https://mybucket--apne1-az1--x-s3.s3express-apne1-az1.ap-northeast-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_143() {
    /* builtIns: {
        "AWS::Region": "ap-northeast-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("ap-northeast-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--apne1-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--apne1-az1--x-s3.s3express-fips-apne1-az1.ap-northeast-1.amazonaws.com"),
        "expected URI to start with `https://mybucket--apne1-az1--x-s3.s3express-fips-apne1-az1.ap-northeast-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_create_bucket_144() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .create_bucket()
            .set_bucket(::std::option::Option::Some("mybucket--use1-az1--x-s3".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3express-control.us-east-1.amazonaws.com/mybucket--use1-az1--x-s3"),
        "expected URI to start with `https://s3express-control.us-east-1.amazonaws.com/mybucket--use1-az1--x-s3` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_create_bucket_145() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .create_bucket()
            .set_bucket(::std::option::Option::Some("mybucket--use1-az1--x-s3".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3express-control-fips.us-east-1.amazonaws.com/mybucket--use1-az1--x-s3"),
        "expected URI to start with `https://s3express-control-fips.us-east-1.amazonaws.com/mybucket--use1-az1--x-s3` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_directory_buckets_146() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_directory_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3express-control.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3express-control.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_directory_buckets_147() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_directory_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3express-control-fips.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3express-control-fips.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_148() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://10.0.0.1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://10.0.0.1");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--usw2-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://10.0.0.1/mybucket--usw2-az1--x-s3"),
        "expected URI to start with `https://10.0.0.1/mybucket--usw2-az1--x-s3` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_149() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://custom.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://custom.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--usw2-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--usw2-az1--x-s3.custom.com"),
        "expected URI to start with `https://mybucket--usw2-az1--x-s3.custom.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_150() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--usaz1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Unrecognized S3Express bucket name format. [bad format error]");
    assert!(
        format!("{:?}", error).contains("Unrecognized S3Express bucket name format."),
        "expected error to contain `Unrecognized S3Express bucket name format.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_151() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--usaz1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Unrecognized S3Express bucket name format. [bad format error no session auth]");
    assert!(
        format!("{:?}", error).contains("Unrecognized S3Express bucket name format."),
        "expected error to contain `Unrecognized S3Express bucket name format.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_152() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--use1-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3Express does not support Dual-stack. [dual-stack error]");
    assert!(
        format!("{:?}", error).contains("S3Express does not support Dual-stack."),
        "expected error to contain `S3Express does not support Dual-stack.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_153() {
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--use1-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3Express does not support S3 Accelerate. [accelerate error]");
    assert!(
        format!("{:?}", error).contains("S3Express does not support S3 Accelerate."),
        "expected error to contain `S3Express does not support S3 Accelerate.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_154() {
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("my.bucket--use1-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3Express bucket name is not a valid virtual hostable name. [Data plane bucket format error]");
    assert!(
        format!("{:?}", error).contains("S3Express bucket name is not a valid virtual hostable name."),
        "expected error to contain `S3Express bucket name is not a valid virtual hostable name.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_155() {
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://custom.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_runtime::client::http::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://custom.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("my.bucket--usw2-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err(
        "expected error: S3Express bucket name is not a valid virtual hostable name. [host override data plane bucket error session auth]",
    );
    assert!(
        format!("{:?}", error).contains("S3Express bucket name is not a valid virtual hostable name."),
        "expected error to contain `S3Express bucket name is not a valid virtual hostable name.` but it was {:?}",
        error
    );
}
