use arrayvec::ArrayVec;

#[derive(Clone, Debug, Default)]
pub struct Unhexdump {
    buf: ArrayVec<[u8; 128]>,
}

enum Format {
    PureHex,
    Hex,
    OffsetAndHex,
}

const SNIFF_LEN: usize = 128;

fn from_hex(byte: u8) -> Option<u8> {
    match byte {
        b'0'...b'9' => Some(byte - b'0'),
        b'a'...b'f' => Some(byte - b'a' + 10),
        _ => None,
    }
}

fn is_hex(byte: u8) -> bool {
    from_hex(byte).is_some()
}

fn sniff_format(mut start: &[u8]) -> Format {
    if start.len() > SNIFF_LEN {
        start = &start[..SNIFF_LEN];
    }
    let mut all_hex_no_spaces = true;
    let mut cur_hex_len = 0;
    let mut seen_hex_bytes = 0;
    for c in start {
        if !(is_hex(c) || c == b'\n') {
            all_hex_no_spaces = false;
        }
        if is_hex(c) {
            cur_hex_len += 1;
            seen_hex_bytes += 1;
        }
    }
    if all_hex_no_spaces {
        PureHex
    } else {
        OffsetAndHex
    }
}

enum State {
    FormatNotYetDetermined,
    PureHex,
}

impl Unhexdump {
    pub fn new() -> Unhexdump {
        Default::default()
    }
    pub fn feed<F: FnOnce(&[u8])>(&mut self, out: F, hexdump: &[u8]) {
    }
}
