-- Test #3016.
-- The issue here is whether it compiles in a reasonable time
-- With GHC 6.10 it took hours!  After fixing the bug (which
-- was too much inlining) it went down to 30s.

-- This also tests #5652, a complexity issue with the LLVM
-- backend for this module. Compile time down from 10 min to
-- 12 seconds.

module T3016 where

newtype F = F Integer
data P = NZ !F !F | Z

largeConsts :: [P]
largeConsts = [
    NZ (F 0x1f8bd0b0c77369f3c5a1943c01215cad8c7018c4af1a588e6eF81c0a39e0a50db8e55bb371d956b15dbcb13ab12af532b1fc6b7ddf0a13d12dfaa76051132b84020bec72d2f265) (F 0x44a9e41f77686550649d5d124021aa477516211625bed15762a0729a0d052c71e99cdcdde7d245c0ab279cd4fd5b554d1f5f5e4ca912c0051df85de732dbc5f672c49f12215103f)
  , NZ (F 0x1717e2a5c3ee28F6db3f13b087fb3e9efbe38772ffc1f1b03e0f2bbccc016ede33153d46b7ba33618c056cb2f35eda083af75b17115e138483dc59ad83F1077a2829e20bfF5f) (F 0x0c2a90da370b1b8963dF950c975806f6de5a01e5152b4850b2ff99d1f8b0726d5d2f0bb850aba987acafc99b70c581abe9dd39e7bfa4acfb303e76738ed001dec5032359c3ad2c)
  , NZ (F 0x0d9bae2a98471270cd81eec78d6c906d5db35cdf049f56822b5910fa9b03bfbb07bff09ccec3831c4e4b04485F70a460ef8e0a88f6be4957822bf3c997f34dba2864c6cd47e0b1) (F 0x5c08664f55b7ddce2277f251725bc76ea968ef0c4e4a8522ef920d9dcd36d68704b1c7f03dd54154F741e1970c4cf3bcb055b4938ca787179aeada021e2d7795f52484cf504837)
  , NZ (F 0x68989557c872f0f3b33eaf57e55f7d5853a2b61c368ae0b602b587b6ed600856dad98d83fc0F370ff6f229b3a0aa3a5fc9ce9d05ebf7f8f531071479c643f0f914226df4a875da) (F 0x0069c79079321474fab6bc7d302eaf60ec2dde78023a2865f2d428be48c8c24fcdef0c049d2c9d6e4f67d37a00b6542813d485d3b3c04a6292513775d4f86d8a288741074d5c88a)
  , NZ (F 0x0ce80da044b946af21a69e31ac4fc1e5a42bdb8d6cf99fd54ad02087cbf414483145ec8bc2c2b05bd90db5abcb55b0d3fb7c5c9f23acb5605392e16836df34898ac0e8a244b2f42) (F 0x6f19698a2e8a07619db0cde15c261b4bb8f4a2b0332928e2c2529ad04414c7cfb84a38514fc0d6e807dc5e1ba2c35d14cc2d1756df443f407a421a96a96a9f6c945b38b51e6a3ce)
  , NZ (F 0x2d549e10fd758033c2d9c42b9581291395f196c0c235e8eeeb2c7ae1aae4b81009e50632287b9225b28c4a07be3b32136c2df76bfda3db44ec1ad3c2c75198ba88c48df3acbcf6c) (F 0x0c8433cf98b3a74bf644a38e2b1665d340e68d22b0e12725b6b152c67ea8352247b3be4c454b005362de4f74aba48083374d2d35c94e668f989c2705e86786a9ae6f4551f7098f4)
  , NZ (F 0x02707bea041e78a21de04f0d99de3767a77af119bF08ee2d2645f76517f7716bbb9c342a4025a5743c82720c932c2d7c140c3347e1585a2bbc54c9185e8005064500bdcb5b602c) (F 0x402be6d62231db6644fF204e039ac366db5c875d624d19b454e267e8661e6c1b7857ce8d9fa88b5dfa232b66b743d193ff8df776dbe191b9b488a30f28b74ce622631e0435082d)
  , NZ (F 0x0704694ba693174331f08b462effdf5fdf4248a09048a5752732794f317d797982aea4a73de08545332d7fd3e47204cc76d234178c70355fd134dfd3c09db43d984f1c5368000b7) (F 0x68c6e1741a6b6c05e0c9a7972ab61beaaf5ba808198574d76988664f6ac08f67cb8a28f39f7fbd4beee011a784f4e7720091f69ea9670e8307f52b1468ae03a1d55a9F4601b560)
  , NZ (F 0x1eea11c3d5391cd112c54b56181845a38e0e819460bf38b14224afff8e365364e2b21a6d1b1e859ac53349118cfc49ccc8f43c2e2082f846da7e7289b03e33F6301e23fd3be5b6) (F 0x501188011b45eeb4e0849a15441c48e3244b5453798223d3f8207c836fae1561a88f27b49e5d903044c70bf100be066be47f6ffadc1f93e21dd6d73e76922566128b13fc7278b78)
  , NZ (F 0x6f4028f5d3c848c11979294848d590bb60c04aaf4a755c955f0674da8d4f16061f2a2ef10af04d4ad4361a577114b3862decc1606efdaae107b97ebfb6658898F3274d5ed773bc) (F 0x24c24b6001f97364416d1ff2924e85d008d142b2de80ea133e12253c460548f2fb16514f31c6199a4471934c75441821d87c88ab4e29212d19d3e9493f8bd478c6728c32F3ce87)
  , NZ (F 0x2cdb2db5887b8d5e72c360b7aaf778dc90f3982d32cb4800d0a4d89a62716195fb4bf34ae6a9b9f85b845fd1265ea348f979553d16ad17dda326eeed5ffba79d7937926417aa87a) (F 0x6f2dff0a5a06ff421c5713002ae47a29e42e1a9537c049f8d8e2fc82232cc41fa9acb6a93069adc0dc5fdb5041dee65f972255a0174c139885cdbfa1767cef3f21fc8e20691af54)
  , NZ (F 0x62e3e472a5361e3a807e35e3a0ef747af308399ecebaea7172aaa5ecb464e237021ca06e7592241098c027a1d6170ae09610b3f2a43ef705420e62455f0a4d3c871327cd626cd49) (F 0x0c0ae9be79663ad7af9a309910ef635e6a29f43d6852073e91f33ffb825ed1e458ec59558e50aef20a2a2e764b64b6d638f05d48cc11289ec6bf34ebeb4ef07ca2d1e316e85ce1f)
  , NZ (F 0x692a88b4f4bb1fb765c852fbc801e30da715debdf38f6b6671a0f8d0f2f19eeafd5074dd3ee3877fc61aec49ac10e94abf9d575fd0c805d56781958bbb2fff32f9bac3cf217a3db) (F 0x6a12b076fd8c5c6bf6a80abb9c86b3c8a046c6f54c1803988c788e678134b1cc9ebe3d4fd1d94dbca40af830e430019022d595843133e95b25191eff98238e2f9a158ea6ff146dc)
  , NZ (F 0x12f4F60602c7275862f75b0c6a37f620ccb9ac01428f4871046ba7443c27f82ce4a20d92c7f249a9586737cbc4ffac2d26094dff3ba865275b53195d8e93776be097ae89b638e4) (F 0x357d198c192d31d0a51ab8b3171e973deb0a65434d9641640b265ccded2c66a1154d3e0d1fb78de562e98ea17014da4716027279d4043e842195d6490f7de4ef71bcee694bc95df)
  , NZ (F 0x1fa9d46086685069b0c658aecc29fc5e0720c1db18a453b475932681ab021ad7d0e8c61319c3c5eccd408caede59807f9683a344ef6248b6b7af652d844b94f469a9f097bdf7154) (F 0x69cb3584e77b331a39272407d9332ae3d756baaeae4c96d3206a82a53ec0dfbd933689521a88b7cac055af2692e8346d865b8042175098010c9f329157c314e74e40171f607c6ca)
  , NZ (F 0x4e11fb21ab6cfa37dcf0e86191b8ac3ee4fcb59d45711145026697d6071f626d42831798b470f579298298e4d0f6888ae11e8f78dc7b67f0d00f51f82dcb93bc5a26c10e0730413) (F 0x19e5a32f6382ad8ed9a8c6d309238ac01632d19b19cc05317073dc7e1297ffa011b42e3ec6ff6e3f46320d5d4593fd947F9722d0a0ba46c713c18817e12b2879546fb300cca135)
  , NZ (F 0x2af9b31ee022468cd99ade25ad532074c28bF69b9acc043253f938c6265526ee0088bee7b5ebf09cb4978ccaa26da8822de16f966a97e2af85b857aef07f3ed014e3df6692446f) (F 0x61a9192be5e230f9d3fc256320a6145ac8d15a6533d2fa28d7cf23f5e538fc84b463f6182a9b725d41c7e29fa7c4477d4302243a5fa529202a60c8f5e7e43279245F7f364c1706)
  , NZ (F 0x09893af62c3f9ef91c390ea927747e97a26ee968c48ffd8a33eacee0ffa5bec85dc9017260bf10e0f6c50a6ce5105b8fa98d03a12934cbb1c17b00a882f11b5ce476b1782f5c481) (F 0x0ebaae4919b808ee0a8c84ff691291ce5eb17b47e3fc53f703bd450862e41997964b12ee13F6a32c5d851ad4c7de72ab54b430977fb1044aad5396acfb93e2911de6bf61089909)
  , NZ (F 0x2ac7ece094487ec15863238cFe36f7d3531f7af3ea6f7bfa901426F4ff9de97edaefabdf3317bc5705f817b9ba5462cd15853b24e243891f6103cba63424154662aa511e4c884) (F 0x6460c199fd17a691d361313748c332357bf2c551eb6a34eda7ca050563dca0decfda32e24e9a521620773f23cd8c1867243971853ab5e8524257d59e7561231b0098b86dee4038b)
  , NZ (F 0x3d27d74eecc5c08ac70a331978363cda968654682a541c83e4b9eed30049eb5ce19ac1d44773a8f4eb15a9a16f658b1c55a7a8d0387a8da1e527ac43150827be69cb6a385953165) (F 0x632b43b7b47a86614cd9f563022cf5faf83e3a18289783836e7ee17624c88fda2bbd168e97adeedd2cadc36d01a699186c24172d97a5a4cabd6e92e5ee75065fd0a21560021a4c1)
  , NZ (F 0x10e0b12b928b59df4156f4947a3699ebb15eb77dd7053a4193d8d539a8208b3328741ff1f4214312cf2ac517d578b6258720e326e5e3ce6ebfabd76a33866588333aed8eaf6d2be) (F 0x5b45cac3c6960f930473dc92a59776c705f6788f6d4f9bff84ff23a27b2712d5925a6a412dc42c5771dd740e60efdba850b00409908628b21dce05206d6239b9dc17bb93867a276)
  , NZ (F 0x10f3e3d9b513c66cc5e385c5a0345724b6b12fdacff837be94e3f6c03717f1514d055df9488be6eaa7e3559f18e1af7b8ea2f9F80b51a82410b04599938403b2c0a0be25281a7a) (F 0x48e6633596ae39992abf47cfc683e1f5adfc35795630dcda7579d2805ccf95aff18caaef786f5f8ec9e4b6cfd74d0088F79cf9b9e3dfbbe22136a5F8fb89114eacde7971ef4dd)
  , NZ (F 0x449dc8767edd713b02dbb079eefa7fc8ce9fF3f993584be5f75484f4e527f3322ae9f09ad43ef3510Fb031cb4F90f2690ec6311d46d8f9a5a31989279ce0a1b56097c60b594b) (F 0x33b1c40d75365bce66ffdbF6825b2a68fa2d9542ee14604c7710c5204f8491e77d47f40f81ebc8f7ca6d55194e48c3edc742ab20f44099fb87e10774bd10e65f0ca9b102a42f40)
  , NZ (F 0x2f972908d156af47cd0f810f5f8274b1d374f48e58f103d4f4ac7548b2395639893c0f717e7a796755ec87bd72a8c20466f6a9821cc8ef7adcc8ebd4a996953e328c6Fa81ad718) (F 0x7f8d43bb33c1bd3cb05a3484a087152bee4a93894cc941240fd3611f2d7877397ba3b8e18539547c423dc26924dc1542040b15a4671ec2e72f0352924d7703f101d1cF2e3a59ed)
  , NZ (F 0x0c6fca7259742ea612b83a60099afd0e44ee6236d56938ad45235f57e7da9d2d36a18c821ebc84af4f946739157c9945fc2225f0fc20b5fa2533d4422f42a8e4fd526a935ee909c) (F 0x265dba8d9490e018f8fb859625c5c664f8e877984d15f74397c8481d04574392c76467d2177eb438b0bfb8d7e898268f425a327b61acaF7263ecebc1b82be2630a8eec65e74961)
  , NZ (F 0x0804bbf283e6a01d5193Fab80a61f4317217d624a416c11781b8d51563578b9d9834b02a73ff2582796042adbbae9e79852479aba7e9a20e55ec1b0675b6934cdfd39914f3eecb) (F 0x64a61d5f7afa2331b99e53a9e7f459d3829b85c2ca77b82885e8d41f18f8811aee847c6177f88179b3df079034dabe90e36e81a37665585eaf86acb2967649e2062a76e575eb51e)
  , NZ (F 0x32b3d9e6102f41847cb6c2d9990875fd8f474fc2785a91b8aad7b2b788dba5b4f205fd45faad58f42d2a1336a7a2bc7e4baecfcb7620a429b1df916c513fb748329f9f184a2135d) (F 0x0b1d61a8233d5cab3cc6b73703f617508b93d7ab7928e8772e3b5b491bbd07637ffd13d2fa0bd1F94619430ae87d0750437820516984385383d955aa77e4baf9af86cff2eaabcf)
  , NZ (F 0x7914c149a93adbef0a2f4652bfb22e56fcaf19d6731b203b4e54f5ea5cc8178612192ff14511bb5645f1f0986ca66cb13a6e175e5ac525d56455b0dd2d65e1f12365f7318f101fa) (F 0x7e2150105e893d245964b8b67877fdfd2fb5bb9b11e18263207ab62d699a8a9ffb564fc90c54f13a01644bdc9905284e72e78ae50bb6ca0555f3332cee0F1ff815c2db743632da)
  , NZ (F 0x00f98162baa57c158fadd74a11f85c9ada738dc4297e3a8aac33a3bbe11a4033984414bf2430439fc87869d4618961c22d3c3b2d96181cdb5781d588332c36c00e73a3b8ea665f2) (F 0x3f8f2765c88a18f91f58fc4929be654c5f1f2668ce9b138c45c8130e411d4ffb42f03040b3c27d44aa55771cded9f694fc462bFe790b226b8ac322509dfb2df335baca96c194cc)
  , NZ (F 0x2ed1b863af5cc6ec631d41a0087427989b5f6fa23f059f989605e419083b4258cef955b93ca731072d40593a8021d994e0d6de20069b087587f3fd666a4e688dea1e4e595406a4c) (F 0x42be26b62e46b02c25fb998573769b0758dd00bebd5330650f7f988053450a579bb10c30ec37e01e79356b1ec72658742d9ff0f6ab42a874475e004bd2bbba8361aa52907170dbf)
  , NZ (F 0x038586a9f436a96f0e54f3fba5228e60017abc4dc4188603a8152167b64948b728238188516ecace3e03fb83d3ec13d3d8987c05bad80bd240c085aff4124ff3bdaa3228beddebf) (F 0x53516d45ff41ffd92de5a8151ec2453971cac4106393f2a3929c7513dc6a586325a324987896f846de1514e95bd9b297953d519570b5851864d2c7edf292db15a49d54843fc4cc3)
  , NZ (F 0x0a152a03190a01eadb5710587cb605c31dfb0536780638de788bd416b20424a46bec12dec2840abe593524f7118deaa8b1c4e164887914cf11eed5c3344110ad8278a7331084e85) (F 0x212f1987e1867ff743bb3c76db9e5e8ac38daf3ef4e7a28c9652c7996b5bc9fb3cde926ac225eaa015b1cc285bbee989205f40b32af5295ba1e7b676e4cd2bb514f0cccae479ebc)
  , NZ (F 0x73bf84dfFc477c8ff722e1d4e43530832903bbab606b936d2499bb7737b6bfb28bc67a8cc35977dc1ef80c9675bb5009afc5ae4b894f3b52857ed41c7ef275670a05f073aec47d) (F 0x78a5b7abb4e863130689a7bcd9ac705bacfccd966a7b8ae6d64b9750304192a957faafc82102c78a3abe3da1b788be674405b343f29624e5ead2ba09d5bfa79d42e3f7ae5332d34)
  , NZ (F 0x1138c92923ccf725ca84881af969Faa09cdd8164d8eca1acaddcbfa0bc849e99ef28e93111717fc4c101b3e2db6534b59f806888b692f014f1580afbe1ca3e448cf09b69543cc4) (F 0x73b180d7fc410beaaa8b1aa68b6c63e949487686f036b1ea152f48f19b77f8b1397814b88b1a7ce4fd3da0d66e270da1d1ac6f5e080a7920f3cd557e6c90074f39be1da3ac7a671)
  , NZ (F 0x46fd74da3aadd6141e5a94e39615c04fb9b93f306d78c8890eddb9ce9ce4d98bcbb07f8876e1659aefa6ded749004392d9baff1c102ccf2c8Fec4d154f5f758c0511953acc42ba) (F 0x7a37d404c33e6b38caa4c83a81ed44915ae00706e696e6e690753b1facb05ef63a9956aeccc50831830e7e63265fc3dcbe5951a613269cd9029b081a345630726ec6659464ab3ee)
  , NZ (F 0x110ab86448753b13e1f7bcac2208802ccc8e175dd4446288cf55eefc2d90a84fd8d3841621a49a90f32afaaeaae91da25b9c50dfac657e03eebbf6506f83580ff1b09b9c80a3d89) (F 0x50d4ea69ff2cd6458419aff177d5aa380a95cf9c4b9120c26a77ba7f3ea787e72b8d735f2083e9eef4e3e50ec29af24294d5c7cc175489514614ebf45f36a47241e4f54dcaeff35)
  , NZ (F 0x11a4f4644af9824a9fFa3882886fc08666bf7eaf9877d52f2bf625b819909f783817502f03f01754959ef989ce4c91df73b8f4bd876a8f2ba57f443b1878e3F2f0e4b239c7f0e) (F 0x1b6fc9c9b84d52b9fc1252a40db309018e42406bfdd0bd7a50f602cda7b3da428607049fafa4201d7940F261b1524798d0b0741605569141783c0b1ab7151f45f2528d539d9fd9)
  , NZ (F 0x2f60711ace1bdd6526ce0e0636ebe2b349432abad66cdeaac2a0612d003a9a6ecd6117eafa2ed852633890d6f23931c7b568affdade16d8708c4c883e27ac9ec4b33d8df02ab69b) (F 0x4dc2025aa3ec598bc7f28f10d42eb9ed52661265b5d791b5936d9f4e0ec8ab9da5b01efc2a2948128dd3aba9b59eea9805736c3F528de588ce62c4e176e6193cdf8157639d4dc3)
  , NZ (F 0x606cbaf12f6641692858e44dbe300a70017e1873b48a1cae6093b3da77e0a5e72611e759f868013c60ef358d55932b29a7f472c5a5af431a760f486dcf4af1cd96e2a81d21ace33) (F 0x20c98a6081c7ffba1e26fdcb02a171b449308325d297141395ed457a591c832c890ef464f2c7e226d7d24e582012a023d3e6cc60cd2085d19232e5a241e88747f72a92136f91cbb)
  , NZ (F 0x1cf0d9a7c117539d05b0d196664bac61d3f69d7f1f9c8d5d99e789d5bcde4cafab89be1a8ca286513f6aa24b5cbd9207730382931f23ebc4e6773e69666a155dad73f31a1b8276a) (F 0x68e994a0a3967893f2f5fd6d34014a6a417485c3777633453cf68f14525b7f912bdee1ad5e355c94500ba02ad7fa69047e48d602273e8948bff7721b52dfc7d43e685cf11364bb1)
  , NZ (F 0x64dd3887685a42a260299612de16aba7362a3a26990ca064f52940c0068dc94d1730b042de8bae85e8fc78904a05c906a18a7556042c35f9ad50b203528f575ccc7a2ef28f795f6) (F 0x6773b2b064e481bee3ce92a8910c24579223a86f7d2983a763ebaaf2964578cfd1f0c4c4866b8b968e3b736e6d81044b43b69177ce36a27b217f8cf4eeabd87f21e31b6da6f07b8)
  , NZ (F 0x18892d70cf7c7ed14c6d774d4d8fb06cfc4d88b2cb64bdc2b33bff0228fad5a5aa72fc0c29ab716482c3395e5190F37c3168d43ab6ae7a2a8fb8eb4ac352e4d3b3e452a6958907) (F 0x154387f1e6d3231df9fb4f29f9a7178fd0efc1bd46456f9938df9a9552224fd362d26ab98fbcf5f6bfbfad71cdbf4c84deb34b52f0341e5604a5b54F9cc04db98b1ebcbb4036b3)
  , NZ (F 0x02dd16a2337c17b756f1207b9e41fd4ff0c90a85eb82d3cff979347006eae0e8346bfbe10f63258166bd01091f907003c9c644fd7ce21a5e0e945e2c293a0b956919c85ad023c1f) (F 0x17b14cd98559da52338cd0b517e85e39ebd6e78c1632acc70ab07e4021bfb1dd929978380140a2cd4beab54c0651a420d82ad3e5e834b0cc54d96669f565e083a8117ae4352490a)
  , NZ (F 0x38fb0d2cf73364bb64298d3f5df997a307e7b3d577e6839970111db788269b87bdb14eb03a5304aa767c583349ea2d1451da96b38045b7d70db026ac0b4526646a2a8717521ff4f) (F 0x3780c7f465656367caabefcfd330f6ebea232ecd6a309acff73dded18f1e8286d32004658316a3e36cdd7c50a4251bf64eb232ebbcd70da553a21473b5899ff56cf87470af63d90)
  , NZ (F 0x5681aa548c1597856b5041ae597002ec0e635698e62e68a8F8d13272279d686b51d3057d25f66136e87049facba85444ee85e2804a9fcaab066ef222ecaa88ea6d05e6d72d1593) (F 0x2a8774a7c3d9534a42395cf20975f1b2371252eec136a74f21a5168d66e2eb61d40ddc37e108fd23eb185d76eceaa3210f0eb8f8e41b9870727580e7cee54552369662893e4ef86)
  , NZ (F 0x15ecd31944ec9215b045e80056682aee721adc0c80cb2e74346bfaada9eda5b1afd412a66b74c890630377f4ed013140404a999dff8f1b2d7bb97fb7c80f76c94cd1d7948cdfb10) (F 0x03c02bac8c24a2d00574534e2095a3c83e245b6cbf337adcf1f0f4c7e2bc0ecbc0f90a052323ee24068a6395342f6fd9ec31fbe0b406e0bfaa1a219e96c9d8311b75b6787617b0c)
  , NZ (F 0x3d3d6fcb01f68af98246e3f3a45d75f2e83128831e6426c8d64a50d5fb1dc7249e9b93cd292271460b5a0c3b6be84280abf850a80726b67842632f741258e61159acc78cbed27dd) (F 0x0eaf0687eb8163fc4871712bdea607f0fbf5d6db8c367db111ab3d161b952864b88e7f87cbadcb4993a382cd75f71925adc5dae1253d5ee669d53d883da2dcac57634dde5b5d1c4)
  , NZ (F 0x51ba2361e95a1fd067599de19a8ad87d9256e9497c198d031abf1535e1d22dd01ec62b07454da7509972b0803b0352da4681cfdf2d1ac376a0ab3b7100258d529ed8dc88ea8ee02) (F 0x243d5f372c356fde79e8d0166c98ea0cd5283a9e29af1b8a1203f5be0d47f56a764284599e63424c08dab89774691ddb2970fa5b5423acfc3d1037F1740130c5149620b7b012b3)
  , NZ (F 0x28b93c69dd210efda8b5afd81a077e58ad21397527a530dc7cee4588be4a1e054b6871b511a5d4e913492f47260acecfae77c2550427c44a87bbb79b9ee79b684a7167200716e41) (F 0x63fc10efbeda768e506a29b4221e3cd8875b26a9f2de6de2Ffa01362b2c6d8f1a9c28dc04bda195f778b4315ceeb6ee6471d7a87ded6f4c603a753f4284a52f94ca14486804dd0)
  , NZ (F 0x00bed73485f4261b3d520296c518ceedd73c11ac68603ea33cf7ca2375eafdfd1478713007a747827eb6bf4e52fd258e56bd47a359230cc3d540d7b257e0a29b6a14026e9953226) (F 0x492a14a9f8c79ef8e414035e564344fd70226b8858ce3712F6724fd73e1549fd5268e699f45748d1f050fc606136ef50fc59a016073cde7afb757a89230ce6b9bb41a53f3b274e)
  , NZ (F 0x1836a76659698199c2d194949d99dd213Ff4f40a754a23eb41dd88e5f392de7cc0e2a02ad18ee8f7501d0b7fbaf2a16a7b4621fc82a72b0591b0cf6349de86d167c34ffbb581d4) (F 0x200e3bc5054134518d80b46dc22b3d4101cf661e5c5677b7e5F739eacbaf35c1a9134e7af5cb2F758299a66eF02d1e64e88cc405610fF4e37661960c08178b50d814230f3de)
  , NZ (F 0x783934681e7c761f9bb135c5e27a3c894e7bbb7914b4a40d57de6b112443e08d165623d60a77464b370c599703ace3b1f403d28650b83736695d6847cdb5669769910859909dba5) (F 0x769741882de1c101ae43f26e8a042523e7040e36af8e774445eabc25f3d4ff5a68df414493e90a11528e58471fca2e192cdb3F4387bb20bdd73d157e20ab60818215706016339f)
  , NZ (F 0x255b2ca2b903ef6496823f0dcd734fcde4b9cb57f3966a7f79cb5d4f973f90a996548eb5a2af7846c016a31be3c661bc82433d18e22d89a9ea758ec6309c7fc18b9ce5f6c3abbe4) (F 0x04f2b3506de649cb774faac74d99750dfbeba6c988429d001bb7751936bda5de941b70fa1038f3c79b879e9ef3e8bb6301c57393bd664f36880125c9e2d22309566967b60326f62)
  , NZ (F 0x5ac6f875ebd8b682f1de34316e92fa838039ffb3e73e8470e044580a090f225a48cb7F027dedc4ec7a339defF2c30f1827161adfcca5194826fb831bafbd74bb4fc61ccc0bc0d) (F 0x2a450cf428f48bf7b77dbaed04c1700d5cdcaa53c6e2935e5223107433514a0c957f652fda7ed19c12aa31249cba4a90bf9aa7d5771564325c1eba786c6820b55ac852c2cac54cc)
  , NZ (F 0x0155a9df1ffb94871f2ef25785c72d0047fbe31f86167fbae322e29dc111cf7249c9c06f8867fbcbea2310450779a0c45f775c28505d35605e17758c9c19c1713c49f2e83270eed) (F 0x7df61e7124b8d4e953bc8768c13033048a18f9a8c0fc683bbe3161a3bbc4f797d1680636b2daa5f2a4c40a93eb0a6e32ccae4730d17c703ce57c089754b12e561cfcf199f216fdc)
  , NZ (F 0x44dd3e25bF21bf957bbc1b65a55dc5f3ff6322639ec398bc62f54be23f2778e12df961ba17b0d394eb3a1d8ed5eb3bcb9cd6c11d2cba7ea8c751b9bc6c33d4cee1f508e38567c3) (F 0x22f327ec62cc1edb70ddbc993d625d5c197a39677b65fa5be391dd0c5beaa9737aa60edafb79ceb8a122d9bf6886380872e2aaa7ab4b2c65460ff76094bF38a5c96815f001887c)
  , NZ (F 0x4f2d7eda83f921ec7e46ee568f880daf8580df049e4d3f50a3dcd0841c25F0867cdf149683e92bea1a0bbcf27ae4a98390cd40d1f8e812404fc35aFcdfFe4021ac57f11f48b8) (F 0x1bec80ee0e3216df2e29ecd3b80c5d750233c6b22363a0bd6f54cb18ed0ecd7d068d25424c31dbfaa59a1b4f6984a907435e4cdbe8b3d7ff3e947b2044c31F5d654f6a332a1133)
  , NZ (F 0x7e79e1fab6d3784ac788b7ab8fba45758255be0901cf1d71f2f5deb6fFd518a54ed822bb5f65bdef300301d34a776c688ca8486fde7ea857ec9b72db52ea8f904e3912fa4a6237) (F 0x721114e65e7d522a55c10eaa64a5297bb8a9bedae918d667d41d21e613b65e1646d5149accf7a9c44f16f797030f158fd331ee04a8517274d162c2d60703ee1cd5585068f18822a)
  , NZ (F 0x114736bF6eb48158891c61bb296628b28aee02ff7977d9f5908cbf3e557c2781e696ef3dc7f48ae219ee03ea0944fb4ce607fb4ab3bdc569072cc1aed1d4b8682fb6697aa415c5) (F 0x60a6090fdf19df4358d3a1de725c18d2c215f203dcaa03e28c84c52753cb735c28327028e5822ed6119b3d275b3cb96e9e62fbb93a839e40b6a1564836cffb99103e90ae3a8ca3d)
  , NZ (F 0x5102ea2acf66d3c49c23c6dcda0276179e6b7ac0cf6464b86f5e1fd5c8b6d48164788f9a40bded511b5f6181439e369820e58d74ab96176506939f9dc6fae884b8c2f45a0866409) (F 0x23F159abf795d754106a705502620bf7b666f9217d827e20e1c741b583eb570764bed6a4528951f2d4527f383193ebdf93074b98dd0955d60452cfF0511afa895e4e4ce3bd9ab)
  , NZ (F 0x698babddab4b4e33219f8a9a4089aa837dec3fc5272948de1ae100a155bc180153ef4ac68b46a674cFd512f20d240c6101dc70b6c4d3a76c581ce9e73c053ca1b8a135684b4a22) (F 0x4db158136a0448e6f82cf54aa12360c5f83a18ee721ae508b691fd39840a6b97b7d9d68d73f8762cbe4914cbec9cbde0a09a5c29ab46de87b166576da6829349bac89872f73f05b)
  , NZ (F 0x077b1989d49ad88b13dd8f63ece6c7efa57711f7277919c82f50500f4264b50F730f9a11921d45f3bd463f86Fc2bf202d6fb42e1817664bd908ecee7e9ae4604a80e86479bf88) (F 0x1712720c3a7adef8aec8091a540904934ee8b50aee584c663bf60baf7825fdcb71c590a250af7cf100aebb6b176304dd125126dfb9acb7c331d90b805a02331fdc45c3d0ab5812e)
  , NZ (F 0x158b2a619652e24d91792c128b5266f9f5ee9232c36aeb98F30435f785785c90d0a49d40cc89d4dfb84b4a22b5658696f70e232e0e62fc537438482a42f625366ef7590435406f) (F 0x449a52c0183fdd5b168796cf47be83039fc4bb3a7fbcdf10945bbbd29368b74dfd50a7d20570c43cfb52b9b6b9694cf5faa96b9d6e9939c6491c242ec4023c7f2dfcfcF3eb7f9f)
  , NZ (F 0x54af9dbf9306465c20c0536d7ec0ef73c1ed2895cad3e8dec8a48f08b63dcc3f800b5ac33e5dc7664c3ab247ce27baf2e441ad96aedd5c940a0d28fbf7e9659c2ba5ee0f769e712) (F 0x66ca236e547e7485d7cb5307140fc05a7eefa0fce6f42f217d933b0360de2b0839c8038832424f8b357e3e949fab6ad2d6a839769672caecca897506fdd775775727ade3e73fb4c)
  , NZ (F 0x56103e3d570b5b5ed9932ba2f6fd3334bd25c9825e465de792f7d388d978e1564f6b14b34d5abfb6982374eb0dfd337fd3d53c667a20aa81f7c1d30b46de9ecbb475267e70413ed) (F 0x7ea6096fc87fb1c4e6706d7180227f4e3e3abcb52bd637998ce9a55700304b242629cc131f72f41ddaa83acb2d36993dF043be976a97c0f0fc154e5f3abc648bf4010859bfd710)
  , NZ (F 0x3d5253a995635daadc4df234ab49d7eee160f7e447694252e98520e2800f65557c9c7637ceb07910d0edb53f2f09dbf0cd2616445b0156b28ed8437652b6b9ab8ab359de9935112) (F 0x33e7b552a534877f362ddd6fcec5259a35832aaF1be6b4512ea9c02b9f87b4e9d51f5157e71ef0cc3084962a67b3257eec5af925221F72572393611aa46abe67e38b4ffce146f)
  , NZ (F 0x27e4b77b434ca0a36ae39d4db1bb7fa9a9a861b35b6bffbb84f32ae2ea70eda59644a26d87b29e24e83c0e97589b933f47215486007b293e22f32ed633a4a643f111b3b3dcd32f1) (F 0x6a96ed54c661b1e6677ad3b8c78ebd0aabd88b64e0582556c00facf5e3cd4b600d6a3bf43a868219a58686a616265bF121e1d0a148Fc2c90d8654d8662a1117d1f9fc081b1a7b)
  , NZ (F 0x290b953c6146abf9a8c60e09e7b23e36326f99c38b8948e232d0bbab0aa38ed45F74e374ebecdf6ce0c226F64ce5a9fbe9a3a82bba51aa58c5179df3c00009b3303189F9b8c8) (F 0x0512d3ba2ef95f030e25a2f28ac9730065e99099456aae73de520aa3cc7f014a26c51472cbdd06d9cdd7f1e38f8ce67f386aa3ec4651072bb4e7bfbd8835a1f6bbb2280af39cdbe)
  , NZ (F 0x2875b9e0062f306f0c881d3cc493d22f7eef33e4ab45a3be8b2c85e437f85deb8bf64f9357d95140068b91aa781f41b2bda76517ea7c1300c0e0edf8b877aac7295e06a7f4d8203) (F 0x78324313517b46733cf2113ca3f668932e359ff59017a6a6ce3910065c0f9f4748cf6950334dd1a89db3ef399a700a2bc7b26da1757ab507fd1c18061ee65afb5526e1a5136e404)
  , NZ (F 0x1d44f44a85d9951122c63cb6efa9dcc290d99c332c151356c930Fa6c60069a14a957004e69579a00ed8cc29d5a21f60c3b03b6e9e198ab5931d0b7cc5c870c2604835616bc5481) (F 0x7150bb89ca1f1d5c73a22fabd16ed75b2e969971dd279f2192719b858f8daaee047164ab6770cd0a5f14dcd1e762c66840b3686833637a6a176d0694a6dba4d9ce53d1ba24b8f7c)
  , NZ (F 0x56baa15d49b215962f88b2301d23ef6fa68712762cb20aa66afae786ca293179f22b35471dcc49636b89667183da40e3e7157663200913a5f3d66809b2b64d547b652760343934a) (F 0x1c54717b14c0ce225af3b9e6b28c47730846946ddf19580527814247d6e37e97b98a82ec219e30a0b73a43989898a2154b353deb36b654befa70ceb8949bca0d04d612b5f34a53c)
  , NZ (F 0x67ad76e431a18c5403b58f7dc744dd5beb10e5e667ad02410b6641aa54e4b42ce9fc70ef4da470cb9c0c12d1174bF475e12af56ae503e12e23e98ca7c874eebadced54ddff6e41) (F 0x2879c10ca29760d2e26a04c2e2a5b0dd14F90498902b50db8fa5f9cf4ba6d4810f4e05c57129619159e2754c22e512cdc432ee6a1ab8091b6d8ea36f38e18ea7d178437d172d48)
  , NZ (F 0x5b7541796494f39659ae28bc46e94f314c5f3a848a2f317990172847c10e0bb73bdf5a0e2a0012d9fb89ebbd7c0cc54400add6d4d7fbe77ec0b3d0a20f45fa1dd8206f68944ae68) (F 0x68a16ff28e03d99a7e591d93068eFe464ebab70e28b0f0a28e3f288e3af5be60d05f91cf350eb9b6ae699a5333111d9db362c712063187cb8d870f8347800126d65d8d086a08f9)
  , NZ (F 0x01d27a4f1c6418929977db049592f66bf8abf888666d8aec9e743436094aba768c99d6d6a86f8ece035e706324c5eae82387ca29e2fbb4cd8b51b427826ca0c366f9a8196d57493) (F 0x4c8c4d22a88bbe50ddaf786ce643b40d0fc737f81507ef7ba41b9648a5fdc6f41b96e72e2f7817e4aed871448e757ec2b0bc144bdde9bcd4f76ed1d57beed5d61cbe9d9e45fa5e0)
  , NZ (F 0x1683852e112c4b5cdb14ffa703e50e88ce3f395b7f43139c0709fcd21ed4c791b3fa8a901e585e4d7d05d8c78c88533a44999253515ed80dea9cb0a23f326d40dd630ac79788793) (F 0x5d28d5a2d7c575ba725378fbc9a4fcd139d003626822fF94e9bc44ad94afc1da7faae42f6e984b5c104131581b852379434aecd53c8647a62a1993949f653e623b9ac254da2313)
  , NZ (F 0x18c9c726e1eed382c6a3745e0415579788e8ca815bf0f25409430573f8b8c54530c25992c88c86c1db00badaab3afa60a012d467bee2a759b1378204fa132b6df2c358f7341e16d) (F 0x73b0fa7564d6db6fd76ee2d2d0d997b2f61d77de1a8295e769de3522b7002cd495aa914a4c5b913bcbc11edc0e62fd5826fb3110af4e802aa6badd4eb72aee1c5d1c6ded7c9ccef)
  , NZ (F 0x2d4843ae7c1c56d4950741fdea6b6f509596aeeeae4f21f287eb5b62ed92cc9a0e61e3039efd15b7e5bfdace903bfdfd36a437b7824279f5288ceecfF190cee1d94848a5e3c2c0) (F 0x75896b160e9d7ef83536ccba5085d8976a6ce64a620b6177c343266ebc9f7b0d264F9c91f0d43bf16d841a44116f9d69256f3cc48be1a545b10a878202ccf31ee02260b6F09ae)
  , NZ (F 0x01ae1de6aab007a0f00dc72c95de7914ed07944f5327519e686914e09da9ebb485af7707c211f12ca259fdef73d6204642F9397a75f21c4d879fd930fd9ff091b627434e6F84c) (F 0x32bbd8c72afa3ccf4ac016b1551a3e6918a171a1da595f322ae151f5674756804d6739b2c41c90710aca7d2a6a79881ef339dffa343e4c1ab48f6c41a746b7e1b3ef7c8e5980480)
  , NZ (F 0x0b24e998ddeaa44b015f4ae2f02ae25922474Fd539fc27cf6bf2b98e27f366528278c697b60000fc7caeF3cf132942825d696827eb58db53804438cbc56cc09a29026eb3db4be) (F 0x05052941b9152a1a05ea86373e37ce666adb7554b0d399e2fd821a20f1d3ba0cbbaa0f0dea5f7f6a1f11ac65c546b70cf223d2f6a34676eca77e1cd6459a7d273d79968ef6956cc)
  , NZ (F 0x651181ade340c5df0a421d2460d48b9069ffdb0c94ac11596703b1316e9fd7eeb227e46c86c8b5065b6bcc4ec6a9f1201067777a9dea435ad6445ede9ac735e0a6f533358069530) (F 0x078cd1c009e525f95be2d193ae80ea522a8d2fc61d67F64afb0e8955e034fabdfb21608b71f11327d9b653bec2393ad8e38e91e90e663524aec7300c0beba213a81f8248c59b4a)
  , NZ (F 0x69624c7bf5b3a38681e098b4e3f7e64833aaf0450020faf66e2d6ddb99c6652bef468edec1b512c8b9f3ec74757db5f3961c65cb611be4f225a37bd5f5651971a366ebc47b9fa33) (F 0x4916e7f30ffd33c0a6777832e1e219c6bee11f67a255b6652c8d072d8ec01d8e7d45cef11c1553bd28bf9d8bdca0278fa4df677bf094f6357a1ac89bc82ca910a03d03859242bb2)
  , NZ (F 0x5da9eee37ba21db8b6be04b0b58abf663e8438ddd737d883df1e9cc93a413041ec827327f4543F8fd705eb9e26F586988919fa62fc52005495af5881698c1b6e20Ff9c3c638a) (F 0x4d7b03093b1fdaa6f5f68ddf09afd2a36070dc57a315e7b0f8fffd5cbc5e49e8c279d8cfff5dcf4c0e3cf23589aFadd58bd72914bcc7e8112785de148cd3d8e9f63956cb9bcF0)
  , NZ (F 0x28613f73f4cfae4e738a6b8cf69c9a57940d3ed3966de1ed3c7dc6bca3d0a653c42bcd0c51d09ae388001f40b097953218f6afb038238c831eee331ec5be08c34f1f8d55879f23d) (F 0x1788c9d6bb2f01288eccd6ac01cad207c786e901580ff66234f2cb7e11357c027ca3cf69a13Fce4ed29ad71480fd1eb2090df4fd540c27d9ceca9f78fcea01060dd53f6bda0cf7)
  , NZ (F 0x5f87e378a3bc5f76d0400de551a08b2ca6044cccd0a5231866701c0728fdebac9e7c677c479c9bea733a212cd2b23ce1692af7424cdaa353350803abdc3ea0050751f36b65ca779) (F 0x1385ba33908e1d4443c448534745e84d6816a7fb2658607e3d2ef9a85ead476229caf571db299aab746c7e25784538ee212ae262ca9eeab2ab09e585733af3a85cca3ea3cccd601)
  , NZ (F 0x3f4ca379a3213fc9532ed51ba007a9817739008276c3e53e61da3d04251bf35da01ed5d1adbd855d3e1dbfb295dba938e69f0b17410ab07951f9a2d1031ccc7cd651c9ed7199a32) (F 0x3cf0c7532005a6ac3453022a43d1e6a52cc11fa0e5a5385be9cc46a7370e337356f7b03c7f21b4f35fa45ba1ad884d51f679f0b7d22743b1024ca1a226e4868c9bbab1af29cff77)
  , NZ (F 0x01e3b895c86db8ef0621c14ad59a158b01e30a9bf6104db886f38f45eee7784d292c97f32303fa18eabb2454bf052c66cb003f9d513e11536c5902b0a43f534659695209c75f68a) (F 0x33e2262cbd9daaf0dce60fa546275Fd1a2a0f56b89b22924366434fccfd57c8b481020bb80cd561bf8c61a7ace75d8d5c42559cc6bb5bcbfb10dd7eefa507bebf60e56b88e9dcd)
  , NZ (F 0x721ea141b941ac8399d5e051f53f116566c09045c6cb68642d8c66218239679b4e4dbd7d825474d41f9e5cb7e574b17155a75cec9dd56431e917adbc536c4e828192ca284f14c6c) (F 0x6c484d6eb9e7fd962d39ccc3998c52e9713b5f6efbde7ea4558499142f49b309daa4fb48ddb21362af6c50e5005d548d1d28f864b04857fca0e456289d70135027a5f25682Fc02)
  , NZ (F 0x31d9e3a62c3b7dec60b17d43fc681c46cfaf083221fffc995fbd017991024ae87d5c2cf77ed19145b9ed8a106ae12a4a1a3ad7cb2ac23fcc48bF641aaf79c8f7c70edb79ce2764) (F 0x292c958f37c36e425a35182204c613153961c602Fd62b60a7d4315d73df9856b48b7f3cfd07dfc14827e02e52c630ef7b3abbf3e4ba4e3745e7213f94785c66e4707c15f6dee6c)
  , NZ (F 0x6000ea69b5803c7df226e62156789b55360ca862ecd8ecbe983394ff587327bc8b7902d00c9e2864c9f57d7eb6d9f18fd55fFe3f14d4495f814ef54d968660fb6f3809a79e7246) (F 0x05c3327caF35283ce4533c5f43f3a3b2bbf12c39b0e122360c0868c7878b1992e91F348aae0a5ab000805c574b0c0695ca139934999a9a9415468e6251dfc60f9abd75a0e5ab8)
  , NZ (F 0x3d42a1ff96ec08740abc0ca8bae7088aeae57afd36942b9a4f33cf8dd022db7530642c8e2f8ecc64e5fb6453220252d40e19606d49a78467f3501946f3349b5b3ea820edc271c7c) (F 0x319a99d0edc50fd488bd7c7875e8e36d78c6f54bc9b77d51d3dfcb8b2b35c73833192f04cc1f1594db83a9f4cfbf5af8cddf850cef9cbd8422d022e1532697d11b6a7184f3758bb)
  , NZ (F 0x6aa3971a90d9e66f952c380e734cda1bab3596aa87f97d15c8c6321369be8339b0c4401f6831e7427f527c742690a8fda58f53ee0896826baba334e54f550b4610a4202a0814e03) (F 0x3f9d0bf15355e3df6a1b37e76a123bcb2a20323b97c2b4362547acb8557780dae6c144f290907a3472dde27611195980b6ee936663689b8eaa776b8af5191d1420f2c2c6ffd8227)
  , NZ (F 0x0c5f09a23b75df9d6db88799e4fd38d71e8b70361d3b166759f3d54387606dfbFef4ff82cf59cFabd8e225cfa39f44d7afcaa9cb8c68168adbaff101bd305c7097990c622dbb9) (F 0x5b604c72f2098e695cb9f087405932c107350749b09822039adf7d2dd7c4046c7ee3c7949afd4b20205b0d505939a539fd8d3525ff50cf102f7178b03456a9a1778ff15536cbf7f)
  , NZ (F 0x7e3e9a256c5725fc0b7971772354bdf679f0ddcbdbf021b6205bd72da79eda6781527Fe708984d026143f7c225a65c84948fc2c279350700cb7e9444bcbe5f9d2a18fdb8f3c169) (F 0x43997f1addd5f4e571d3f89b42383f9c6a2692497ee06ea12cad3b5b771cd3ac2117e2794e5c4e4cb3f9d87f5765aa825624aa9cc725bf7e8243e44d8ead952b67ad664675b65f3)
  , NZ (F 0x10d258f6ecc4dae48f41fab159f1f64341b678e8ae081da3375e5efdaf5487347403a73f65fc34c06c2d8a67e3be7894054fF0F9b2282263c83ea13948ab338c1b2fb678c433b) (F 0x65334672941cee081f6d20b07b9491f156df9ccb4d8f9510d3c5fac868541a84e2b2201264d28c2d64f95ff2c15cac0258e61dc8fa7a91b827c0bab622e1d84b73cbed2295f8e40)
  , NZ (F 0x77fb8fad7397752454b0cf17f5b0217d7abb02f2f67f6a3ad12dcf6df2afb9c4f888fc54b01458559de4fdd590915f1f749b408c9a1b782450171d4c8ab339468b9b593283fb6e5) (F 0x21449241fb9ef0b730651b7840082ef2bbd612a34a78a40bd09a18523265899deeeac6Face83ff1f72e5d8c1f07fcf98c1832a3e09a5a8813e2494b5ef410bf3f5d49d9acda189)
  , NZ (F 0x25d046e559a2dd2b92719cf5354e220d010e625955fbd529e5d7e3f01efb07f50a9a6b9c067d4d125846811cdb5bc3f853d7dffbdcef1d19e3eec3e213e444073790b6dbe614816) (F 0x6c340b67028675cc9a446150a013078457ecaf748c0f94b39a49814b43134b4735356280479a15e96e4900987296bc492a27664cd77374554d81402a73c8968ad5fF6dcc27051b)
  , NZ (F 0x2136f41f7d1e7abdbbf569b495b39186f61ab50df469aa387ef5ce9bad7009a22f78f656725e1f63eeba311b8eb4177ea64d06ac5e28110cdcda2d057f21e98362dd98a91495ce9) (F 0x2d9b8769e80aebe1fcb9edFF1ac458cdf60e4b309ca794c27a456493812dfffc9a9e1dcec66703cec639baae49d3ab5e4f4fb6aa9330957ad611b8e56e6b00682bbc99290a61e)
  , NZ (F 0x5535ff3a04ca6b78a576c0e8bec9208ae8e8fff4d04a553bb42758597a0c1b836045b603374c12bf6a818ffda84e0de50ada7ad7bd3bda5e47b8b477b5a72cb547b78c9f9154152) (F 0x76896059e576b9766056d029373bf737fb166c5aa7a379c35dea3403c6f0a2e8148b0b6F5df29Fe674ef24ebcf3486f05ce27c1aa351bf75d84d9434d77555dcF612a8b70ef0)
  , NZ (F 0x642e435cd5bd6b14aea58e6f8403896b8ea65783b50c3da588ed3dc8ed5532e016aa3e0305d588c4b5498b09dff284054e8335ba12dcbc8f67b40958e1346b9da4c5cb904c6f4ff) (F 0x0494fde9ca0f4aaf95d5a1a8ca1b798ec08e4645f1F74dd5c97f039a678fF1e95b9e58e52facb67956d40f99cf916da9761b31dac65c8666873a91f2eb227cc5857202776cf6f)
  , NZ (F 0x55ac6ce052b50fbd956f3f6ee14eab51a4acf06b2d4722054bf0c76b3b5b4b20bde701c4fa3a6fbd775c62061589b68500e7500502f2ac73bc41fb959587468a3ed71d3cacdfa84) (F 0x6a58e5216cd7380642a64c01aa81763d8fbcf46f5bdecbf4F371fc25b1111898157a6b2eb1578d718af4704926abe58e4f0d3672d61004533ffa1eF87fd552e5ca190862fc4f8)
  , NZ (F 0x349bc5af6da8142431fb603010560f8fc555a35b8b7752745d1fce8d1dcb602bf8c98c2bb4171b7051a74ce50969aa97b5a4838e249393c0dbc9524e5bda6f89e9428f60ff8efc2) (F 0x6267576dd7c8edd83b117c2160852486c2dc35127518123cf912471fd245747b8e51f6f50235bad0b995c96251fa2f925a2ecb4f81a4068b43b8804164c61a5515caf1c9ee53587)
  , NZ (F 0x6e9814eb77878330847534c033d22eec83Fdcc9ce2e8556333fcc48388ac4997d3e7e77986902108b5a4ba4189380fd22a2562710c1b2c3d394214e13f8a8f9dea48f9e35e957c) (F 0x29896819b64296a8540dea155ebc0d800688fb305397ebe9716F12b80cbe75f761c25e8b6e42009b397599513503528177abe1e404aa01afb31bc41375b154bb78b77f83dd3fff)
  , NZ (F 0x535d792442d41050ecbc570c0cb875602324e3018043b8914f03d93ff20c772ed9c632e5206fb2f6703b16f66f93961b072826b8aaa313F95e25a6cd96e7153437cbd85408c3ff) (F 0x7386305d3d7371773699114ecf1ff03babc7db5042c58d317d320e0cecb625d2ade4f2d23acc16a8476a6e61606c97c809d2e49d0e616a399ee754c5a425f378615427fc01d395a)
  , NZ (F 0x5385d42581c0f353a16926d5c8f097a19ce85ff9d08b6f84c56561b4b767dc9475e559b11bd3cbbf7b9F4b4339ffdfbe3c78a7b8acb59333451bb044a0f201a8981cdf0aa1e6c3) (F 0x791e9421736d07b81ed3e07ae78ffda56386ed2a8746944f8e6173e54f0e9eace3799b20ef2a9191cdb0ff2caa815c8c828657ad4e70e0ea2e64020b60f5a4947dceeb47d29ebee)
  , NZ (F 0x58eeaeb1514452d0a713ae46a7b62701bc7d2155b432db0fdb1682368ec14c8e77187265e7f523292e0ed3e4bdab1f1158ca7f52230bfcc81d796f0e485d1856ed6b16c51b509d4) (F 0x0c644f089d8e0c5f941b7de53b45a2292590dd5c2726f43baa09c9b2dc7824a18b708d105f8c07a74edba44cacaafc8f76faf3d2d455b8d249d190e487f18627a5d09fc08c89c8b)
  , NZ (F 0x5dcb84a321ea4b3c7d92778e1e7407e498e855c44a406f9334af7ed65131ca0f0b28bf86ed08d5ea1e491dd558689f9d7c77b53f5bf2de7c57c863176ce495f27418c4da7ce9581) (F 0x7ad5c35ea7d5a4afd5588053b08e1d540a47f139a77b2001861ac819b8680bf8213307530eda9760e1541c2860a627b60d6badef4bae60d445774741c182e8d710f6bcaf220cc96)
  , NZ (F 0x043007021b94cf80309d066bda1f99a22939decbb3511b296279f11b24fbf6b14cdc48ffa232dcf7cc06d3cb19cf38e59c2a84d406251647d8caa985fa79a987af11b8b8acbc3f0) (F 0x3417952f30c529472fF89d90661593b653522e9bdf72b32c5dbe4aedbdb939bb6a2a315f70b05d32ccf6543378b99b2e2695ac1e85b303e1e6aa935219a1eb91b5c2d365b1b289)
  , NZ (F 0x36702a08232490315a776f982ccf1f47b54afa33d1466c8661923eab2bc6bf8ae4cbd4cf0c25eaf576b13Fa34fd7c97c738b1d0dd53a6d85682b99adefa67276b483176836161b) (F 0x4bf8be406ef048c03a831a7fa8b037c07951172081009b32c15696430b7d98213bb958eb06ea231aaee69ff40556ed419d903113ddb50e77372e944d9ce123ef7d3c60e5284faa1)
  , NZ (F 0x52a9fad224606a9f38888a293e007a31e228f9ffcda182bf59e93d6f792ccf0a99917ab38ac7321c25087af41a545c0acf17f393d6106b6d67cd314bd8aae0cacec0a599ee67930) (F 0x2a971a54ef8a526cd49427736fdcfb935e471c387243bf155fd682277de09c28a0d6169b7cca355ad81f978390adf830a81e4022a05e11badee20c737052c68f489ae514fd20433)
  , NZ (F 0x57ad7e98be74fa6d5a0721258f8d62568b4bd51713055314b44c03ec366d6f13619384cfdb02F2717021a52cc9b3ca2fae2a83af516369919f395caa2c790e21b2c0541c8e02aa) (F 0x4f13f849e4e126d361073520bb00e15380b9dad775383c1242b7d3fc4c7e294e8003f835a850a19524f469a5bebd4320410fbc8d2fba24ab7745a966a2b9192369dacc6877071e7)
  , NZ (F 0x507d77445894cae623838dd125049f6141a461620d395c345b937d484e8e251c56ced9fb5f4067e28a0869cb1266395d0428a3b07bc4ecc6bb52190f16d1b5f963dadffa9af1a3a) (F 0x7a63a221b2a6e6417eaef232b29f8b29be92e0e3a7f11fda9d28b0fb5357bb6d4658e9bb0b091dad20a86b8d617aadf2f74173e1301c948eb669a09f3d450078f2c50ff9594b5c4)
  , NZ (F 0x26cb1705160a2F9960e0693832f42ed404dd73fac9ebbdc33bdFf8346fdcb8001de699809cd69d2f319453b53ef7e4be7fc277cd3ba6d44833c719474c4d8e19fcd06d4101618) (F 0x6b2ef104c554a61797f440baa418845d97f3dbd3bd72d9defdae4bbaf32597Ff57c602d8e64de4b319d8a1db126be4575d5003e6666829bdee50321798fbbaf1ade5bd2b8ee38f)
  , NZ (F 0x58f59376c96f24cec08fb06aa7df9b56e123693f191fd4d8a9b5f57815dcc0d6760a74fdc42f3e17bc5b33466a6b91f7f0f55c46f5b03b01539db0f425b2e505cda86ccd4fd6b5e) (F 0x621c755a6fd77b816ca01650f57ded475ab5ddabca6a83b5178486b1a04cc5e681b31beaa6a1c2d52b173b8d70125511d3bb120e922824767F37c26819c0aa9ee55b3743e8c1f8)
  , NZ (F 0x44051e54c3df67ba4e3c02b2242e9c61d03d54edee3cd77eaeac6d5bee037f7c378eaf0689882ccefb90a4840a3bf93b523ca75e1b800bd9c678aacace9cb5f9c54ca0030f9f34d) (F 0x0fd57d3053fbdaa80b4802c16e80b7be295ec65a9f36b0aa52f260190aca101cf10f07b650e57a8a5d966eee576be43598c981f7f076e667dd35e8c73755107c0898b5faaaaa9ba)
  , NZ (F 0x29efa1d31f110f51f9087064078d3029dcf960810629d2123caeffc73638e03d9cbe3b08f80f695a50c7dab8b2ed136b0fbb94fd19f5d0bcf3cc290ff36c0b8bbbe6cf92892b17b) (F 0x52dd38432185c7550d3e9da434b1abbaa97d63a5f9e3fa2ba56a1a349b6904aef847cb4ae6a120b97cf4d1298f5100e2ddeff44a764eff0ec7a2be434f6aad82f36d6b1796d0f3f)
  , NZ (F 0x6abab7fae71cd020a39c0cf1860197292acbd7267a710091af32800669ca8a309a41cceed02257271fb451beb2ebbcacfcbc02a4079b143b8eb180ef1ae624d568b975f3b0b9571) (F 0x50def8624bbde6ca5c7efFc8cc8ce29fb49df45891419f724c2c83672f065e3d940524b53ce32d1cd6d896567c2057fF960bddf4Ff2884325ead8bc631b2f62bd2c8a49dbcce)
  , NZ (F 0x03a981886aa3130e272c435f24a5630e187341e483f806334af71c1257346164a0bfff6e9eb2150b34f5a6563db3c19b22d7791d0573720dc3827385b2ecc733224680d4e703782) (F 0x63866d7504b53e7edd40a0cddd293327b6ff8e1ed16ae8fbf36436fb0064eafc46afaaf13a4f78adafa7b7c19f6bd0e52bf3b39ddade41130d4d9a5030fa68cde30465c03443fcd)
  , NZ (F 0x2037bdd1afb7e6fbe331cd2d899c0e75c4aa8551e7d12ed201cf1bcf66da8cb52f0c03327dda3004d37b465c3d58447016ece90b7c29a3e769b55f093275a00e578bec01cd38c0f) (F 0x595fa33308f1c9b074807a5fc2c8f437a603089473b9a37bebd33ffd21cd7cbab98a8f56647d064972c872c7a7de184c0372a20bf77489eb72927e867dfb1fb674f28ed54685078)
  , NZ (F 0x2f3224c72b49ed45d74d3e4240a5cb3f290dabd056a2bc72ad2629824c07066eb036fca3ba83db16c05661ad37a243313fb870547c05158ea5ba8e1c8e51f226f194d590559578f) (F 0x4a420678f1b15c777d571447db6c3f5d235ebc77794a9eb58222d114bb5abc059948Ff83c148d339f5cd8b3e178a55e081d06f9705162c1e40e05aba505ec1972a189272484b93)
  , NZ (F 0x1403a6aa0d2b155879a74436d2e5324a6d6054ca604b01ab1f8db38a5502f596682f457a3aad0bca97eedfb00f254ea6b91726c01cbe244078b6fd6dc6f94920ce0d7bd72ae56a3) (F 0x33b7cbeed2b7756a1fdde915f11962ad8b125996a6a7f0f24a3c058759545d5e522f285e4ad99242F60431297a4f487be427ff449b13c577475b45596ad7d73275408a5dc8131d)
  , NZ (F 0x01f1928f41c570b03F8aca1d45893051c4a5f6b0293319c865f6f5a36b6772672c6f706c7afa4fb735caca50f297bbd81a38c0d79ebc88cd55e5bc2137Fec7c2e9ada5eae6df4) (F 0x440bc0fbfc6250a1f5064e5dc936d65c0eb26f4a3afff70fddc1d38809dff2a1e29aab357a7b069b84b55babff2f5bf09e596761943ba30acc5e178e22bada2359971d1c5a2922b)
  , NZ (F 0x6ae9b8059af8d1903b8aea8ed64cdf2c0b242df04c524b6c99c7f72048d3b392a92f711ebf99940e00c77b15ebc6a7f0616e49f4cfa491669973210aae4019d7a0664a67f830307) (F 0x77777f4056142b8dd8e7e83b1d0a0d28737d79de8062ec2c15e4d53d1f34aaf52f7995d5a15c585f7d6e1c38ec5f1ffa05e9c2908d736c62627968eaf32a43bfd5b719c34804c43)
  , NZ (F 0x0bb62254bad2F02149b66476ec521109dae8995a034cc61c3aa8e6153838ca797836b2537fbca1613b091aa3f34c34c7d4def6b46cc8c58f48f7ab697527db4eec326756f68af8) (F 0x15a37aaa9167c4e615a7207487e59051a5ec7ccaf19243473f309e16923ae3f75198e9f832980d124ca74d43ebda98e796e467b49214e1a80b56ab8b3350f48e68640fd5f565149)
  , NZ (F 0x410ff375444b20324aa8d8947f9a6955304f209ae0a820c49331a2f2eec0194e512882ec08a31757df41e3390000afaf4e0f00eb58ba19e9b5839871b2a1de924f068a098a5ad77) (F 0x4ceea66d95dFd0cb64a7bbd579eb5a1ad726447cf6854d9121e44686c23e5ce1020f819fcb4a8b9026d17ed6a3087845bc31120fa4cbb772b38976982cc9c0429b36dcdbe92e10)
  , NZ (F 0x13910ca36c46ae1d59a68d78106e155f0fdd88e4e99ec4230815be48c8ce242f26f5ffcb69461933cd1bff8ab076f3e3aa4ba619238e0deb9630a1e5ac32ec8647f0be8ef36760b) (F 0x3cc0ad99b00ae0d5ddb5c4bfd0d417f04af2c1a9c341856258388645346d304e8a01606af5df86cbdef34d8da71d6c03cc2719ba830582d6ad5878a675bbeba37c748073d5eb102)
  , NZ (F 0x00c21f68c6d3e45428ebb6232cc1ec2485442279b8ce1734c28313d959b2656f5343594ce3caa01d2d5373d02e0bb3686322b9d5bc8cb3db7be2bedaa77e873F6f928bc66db76d) (F 0x1de6524fd03c659bcbddce6d0ce93a44dea9e568af6e0378326da0cc5ec460d8c108e4ef455b7262dec0d4379373671bb3e9081fb1dff93d25136ae19051ad5c10c1e773b1287f3)
  , NZ (F 0x24a7a5f06500a8eabd359abdad8849b368ea58c26be0be44b495b04135b2389F1867bf54dc81f43fa8aaa00fff7dd5e65eaadb4211135484a6f8223828820c97d995cc16cd1351) (F 0x162505fb54377c5e61044ce88f38baa2b2085021ac55fbf80bae17f60a8a37d9f3ec97b6fd2cadd5e5b74db9642eb0be4F7d31a14193747d08fd6c5537f7be4ad96718cc3aaaa4)
  , NZ (F 0x7af5192f414f7a887222f566af539370baba86e05a90f4509ece5c080abb1cf6b5c50903b34b762b2e62edb3ab82874a5038d663fc60242fd84638f54f3526d1e89d299123f947b) (F 0x0fcf5048464031a9a1e0723a5a07db61ecf6605d654d7e351fa6dabb5331fba6ae4b4e4fd8c7a6e15076ca1b340c4a3b0bed162dc226e3e16b1a30a4b299c5cF50e2b8fc539254)
  , NZ (F 0x20f1af1d3072307baf4c12711f8231d9c8d9f338b5d671097b02dc413d447ff418d92aee763b778f089c585950bf8b26858b4bfc40b71357505c2df8f919c0f6a4945d643253107) (F 0x313e7302cbb79f922973b7e4d17a4bea53b4b7b7b9c47dc4d0d2d577b0aae466b0ce701a9f4ec17d1f162a66da545aef47b05642ebfF91e78c36f4bb7f7e0cca2a33dab224c061)
  , NZ (F 0x67797c14db33866e1cdf62e8263e8c47b8629caf2a2be0f22f0b62f823e885e036caaabff934470e3d2ac9e5c687c64d7bca32a4da41b2aca64c5ccb78c9d4902aee9c8afb9860b) (F 0x50751285d62000916bd1a49f9c78a207a6a5e56cd0522f6f24d993287e17b9665f9931798b89650bcd449b17034622a83f8eb32f5a858c31cff9b8718fb5e6d962cb7a249becb11)
  , NZ (F 0x1138fa25a54e2c00d3ee489862eae2c1763293bcd1e498c7bc3c8634ba6959a8b13a876dbFdf60282b39284b084c688986cd152ac651d7d8adb9ecc08cca9ed6272254faa9f1e6) (F 0x1a8725f8cb4a6dfd2c2276d7bb1a8e682c0dde77091b336a5f19ca10fcd5e9da787Fe2317d2eaa5edc8b0bda38a8fc18fd49b8c7595ca04a5d563dF3a517895b0e67a0033caab)
  , NZ (F 0x13015e1b9da7b781651e06849d2dc65075ced0172bbc4aaf5ed10ed22c5ac8c3344666cc72310d31823622fb6e313f357ae6fcda5ee78fac5ca3a63aef2cb357c64e3e5c91311b3) (F 0x1f08fdd1e38a449ff61ba14bdeb7c1ddac60a58edcd243fcc728b37950d8a1aa6cf5791db051ecaf3c3858919ef897cc6ab9a2eea6ca793c01850209081c940d7ce4657ef593445)
  , NZ (F 0x1ec187cc156b7b2ed922483282aa19ab74ad23c49e1a1c805d4c822888691a83db14abd0d62ef8e407c89e7d66071ff7dc1d1a017e418392ce17328c72544e8af4c15560690b0f9) (F 0x2fa1c08243a76313287499ee4b5e76aeed4e8b54873387c6175edba1bf56076b7335590dfbd7d415157eff83a0d8afaca0bf7e207ce4956eb126b89616f7b92e157d912961fd60a)
  , NZ (F 0x26646b2f1cde882a65b4cfa670dfd919c04e748cb46e0b969db920ef4b897943069445eb08636c5a89af76e7763aa6da853886a55e3908cf0562a88c386b72b57509d3f31c32467) (F 0x75a818d9a59fbed41180132b7bcc957eabfd9dba10818c87fb568a1055d666f5aa0073a88109c681dc9eba0a9522a5080ac4dd9a4c194b014af314bc483945e98868d9936eda04a)
  , NZ (F 0x735406f862050680b13017f0da92d0dc02b41869af754ad27be1fcbbdc93897a0b528a8a9c0ee60aad62b0e2a504ddc0f80e0a84038270c10a0601d7ad40bcc51c6f66fbd8361d6) (F 0x140fb52773660ccdd78c3dadf187745f31e1ac421d71649cf6c96fF995cd166659b14467aca8870185a812d79c7f7945029dcb3c4decc6707821a284060191809566e40b05476e)
  , NZ (F 0x5Ffb0b37233ed52068204101c41de6cf0587f994ddf54488875f3afb6a7e9d8260b9795c452a051a3d3c41dcb00b7cd153df45ec510ab3bda134deac7711c8515b817875fbf494) (F 0x494d4c56220d7dee238e3185c6b02493faf246559493eda14dd0debba26ccc15b02e3beaf4d098cd32360c349c78ebdc0de0d1042c7975f2932081a747390efd6e3c2695efad852)
  , NZ (F 0x7eb719a101ddeb132684586575635a93fd43d9ea00f5ac8558f0e93340893874197264f0a95ec898343ec5977cc1f6d2337dc8c729213f7ed4626624fbc779af416b3a1330732b7) (F 0x3301303b0b9012336c1f077bde916650ebe7b31e02f139a781fff69e0e45e789e0ef30a4a778d4897ee578ad30b34e11fc3b61ceea40e4bfcef04252723937a85719d5257118998)
  , NZ (F 0x716392cbc2a12cf3028d6793dafd1c37881ca62e5fbf5511a2bbc5b533c346cd03f9c0363e334c325af53791c3ac9e41e9519b814aff71be00e2cf8a1147459989b6dff3dda0d3b) (F 0x7d2b235c557e19389d8439a5e8fff4b5b7524de2b2c5bd0e5d40fd894014d4aa3f6fc503ec07ab72d59bd3198454ce9dd6c7218aec801eed30bef1882e0ff42bff7908e663233bf)
  , NZ (F 0x2da1a9a76d28F1e3b4f30240ef33d7661acdad1525d11ae974d5bd7a2a51b0f46e9d1F8397c48b5b4ce66e6547b1991bda6a0845360a05821e7a073be78eff39be42b9020881f) (F 0x50233e496e0054b8dcddc1ec227fba7172e982753391102f577fa875e3dbaff3918a4fd7c6a3efabc3611fbce63586dd2f38a0c4faa773020356ad3d76fc0c9dcb6baba331F365)
  , NZ (F 0x5955ccb7ed9542a3a668F8acb11244d5251547ba3ff6084a7cfa201118f8Fa7bacf46378488b9fb50d8aca0ba610ebc51151d322d4359d088cb77c061b9ec8f9c1c439675b373) (F 0x1e0c9e3a93b85ed74f51baca6c33e300bab67ad668672147572c623e9eabe6ff8af3df8909a97a0f56daa6967533dc76fF7377a490533eF47d5dbd02f5fbabe587a4227f3857d)
  , NZ (F 0x1d0f4dbd8d36823b004f57fdeb467aF2750903766163835c86e59864689732e70f3Fa1e88bd0d12fb18407f208ed5df58909e93ce574cfb9727f075594b6e26d037589b44b2db) (F 0x56b8d41ca20565555b5c6afb4d8a1478760179e31d72c8773d825a1b85799ff7bdcd00688edd54d4a82df342a4fae4973ab2cc5a17ef65fdd3ec700d0362d8e3191266e0ff23f14)
  , NZ (F 0x0e749b21d2b7b041006a8f1397cd8532bc4ff6d148e2981061d6964fb334d33d06bb0f5d0715bF69e04cf76091f41ab3c88bbc701e2511787fde965c282e7a8a3605dccb325048) (F 0x4197a688028a93a78a150cb8986e7743e9c655ea8e5e7385e890d3b9034279959b17be0f6ee79a6290f305f8a1e08e618ef0ca5595ba02ef56242dfdbe7668621db8728e059545f)
  , NZ (F 0x408f3abf6e7d8a3f7fc1d35bdd23cb54527023ffc2e85097e4b363dbf114cc0faaa88834f72e93a35b4e4b42be9eb39825a3325e609f94dc2bfa1774eaa80a8ff2a0F9a47491fd) (F 0x6F4d54cec591a6e5bf23ac068b4ef66c792183c16a05ac69a967c7f10b1378c9defd33c040e96b04a00735cbcce21acfFe775af186d4e4bee9ce1a4afd5c04d1f463a66b42e78)
  , NZ (F 0x11c2238ec9348aa11d6b59763Fafdbea15b2bc84324daf3d4d781bf9f8b9371a67da089b93f81d6c8dfbdf1454b8af708815964277dc407F42e30c3834fd735d0e85d2387bb0d) (F 0x07872ba50d77a7f037d308bdc18a5b9f38e7f1cc937d105cfc8eff5219c3d6d638c773d44503ef2a18e667c4f433b5469024880630df34e431510b1b958203e21b3cda753d6ccb7)
  , NZ (F 0x4bf3b063c8d54be9453710b5036c8fa60de0cfcdc7adbda15ce5a276e4f671479faa1e41c5815caa06ee5d48bcbb4c96d2e9334f6f085a11d511a45cf3007b15d7b3b71ffda1ae6) (F 0x012205d31cb6b361060bf361c4fb036291314d02adf00a73ede41159910c1c8c654b0984c800e5eda2d1a99733583df87f501d8e0F51647e00dc62aFe533dedc2afc42f10d40c)
  , NZ (F 0x44e97b0b5023eeb3b3048f6353ddd953f9c12d32a5712d901d21104285f3707a60c35aacf0d863efd3bc5d0f59863e461fb7c6ea1c6b6c9bdb5e4dbdc6b9f43627fdd4f78d95ab0) (F 0x5720f90b42530f1be05077d825c9441c982e2ab0468408bfc9bc7e5f4d84f7ed7507310dcadf76e7b3bb24833cb4ef3c5652dd2bcd88e5040e8c1a97951accd49bd6502bf0901f0)
  , NZ (F 0x7856987ccfbed5e00cc490eeb15159d0fbc3aee0ef25c1a43d69b1c62413275c79a20a26cce9eb08167bd207912aa8417230692976b2fc3ff9f287d69183085cfb27c9a988a31f4) (F 0x737b6a64a08Fff264dfde7c3edf122548cfb62942c38402c4504a95779cc4c747545d9ecc552b011e79daa1d09370b9a420523b63bca0a62dae7caa386cea13b8fab4f44b49f1d)
  , NZ (F 0x6783a6b938ee0550944c1eF8cb83ae8155f9cea72df482cf5205eab1a1a8d5bff78b4f9e16cad8eacFf95e3f7df96f993991a19974e9ce916ef21b74e292f8c751f6d320c28f6) (F 0x606a546376d1dac27e56cb1a35e893be569d2df7e50289eedb36888146a6cfaa341c712042bb064ca66252287248ccb186bcfb4c8717ff22781efa5192dbc8cbe6faccac780fb3d)
  , NZ (F 0x792b51a70f4e455d16df41933793649ab1fb9115a620d9194e0bde1c49f4e73b2be34069b6381cf0a32d9e7a49e8a9b54688063caF7f49a6123609bcf8571394cb95c5345bdf85) (F 0x4af476d42021943813f469a3ebaeaa55649b6af32282b7b7cbf88f0ee3cd68be3c69eb5718e54e65f799f99e7aa99eb9d5c9e4b2021dbbf161ecd92e2c321921a476aac0cf6f5d8)
  , NZ (F 0x350372a65c3df3056b12a719d18f97cc73af72f1226f51134578834455354cfc65c29aa04aeb8e77c30e74f21f75301126229c06a9f872939a54b693fb626dbdf0fcdFdb394da4) (F 0x0006042d5d714f59ac7489f17a455d250bc7bccc6c6b913f6004128964228eccdac87558d3d7879882fd6d85348cd8374a06790535f2344e3d22c7af54098244f5ca6065312e52e)
  , NZ (F 0x7e5901b97f1d18a2af0b748aacc381afb181e7c900922194a7435baf32475e1bd4d7b238Fb7eaf2e06ac8bc296df62fb0d081b93662b648081e0089e36668b3ac9da8c9a809118) (F 0x5185f348708462cc67b76e35cee61c611d00bb9898ebd3f84f81dbbb8d57ab9053c9f1be7596b676695007bf4f3c50cbaf6728d6ee450a7b21710a3abae38d52584225bd0b2f979)
  , NZ (F 0x781b476fa3880368b883b37f045654b880ef70cf3316da40d9d7a2089ee37b03bfd14cbbcceb0c3f83797d7468e47d5737ffffa847af09165276513568eedcec3d4c7752a428344) (F 0x4c37e5835b8a1580f82ba115bf5436d28e324cc2dc5b01ca67d51497217a4ae6c1a1e0ca38953da3965fb905aa9c9aed9da9cb1e38bace7c6c34dafd0F7de8216ad36c8b56c291)
  , NZ (F 0x030a9fd1e4b6a6825dd5a54b9c57dbf6eab13b644bce095d1bd823a964130c826aa3b8f99bbdad3d4c90a0da9b9a46abcbee912680c0ad82ec940616Fe30080d5682ac44b0b155) (F 0x4426c675f4eda4f2df0990f0d847cbd5933e6ff0cce272d36b9fbf142f98903cb450d8595c1af214bb27f8a27d8340efab15ddc8863aFcc986942dc05c3ab891fb45b645547cda)
  , NZ (F 0x35ae3d8227d2f74114c219e233e0f6511b8574f2266f6153a4744f7b85a99659013cf100623f9c2e68a53f0289995b9c8e77c0412c3791d95750b32d8F1401806c928a3faea4d9) (F 0x51dd701e3fdbbfff370e48c5aac26f3315fab97fa516f502c2231f16a28a77a2328e603498a071fc30158cef0b220e0fa40f5b16d6b75e11ca6443824b2a0d3403d20144641d862)
  , NZ (F 0x1056ec4552fdbbb27707c742cdde4007f3983a860ce1591236569acd42d1d71d1a7aa2cabc0491ff86728ca61f77bd0171e61366ce70bd51c4d299ac0956fddF6144d10f5d67cd) (F 0x496b28bf3564c0d4fa1ce1750a91ea37bebc228f1cf13c30bad2ba7de0fb18f50aef7126c097f1467dc904c7cd5b189ec5a9c73b69c7579d05f0658cd68dc7d9f9c4e133f55696c)
  , NZ (F 0x798f9b23b5c455a492f7dd76e182ca2d35bf67192c2b84a0f4aef2d507bF4d41491245771e8cacc08950ff6d391a9bd92c3a2e517fc3ae0097584f2f8aF6d843e804cd313cad4) (F 0x3a387f0f903024f7c4dec77cba75306d3ddade2327be81795f6f89399fbcc1f7e05903f0f3e50af9c86a8de9631ca0765b684cd6bb0a6575c5ae9af2ec156e5cf258e0f7050744d)
  , NZ (F 0x71df6048d286c20dee73d0152ecc63170391b6303bd962d1254fce7468269d27b4469521f4275f5568a88978489d1784caf88fb6a87b64dd25a034176a17d84992c49248266de1c) (F 0x14b4f041197e9462f1b2b16F91b3df561db55fa350d3841c8ff9a7cf936e87e00a1b30651758a689336e830a7e493eFc666Faec9ce45219668d3dcbc20d8192815289d923605)
  , NZ (F 0x4e1224e58a1282a0d542b9bd5208066a06f36a69e74a7a0323d284a73ed5a5c61c690197ffb5703f71167381f7F368ff692404abadeed4547080130d0287d8fb8126c57ca8c98b) (F 0x79efa4e5bc0fbbc518b01d3e42afd05507512b83df6e3d5e68e75df848b40472a930b0317b8e7e501f1021F2e166c7d5a928be68e52e8de779969d6004abf423e00e386f7e97c5)
  , NZ (F 0x7821f6bea5f7a4f6978c831141070b6ef7a83aa0b85884ed4cc5ace2a81d7713fb590d962e03b89b07bb938f10c4e79140545fbbd72e7c81c16f02fa3ab09e2a025ffb57cd4a7f7) (F 0x31ff04906fab37aeb503ddfa0c79dd2845137d22bd245449b68460cae6259803904f934eaa2833ad906ec3a7f65a10137f994c6ebbb9b26a9d620016d8676f83679e3fc3a1569a3)
  , NZ (F 0x7276937fba7d0a3e382519ffb5b6d3c5d83c290c0cb15ef83ed6387dFb979e9ed7a3ea4cdccb3e53087ea8d8bf9f230084f3a785de22221d6d98c46878594639501f3a44ae6617) (F 0x48a09974297cae8554ada22f384b51da75b81add433d2caf0c106f84199087a6d2c16f546998588ebf4896d01350f67cceb24f2d5cf571bde5ab015c18e60ca4db643fbb552a717)
  , NZ (F 0x637754993878806724e59392ce7F1e2dc50af344635b51423bbc09ca123089cbbc167b2dc1d1440d15dea4605062484c19114c9e146256e5b679ee5da9502f1dda662ab0bd46d1) (F 0x2149e5bc5435758f39f35d809fa03a4743ec62061f91e6412e392a56ca35298e32571953f12d2859629e59beFacc025a440d2a74832b0f605cb466d5d6ce27d2c7cf242Fdd8d0)
  , NZ (F 0x37fdb8d62aaa6319eafd07d235d49f6b37768dd9f5c908ec3290a2352c22e11b6e90ba94bcd78Fadc6580c2026e5163ca197026a55523530d720cb6482c12025c21d6a420250a7) (F 0x25f9bfd4d3645de7cd9aeeefa8a5842ebbc36c938d908ed54794ffd80b0e0f2db081074541b9499eab478ff01c14ec78cc166e9df31207f7c65e6aac3dcc7c11b6a8357facfc462)
  , NZ (F 0x57b62efa507593a0e97d0943c0a2d823d1cedcefdb10d4e1f8247Fccc5ed9625d6ee543c28ae941f19df7fd225eb0413386431953c3bf5c0d66c057cb7371F36da539a3d453d0) (F 0x2F82735c76399a6a9fb477c1c580cf0dc25233e3ec11072d1d18a6da9699528b59333271dc3f45893678b16020f209907ff2f3ab497dc1523687c1d2e7a30c9b515a62b4d6c5cf)
  , NZ (F 0x125b0a5a4b7e8f2608efaafc560a1ae5e030040db670ac81becb2bda4dc57781ad9fa65a566de587c8f293c65bf6f98c9cead2073f84079384305aed0de8fd3d90b886d1ea4be7b) (F 0x073d2361cb6a0051fcab6dbdf0a5b92540071a57c643a10277f95f4374c797f0d79b12b0e9175621a123086a0a8d03e173661c1c0d2d5f1cc081654a99ae10965dd7dd07b1f3ea4)
  , NZ (F 0x5Fcb4de303a636fa7f96b32799cacd3943da5581262469a817b8ce3e6072e64e500360d9f45a7d7cb176b96f3214b65e81ff25abe9c29f897f40918b164646b2767ddf7da3c758) (F 0x44bf90bd280f29ec281b60d09d13c22f1987e777558aa474e1ea85da214464a4F6b8ac809509c86d2e3d2d33e6d7e9ac442c3e6fc9b745f79a35c01ec8e0b9355d48e6a6b9827f)
  , NZ (F 0x61b42c569bdd2f5a41256a64ab6a3bc36a58dd13292e5514fcb7a8b2e390214df876212724ef735ac35089b458d1fcac984cf38ed2eb5f46f65ca7c035859a76829eda2df0879a3) (F 0x64f3c0e7c42eb219b8cad63389c45992bde7215ad8411163a5e936c109ee2b130f2f6fc616e81d6d89e8c1d9e69d7b76d1f7acac1bb5819fa5583e72109c65c500576632bbbed1f)
  , NZ (F 0x09bF975bf3a64bff4cfaf9bf978d0e53f6506602127931b239a3c6b8a88872ef8ef2af068aa9ba7544c1534a571fdd504d6f59cdc88dfb71c344a8ff81d56Fbf74ec4e38cc082) (F 0x66140b9fbedf560bd098a4329a114f0c45fd076a2f2cdaa5a020099bF2b0106b202f01a8773cd3da682d0232c2bd6f13cd1e8a559490a6d6758e0a10649c53ac5e507b993ebf60)
  , NZ (F 0x237b21e5c8943400f158c7407bfa03342ca3644ee02ebd8818dadf96ca961dcbd7d32b377a816bf7f6b24f16b76a80345ce9a296bF67ba961335b67caa2eF9f14a0ce2730653f) (F 0x03876c591b05a44c39994010567b924d29afbb9c31adc060fa1642a5fd294ed323d574b746011eb0f490e6a8175d0c8c329a8e652d2af7140e78c2b1cf699c054e710c1664f94b3)
  , NZ (F 0x2bcdd69de218d8d4e9ebbbaf1080149b02d0F64f7f16217c08d6235f5194c4dfca2ddb497f983f85b50ddbb23a71b4282062e7bcd165b3dda2345103efd07dcca649841a647F0) (F 0x1f57d7f2a8b3ad7e3f4f7a06aa11315cc5775e0f971c1b2f8ff9184fc24860253065f82377ca4f5ee02beb3991cefdaa7132ce63f5d221f88490198b0F8082375a04269a4a4a5c)
  , NZ (F 0x16027c7493b1330ff9e4a198b6842154a594063fa56d008f1b1509471784aa5ac1d3d9cdcc0e25decc5a0eaa203e917ab87a440c4015fa999c19c3f1ea63e0b5cc59e9bbb75823d) (F 0x252f5d7381845b0113134e92edaf036f6a52c83465819cb34a26389437d60f8b43d09a6f3fcae6573e1345c226f9031c864b64931dd759b41dda10e3c0d2971c0bfb2adf898ff56)
  , NZ (F 0x3d51b0182eeeb61ab94c0d99b3e5b9cf77db47ed83741490c64053ae9360f9173191cc7bac55cfb08e4034d0cd5e68b4be51a3a0be03625aba862400968eb8f6ff7f276087a6c80) (F 0x39f2588e130b113a4f6793109badb16709d2c540fbaf56e0d7be27befd9c42b74f8fdf8bae011d2a36bc93c3c8c295b07cdedcfa37887298de9d7217179989e59a737e3e2bc23f0)
  , NZ (F 0x45bdec38f3ee2850f591628e79422abad2326a5c3fa8da5c635e68c1c218299d129253e8759523adae06c2442bd4b4ff1a8816f4babd73f172c767c47bf66d0edc037466fcaa93e) (F 0x782341a1acf611583e27c83a9418ca9dc03bb5d8e7c0facf13f8a9227504eb23b617502f8cbb9042a7bac46701ddecc2e7530d086df75d82596c3b42e4190414ea7b71d125b7247)
  , NZ (F 0x143ba435cfb725a0198542e7c106e1ece6ba678fae0e31822b26a4e4bcfaec21a4e5a476e9f7a1ac1bfdae393147674ebe069983f5bbfd7f829f9110754e5693b330a5166960274) (F 0x152552bd336075949de4abbb5b517190bb7af62ff24568c02257567536618f5458f0798f74a3d3998e81642d6efa7d3a0001b5abf633a64b03715ee749551924e0b74f26c93d334)
  , NZ (F 0x3f8cc155a8251d78b2d12ac5e0a4df878fb7cb59c2c6cccb17599ab7e857fc48c12a3680344c7f269ec0a45e504e12d7236bafa473415c4c4b8c333Fc53d892fc54689e27835e4) (F 0x6633e74e9d8a700ab0b5b4700c2006561d98e245a25301b13d47ba453eb733409da02b022d5c0360a77507b3e2a77ba37dfc78e895be6b551697cda363aF56ace1c771ca2e1c19)
  , NZ (F 0x4e9d070639600319c5ec10b86daeb205677ec2877836ef62d7fb82b5316d816f2897e142165606bf6fd5122c40c701ff3d001ff1af6888d60525298a9d460d23e55c547abc75161) (F 0x5c1334c7849e604c423e0d50caedd53697aef0d90f6c272a6cbde7f1ca155222ec466e4c5df7015514d473419c40684735702578218ee5a1f622cbb46727fdc94c08903dc448399)
  , NZ (F 0x43e32ca45c5904ccb9dbe93cd19a9a02a869701f61F3ea6aa1d56cdb36eac1601f9c630b1e8e2f457b3fb1bdd210db05f577c73dd8fc9831353f3697de7534de05acb1962b8eca) (F 0x52bba7591156fcae4df8175966b317c49711d3b9d4064104038779814668bff9e6c5dfb2d4a2200b2f4dfcd7816dc9b40057f520a1b7058f55c296663fa332b36b8245a7c514bd8)
  , NZ (F 0x3dee000784d12f0d8fc23553acfba510d1a6b88e02fae1c2fbdf63e38911a8acef8b360b013b628549365c5307962f854a048567f6cd3f284ebfcb68dabc95d8a268b24d543cb79) (F 0x11e3e4d0a1f9149d04f82c5b469d7d1f9d4bd0776537857875ca3a5d534d2c3dc4e1e804948a80bf08019152d7e0534847d75ac366fdcbe89df75108c41dfdb29d9f2f3ea6aba86)
  , NZ (F 0x7c9fff7c2f6cbb152e7092e63a28d32892868952b70d36f0fd07372ce64286b2b997f5b8616bd9b9b609502c8c29a77701d945e2ce2c9f5cceb3b15d97749f8f0668c82c0fa79fc) (F 0x2b17078abc1c7892114a46f9fc8cd0168f5623e07e2cda7af1bc6175903dec78d7d685eb847ae8798cb04f132b5397957b0d5142ed58357bc90c36987946d07b800035bd860accb)
  , NZ (F 0x653451de7ede21ef490670a0861b79b4c49a40cbb4d976c73bf474e53e2974eb4f13a56ae5eef077b24ea08ed1f77ba53151ce770c05689c0f5a11eb74bf132cf4424ce56018379) (F 0x778ec39a4d2f16092b6a28bfd660ced9f31b1c28a9f00b99cd6c8b4ae75a958fca2d84b3f2861ccc00ee4ddead4051230d4154f35ffcf84cbcb86150f6fa7b3acf2e366ff2c1878)
  , NZ (F 0x28cb1e3ecc00f03c2938833f19b187682091d8a3b02092bb480d9b406b88582e754c7773e228b50a5460e522235eac98f8a64a7b0cafb2307a06c2d9722360f8684171d006d2a50) (F 0x68d4fc138223f4Fa28b85beba48909c6a7a4ec3243268d76497ed6efa19b316d52c5a39ca0faf72bbb633382281daa9f5af443084e15d824d40fc39781492390b19525840edca8)
  , NZ (F 0x161e3050562b777ebb7fb688f53459753c094cc71c181d8ab5254a973f0007be9bcc7a2b002de54b60ddc682cead6e973aa48f0a0c4f08bdc7d5ecdee63b767bd635ef82b0d78c5) (F 0x5501e156c9bd68a3d7737d9af2cd7055a77f2705eb172b29dd45a9b3d51b1d12742656ee45f895f113c0c5e08e9926cce92ebcb6091a2c54cde5ebd32958a50c14c1a08157b69a6)
  , NZ (F 0x2524296429dd09a84cf29e00668bbe0a1ba4a0c8F39e4291b33dd77c84682e1b55d8728169458a226a8430ab995dd74ce940e55db50cf4eccf217d784dc2404a8b262489935b63) (F 0x1566b9d5d6b54d53120b07c23756083f814c60166232552bebc64e9723eec5e46a3acf9051231159cb1098028f483277b3c6447e93cdceb19656113308ad7801a7a3468ca7e7351)
  , NZ (F 0x5f676ed937b1d677997e431622988f4dbb2b2ae70a99837dcb7470043ae639c7858cfcf4dbbdd8e3b4a15eebcd5d14886579ec009a1665c33a22a3ff23d450e80dc0b1e7b6fc416) (F 0x3db38c083afd8676e52586c7ad3a600b80ccb8f2d6a4724991278df3b92979558bece50321cb8500a9b4e1c02b231ddb35d711937ef1e0d53b2bf8d0e1d536bac4334555a1e5f33)
  , NZ (F 0x2c47e9b5ac9e35d2da0301b29c516701d12ab3b52aae62c4adb23ba13981e09c01428463f68c3affb8258067ab28fb0517acbe72da093d843e186810261697907ad2a464cc2d564) (F 0x1e2a794420206609ea5fdde9e0b4be52413d861da588f1eefb18229399a79fae6ab4f49eb2e2e25c6d02cfdc2fdc3aa770925f4b03a66a541764016f0507821dc995b4ac6613658)
  , NZ (F 0x09f6485Fcefa6b7bb4ba5d3663135efc619ad3d810777e5d0c54f31f2858edbcb54a2d6783f640ddb9b89af343c2bc093a0e3c6576658963a91826b53a94ef0a10702c4b148318) (F 0x72aa0ed66efdbfa2811a88b25d2ea81a78ebd996759e471126487753b4e060abc2dbeb24ea2dcdbec3a148c651004a88f029bf7a11fcefcc3361d5693edfc95bdf43Fb5d67b4f4)
  , NZ (F 0x1daced59e95b88b862da99941095060f7ea7d77f5582aa52c4caf259d948bead113d217739341f42478e20d306ee798bd401b25b6a5f516ffbbd77d69ca42ccab873ffdd4c2756c) (F 0x0fd199301ba85dcc2dc04667cf977ebae4632c880fba072d7d62383750a36e9cd54be712a3763d670eb2175a002F51e2aea3973a72d5f7e2e10104dffa29969b6eb6eb3d73760f)
  , NZ (F 0x3f048a7862bc0a8a6f3ef30e625eb08babc1056940261cd07111fbeFa8f7e0a183de2420d12ccd5b829e766b4d3ad40eeaf63cd2a5b0841ab10a3e376f83221dca054430383a66) (F 0x3201d3be301655504c5db0b778ab53ae7a318f49c09281e011a390e01cc64c5F44fdcbbf224807954424445f63806c5649fc3572a737bee8ec1a404e7dc4f1d2f8e3cf152da45d)
  , NZ (F 0x7f83e103bfc4a65c93866333d11b9b5c0a741d92d145323aebc01c21d09f39993aa4959a4fc16901ebec218ba13a5f036ac0a7d982d1f93F2e22b749a2f9321f4706c399d537ce) (F 0x112bd10caf88f3c9704e471ae79f9842832ccf0541d403196c6234abb78d04123b367a30822e75f3b866c59fc291fff123b5964352199e9b71b9c6f61ded85a1130359bed8467c5)
  , NZ (F 0x50baa197ef799a1a7c5a6f1a0f986ef980dafdc4371dea72dbb445cb0e423e109228aeab285cad460e44be193fb80cc0e2379d79754906559f62df279f7f01a996a770a494e03b8) (F 0x088245a3854eb650217b214e9ecef59181a1214f3b0d13361370adbc376a48d30c3ff51244f488694746729cd88fd325f7d24c69fc3194dd6ce5e4038842854ff7580fdea3d177a)
  , NZ (F 0x0b8176664a1bba03a9a2f6c5d5978dd349169715f8074387ab813cbb8e8b3fa583c542f0c41b84c4f282a91182abef7cdd7b755ce107a76ab644f9a6a24eb5f36b1093d28de0979) (F 0x72f972f4ce417e9dcdabe29850ab622359a34e5a5e72af336924e695d2e9429a0889160bde705c1f29d80cf979658696e59796becd1513c29651e67d4523a5ad60605d7ab42324a)
  , NZ (F 0x67ac57b949dc455d8a60c2b02cd56c7f05429d1ab010edbc80ed467492c606c15fd76b9a18e823719227dd81eb2d8af387198eb4652dbdc758f342f156ae35ec247c59de3894671) (F 0x19755e7be281c056e52f435eee30b86cf750311c63dd4dd7c9f00806ac769d0f223c7bc7e7e3fdf1edb7eb8715e95e65ced7915d523d6010c57fa3ee85a4746d7a36016564a6108)
  , NZ (F 0x34452253804d272516b68e0801dc1b689b03d32ef9e8459f2c06b2319007135c644c8d57c937e46c0a45701ed169750a1d39d36566fbf6ef880746040f8a04be2015581cb6dac7c) (F 0x254358cabbe27da1d90367b0e03b21935ebc4de5e84963ab392f3b6ad5b1d7820b0484bb35756b349f4067361c554086b84225ce5cb3ab86ea5878d77ab3264b460eac290d77ec6)
  , NZ (F 0x45410ac01618704b9058ce4b78f2023d63c4a2372aa69313b77c5533ae5ee8de5207c5880bf061109275c4d5f8177ebb52bca7c53d8f6a33e19ec1405275cf35686a29af70aaead) (F 0x4c6387829290bc7aaafc74bf50432c9cd5fd6d9b197d7c63d75e2e54f7cd67fb6084e0e0147cc95e12ed2e3e14ec27adfccf79c65faf5a03b18219d5fdc49b998780c9b51b78f82)
  , NZ (F 0x7dc826724ffdca793d1bec7c462e9a9c9b92901d458abf216333077f6d10a0e3915b7f08a05de8696a65283353a4a7ce9b424119778692c24094ca3efd6a5f10ec1a34efb6d425a) (F 0x0ce3d664fb66b023939b993b14bbf240eb8b2d5d8e8a8dc03ac628a190c49a50c6a20327efb0676afc77b17c610e4b7a11648037468babb9f403ff51f13d090abce02a16fdc567a)
  , NZ (F 0x479768755fdde08c1175799ca401d5cdfb8b60572256e03e99d2b02b31398f5e8ab4452e7fd851b86706a12325c7b319b680743941b412d63e698635d6a01032957d05eedbcc7bf) (F 0x734fda15c4e898b3c3160367486803dF93e233d850731193351d91ce5c4397b9F62a4a6e3b19107587ca2a4d79f49a344f660a8bbbb3932d30f51d82443c29d2635af7eb2577b)
  , NZ (F 0x6c9ab2d1fd9679742cef39e868c450a579d62d02b65449f5d0f0b71d2f54e8a25431e961222b51763bbdcab3aa04f2a862a7c99d28e9c14eb7f30dbb4f4b7249544900cc4967302) (F 0x1887b5515960a90ab8d0fbd7e38f10fd03b69f1aef580371c0b4e653e067662bd7f7d60be1cf8ab2c1e9c49ebd55e12f33f2c49f00416309572d49c2b83e92c292653ad02a635fb)
  , NZ (F 0x6f1b87e64c4417263a4a041b2772108c93787563948972e3dd60c68378ef9a278a5e44059c7152727608455085b17245b6272ee6e9efbaF6e240e18445853141707bbdd7a14cc6) (F 0x48a562cc2621409f599aa8c0659ea1ed5deed33e96424256d298f8bf1f5d9be6096e9ea16f8Fc8228835f69064290ac1403490638582e3016eef9a77037dfcf953b0e02fca91cb)
  , NZ (F 0x556f192acbf99c485c5d02146a7996c11d5a8f2c4b278a5ba98bd7b7e94303a275bf6cf516239c2b45a03b14495790aaf3c76616dab067fd17a1c5fcc66bcf91783e02b5caf45de) (F 0x0408645aa01fc6c0b7b8d08c194ac51d0ef2b9e4fc14163d2863440579428cdf5a794da9715184830fcbb62bad5ad6a5bcFbd7281b7cbfcbc9f6682e390975331f12ba482249af)
  , NZ (F 0x48d27aF37db0447b7a0acefd9c15caef8cec9753bf63ea4603fa1217f7e11fac7ec211651079f57854b40d73186111a7e17806abb9bf7e11d0a24cd2a618a35a866145511e4e0f) (F 0x6a2aeec0dfd14200742ff36a7210eed6472ddb092698bc527c365d1fc39955d39db028aef62abbb799e9ae89a1d6faf9b8a1b22ffb223Fe4b775f430eb8ccd3a98c78290e74f21)
  , NZ (F 0x75a9c657a91b1304bacef1c038f69882c6361a28F4125e11bf5ea5b342b014fbf6cbfc8e5365b8f7483a46c4849eaa58df1579e2602f8242469687c4186e6308aeec2511b7527f) (F 0x467adaab9ee578686cc89188255ced71c1c9bc6073ddf4777657f7348475e6ec6652c226d63a5d6588002c3e1e2576713c0b87ea14e1a6905aa00fbae368cc8b6f4a81381644505)
  , NZ (F 0x3dad0dc2c31a69d9affa16a24244610b27575bcdfae7ec692f9dbfd887543685ee2250cd6cf6ae129e62afa9a927c985cf338b91cc49f1d26653d2d35d4f340df580f0125ffc1d5) (F 0x0dcec85f02ab563dcd93f34c41b17317da35752b434e70b22675f8d85d519ab22a3f9a145294264f453dd157b557d90e61efd6285995f1ac99c0610b9d4716a58dd5fac50799738)
  , NZ (F 0x1d4c54a09ee13769ea4d28bd20ce01411377b4d505f9b4900d85f25070ad1bf29e517415e13155a6c50f26c6c215adc3b463639f9009713be137525c565547dcd0959519da6eaf1) (F 0x473c65e51c7db26fd2c3dfca21d9bacd55e0a2498a0d7cade67816e4913f2250c507301f611cfb091c41964630f86af7b0bd2fc53d577ec6381e9453aabaf5bcb1d8697c258e010)
  , NZ (F 0x43fad1be9ba195a35a123dc773f5267c6798ba5ac761e55677d690cbee095a71a78f10d2a9852c8c83cc3b369d09fa23109a727257bb595500dc8Fcbd154b8af647d9f630486c2) (F 0x38895c5e99ae2c151b039124239616500d21c1f3fba2349504e5020a8b1f3ee266c0b810f4f12005ddec147d1b72Fd2bdec755020563bb4bec9F6f6c7c485f6de1cc5446da2c8)
  , NZ (F 0x604c63c844dd1c9bf6fcefae418fb8f35077d304710a38c519b55d0564280df7e67da983f889713e8d4ca0748aff9F7212c4227aec1724cfa8a1bf47ec0ce79cb9f6552F037a2) (F 0x61a8124849189a09dd94ef821b7bcbc519ffc42b9114399886f8670946137495779F15a26fc9b15d71941980e064e2ebdf8c65e25fb98934f8e6575a37b5927a96f029f96fd544)
  , NZ (F 0x19d3bf0dee17b4142b3f734e4e579a355282576e1e77d68291a3f4c09bd2a5ff81976a427717dbd5ea550af9aaa362da2923763eb7b1990921bd3d2f8f46902807a6ba1713f9b97) (F 0x7c216ad491c85785065fb731218146c06aa862c81b15909ad29f5aFfd207816224fb94831b8a0d6217dba6a9bcad2a77dbcacb81ccdf4523739aec2cc31f3591ad876c85804826)
  , NZ (F 0x4e5860231a3f4b0bdc153e4f2ad8b1fFb86d6f484af7c83add6f6a1ef9e7175a8f744da2daf49F1388408a4660a4ab5137cab05c925dd40a51dabe9b23307880a7dae9a2f4e4d) (F 0x505f420569ba05a1486236f67417a0b100f69aee1335515ed971c321093ecb7a469b080c0e4ff311b4d4c6481b7f15a760e744adea7368f750b6817f2f314327a408055007de30f)
  , NZ (F 0x76e56aff6b42e74a40766b3bc132b45b39c22ad3323f5d69b4d647002c68d8a9265a4528b0b8529db285963341e8f3e337b61a46e2ed19c530a88def96970eb3f0e7174e292c5a5) (F 0x244f8c168c7c1d7c07a038e32b9cb9a7e06ef0cf4fc42c9ee6e8438255657c79200703283ed338961c1aea61b3f70d94a9b33811a066b139066e92f02445aFb13c73b9bc2da29a)
  , NZ (F 0x27772d2123c116c939f40ea5c6961c7b67dee138f3d027e0717ffb472292ae67fdabc1879e8186e95de1d413f31a27730509cd439851a38411773774b0b337474b32a7400c37c19) (F 0x4e1a7eb3e5b2e6375079d4953877a55e73a72c41f0d497e07b947e896177974c0b23998ee2b11fac81bc501b16df3274e8745a3acaa86a7cf645d947254aea7e5d5cb8325818f58)
  , NZ (F 0x1902180be990c70aec771caeb7eae2b8aca01eb3704433b77F5ee47ba70c53c4a153b6becf5802c0acaeeea55a1e19deacceb7c3eb96b5cd34F24e18e173dfc84b481b6aa7acd) (F 0x03ec933a09816f2ddfa744e2d2d483b2df3b68a503c19b3442b7f113dd7d32e04c9bdff7348b459f5817411ad70f6a64dd1d844c8393da2988f927339a482e0f429010a575d6af7)
  , NZ (F 0x455ddb601fabf4c6fc4ba1c9fb870abcd917d78c2e90Fa3f89d487e0ebe0156cdb9442b46dc9b1fdfd536aa41cead887f921403a224a1e35f83596120828a7f21a36a3fcb7fa27) (F 0x75040047ccf8a05169a6c32e812e78ff4841e4F15ce816d151328acfd69a89644c3f6e3ee258779dd869e9e8c6bb1f137606f9df9c45a3cf8040f94450d62890bf6683d091e602)
  , NZ (F 0x40c65063736cf70c4cfabc33b653ae466d6023317573a59f31dad1d3d8cf3da3939fdc203a3cb267ea1490ca65b7d8bf1adf4e55d6968a124884b31cb06b7526b970639f3cbffb1) (F 0x0a82bf7195ca56ed0931405e8c747a89fb562f5bf514f72af06931b7ee2517d96a97d0a5b5eef274956f29918bb76a4ac76415cF9fbaa2b0c5ad1bd49d1053da33c8d15c096be1)
  , NZ (F 0x4f6226c9303923f5614ae9517aa3c4cdd6bf52400ebe1da370ca36eb26948637765e17e6e307e1b3d6c351cab37ed25eb35507f945820248041349c6270c1273ae9d9698880bde6) (F 0x6b0612d55f498401ed6efa829b4d9b816aF76cc665c3ee2184dca487f0226aa4d1809cbddf6a10f344b948d334a4e3b35566ffd64b33be6ffc6081158ad0c08f03484ff6bc3059)
  , NZ (F 0x0c694bd7c253e75f37e613e8e1a3a2ad9f7587d7bf12626e6cd600c388198003e8a5ff8a441aa95b88c6ceedb9f3dafdf2a3cec2dfbc675b6fad96986b2ceaac43bc3b0d934c042) (F 0x008d2cf2d3acdb227fd08a8636a0bbefae2ceF064d836fbfd258e1cbcd74ef0e89F4d9263F78dec8904b7381a2ac00de0a81f21c4a048a1233f323a928256d768f99239582d8)
  , NZ (F 0x269fd561a967a2b955ba206338d4d85173bd518a14d8870ea1bf886592b3a9336e50a3e1c08ca019a4e1887aca76ef2d28cf89ebf3c464732f6534290eac58e01f75e262a784d6e) (F 0x6441f717e3d606a5498962a015bef453e11f1457c1e610172dd0aece71b2ff134719ec41457b3715654e7b617c9601829526b02811ec0d05ca0d242bde2d5943173ba4aa73426c2)
  , NZ (F 0x5a6b0a9c20406ac4b605ec983446e7fa49d464a36f5df210f71f1ad86232aa54589ead2F529f5a44ec7ed68bd30d87f8875d6b8c78F93174245d9f6d816ac106fa30661cfc48a) (F 0x629f60ad346786c5dae6aff84e5ded7cfa142250b6462b0559c4beaa243402b39ca439dded754c277b6f21884ada82f4ebaedbf8164f8a106345a84a1e5867669b2aa856a8a8f93)
  , NZ (F 0x5c780314dce5e59416049521f83774d91de73cc1de007834e712698d019b4b703c135cec5053af8f8796eecb2f36a46d16133496867443b6581d62aca7ecd44f6e0464d5e51abf2) (F 0x4d36cb65e9489091d4ccc38437c8da30234485918fb98cfdcbfcfccf59fd6817adb93c5e4e2842dbfbcf83233375c0f9f2d3173675002cbe9b343b5c52c9e042F532b0cef80497)
  , NZ (F 0x6bf4ba11eb988a2ce20326cb3b4fbfa817b901104c884ff07d32741c8462bd45dfb2dfc8d725b997dfde90e8fa8f47cf175330792400b9b5761b5a4556749e06af59160241b259d) (F 0x74ecf0bf19925a1b6ec206f534195259da7c7ee1e38f7584bf11ce0fd23e6e2c6cf0eb7415f7d1160998b312a508b99de99d926fbe1b16e04972b9429ca1b448458ed5c5ae9c5a7)
  , NZ (F 0x5afcda26408f24a56c73b782c3f6cd10a05e47e6a7ed211614a3979b8ece27268f7091c0f10c3e95cbaff99e0f08caf653ee64d86f553b4efce17e1db8110cce6dcdcab4f6f7600) (F 0x0c72def26bbbe7b31fbc06b877bc5551d893d53bcacce8457918c94c81352Fc9cc0cce3963c3bbe59cabefa65b21daf53966af16a94c7d213367a3e0c931ef37869cf6dd21ada7)
  , NZ (F 0x054990acddee5b33b22bcaaa10149b6d72f32103591c9b33e2cd0cd0c364928b4b5efb2e096b8f35ff6019627716e9a6e553b05cb8e1563d8ebc4823ad1d0cdcc07cd9b22f8d753) (F 0x72ad4c8b467c1df0c4494831eb66d70845ce37fFf20d71011018dbb164a6f3da71b11080099fb0589d77036bb9e103f142b5e7ef155b71350bfa0ef5a2a84880d1afbf7ea658bd)
  , NZ (F 0x0f0457ef39ba92e38a00acd2ff925f2b05ede4ef0596cb9ab8197fa3b3d405fa382197723f4d871cbb654c820d4db668e820a00e7b9a5976b2bc505fc76170f0415c7aa8c920561) (F 0x5c73027aad719a0af1f54b46605bfc4b1e3330c49d1f78fb77f9cbdca4d67be8d41091cd1ef46e15cbd7f963f5b606f7612953a7be6c5fcaa91bfccf3a1b8bdee282b5894285de2)
  , NZ (F 0x38504fa99c7ed74521a09257145db1846487e4ad2f8aec99dc490d8393a5d278ae2a4363def022b646da0f832d1dadecaa114b06c3f654c9b37979fa63b2d8864195fa6bd8419e8) (F 0x7f7c3d45F423fcecf59ee2e77abab4291cc1e1e9414c9617881862c01c3e85a363e8d1cf966fc5de1cb1912d296d2057b236220879dbc35e601a0795ceab56cb91e339c60cae9f)
  , NZ (F 0x5f2761d352ae497Fbf49334944af8fF99a5c6eaca618e400c79827aae98d5512f9a3438121d475acbbe5408423f2a10ce37d53e849069027c230c7c5cba19b30af7e11df11f12) (F 0x566c840460bd1568871d7364ab9b96dfa7a9193d9da692bb3a7987267b36d9ff4de717f365b22c1116bd35d166f159f613371645c9de16d4d86d491a4915d9c2605d2226923622f)
  , NZ (F 0x71038f9cdb113b84ae4282fff461a9fa2b21f4c0a23a6503dceef187ddfc8fc50c171ed8313b74de81b988f0c75eafa987aa5640932a56ba207663789780f5a4d8d2f14eae8efac) (F 0x0473bcc49c6Fe6f9f9fbfc883483153552Fd9fc962a1f324817b18961f7fde81c622abb358c21b782740292a2b90c05dd4ea0029a90626462c84311c9562ec82da09be2f9abbe)
  , NZ (F 0x58f8cf29fda61b8da53f64e6cfdd5923F477e5b9baddded4682f176146f7d9bfacfba99886fb9ab84d9ea7226e441d2a1a6292bc7b66a33af212e6bc9b1ddddd51afaf6b0dded2) (F 0x1cc5375fd8b6d8b0a4939d1dbe036d0e8da5Fc54a0b8527c6836172039ddc0062bce2d701f89a304fcdb9b3a87948f29ae2ffF972eb28db2ba49ce4f8e9efbe4a801a22ee64f1)
  , NZ (F 0x3e04de865c35264b1ca5bdc5a5492e9e3f43fbedb6ffda353d3a4f5a59433e0665b5d330aabe5d419b936b3c58db50b2f5c28ed8e21fb7cf4cceeb57d974a28de60b5bdcac81824) (F 0x7068c65b5c8dee3983f06f61cc81709bfa1e40Fd0696a3bd37376eb2ae900be41f308b7103e6e625437db89a9820bedd1a9cf5857c7274a38994e85139c70fcc7b7c206df50bb3)
  , NZ (F 0x0b7e74df6144045b9fdb1cb993094d7c05b85db04d3a69d4d280bc9923e7f435566ac3a6308c18c1340e254f8F3eebafc85d14c870b0ca20294eae1c7329c8a76427b847cc7536) (F 0x3da4446b7482437f59e1f476488487da43f9ad479c9ff6ccef6242724b2311c642583169a09fc5b9caf17ed1473ee9b098262e3ae11f09444fc80b67f89717799733cbcd1b4a343)
  , NZ (F 0x3eaac2995465bd7e4e22b77f806a2228fc277c03bff28e8a0c59ea1085ddcc1a44260a2e502855d242413e6bb2c098bda868149422aaf5916f74020bad2b8413413861658bd53e1) (F 0x0cd912f35d6d906fd91482d51ade5d6844b805fae77f647c97d09352e22fb0be9f1ce0e563e32a3475ffd7ae7172c4933ebade804c2c761de63290edbccaed466583cFb635db69)
  , NZ (F 0x24a151d37bc46f1a2ae932adb923992d00f1bdebb1b99cf6913cbb7f78cf3565475493067a299fb1387ed3c3003b313cedb9fbc328edb990951df8110aa355bd30858700751d673) (F 0x0a34b330f667ea7ab9c7bde886507c4d9d77aeb647d72ee769cc8c4d8ad78dd3da2e37177a347ab73d4528aade38580e260b6e1F54fa95c32784dc108fb0aa3ccb136fb1bf02eb)
  , NZ (F 0x548a174af0717c7c9f50be69f0a91477e523cb59172a5a43267203da8b3e299523afa148e00a379b87d69b6a5c2f32d75e3b1007adeecf37c93161b8f868Fb2654b6b07ef83F7) (F 0x51e02aed5939c0bbb8ece3b3a8e6c4f4b862df72a3da859a9F14843a865b1838b2d2d2c550fba46ef303a2d829e5a0d14c3657f3802d63abf364452aa8c8ea1018d29dc8f04227)
  , NZ (F 0x3836933e0024faee431f7b7c077bdc47c3a2a554ea43fab917a12f9e8489365aa1211c44f721ca63628d41022f929f577341729567f414fd0f0b21446e572b2bb47faef190580dd) (F 0x0cb8bde755f378e400a0879c331b1eba207503Fb506ac67f487e8e795d916835a8e34d427a97635da77378b74e90d1e59ca365a44137b70eb7e74c0395bd3f74f26855a45d250e)
  , NZ (F 0x30cf5d3dcbd150c44bd18857abe9b67c51490b3745402beb4deb272cbd9835aa1a2e2c7085cc89ff344d621e9b1b56c66cdac2159a7a3075b87e5f388ed7401a6c405e96c207762) (F 0x2b8aFd5cccd96117f3d15a72efa8c26934890069414cc3dedeb19a76468762195b257d67c6bea4600fcdbb23a32cd8085f032aa60989ce398240b8eeafa23fb4135a03c26826a4)
  , NZ (F 0x3bf1bc37362579c1eb1eb01f683b629c611591fc2e110ccf0de90382079a385b890f1ce95eba4f653a243972ded83d5d06662adcac7eddbc021607bc1d374a775719d9a2e3ae029) (F 0x06f09f3e7508fc7c0b604cf53a917ecfc57d9c7cfafd0166ce6f878a7ad4c26c622edf24a99c1b3021563828ad3291b038affddc10adc0e1ca246ea64af7525d8b234d6385ce77c)
  , NZ (F 0x29f520ab7090aF4c6f3497eca8079d39d0b2b0062bac8640045f28174460cd68d9ede67eFc412e20d172955201d6423f48a4645493a1edfa1b59db06c231031c21692747ba9f5) (F 0x23ce14d0af1b9e595a2727eccbce7eff6abf4cbe4eb7eca5cee43240abdea5595db6ea734d710880a726ca16d7e25c02ee6501eeed3d7274aaee4ca1acbb6df6990589df9c4e7b5)
  , NZ (F 0x72d444c865d0ef8d9d0d509186f69610e9ad6080b7c767c097d661111a9054cbfb1ddab755830502799199a9a5d285bc90c8865b531c2c8b2194585f5ab0d80ef12c74d4dd8efbe) (F 0x3d402f832da6a6170F6350199d0f29906de6d64b9c78fcc588d91a7ec8658dbdff6310038f7c876c806517877da95484b264f271061377Fb1e152690d0625a0e3d53d9c2e72a2)
  , NZ (F 0x712a46dbac00d73a7b5e3d42fca8ad300365792d54c36f5d741ab13ae0fd077e98b47a54901d5b99a754787d4122abffa6941fb9afd9175bab2fbf9fdae3f69ea33a01c6eb98b5f) (F 0x74388aa3677e52a3a1ddd52aa6fa1e2dffb0404e16e06cb92e00113b265ec5ed223de5ae920988b9c579bbf6587dd819097f45c9d8954158125241a3e668d4be62b8775067e239b)
  , NZ (F 0x0b870cba76b024484744a3ec3c9ed63b60bae4a4c5715a92d19dcc4b90b881989971184aea78a7e3243d8bf576061b21aa6f8300f6d18373c4c98eddc0e2b7379a5577ce3a5f1ff) (F 0x7af7b1382dd4361ab121daF2a80bfafc9800827039bea18013be0b332358094b17cee9b1c87a18330ac164205da81b218ee730b96a762b84cbc9fcf6c620F76d08145d0c8c619)
  , NZ (F 0x415179113efafc7cb404eda551d53f9a97c3778936613e5411d2afd85d3f9be196e71a95666854ea544a219d0418ecFe4d29e1e9805e7fc8e7f9ade14abd4b632a798808bd8063) (F 0x2f8b08afa52b6874e943d83e614f46a9d980acb1f10bdd03e227a5ac8a90c8857ac8f888999681dd8b756728dcdffabb8147b4eaa2822126ecc22451ee02989de9289b2a6c5Fea)
  , NZ (F 0x62ce457ca5d6b78b32f315c700b3af895bea3093487c21880d532314748362495af2274dcf13d461225e86ad4f9afc36cc08256bf5aae01ad70db836f603a2c3e13cdea87d0bb7a) (F 0x350f118f83f53ef392d4269e64423e32c8135d11922454a49ecf19af0a904ac04c558c38f459c9c03eeeb931b0a34b6386ebdb2472c77b0b271d7ce10e5b98c5b30b553aea36f7c)
  , NZ (F 0x34ea41d780118edcceda032fba9ba82ea0b090b69bc95a2de82d58b11d21db1cabd8625b1535e95fc3585b5a1aaf41d713daa51576f7dbe8ceff34cb047c15e2b50bac0d7844149) (F 0x4e5b9c3223fd95472f633452e5dc8d7ff0988596be2415439913e05b620ed3e296441ba457b094a27a3fa0d650ef46c8d6fcf7d18e83ba5d198bd65aaacd62c4a939a2096922b38)
  , NZ (F 0x09faf972ced0c1ad8a296f940d037ca789ed9ecb9aeed29f9c8573ccf2eae2f423688f6f266693196c731bca9618f0b2d7b7c30eb226059cf5331495d5962fb61469fd46e619aba) (F 0x500e62021080806f82216c6d117f16210d02d69a5f8bbe88ce5db0aef462f36919549bae142a907aa1b3ab7a7ceddb7b44305aabe9d309b6d7854Fa3d1efc959e29134b1cead2d)
  , NZ (F 0x0283e4fbcbc90a0e9bc8c7811da21645ac34bdb615ae68dfb5a6554e092859791611c636f32bc01b3215edd11b454eb658932e14fc7f7c7d4206b2add141b7566FcbbF62a33ad) (F 0x253147c4fdc8329ec280fc2050a9a7ad71c2c5eabefa2559c59e5604d67da9732ba2543f443f9059bf84dca982a5d7dbae9ec45e47ae132aaaa3f2acf22a39e583F90e28c00756)
  , NZ (F 0x41df10b7b2fb3fa9d492c7b05a7c00ca1a2305b544c849933b6bc548bdc6c218fd69dc026829db2a769b13336192d88e5b59bc29b4f1abe6cd379f3df7376d2ff26ac71b498fac7) (F 0x1c145c827e1df3ad93220a2600c5de914613ebc330fde8ebaee364c5027b0bc33f2366467f35f203047a48ea662cb7e8caf5c1dac4a3b63e559830e82a9ae42bd5c20217a92efd9)
  , NZ (F 0x3c2fc07df3090bf85ffde0d3f3595528ed76803e5a3c86e5f745ff2171de8ea5ab0976f09a6bdb0a9e60684f16ba2b2d2df0a4b18400df4f6041700815032c9c96912c428520ce1) (F 0x38313d848494b1c30ad317b93734b11ecb3b3674ffa83afa11ef2433c903ddcdb86984c3882d70385c27f49374151c6eFed99677b630c94f1ff8f46a55b9eb888d914642a0cfd1)
  , NZ (F 0x52ffba37fac41d20f8eae991752584a6b62f996147ff689ee98ea3b6a2b83d131c2030b0dc303f14cc9e67599acd0fb267a70a350b57c1941ace5cce7337f4d5647a0e5b649cd18) (F 0x5f1a5aee6d188fb28cacceb32d93Fcf9fb741cad7298deca4b23c29098f7c340add95adcfc53e4736193792e37341a57b823621f8746938b501914f81332a2c57e40f690f57b0c)
  , NZ (F 0x714c7124744d9d7a782ad0547a14b6c528d516aee95aa8b13faef9a06f06754da33ecf1f2dc4b92c4aa301d24eF25b69fbdb197db2db4e08bFcead870e275b77281e99e8c944a) (F 0x4e8cd403f15c9927Fc33e18834bb15f0674f4F98ef7eed63dbf27e2657b7c7709ca44e0034bed705b98c5d628c483c67f57e0031ed557eef1884365eabd983d153a5613404d43)
  , NZ (F 0x414bebfb6bde8456a5422315e6de014861cb401548e6deb85210baa2c257b503304e0b635043316fb7b3a2946a79910f765e3f6f267955f8036a07fa972d5bab25c0f4165bd1069) (F 0x50d6e5bd23e5a19f59be0fc35839839d41924c09ce6ac83749eb0c222f05ef6ed14f1cbe02c8f00aa87e1ccd7b568db129d9571f07a2c5c47c79a34a291bb66b04bc05a3e6d8580)
  , NZ (F 0x045e02e941756d00c488785b3e80cb09dfbF1dd6715c7913770aa119367f1b437e3ee25dd522be28e89682698d6e4684bb3c67a1825734b36a6f9e65fb26a404c62549d1c3ad35) (F 0x065f87316e550069384a03329b43b77e5d3ee36245ed3a7ec939430c108c0e378aafcc3caca1927d118e239117c502adf2890baea7d6dbd58d8f6b062783c2e8f127c3e9cec44f9)
  , NZ (F 0x18edca28c3d9f0803a491831957f53a8d642602395b293b8486cd83a79f860bc2a3b4ddfdd2b733d7ccab0500e6eac43a47fc98d02deea874d67a7dd6a16cc730bbef7a2aab6cb2) (F 0x2adf3cd9f660f7fbbe620e0a44aa64425bFcd4eaa79764072f13e594652c480e1e5e4e8ded6930b9757a4f4Fb08bf506c5ec7ec797cb4673f01ea5391a044424081c03c730748)
  , NZ (F 0x3e05a6942de547cff75590e5d5880fdcc5bc49ae93bcb41df51efd50b9ee10031022461c1e153e451cd9a60460928437932b85d5c36e101919cb7bfbe267252785e1b151279f29c) (F 0x23a1463b962596b1955bac80c487294a42e4c340462be880538426dab1ba0aad117d84bebbd487c2cf4b5f02ce10db832dd23a40e8a864e092dbf08e3d68383fc115a72edda6297)
  , NZ (F 0x67253d0c5de87e4b5cbce31ae44bd9d9183c123ba013d51c3c4179408fc57f14aac478f1bb81fa6adbb0b4d99ddd58da3eba36b66eaf5cb9f09d685d0a20dd3565b121cb96f39ad) (F 0x136c059b5f57b8d7330d5c3def0e3f7c960caf98ec1d8F5eb0be401939144588c28e2c8a077efb16833271c13b1ac95cc7afbd5e93b816e21627e911703b6cd97f444e87adaa64)
  , NZ (F 0x157d2c314add68b3498a4921a077d1045be3110b928260426907f15ba0efc5f2ca33fde6a580a84f7e2be221b809734bcea726e41f18df1fb63491efbe8d657d2e3ba61b410340a) (F 0x25a9623bdf9c4794d86bd6d187fd948e221f13b89fd3d55f2dbcccf2cd901e024049fb28ae66c832a3dF1e178b729788b30948b13dd2b7daf073a8c7ea965575b45591219cd8f8)
  , NZ (F 0x576e54c9728db80444bbf803c8100d0857aF6e6bd8741cf0795b6cb1062b287213e6c3338d9b23cd7a744d45a1dee7a6c1ed3a1073a47eecd7bda4db93f75f7dce5d8396ce2b22) (F 0x1733c001154e9620c8c1add220021118b10ca9434053ab8c00a368f4ecef31da4767e6d0be2dc9af41c595b96d42b298c6c4b6e52c47db7a23c458fb21ee3c88794a61ad22fdcf4)
  , NZ (F 0x5d0a1b222ef2e79b58a0f29c6ce9991c0b9e933dc0ff75ff15359688e293f4cf6b2e5b631cf148Ff27c472a35524eeba91a2a2c3a3a2326f407a8c3555020b89a22e57ed400a59) (F 0x7ce452dd61c23b6e8ab3c2eec4d760095859cceac6e4a3a112fc577c4e2763a82961276ce9203bf3Ff263e514b58f511c18b1a9d6c135e44aa8513d9cb8648cde8c5718faa59e9)
  , NZ (F 0x2ee0120de58da43fadb3c1839be94b47f52bb6957F7ea921066a5cc139b596c3b32ab79a36da69349c11e2ca16267a5e2f72739d5f2c8c6c351c5f8a37b452bd385b43d879cc3d) (F 0x69f102F1560e1620a94ea7eb389495a0314c3bd5fabc17249e5ab39e7f1434ffb1f0629505e7ae7ad90c32d7c53c7c62fbddeb1e3c7f9ae9fd5bd1f1c68b37498faf9F8921c0a)
  , NZ (F 0x077582acd1a626a553c253e10279fb3b7961f81e76b39535de22f398a466bdbadf7838ba0640bcc29e64d32b862ce636af5F85ca12b5d7ab74ab4e515e52608edab5a83e9e780a) (F 0x210088d3eeb100536282da0024d9dd22ef7194c7a362de80375fb6b6346e74353a80766090921d529d97d947b9745a329d576a2a3b4d2fb77ee8afa936319f813c4b204247ab073)
  , NZ (F 0x6630aa5cb6a05207e5e15c861cd805a7727cb22afb78a98102bda5110deeac6b5abd7b46ff31b89a2c5b471aebbfdd2bb63d271910a9e1db5c61462b915b29139Fa97aaf358e7b) (F 0x7cf7aa4ce1bb713e52ba668f237b5ed1e9b4b2dad2502c10ca94e74ba4d80e9e2a9f78e33ec51b3dbef410522c3e9bee4621a558a218da543fd9704c01288d7b31af69604915899)
  , NZ (F 0x16c8f2f65b2f078a273690f008F5b3310b70d5dd4a86d723d0a6cb01d45e3d7293921f24738e7e2742f30838edea77701c65908289c9a01904b1770a92e5d64a2fb2aa95eabb01) (F 0x7afb0f5d9d099aFb231775fbe76137e11db507ecaa8b21d9da4e5ed69491ba5205F55c18f0c2c943a15448302cdb122d283b4906a3b809f623bdf78a0fd1b356f74ff32ad9248)
  , NZ (F 0x46529c5951c4372e37a3d1ece7280a29df20cde80a08339251ae625eae1912d8750402f8456b52aa777fb50c7ea13a5d808b2bfcadc71e6a20daab454f00f99dbd92dcf6ede98b3) (F 0x0e7e80d0100c8debe14ce1286048fab7d4535d84fdd39c892ff56a7cb533a45dc911329c3dd3c16950396e780a7c606cae635e3f483e36857f9f5de9b691c679ca755410b7a3970)
  , NZ (F 0x25586ca3bd7788cb2928226c224243f37608c7c7ad2aa1fc6b7e7ece4eca11eddcee730ab074edb6f108dac19bc448c7336b22a6a474cf0631c00d64F722343a3e0ea9abf9b74a) (F 0x6149b02f4484ef31949a43b4aad97621d68d26b212039ef2f5c1d2316f51a6266bd160b758190bd39176b702d291dfb73F12f434e203c662e5f05f7f7ca3b543ef628465508b5a)
  , NZ (F 0x41c448100ec5a217b405c4b33ce6793093f8ee8e8aa2cea6c0a88be3a3e3303b790d45ab6ce3c23b67a11035af4172a0acf4add228f89bea8569ce20b168a2c25b5959ac8fd7d31) (F 0x0686d719f3b2a8769310e9d6421344a0d125a68dbc00bccba0deeb0844ad2d42725eb974149de245a3f74ea16e4a6c7be2eaf4d36e0f47e027c5f9d7eF4140d8b3f1e498548d90)
  , NZ (F 0x4fc1b5b494d45e55e178703442b7569dd7dbaf27c3c95b29032e8d0edf7bbf903e6460c0353eb3e7bc515cdF26a718307f2854fa523c22a9986e87c3ab1e2396966b53059620d7) (F 0x15975aa8238c4d75be2a7051944a46b54888476ddfb1203eec467f93d2bcc28cfcdec6ad1bde4c9b381917ef8edab3704a9687ec0dc67ee094fd0d8ffcd1447e37f9a054ef76f03)
  , NZ (F 0x21f61994a5d5e71f8958eb556dbc7d1ab8d38054aa0ab96217251be5ee600d393f69d8e0617f5b957F4801403b57cec7ecd621fbb237c2fa230d1ab2ac6bbc0847570f08d16fb7) (F 0x186113baad161b25d320604f1d7daeb4dbb4e8756b89db307ba48dc50728fc69b08583046ff7418cf9816020eeca4f7f375876c7668c2ff6ce6745bbac6d73ba426087eFe530f7)
  , NZ (F 0x25dedc0d8a44F85a2616fc9e4e649f5642ff8cba4b5aac7422c6ecea78382ad8fb301e14bc43c228e47505ed95f442b2e5722b24b542235e3a50e5244d5d6a9972bdc2d54a394a) (F 0x217454e6d3dd2c42e886689e152f49e8c2dad8b46ea66669c8f4066ed8aa1e59ce3cc98c69f5e8b64f98a4bb81d2c76cd75b242f6e9a37c3c78ff4953F17d641ce73def9d4012b)
  , NZ (F 0x22cb7ff0125ae2bb73034fd2bcf47ca5f5840bb16e263b0398d4e9a1ace3eb2643b31121cac3f38ba1d5d2777f0b810f3580057717eef55c062f2c01e8dc18794Fb86c59d31df0) (F 0x1dd3c39a433b8310e762097b8f42044e095d3a65ccb04239eb3ced1f955e62ffd8c331cc3113520d555cd6fae0bddc5a4fab2cc9ea6c7b6eaf8e92197735f7677d427cde81c59d0)
  , NZ (F 0x1a01c0c2412172ca6164166ad8cd8f89e190643f676028a9218d353d335f4bd02d914683cb205a60a20f2f72771558b7c0925c3748bea3f9adb7ee1adee58aee395b8a23984436b) (F 0x16ef53c51d1f94f977113f45ad24fa21b1966045f0e106696749bc6773a9cdf050ae7332c60c148466fd35e402fdfab0c3a241d3764166cb73a685a5a7ee6bd9c04549262ae4e28)
  , NZ (F 0x27f137798ed11e5a7a779c60b96a5ff4f4c221626dd5a8efa26a4d88a1571144f078caf99fddbcc401c12bf60936a4f5af7de5c2d53b5090e8a15945e3a132d47987bd702157caf) (F 0x43ed3bf21f3319de51470F09ee9cce825517ec90884fd232d49124f8649f3fc9c0bb60896611f420b8959eb19892e60d8efb2325be14d81ca1887eb6e774de0c46619781c5a56f)
  , NZ (F 0x068b335f156a7be9f6608ad33806da5d5e737eefab99ec73f3a1d70eeec16bb2e056f577c5a4a073aa55438958ca39b43f567364ba7cb93b42e162f9efcba9a2100f1f7c9a76a31) (F 0x3b90331f1ab28e9a7db099828ec6c4691d3943fa9542cd6374bf928ec20b9d11475b2424a0e2847b3cf6e22f7a3961c88674d0c159cda08185836c8c80f6e0bd9f705e075d18bf7)
  , NZ (F 0x2b7e886af6121b60151561b43bfa26f55bc9dcc9d12293b4a1e6b7853ea02bc666321a5f833255a968053f96bbca954b02a8ca68235adfd48d425c441f30e1d56c0c09ca1308265) (F 0x68c5a80f29c974389789F97c5941de364179c2ff851574ae6a1f0db89f7292c00a9d16b763df833995d6f3833fa8abbbb0624a5135866ff3770d93914dc51832c18f2a1bce7f5e)
  , NZ (F 0x5f2daab021951a858162779cc67f5233362666f40f493fdb4779eda646bd7ed1c3df6664b2fa3b9f309c265cbc48f00f527be395940ea06499310be64dda535cd6418adc2366388) (F 0x2f8a3e95478390096a21ddff2ae025f15b9f33901275fb0290d233386711c322364c36c7b93a34defd8bF75a3d53382a8bd79d60463ef7cf1472cead60f625aeb9b040d388f93a)
  , NZ (F 0x19edf44d2Fa8c6d7edcefb6a2678a9015faa30e1ff19fd4f8d1691a7c4c8b61b1216f1c6ecce22a09f958c8cd46e183ff49c75ef3831c1d9040830f425f25d3c02ce77d160792a) (F 0x791953acc6cb7b6abaF82f88c374c2f2948136f0c4531442484ec5a8af413306df3d2d4a3a62e412676363c0a8d9ef784e63ae6F8733ce8d0e593a75b34ad7929e8cf525a6246)
  , NZ (F 0x00f429a3cdb3485db756523cbF3bf25222b4ba3906dca927841928355df75267f2f7bef9e485f98152140acbe3b740036eaba3990ba06389f8fbc81e73eecbd07ba22c15f9b52e) (F 0x691e4f064b51cd7b9f20a0e1b9b19773ea33918e372b4ac7526dae496206a498f399bd9faa3fd38a980be67e33fd938ca954eb860ea44a57773703e297e774beafb549e3890fd74)
  , NZ (F 0x079426a275a79aac01dfa1104ff27d67ed70e280945a0df02f8d8ccef3f419884a71802a0eed4a88cd5c16e5e693014f2f42a8126c237664030607d260cfa7ca3216aa4a8cbb023) (F 0x2d0a5e2a362f18c20be0235590b52bb3166f483716727b6036ae08a762011a767e20559617e1869cb2Fc2d4d379e7d5ba06f0d1ffa99c69896f63af173734a7268caa05631554b)
  , NZ (F 0x160dfa75e225cd140ef77a85ee4f03fbca129832540dcbfd73b783707dd85c35133dd35df8b511a1a77cc7824a686c17c4d745443aeeb2358d5dfc1107087c7edc81ecc595372f7) (F 0x02916a1b08ba34e168a08381f7162710e3c47e1eb63062cd9effa5bcaacc5c05a42722838d34ffd0323cc39088fa44d2d74b295c32e7ea51c490cf9a3d1b239d6f1068d37d0adbe)
  , NZ (F 0x2a302d3ea74d33f2e15da3e7703b92c1abf9614a225bc572220961fb0c443533c4ea58b701a577dd2f8ac97aaa0b072dbf1dd90a069ed0b2b75809c55204c799b23406da4c6406d) (F 0x5d65b544c825d0e58f3988F59d528bc753091a190dd426e8c33b34440bb3c22c91ef72bf06d99634bcf598d1977d13ac728806fa0b9ae3c3f6acf46d03d22f71b47a97ea019e03)
  , NZ (F 0x2f81e1edaac506077ce38e37b9fa4b78d9efc62bdaf0acb502ae391004bebb63e56cfd101dd6cf43958870b648962da26c60fc7c4b73ce3cf3856b772cf330beaee49b90c9f7a88) (F 0x459c7f7e5b1e81822005293904015345dd058a3a57d86b79952d867367d46a408853e688b12b2936860f90d30fa1dbd69b5fd775575c5f3bf62c495c6a84a00bd06c92e5d813a7e)
  , NZ (F 0x7d4875b384a303d6d28acb72fc6c2f176afaa28abd10bc697ee1077ae5ad27fccf471f0c2a9a9b029a683db24b26842d2befa333f4cc50833581b30adbeb5aa7668d4a3e904f7a4) (F 0x634934838d27cc224771c35c7b8bad8c7c0F099c8c8287dada53F6c5F2dc84af4fa6d3c596e9f75c715c02f7e212b7e7e16710a480dd1a9187312715Fcafb00f74916488961)
  , NZ (F 0x168c52c19d09123b56aff579fd1f5b4230a6892435605a3d74ff56a4ed81238889efaa75dc07befc69b95e154fF148e0c3fd6355b38110e13bc6edc6ab4ab43ac59210e2b2ad9d) (F 0x4b6adedeb50e2bc0e4c83d2a4e0a9edce71d0d0f74e85fa8120f91a165871955e36c960d4754394af959339e574bd033fFb13c92a33a3665a95169b0efac29f5968871407f0366)
  , NZ (F 0x0181be7390Fa6614a3b510707d57db684abb9f22b277f58591d88f064d82cbeef80f222ac977f1d60e4fa38c7ad3762366622f82119f25566814003c212ee1c970e9aec04df947) (F 0x11ead477262c8ac9be7217e8a507838dcf1194e942b28ae444e729fb92d7cf27a6bf49cddf0d5aeed3ac5f215bc3415d828e832d4c078c31ecb5162dc4bd00611e261c00330ded0)
  , NZ (F 0x17d4ac8243b7e83b4721ef81f8e00f5ff50ed4f67d8636936c3d30e6452eb98cb76ee8211633ac748a3e0c870f3545f2e66006070d07492cec1c70f6d5d4012bb82702cb4f9d259) (F 0x2f76c21b7fcd94d4f1cf2bb991a7103d808d8d23bea33699cFcddc0b649fab5fa78822f4213e22f3e857fa7b14e714351a63c1de58c3637f7b4c8b85cfb2d39be9ccfce775f90e)
  , NZ (F 0x6f3d7cf0a49f00670ffFcd38a0dc2109c4fcb69eff8ef9d389a24405117c0b1a9bb34b89e183da796c868dcd5c25e6ff9b955643a3ad123976cdd888a2fce3a8ad338b8538119d) (F 0x74513cFaf8916db7ed776f0580c1c6ff883356dc766ae35e8b01ede9e8f85943e4F34fabc1f511ab736495827526ca129b86b46762dfd2f8cce06fd9f63cf9aea4eecec1b710a)
  , NZ (F 0x2e39f95e09F6b2c53928e35a073a1cffd2398595f9b30fabc2d3d50094695929cfa1ef32f0ac2b17404240d6f91bec9760311553067e5b11bb36bf6574b6f14bc7240e4dabf5c9) (F 0x0c575f3a2357634aca8d2f35a0105fa6a421b3b0f4abb1793c3134c410b43c6c6265026ea9200e12a8ec62521f2c0085c2c2041502c1a12a1a00b6fc2563354b10e9f4dc97e3c7f)
  , NZ (F 0x7ff72ca473925ee946166c493ff733945711d87a8742a4783283d852f2cd511c6cfde8ac4b0720f7e9F3ec7cdcab2fb7ef32c968c7ac56d7634ec7b9ade6686984d98c169d3eab) (F 0x42df33ed5625a89e09f8a71ed06140af858f90b6d77afc4420d97a3e52c9cf429923e609e77373e98572cd1ab5e2a37d79487b82dbea6cbb067f5bdf569ccfc8c4b6d9506ba1cdd)
  , NZ (F 0x3fc70b90ddae1aebff85cfc5fdc1b5123b687c4894205c3faa88f00d121a245f1208afde280eee59153065fde5783d65401ef792af313e434122ef528bb0b29448dd4b8d2ffdc36) (F 0x25392bdd706625df1f50ae674808aa034f5b68688936187e2c2b0b46525df8c154cdaea589a6875b2dcc151e7d91d0f6bf34a5ecfd8246a74620F4c0b5793bc312948352d8d002)
  , NZ (F 0x34bffba954ec724b8e11aa9c7fc273e6582cdb532e4bfa7de98736dbedfcbaa958df29acd10df20a8a0f46746242a0bd0a316384eea5b9450efa104a5f2ef070f8bdfab4c55fa2f) (F 0x4a8d667bbc62397a8cba0c595123eb211c2f9830693ec16f86a10436ab4717e3a6837f28e3a13b4b0f88c89529998a563a66ab507894b7cc9649014f31576d31b4a798f698ddFc)
  , NZ (F 0x76ed06107c5731d0169900ae0261adee659cfcf0aa0c606b5825666271526285784241a11986e63df5b96134225b08ecf9c8c92c81d2b7b4e149aae8fc2bb94e7ded71aea9c3abb) (F 0x1a06e445f53e801e198df38863f061db929c2624e216c64afc4317fb33b41736553a82814ae177458eb35d22f8652ea04fb777cae7b7ff08118747af2466d7706cddbf33a803047)
  , NZ (F 0x14288a8945e60ee5dfcfaad48ee25a980b854636923ba501dfac6b6320e7a3156a1da66ff9f0d73cf6d4739d4b0f9738901dc7f98fb351e5146c0b29b26e62be22a95615727f042) (F 0x22a3992f79f325f56d3dfda922ffc1ee32183f3cad23935bc9205a25178522f819146ae1ab7b196fbdc03b86a131217c0a9f9950a3f4a69d4bca3ef1571676087985f94d115531d)
  , NZ (F 0x21612a698b6e22b482b6295ed092730224f1bda99abff69185e23e60e6c47ac5315bd50926163575308c0e613c6af01f3b0b2a68eFfae2b9a0752fc3ea05a9efb197b5a8fddaf5) (F 0x5025f9b2f5462971aaca2d1d4e8fc34c48f32f4cebb1a1cc954046ed5501594b38380131b1244891fb3ce1df7c4190b70d1b330e9a96de3975111457aa94e4755f463c0963502cd)
  , NZ (F 0x2de65eddcdc92e1eef5a98428b6Fad1129837d8f1004cd36e7141b8fbb8d8cccb6a747f954ec08943fb6d193421c4ff59ba55ded8713109b481eac96ff6b76f1512c1eaf888ddb) (F 0x5332b975baeb568e577e2d330565b4da79cbc021ad6798b4a51571bc4b4259072b208a0d82074bf4deed0624ec0124340472b6efd1341e0d9d909f32937d0c6f20fa154a2b2607f)
  , NZ (F 0x423a95a8853c492a486a50433b45fb38b15d7ad979ca0dc22ce70b6ba8ddefb849160629360f3eca5564c5720a07928b997ff886a88c530b740bb14fb35842f4995024dad98fabc) (F 0x1382c0a9d0d7ec7e20812a07d013c5213ef0fdc9F04064c41669fa70d322f31e0213faabce49b0143da9c4ebddc5143fafaf9b68af8f1bf3e4a6f3ae6cd8f618a88e5476a01696)
  , NZ (F 0x096b771794fd12eebd59769361a2645ac12ed63340f2b2c637b0181399dFacde2008961a41932e17f2a6cc2db260a2fbd71ecabd4defc8b1e725969406ce7b5a3cdd407662b272) (F 0x531e528b428e4ba8246b270510fb3eb0d3c843d3d3d1015a843ba9174c70f0bf1a6d4bece843d06ee6a24222c733c96240b01455f8878bc0fdb5e52777c599e50566f101c348496)
  , NZ (F 0x2bdcb26dcf6307f2bf265db10a34bd4c02392dc7eed1f2793b0081ca3e17d4602e3f6af9a7ab24a42a6d483e67cc2f8bc13726051760751719eb795586356104fc2067bc882b818) (F 0x0816de43570e277e8e3c3dff2d91d8fd727059023c920e0e67d393102d42aa0946b45abd236914a0e7acf8497f5d41f927429c41f1368dfd3d20882d70dc9303446ecf08b8799dd)
  , NZ (F 0x0b51bb043b5b03a011a49ca7a4c31324b9a4c4eca9da29edeea192780b120b6ad2b8f92f64f0a6092eba2336ba13574328597ffbb956eb4a4ae4d48805d2b311d73dfce31fc0F7) (F 0x177d4cf5650a0a5252990177d55147b70d6ad06f409e7450c62dc640b5e9986e97cb7d5faeec6693ff6fcdc859a94562e39b5a971dd5af05de05fc0b69b8fa8f200698588492e78)
  , NZ (F 0x3307ac0b96ce2b59da5770706f8dd26df62574b08728f2a819dffd67603fdf0a3f4263609c54a8e86e9964437e8ae2c6195448507d362c0d91805f2d463c6661272428d47803368) (F 0x2d794fd54f5022531a5f7ef40e62de326033fc05de9cfd2b5d0e2edb9a4c26b111c5f330e7e8864c37246eced96160b5965ddabdeca645ec891eeaad865d10f7ab5e1b3cc61a127)
  , NZ (F 0x66a8950f33e519961599740654736770a2ab14dade2dd1d5c99bd0c82279ef2f111d179d74921f95f20729bf95c84d0aa9d6dd7f106b5add2b2af2f5d96c31fc2ba81a786ced73b) (F 0x4311afda6a5ed05d543cc3c1757010bea900c5e0534373c52f3451a55624bbb66aaffa4fc8852f5992c8fb80bF808a79cf7fcea70f58db7fb8f1d42c130ec091016427adae988d)
  , NZ (F 0x56368419397aa0f0b380ea041d657aaca6da8115bba015e8586212337ad5b6bfbef3648070f668450d8ed294e4e0c59d9b9f3c9d11f3dee11b05ae3d301422966ce649e85f1d974) (F 0x4203cc2c0ac78c6e35a4311cf55caaa01491909aa8408c73df68172392f99678dc4c110e46e9e04f2804d81ee9f092716e39e52a91e39ff716698ba43b768482a4125ea131b93a7)
  , NZ (F 0x307b41830aeb742cad760b5a1410f32cccccd90c2fbbba150b8ebce1f2e17844c98b2f8e00dd5fcb342c31f303b41c639e8a7cc7a0805960a4632d6f73f26b053e70672b5e448a9) (F 0x32a40f4f7af8c378bf521959e9f226604d6649f1103dd1eb53235714b7b4b0d6f5573584107367b8593233da3330537d5bc051413c0be25edcfd6da192f0f20b2456709a74a2bb2)
  , NZ (F 0x004fbae84415e240af6831d353Ff738d5757c03f1125d96bfF3af48b135d052d2c9d3c83307a49677bd311f11dabb9b20c3dba153d7bdd5e7464159f5814528be586a22d1dc9b) (F 0x3edf41bd701e3608a7c2ee0b197d3916ea59f6aa132cb838e5829bf962621fda2d450b3e5d882d3c643b32a869f233869030a5c7300194215a5702c07c979e29d3a370f8338314a)
  , NZ (F 0x7a8097c0b70bca06b148a0618a330b0bdd1fab96ac74fdfbcabbd614f821485ee2d35642bdcff82d5e2ebf1636cf5865dd44e2c1c6433cee0e5e1260e9d4de088924749cf0629ba) (F 0x36e063798b6f3fa0b5533b77decfbea3da055f8ec487bdae7404b2e416ff7eae6de0f009ea9dd91105104e962a228672d8466F242328f6b01c2ca8b2dbdacea0f55990d045c5a2)
  , NZ (F 0x71422ad9e928fd6fc8dc63008596b31cecff8c31704b94389bf619a47bc7e43587a9c5b0217356b5d42727e2fc2ccf796551e3c58ced662c53cf3166ea992a3a99543cf48b355cc) (F 0x054bF735a821dc3444745a45c32ab8a7ec6498937c144417808919cc0a37fa104f246d0f472ac9e8ac13d3a7ea00b6c45cb129ff872405e6c03dc7632ab9235290163eF23ee40)
  , NZ (F 0x166c562644ec16dfa23b69d2e17c2ed11724ac4443e285609cd41e70bdac81fa0c2b2755fcbb6ed1d8a67d05bc102F88dcbec844d2f73f1e8714ebd591e7b625aa6923f75f5b7c) (F 0x13795d52db23668d4928ec3637a9db80197da8204c852d6cdea230315ea643e2eF7dda28a6052cfbce122b827ad06d8f3c09882320f7f488c5f9634c3a232f149101fabc588d16)
  , NZ (F 0x02c84ce75541db248c1ee7cd536c41093225ed6c5ee686399b8d8867df3e9e00bbfb9d102465b319ba1e1debd56b0901757fb91f8543a2c84b964c58194dc7f71160ecdd7800587) (F 0x70f4a2683e7bf861a685abd75768Fd0a90cab72016bdda7934d0e141623be801ee9c841eaac9479becbfaed609e4d5ea9350744cc0f75f89346d70ff5b0e7b318f897c4c5d9a40)
  , NZ (F 0x1f39bc9579fFcc238b8a3127d8c58d12dc91c300667ef938c8480ae0618fdaa94700e20c3c6f1b926cf76d8d2bd13a8100e181149a5455aae17001b87c4886c492ee720e6b1f7c) (F 0x495d96dd2f60035b10a3a797cd6dcc4c0c26181fc6f142100f61fab4e6555db93a43c7d935e373a1a2f79c09b7a25049e7a9def9ca2e09e6c2a3637a63d732807428d1abffaf027)
  , NZ (F 0x07472b11e2db3d7e7a0c908f3892b677a1ff4e9f811e84ef989947d6405b26510aaa6d3fc13f69da8f515beef204f70d66636ec245134a835f3c514d3a7997d909cbe113b1de1f5) (F 0x535974847c45ec235da59b2e30325e8fd4dc376f6a6172c6ed3e83cbbb9f01a5df9048f5c302057dec7f8a3b41a6e564e3628bad4a9b93f4a90a5ab49f5db186c110585899f0216)
  , NZ (F 0x72dc171533b94844a6598d24c9ff1a93f19c026ee66f5018f52fF5d646b8a3a66767684ce67e2eeac816032e96c5dd1ac563Fa4046e71b00dc054049acc05d903c64e800e9bea) (F 0x530705a75986d869d3184178a1fc3f154261f02e44527f1b5f65836e768e150a0d0ec5c0c97186a62d0ecbb32880524c44f638e9c42fb6297ec2b0f8f80d72b1940a5Fa3f98dda)
  , NZ (F 0x4e8c1f006d26773193a6b0f4b590f8ac11ad6e0ce38c1676e1da67fb1e012dcc859a42570ce8df738c9cce3691e64f0e93e661abc5b2752df6c29b4af66c4e55006141ecFf3bd7) (F 0x321545cded7f3ed31aaF0e5e47a1c62635ae4b91882d17c24977ff52d189ea5e5da045e429b945d2ed9619a1b5ec716d8dcf0e7f603940fb99c07956a95a783db6b2b85742941f)
  , NZ (F 0x2b2ab0cb39273a796eb044eef41fF1f8fbf986f31273a1f777cd66e90e2c8c984a79b3a8246f030f03d713d06844da593a83d5d44b6a950e809f498c60e42e34575938b2909c51) (F 0x7babe04F7ac6c52f6b4443a841089de59acc3d7ca835fb333536312f527f516d8faf98ed11a58fa6154f306d711502364dffFf307c55eab1f14bec47ae949481a9cc3d0871d17)
  , NZ (F 0x22c60409b7f70560f42f993e92f9d6bfde05d6a421715e7941c46f47f0293787bf6b7e38847e85b840e7fbe976e6d46df7dc147751b1a24046c64239fcf136ea9924fc8d019e0ea) (F 0x2e1290016802f2310928fc6f9c288c10ade6008c1b2cf2552bb381a41401c1b29af5071d990475a285649bd6549b366755a098d8cf3125c14cfdcc72515d9da5b868528e26173db)
  , NZ (F 0x695655b6c673cc9077a2a41cf6c5e2c29d2979d8f983f0e867d209aeed4369d0a457300414e4f150520541c59b85d6dcad0cc554617a5e9f91b3e8a755bd466c15d7e5016dc5196) (F 0x70e0bf9e36b565274ecbd57d28c67d375ebd6408c99be237345e7820e62e1ea41c24aacc50106eed89b86f47130fd69a8f07caddac547a718adceae6a6b9a3cc923a868ff7471d1)
  , NZ (F 0x5b8ddba46b9f82728633e6d97be442a39100257a7325d4009bF83e0ea215537bfbedf5cfab0a607c5b556e217cd199a5cb3f189af67f1284f8555f70c14ce1f937300f88136625) (F 0x20d84fc6cc1e97b3e29a109a955F879d54a2b8b8f2c3f7f96aa0e53f36085bb90d0817db03fb22c9029490dda850b0F739a16b0d7545a68a9acf1bb80ecdde410c50a87e54f33)
  , NZ (F 0x6f250f2933db34d7a9db7ec3b803a679cdeecd9d36fb94d05ea8be33543830aabe9e0d2aed8244e32fcf7dbdfd8283562dc6cd5fb183905f5ffb306548f3ca9a90c486a2f5f3f79) (F 0x14403c1e7035af9ddf373bc57c1f4399e1d7e85b7b535d9f5d98d8d50f0bc8a7d018c29a50c6c96a1bc4dee66b36031e29090da9394b683d7e079349d2d9a3ac9e9a3d4bbdd0648)
  , NZ (F 0x3cd4143b60d10e668c646cf61c44209d435d78054397cd03ab34a258d9e6b8c82b02a2ff8d837a2c33ec8604a9b5c9F36a4d463de1b4143cb580c8431e5fc9f9b50f5e60F8dea) (F 0x57eb586f79e4b7c07207897ca887cc40f599ba9005f0a27fb20e6dc51abda46719b602a92ba7baf168d02552291232ad0cbf4abe67d54f84c90b47fad1dbdf5c180524f9d2e5314)
  , NZ (F 0x1b0e5433b791ea88bb643ada4b305b6697bc054c53c7f693870db9cd61f4634ab02878c0755a2482b2ca338dd6809a78f29d1c3b6a58217cbf93951065bcb64b2f5cbaa0c94a7c9) (F 0x0db2b12e0f13009805e8f4def5df491fa5fb08347c019f01649369993d6e1e6b881b9af9faf14f5c01d49cc5de9732e166e59c060b4cc2731ddb8e0367f985d8dae12F8f376005)
  , NZ (F 0x3645b20464802111e8cb37adacb1c3b0c90502f58f1e602ced3afb08b984aed7c6adaa0a952448838d1e1ed3ef48285c59422353e77320c547aacfb202f24240a196d63eb006ef6) (F 0x455dcaac44388e02efa4a72d052412dbcf677a159b7c96a9750def2d4114745fbbf7f6354c9359dde6aecd108c0e41b9e907d9b04a8c321f228b2caaa3c7bc2a8a922cF177cbee)
  , NZ (F 0x433a96105c2881bc8908a7d6c3755b47bbc34eec65dc400a8a6dc8e97d1dc23733c0d08718d2632761da92b15b24a94ede97117e763ea565237689dee6afa61b575e875aa953b8e) (F 0x72b6097b4ac162ff1316dda2bf576211bcc78b56364560b4d50ead7468697c8a1d8b398044185e07de29aa74076c24b93f04786dd94bbF92f616f4369d17d6a0f8cdd52ff69b0e)
  , NZ (F 0x47173ccc97b8625c1339d5b3e78ac2b966b353e08f1626ef470f729943fa156a2d750e077b531c70fce30450b5aba6bb9bbd4530cc852cbdd316e3f1498eeedc47dadaf4c83dc75) (F 0x669d383bcddfc0b1af6503d01Fad1ca05c30cfd749873b66ce0c19c10e7017eb24ed441c9dcada36080e02edd2174f0c75b7d8559acd289a2bbaf01583817b83e77297ad908de4)
  , NZ (F 0x7fc2032e880fdb1adcf7ae0f07cfdb667aa6fce61254e236f8761d1f8e3581b028b2218f37df3a516cfdac6e1db748f167fb4f791a13d45c7b3caa32b236734032c032ecbb17b62) (F 0x39ce2ca045d4db6086fb45d570eb2dfcd39ef2b06f2fdcec796a01c70af7c5897c0a12b76be6de06e2a19caf0de002a42aeb036d632edc8600d8680F3d28aea3d91a3d11d5b5bf)
  , NZ (F 0x6e467b84d3ad0e0ca811a0a84cbfa82840b9f5bf3b99b1aa53ad99503661eecd02996d50be5fd813ffc620F44acbaa3f8c11Fa807dea8c53ee8fb1d267856224abb409fced51c) (F 0x004b780680475771a7dad0c56d8550230491538da83e471db9dc22b844fbb38c64967bc72ade3f01e2e522bd20b7b96b35f380f0f00da5869774df9a3b735e4f481e9970121dc21)
  , NZ (F 0x2c00fc16ce3cd1d0ab4a4580d282bdb5bb70c7b4ab42562484a0541ad40a219ed6cf19c0426ff1fbe81ec1b42926d718062351aa10f20ef499fbf37f836469faaad173bb93eabb6) (F 0x6fc855eb5befa5932993671361e9ef8de0fae68c821a6e08b688d81a29fd0eb1ca83b602cc79de0abd2fddc998794249f48d26a67dbe970ab3ad7d5a373Fe5a14ea6539a3ba331)
  , NZ (F 0x13094beb67bfa3186a501046196d6704607e475412e914eeee2863b8057590481b08d7a1265f30f66b3c6e8c309d428eb2d645b6432e415db7ed0eda947Fa8f82e05d05a656861) (F 0x33faab6ed66c267f497703d220af9b1038548a9cdfb46ecabef62e2df279bf456f934987c68b3b51e5c679d4a0506e9dd9a5e6a3a551420b1c26229ec93c4c0676d7219b6262666)
  , NZ (F 0x5387f3c05734dc50a4fbbac8d0d9ee86abdc044dae90d7ae40c4348279a36ccb31ba2cd72448d66b3c2fa06a468e990660e1802d79665a248caa2fa4bbb066574b021ab76fbd8ff) (F 0x282d5de7b07d73bce212de0b9d01d9a72804363d426c6adc4033eb2b9b8d0a1169268e59f2949838f8298a09d8dc1721235d18d5168c1f36eb8b2c9aa9bef156b3e63b3bbd52a5e)
  , NZ (F 0x30d88ae0871b383808ed8c955959f669674a9bc226b701d25de356a089ad6b5011a87091de2ce56d41fc87cbb782b8ef8b23d2087da1ac80e5e7730949045c4a19832f916e17228) (F 0x4e73961de2b2679b8c5dcd9642fd79af9ae2bc51333864d1c8f9465aa96f89796b62bc570188e004e3446e8c5a477b5ef44917c9cdebacbdcb6b9a6caa6a1e67a475b84e087e8f9)
  , NZ (F 0x7a76eff48398f10670e084e039d2c0d6785ecfb0e5095d786936f4f720d0de06e0d3b8445b2a1e68206b6c4becdd8af295d79360b59acf8d83aa2e653117085c498534bfd2b55a7) (F 0x527F74d6be6d27574ea392518657aad2cb431cab555e20b0c7391c6261f68a3e697946fb0a30d29c663cc5606398b391e96f2e000f1c893565Fa3f3a56fb1228191e0e44814e6)
  , NZ (F 0x11af2233e9141df73290ad7c87b8883e588ea9233b9bd78c985b2480344e2b425497e0d0c1c070e852a6e7ad726291f76d43035a804e19437d628113b04220764b5d3657edb6528) (F 0x264f08ee0b43bf5de7ca26a606069fc45ebcd79fc4dbc3ddcf46b7e8e675b534a44277b654a5f04b00beab2eb13d1e3cbd72ca81bf2d307526adc52f581490fb1fd030c202b10ba)
  , NZ (F 0x1331a347d20fd3146c97610f1535f38b8dc6d7bb35e7c19Fc4800c0cd34c6d3cc065649a26a0e31017ff74e3c806363da1654f8c8d52f286687e592a9055aa5b91cd4159592120) (F 0x58325ca11e994F48172f7eaf88498c37c006b9f80e7159bd82b30e17805597c135ea13093e90c938830ef90de1a662e7d87d97c63569704e5a45b56b23b758bff0e7553f78d64c)
  , NZ (F 0x7685940c33e76abc13def09b47a16d7da7cd281621567bad8d78987140024644ef6e1fb8c66f4749033887b7844560da0aad83c34d924e8Fb3a7f505ea994ed1d36df6e7138d4c) (F 0x2860c2f02a0f259696c0dffa69fcb215d1c0107285c72c8dbca67ab4bc4152c0b846cdceed81b5e0cebe82ac5659c2c8e90c96c4456F128a7d823291da7e4ec258bc09c95e849a)
  , NZ (F 0x21f35fb874abe85b36ced75614dd3d96c36bfffce048af46c3c5099e73c13350dccff78d9ff013ccb71471267e609ffab655f4b7945275c479f22234d86cf7659073865c20bdf41) (F 0x116353735ea9a24a54dfff3007fd6bac0717fc74d1c030c5d6d1fcda9f3970355a793084034f94a16d9f31c310820a1c4417f8ae078bb9be017b7e90bd13abd0c0c7338933202a5)
  , NZ (F 0x21a12705c24f16637f698b37c5aae0a1de9e88624a3785e987cad86cbcf7a21f2e50ec1b64059cbc343f73773d7e3b56e907f5fad26a409d5d4d059bfc4b242ff256dfa385f80ed) (F 0x340bbab94c6a8f3cbdd2c2ee98ed15b79c28e039eaaa677fd15a4ceb44ef200b281fc4ff2e39e35e5f7a7d02d616bb5973c8e32d8fa553ed1886f6409e588ea6b500f526b6da30a)
  , NZ (F 0x141771444ed47f818a2926821f79F8ccc11a35e4e9191a8e2f45be2ad867d3b405d1533639297ab3bef2584e2eF577bde1f69d0d066d82365128f3a650609322908254f578dbf) (F 0x4b4009f7c7da66c2caf4459d1ad667051db158c17b7a932326681ac878e4Fcd3e968e545606dbe1c59ec8e655b060850e17b180248bc63c640ad7e3ef1805a18662ccc3716ad7b)
  , NZ (F 0x59d917113b0ef334b1130c40221b5b0243d81e296927d7Fd261b13b472a697087caee2554a68599f437e126f71bfb1120140cc4c98070ce04c0e7a4dea17dcd33d251578d1edef) (F 0x1222665e1e3b84ce6dc4af88e1e5670dde191a9790b669b574a358d3c122182989a051bee0b7d27d2aaacabeb94dd1c16310450c7d2f46c67d0739042f70a28e85f1cd63d989d54)
  , NZ (F 0x5f4b8bff19e055a2d6e31cf6d02c7f51227a49df4c1d7ec0a47ce909c7ea7dd2bf0d8eef88da5ef5c0bebed328ac7cb497796520a5496c445bb24246f6b9c000cf4fdc507945621) (F 0x332a37b0f24dc00bfde9beb5498abf895051b12dda1b490028a1659f791d8e3a7babd3a36fcdded0cfff6a241c9018dbd843452b4d11fd8a8efF17853bb4bcd00139c2c6ab674f)
  , NZ (F 0x3276c232473944daae96263b71b98fd9c78c5f5fd570e2982e4Fa064f320c17881F8ce943f5d158e1bd28a76Fcf345cdca9374d9436b8e6bb9e47e72d048005c361f45435b53) (F 0x6ddc54de7a36ec861679d60cb33cb34c71d53f975214f3c81be881e426c4d367abf21f37bd182b99a5d49e383b490bf34863c3f2de6493c8403dce446e2750251ca5c2d227220e4)
  , NZ (F 0x22882ee6f24b01e11a1039a3b4e35f406580f1d79e5f3d777f5aec8974c11cb89f8fb6bd9eaca05e4d847fa59497b1dd60398c891e2e550c5137b6282ed7566bf77a879bd293c5c) (F 0x3bb7d76aae5206e279a7d00331e69121f856f2d59821bac10b04f50248231ce2a24047cc6c5c6253defc55052174164a2cf5a882581f0a5a5f3ce228171fa9b81df93a856cf1474)
  , NZ (F 0x4e3b01b254428121de747f326f704e4dc93f4dd35b0eb553f114f69df5387a5b656a8272c01cd247a80f8b6eb22377f6c3a6eec402d9e0902f0bdb9fbfdc972ad542ec3759e42e4) (F 0x30360a49c21bc3e0eef159556e5ed558e75ac3e3066ca48236af186577008dc951ca70d66F4116e4996f69a8a4178c1757fb61d82aeef89e5fc180c2a1e4ceFd2794e129916ed)
  , NZ (F 0x42bcc5213dff1a14c2f13e7e7e5ceda55f8cbacc1c261040031f305bca5039d7b5c9a4816be9fd1a861290491f3b99da1adc9c8d8636ea7a9ea679Fd4275a0d637298e8748ea7c) (F 0x055954c005a2b9dbefd9be23bcf25a1764109e3f35eb3620f04e63f5af2fd725e1bcd0b1000015f6729c486f5aae4e9c45442db990d7f81e401e83f3d674f0421312bF04784c92)
  , NZ (F 0x5981b63db07402d5ff98b6dcd9f5d83b35a7b5d98425083a3bd322043e8b06d3836dada5c056ca7f7dc724ac9b71d51df4e38b3a61eaf661aaa1008b24940688b493ff912699ecb) (F 0x3a5d3dfd4a16b30bcec236324c5a4563835b38b9f10575c1e61ae59295381b80e880938bf255d2a7b91897699ed0158243709375c7e36440bf88f1181b63f5c459F1e7d12ad4d9)
  , NZ (F 0x41864ca2748aa8bf01b1fa490125b6bcabb29a8a8a421954c3a16c39a8288222674aba07c1d1e930d59bc635d9fcf687a3a4d09752b98e1caf6c4632e23114ec51e919b869a422d) (F 0x4d79a3cf06b357062f07be0daafdfbf275fd232509497988fbcda5c1232a9dbb45dbac2e4ec6f6193c15388906d50fa4b55f2f999e54c016a5c16871b9e237a6b818dd4e67e56b2)
  , NZ (F 0x7859676d21778f0433ad95bfcab37a6e74cb49bf4c99d64c0fcb7d2f2cb90f4f85f4d26b5c4865d384c480f0fc816a9cea4bb6ee6050c6159f1440645875f111671b0a629caf2de) (F 0x5997e51c47591518dcc4587bedc8909e415813a430e8a8068fd38133dc574a07e2ed691d1334815d3f84e6885bd54b72fca97318282196f8339ebbaf4e37040362ff1db440c8932)
  , NZ (F 0x0cc135560a3afbd50f6c1402f6b17c8c3ab47c17ab167aa353d0b36d3e114da6963c0369fd0b22b389d8bf3e5e629b7596fa7fb502ef753bcbee3451eb7709edd438adece2b1163) (F 0x706e331ea37f0e68240b814b5f523bd58d34965a2499db8700b9e5e8ad07d09d6812ae438478c972fcf1554f59538ed5bf20d12003da47f966c0fd1f02eef8ffd5503194a687ff8)
  , NZ (F 0x4bebb8afd1e892eb5d6cd21b2627a11e4d071ba21ae12f64c95672492b533f2a9898a8a6a7b06ecdf02d97a4cF9f8977b171c565a720d9dc67e7bb0f7c1bd1f1b1bf35d9bbfcbe) (F 0x66fa35f402572352592461c7de3c8daadbabaea5bda8ab1241e9c98c2028a07ee7f67010338ff3e6f80631de6f8a690606beb6619f7cb57e0758bcbd47ae26203501f75a422f877)
  , NZ (F 0x3318f0104462d74daacfb3ef465aa29db08af15e571e2b0d635b4e4e2947304ead67acb8fc5fdccFe7aa817fb6f60463c5612bbfa872a3e93369db9cb9354d82eeec68359e8240) (F 0x6763a6269eb0def9dffc3ecca9c037331f67c32396406fbbbea3ad80b21a2c77f42e6e7f362c08354bc71a4dc6d64f9081bbb27a45c49c6940005496b8909b041e4d9f20513056b)
  , NZ (F 0x7b0a9fc068b987b555b57213eb1f025b301c5511b546f89a367c79153cea68899c3faf0bf2816c917eb66640df588934c7740a7b2e6dd833d8e7f15fabeffc7de6d7010599f7086) (F 0x5706ff1ad37a1a2b512b77c0bde933d1fd2c628c9016b6949255584aF7e80a520c389348ba21ac67d709f899741764d3b3b32a7aed9755c3a7cfd5bcf864d8cc60e19e3a64467c)
  , NZ (F 0x38Fbe6b1f7360cfd5ba2ae30386e50dc809260e9f6a0e985a536b4ab66a0f29efc27947960F7d491c84e6068cd948d5d46ffb93396099a9c555607a41e5798f635f5b8b269ceb) (F 0x5988659bea6260bd71d5f0ba745390faf8060d36753c6b206b4fdF9c87f7139b1971bee47bbdae3be11aa8e13e7ba7132dbeda26be27947ba78baefc2e442b238c8f87aee7121b)
  , NZ (F 0x126976ea031dcd773963c9dd8d9eb4b65b675806ad55577ebbacddb35682ab6e5aa5c063306b109a924d8ad5b1eec59d5f166958f0c6bd5c4e77baf2fbc382c171a77c759b9a020) (F 0x6391c3a5d6e8bea02e0057b495e58510a37baf944887d4ae392e49ce7Fe1b0e2a6a23191be32b314f6f96f8181ab29e87db7052e1c8b1681bb444c9743b14201c93975f76dd29f)
  , NZ (F 0x435ed91459b56745ae6b0e573b1f95ec086eb438a0fd6a4ed047cf8f23f5c122d42771c52600b8879ae2ea2f5ca51585933b2cd8be388d806ae8997765c39a4adb48da5cf18b5f1) (F 0x00527ca4895bd9ee3534bdb83403d8ef2038bd4b591bda3490e517f5ccc268eb20c20108d4bc050c9410480ec1c36e8ae9d144b48b35c356eee0f044b9853db7338a3c7fa355842)
  , NZ (F 0x52106e19f5dfd0109a4da13Fcee98ae02523f5Fef65bbb4386ffaa402e0ae18234c02f76c499b5fc6ace3df8fa985b7b87b76f8eb3e9426e121948eedae276412e8b5a8c1ee89) (F 0x768a34673ef75eede1cdb5277100c012f03281db7c927d7acace5049755b1ccdcdb249667291731c4725a43c390a9e891b690db63328e0ed6815ecc6485ef5b1bb610b2dcd7bd77)
  , NZ (F 0x2bd7cc3894ab29ebf349e5b3313a6bbc000cf279b3045d25b7f047df2be3a33d0d537a86baa59bc774fa8aaa90dfb07897cdeb24cd1e781810e09dd3ff1b14e940525d2b36e4088) (F 0x6a7cda0042e97af02b56302cff22a5e42645fa9c4b51ef1cd57adcF5b248450c562e17cefd4ab93da38bc1cdf5baf9166e002d8bdaac1037ff0049c62adba3c7c0a3d20e78933b)
  , NZ (F 0x216ad381dfba4e599030f6cf2d2a5525d18b99b8f39f950f11905697f76edd43de389ec20418559f9d24927f3fdb04011658ac3098fa2dfa843c01ccf3ecc0378b580d9f8a42be5) (F 0x04616957a14bc983c5ce7068cb2b19d5a136eaf1f24536ce9306ac64760f5fF448772c1Fedc0613ae7fb881eb6b4b6a9a02df34614b504d8af55901dd3945074944765539fb45)
  , NZ (F 0x5921026f870e2bb470541ec0f0e2F3426f3d5d2133609c8d29bb59934d45fF04f3cb026b5ab359f3a61bdb19c5e87ba49ad4847a6d30b2c7ef091628050137fdebdd251691c08) (F 0x11ba3a1c95d7028d343aaaa3651ad3186b33b89ee972006Fc78dcFa2f125c0454b1ec71a210a921d0f03a739F29d7e0311d5452e1d5f380cc7b4e2926b129269bb1ff70ca3c4)
  , NZ (F 0x20f5265959b03c5da3a2d80726c0367db06208ce5ed5ea444762dcb26bab90a938420a979985a9413cacc3f19e6de46d9c6e909a9a37c90e40ea419c6b90ea7dceb67461e64cb87) (F 0x36aeac023eb19382b8e837d96f1474dfa7f0b52ae777f648be1F4f2b7792d04167808c156f45ca132f4eda0d63a3c9c65b06c341cc34c5281431b67c8f540174f238eaee937956)
  , NZ (F 0x7848c70180a8017f62F4d9a2c34ecd7843f0bbef283aed65a029bc2c3e14ab82178e749f108e48598a88821924c342b554a0b8813dc25aa8d17edd3cb9af8d4d3f92d61f3dc434) (F 0x5718cd37f25f3fa1ed482912ece1ca153866c97b8882a972f59fd00ebbca870c8db275c1fdd5fdbec7121db03538d32984c10fa048a9ff3611cfb73d59dd53db58e096e3d407041)
  , NZ (F 0x18186a692c6b18205101babc48ea94d60b9b44a3ac3dce11ab0f1801fbcf2300dfc17db507bb83d17d99d1b936f5e54ed3edd9b253681d6d7969d6bbb12e72406516f8840d3be35) (F 0x490569f61d6775830e23a60eedce9f7ee29729cdf2785102c01ee479f150d9f6c20a1345733265c795eb7b1a162fdc67187bc22a67d0a34e5b611903863196be9936d781ddf1ffb)
  , NZ (F 0x479c7a1e9cdf562ec140c838238126acfcfcbdd42c20eb1992697cf1f447d8eb65222e2c966e5a31b823b07cda0f0bc87336e55697ffa5927f941d9956bd14343660b5dbcc55b29) (F 0x2fa891b03b5507b56c8887703a89a9fdb1a402b0de00aa64a485d5712fb11f3d89e0d5be0815fdd4745bf131ec774484a139b2c6ed559d6f96a16b65b648f506bfa5c3ef637f81d)
  , NZ (F 0x05d9d50306a23802da3445b35d989c12ffFb07e2152551e0F9e42f16d262b476a2264fcc4221cddec3154e3c21661a6e1d4b4fc3698e8f7b41a4b467ac0999d8c985b1a88a8b7) (F 0x7b8012521fcd276e08580a42d9d72bd68f571c3d646fa1a9a84a85ac400b49becaa9daecf8f83da8da3a615b00247ef7e0611e687aa7ff9bb28c30d6946709633ee87995e957038)
  , NZ (F 0x3da780363e1ea076167770a07ae290cb6a75b8f0144f8a0bdc7d9de829a62fa37c72e14c232ab0d21b3ce15f72a2dfba70bf79e32029bc879a0e0fb0824b8f5cec109a94c309e91) (F 0x01e23dc5d74cde68fde271659e75405d4bc2d23656edfc113d03091889847e8cfb687b83f83f42c7bf36758763497c686a32946512f7f4caf3803b091b1b086aef068422af06adc)
  , NZ (F 0x34b3c4dff18a007cb322a08cc7546d9c2154427ad3b22c7803b28fc645277e1651b2065648430Fb49c7f6406145cFdc8bc15fc9706cc3172037351201d8cbd2b47dee88c24c5f) (F 0x6ced668a920e824b76046255f2124ac16501bbf8dbb94319bd905561a6b4993afc0f2660865c819faf6e2F2f9b1ed2521c6b532ace05da1450e9dc4875ac3746ac39b3703449d7)
  , NZ (F 0x76bb98f5fF0e31520f5c0332ba64d5d05062b535d6f1a8bb9957d81344e304515b05f706e558053ea47035b8dc74ed9edeb7c78907add1ff553c043b6bb37f70ee6dc8f2c9c9b3) (F 0x3536c1581c67473d59478188091eb25527a8e45ec52a4fffbb781b2dc8b8db4df17712732ee8f65daa1a1bc6c61a9433f00d5bd6e113e1f4ffbdf2beaadbb29eb80a57f4820f33c)
  , NZ (F 0x283b6a2f66e232eb4101d89acf4a8484d6aeebb69b1389ed34269241c8064b9a35d403da1661ca59bf9f3383c9f51ca501dc9d8dd713dca9db841ea8fd17079c188d4cba895a495) (F 0x3b94a045ba77ba0ca9ee89301111c324f9ca84716ce4bec57f2cbb52ffc91a7e236b64e5612c50413365f80f508c96c012a823e8a8b8586b5cc60b8a5f8fbc00df8c1857422e7d0)
  , NZ (F 0x1100a16d490883b59ac9571b37e10e6ffbc7347526f72d34f801d4c4ed89cc18c97de7448d28c61e26486590474ecd7d9ab2c43e9555ca1ccddf99c14dd7931843d3aa930d2126d) (F 0x015f9869bf42b7cd929935e0a33ad63245c65e525b4b3204ddd453a385fc663addc8a87570a1142ca7080604c9177e239802b5107005ba9a200e0ab50d7329aFb7f1f709035c38)
  , NZ (F 0x33940d337b46f2af118e37cda55251b5f3710f7f97d66ea006e94d17db52c23d6a7d53c574f062ce3b96305110e7a2d5f60949323f77c1837ff7266557b49bbd8ecbb3128aa668e) (F 0x140d30d3eb77b2fc15ee889f914d8ef198d66aff6603c748f846421c72e0f5727993274d7f79913dd1968f80cb3e364c0fb3bc7b09368e9Fec7f4f4d749116632e2644b22af803)
  , NZ (F 0x40b7ebFcfbe201208c25aba2afda14e0ad5b93b92b34852eaaa680631c9f8b785250ac55fc80ffd83b44723bc8818c52f2426179257c800ce6537cdd68727aadfd20f56e10b5d8) (F 0x4b5dc285066613382e48e61fd4cd1087a16763c4bb3aa70a522c298c2c03390cbd73895678c272c928a34e46ba3b054e624fd808302688728b9e493b4fc6a96f678cb84d5293758)
  , NZ (F 0x422176ddeba263b92904f36770b4dd0036ef3d54b49ba70c246cd6e9f4ff0cb5d5c97e68d8effd9fa40ebce9253d29cd66722e4c7a4f1bb39a5f423889f4ac3bf2ce91e28827d30) (F 0x630ec81648932cddc8760245962f6a529b9f9601bd55286f01cf570c34a04b8de8615140f93b2bf557f533cbc206a0016e79ab84c09bda15b2cd863c06628a313be9b98e5c21685)
  , NZ (F 0x2659f6319c6c18df52fff0fb2221d71a315f860b4404e3d087e20a12205e23f4a37d24043366f6f40c4b86ec4bffb96a3338c9a4d74ff9e0044f3a8dcd3e0a14e3f2b5c015d08d0) (F 0x751fdb4b4f4a71fbff7539cc50fbe2f1885c1d8621236e150a5d0059bc06673cf22ee68b9ea559b35a97e2100d7a9c75d7998cacbedabb1eed5e583e5faa107656da4617fcc0308)
  , NZ (F 0x223c4ba033a515bc0bc11529983cb5e33ed5fc2099778d4ac9f27e8ef9da2aec43440ab4d6e309f9b7cf11858f699af3345F3Fb53cecc434f74747389297b61eb361f5a3ed379) (F 0x766e4c903f8f0c8d65ce27327d8da9a199d60d845082a2581714de3a390c711f200f1f3afc08e7de4f7100b353e5436af5173c730f2425db74773de44dedb46a243ed832576bbc2)
  , NZ (F 0x7e2cfaa4bd15597c8eaeb116d19666f39d20cc3233b315629c0a40c0cd47ce79e466e891b092ac2dab692413530c2c1503d0f3ed4355721e4e48009116365f6293c90f781585355) (F 0x475f45d6eb8dc9060cbc3408bb96c2bcbade90e96b7a3e197f61dc529ac1dd2f186119d01e60c237a2bf971ef208ef9742c44fd8a89ab42f61870ec111b6c0af61385f335adcc1a)
  , NZ (F 0x28335c295cd563422428870f512d48508d14df1ffa1662201eb4cde90d2de82b00c3aa77f9d2f9e4799268b8bcfcf0c98a6f7370592c7fdbba414174eea870f28a5f58ac46a66a3) (F 0x67024edf507a3224355f427b3108dbc928aacfF5d7809082923c74ce33b49faccdb933bb38e7e9e9fb6dcb22dfc289cf955c8ca15b8b7ad78e0d147eFae6407ce593cc78af1fd)
  , NZ (F 0x6236c53c59b072242f6105d68d24a3a4dcbf649e9abf8322142eb0315866849966ea9485bd09411ef9ebbb2a8ee9711b104cce503265df6d5792568bdfc4544ff24109c2d55186f) (F 0x07433635710b8bd67165a4a6d631ad09bfd730d6f50eaa5db42eb1229a5fc17bff13eb91ece09ce146458dd217d2617b86f85005fb12376a9dddb6d79b21c3ccf6f492c1f9e2e7c)
  , NZ (F 0x0e0F1f53ecbbb7a1ca69c20b83cd6adcb53a1215f1ff47869d3ec8F586cF3db8ac92e0a578b97f716251a322b35f825d55af1302879245ee9fb02a0db1f6341333061ba40483) (F 0x442ae2f589efc9b0b642b55ab4c5dede878bbdf73a361bb442bFe62434eb0778a27948796fadb01d3eb1cda233fb892315fdb22d1b0614162cc7c6c29f532d0c1845ae091e3639)
  , NZ (F 0x53e4c834af505ecc20af598c5371a2172911004d9d8a3f46e63a459deefd36ac21da8939f3ce1e8d84fa23f30f7017aefF7052be3e71658d83bb32ec9f521730ddfd92c4554980) (F 0x11a4bef911f496c06a63296574a34d1b070bcd83327f0c456ca343263e6ef6308223000e7b431f4a61044ee62daa5a428a946fc2f0c345cf40e00b38eda364f528cc7253a2de6ab)
  , NZ (F 0x755c3F3e0ce21c1f9667d07d274af32003bd138188103c4c4fcce690F41791eb3d6b33cf3ae5482e713198ceaf4299380647ab68369f37e8e582e9c491934275076ee9b10fc12) (F 0x348f6ea593e0a92bf3eb07fd4ff40363f19d115280dc7b4cd7f0f1c0d3a556482c142d49387bd38f81f1de7be41cb4fac594e889e70cefa0016a251f705887099b56bd26bc92e28)
  , NZ (F 0x5b78b4f170f6a1d4afc3ea1d23f815b2a32942de32c245751b7d466d69518debd1e4540630dcba830d4e035be99f2e1c6b84e58caeb716e2c370b937ee884fac7a58ccae4071d58) (F 0x3fb43106773d23f1a5173e9c42c9c34d69b19703bdadfca42d984142b7d174f28a11befc854f9ee3afaa80cc06342808b57f01c2da77d5cb3e7ecc339406077f4bbf40d51879398)
  , NZ (F 0x6b56ca08bee40be92f55d5708a237f6664f354e053c6b745c676d1671b6a9f51237b1a60ba7cca1ef2c8f5eaf0124e8f6b2a9afd1f4f22e17ad59315a046501cbe7cce5e89533aa) (F 0x6124d0ec34587796edabd9bf7c3778894ef9d4993fff159e4fbaf541c58d3346b1d5d1b98df8714a22a891154546c52bea908d8cbf666f8f708349b2419fa31847c6227c60af2ae)
  , NZ (F 0x3b6bb55f5cFb01ea1c51c8a3613f369e92e662a04bba8f3e83814e0d73310a445b52163c6c82f8bf628ee8391F8e03c667736964fc6629153bbf3a24c10b66fb8bf9720ff2155) (F 0x35d61495fd54ebac76f7d27093a805e0a67a1899fd259e838ef47e2b791f2ffc1e798559d9d763b25633de8a6aeb7aadca80184b16895bef07d7aa524136481ccfb821efcdccc7e)
  , NZ (F 0x575a7310c8bd95026b3c27e3777c47e6e3979680942207af444aeab06d7ab885db9787f58d72ffbfaa57f5ebb11ca7c259e442ba1c36a5f79ef4028ce3eb851014451bc5e403511) (F 0x41614abd43cd2e9e60ee89b2e1f3e29429327ea2d3191b70357d20779e3241e600efdda6ab06f8a3c91a1b9781caa319742a38898176149ebf90c90648526480a6612f268251a8d)
  , NZ (F 0x23aa49066958b24d0fc54929018a35426681b308f9f47822ecf85456caf701814906c3f917f1241e0649cb814d18a911746fc729a3f29472214Fe304f02cfcf96dc7292f76a6f9) (F 0x219cc84a3432a5df0da6d8d71d65b5258e076ff6bb455e29754a5827d7615b4b03a253581130610432e47483232b6532935a14b08566ed70ea34d03998e80b2759e9f7e37031074)
  , NZ (F 0x1cb7421b8ad4dd72e9875f651940d4a3ed75bbcf95710b8352a85b72a891328835e785452a51f37f978ab07d442f800972b00d2eee39a49e797f5b8812ad334a92351840176fa14) (F 0x4d050d26f9521ff914074eb9d9b661d8603e5d4d2a8dc35b420c2ca1e7c82dfb43f6f947733c5182b03fd4b3700ad84224Fe89aad837e1f658e94fbbeea6d621b8c1d42182f9eb)
  , NZ (F 0x07b94a85f6309882612d9e784fcac00284318111a76caeF8e77e6dd7396de14b5dcf7b71ab9db59e53139ce232dac360384c430abbdfa191b0b4e42b92f93a2cb73933c403edca) (F 0x5a34c223208c5f174c9b983e5fdab45ad0c9f0a34b3f84d28cc81cdaaded4871993106c268ea01a7e690cf2f940e1370aa7ac8c73e86e52e3d90f711bcefcc47b56d555b8a80632)
  , NZ (F 0x7ad98ff1eb67a3d4b9f2ff19eafbe1d7cb53da7b1d52d8480da718ba3a22aea68ffc6695b50793846f7dFbcd0c1ffbc6195a1df6c450e27077c2eb6d6130eb3e19bb6f90f30748) (F 0x07519966b1e5cf37e4dd3e045c112eadee9d3a8949e3749a7036738d410476ce32981b36d0ab64bcced97dac5396a1888c869ac9cc7eee344eee1e56af6817ee9ce8222b164f45b)
  , NZ (F 0x305bbaea3a23047547f75c3cd73ecb130b1d395060f6a8e392de1242cd8880765db46e58d6b79ee17aedbb6dcd5f6f6ba5da45233e7a4bde33bb757bac042f87dccdbaa638fc926) (F 0x02e682ce3bf9139c60dd39e83b81b9dea52ad3319a6d262f34c4255bea295483bfc0fc0af5e531cb9cfcf6bb878fad342947c7968b0181ab053f4d957de18d7a5b024625ccb678e)
  , NZ (F 0x627fd5c1c7b11187b47c9bf3b1c9d53e4c4bbf93d411F522b98e05cb982972cbae2ed94c373fb49c34ce887e3ecc213ea5a0e909cd1fa5596de6ca99c788f2d1872973d9911cf7) (F 0x066e9c8a18dc90db2b0becfa8cec01160a81837c12a7028dc069db628947542c53bcbfd342fb7023ab1f325e4b4b39dc8424fd5f6ed82d2f9909a97890bd65180df55a7ebc29772)
  , NZ (F 0x67965be5a9eac8e589f6cd714a7903fd8a6d7e8fb49a2405362b47c50e09fc703f3b78ed2500bc7572c039bff47f060cf4f103613095431cd8f1653b459dcfF12bd44e57bfd558) (F 0x1a9baed239596489a20ef956bcefdbaee03237b5a0835a6edf0e2db8aaebc9e3e356e3Fcb36f447aa513add76288c7d5e8ee8f7ea595385d4da107fc3c39294e979c9c84424045)
  , NZ (F 0x54021a0073232390e4f66bac27730693567a51f47d784bb80b78f553139f5e015207eb6edfaa5fb6Fd4fdb118749443ab99e2935cdde101a96Fecdf84df190d15d8ede6f32149) (F 0x615c86cd0c1aa157917ea45d43dac5761c01b497c54aa3e45a52c8aeb21b088149499434a182b87a18Ffc82bf9294538360a0f5a179329a90a29fd7b8fc5ea13c833c3bbdf6ae9)
  , NZ (F 0x35Fd94e66503330753d999554b6db32dedb5ad46b982a103217e1e15073c2347142165b55e849792ee41622d06875e2d6840cd96c493af335440efbcf5fa6bd773dbbe553d1b1b) (F 0x026dab3ad6669b9b9f228460d5cfa8bb5dcd2a1ec522ff6bf0ed1a02c3c6eF357efae9574abcd6ab0947223e79c25d8f8b75108f420d6c2503Fe8c70d05713001c7c85ae4cb13)
  , NZ (F 0x1401c8d699c7ef490250efaaf4da80014c65f00e832cb4e26917d72ddca42efbf028baeb65c18494d81bb6c5e9f7079234fcbf5fd567e0b30a5b95d6fb15d088d5a92184594ca13) (F 0x312b563f34b404bd9aF4205de4cd839d6558dfbc083bf27fa205463daaFd099c4877af8060bbf947ae252719bb17d9da62f583455475dd29f71818066383d225c71e42a78c279)
  , NZ (F 0x43bc8838a940286af8397aed5cfb0e13da386963a0220e4365fd4499109458bdeeb6a1693d9202cebb11bf3eb2818b1f683cfa8e85d1c26c1de9ee979fcc952eb1a307b6d37e46c) (F 0x5cb2f1c1df4899ddb6432eb046965e3dfba96cdfddc3445c4fd08183316161e4956f0fc868cf2b816Fbcf0520eb9ace0998ab17ebd94662402b482ed3cd1fb1105c6a9fa737487)
  , NZ (F 0x7bf83350a4aaa3839f7bec16936494d8d90dad7604d76588f40458dac0b427b5fb56d8faf1042b01672605128d927f38862ad0a5966989dbbac019415220e7d0a78dc9056da7541) (F 0x2e07be5e1ec9cc9b38708937c845df474139d452ab447ee8b8F683cc17d3a4375bd5a69f218b260d9d2a1a9b88674870a779fca3d16267a327f1fd54760d2f6d029d8cb94297d2)
  , NZ (F 0x27f8778e9785ea6d3ee56a35af6e1c926b9cf58b0d5d43c3e2132e13061259eca1e8a1887ce9de25d0e0da9bf6c5ccf72b450df793d0b08daf27656c022f5d527cd36a3304c500b) (F 0x6ed2dc412ecafc05d822b1a21527f24ed5beed4445b46e6f2108b5771a492b8be46cc63ba1714269fa869afa46bdc84cb815121c56fd089e7a97fb3943e848172f5583ad3f90cf1)
  , NZ (F 0x7119aa9ee307d302f829d2e013d8ea10aFc8e780eee0d56aac14dc2fbc06fb640d01668ef5f57afa9b94dac762594ee385f85baf8d24aea9f880859d4f83d47089356ba005729e) (F 0x39ab8727da4b03122c829a42F25113ee054b521dc32263ce46b0e77e9512652874a92a94f1299e022c02ad4d44df654F5b6dd791d4a1a0d5e0b74d9a0d521b39c7494eedb8b47)
  , NZ (F 0x528210a266efdd74cbc1f3c625b2a76e4000e15742c584b04273cb2e6101f30291fbbcf0c7118f8926ab264242f8a9d8c5b8afa2b4548e55074f7d9893f8b416747d0fb0a065d31) (F 0x1c3d14fa974494c65cec2b6990ae0176e1a9cf28a5ad45e94126e78608f349322ac52458b2f554cdcf6f4a8b9f7b93e61787b7d36eddacf125cb6a3e8812b3ba5b2f144bf108cee)
  , NZ (F 0x35eebec9ab1ab330a030a14569ecff850178df57f90fd15a9f654476cf67f4798af3630f3a568ea9f766ce093812c5502c162e27a8ed69830a87062c355903f20a03b01fd87ed1d) (F 0x66fccfb927b222572fc066e9988ecb1d2bbe802b069a6f942de6ae1eeed17fb23e56b8d47ea059d9b4e39fba5a417042b9c016fa4db74e3737a39f78f023e9cb6d21b536437907e)
  , NZ (F 0x174a9f6dac3a5f59d330fcff2dfdb0fba7cde52dc4594db423ff2765b62b478af3e5c37646f8c0d7fa2a39025ae6065551a9a3867b0dd551c683eded59252144b9822a8f6861929) (F 0x1a624adad4015e3740285896d158f8d9a2becce2046523f12a256bbf2396bcda7cdc1ea6610e904cae462F2e97e269fdcf8d735792870b66c4146d683beaf9b9937ecf5728bdd7)
  , NZ (F 0x60ab210a15eff90ce9eba8c9138cf5eb264e89356687cd67ef9269ba2d1636679f38df3a7e029c6b636408fdde7ea615d9d059066a5dfd875b133d838ba3a123c69265c702f99a1) (F 0x29eaaf5c2ce8b6827d6e080a993dec120241cb3bb69e3bb52bdb58153da49143d9b80a3a98e53d0175fb9a22b5c94f656cd139daeabb2527dc5ab4ed0107a63e84be3979d7a5172)
  , NZ (F 0x531a0464a9fb9f2c67c03f97e1d5b22425b9c8e0462f5ead16a126a53a89087197fb0d7781385713c1b933f902d8dcc7b2c2e70d2317626be88c83f8ab171ad0456d7dc6050856f) (F 0x1b8fb03a70863efa7503aa4a36505cf241be8b79d065b6d3e89498751b79524044cb18f89e1d12b180ce953457d43c9736edce2ed178d799f28d8497cc74c1d44e30e5ea8e2d5ae)
  , NZ (F 0x32f4d59e7d6448f7dcd9192ee13a2c54572de6687bd7ef9a303c5d2d1667be44b2270d02a47942cd428db3b5e7297425ac429F41a9ce89ba82aeba50d658e0b87abd60697e8491) (F 0x215e1b051b88f08ec2f6e4e0726702f4355e13919b8967887d6b089636bb3f9bf634cb79a6adbc5c130dbe4029646213cc704b7f70b6e114230434aeeaf6e3e48d07ee2ed0b11b9)
  , NZ (F 0x798f69f1f811186e4edc165adc7defa44a5715d2c39d94c4726a97f2452ddaa401dd06e97c071222528edb87fce732cf109892bfdd3b88bac1dec143655f81dabf4a8c0272230d4) (F 0x61892c6fac23e270a81a8ef9cfa1437736b4230b69e8dc90e2edf85ded7563259192ff574ccc7486bd95404c7e216aef838347925866fdde22970642cb6ae5e9558fF4cdb9ae2a)
  , NZ (F 0x6b4a043a32fd32c694a7767415f65ca0eb0cc91f5dac231e510888b1b7364d2311dcca28a0a29ac5c1ca8776565a718e9258a1ccb84b48d126f2170f23d1effd4eff7fa665cc23c) (F 0x1e060a4056c263afae920bc3058ddb0202d501382f329ef8d4aa29624b5a3fbf2e315a4d2Fc68740520b57b19cdacc21bf32e54f4091232f6089b3a381ce8912a145c32c0da1a4)
  , NZ (F 0x45020a8ab2e7960653ba1b7da62b20861aca832dd6a88c52b16f2591b84f7ddf9bf494e3105ee444731cc59eb8f70c4c2F01d51ac2fac1cce6a3649351d3b03ea443df722432cb) (F 0x035a023e449c1417638ede14e257a25d90f047f50492fFffc4bb44dac1a70c2ccb7204d181a9be8e3cedc89a0b488103d86d894fc24d00ac18849e1a82ae0dd05677bd9ff89967)
  , NZ (F 0x2b40f03fca12058aebe96a0a05d0db60818a7a102061087258719bb950812aFe56fb90696cd6022b4729a72ae050ca97dd581774424acffd245192f5424f1ddf06c78691790c8a) (F 0x64432ddfbb2087afdd53e52d462fa11c5a4e6c73976854c38d9594548615cbcd851e8e0b3dcc2cc2ec9576e4a3598fbc17aecabfd63b396382d1c2ac32f3e3fccc7e0962bd5caff)
  , NZ (F 0x4b687be60be95aa0a889901c416bd1a1d4ed1672c976aceb22be37c7f6a3d33c60031bddb6904dc6a603dc696f583199aa5f7c6e7589bFab8da16256d24f58fb55c6609ca2cf52) (F 0x2a72538eab5404aba298e9fd00d8bcf003ab7ab1ef859dd66f501d029a115b18cd36732d53fdbc9e8d1f282303facd60d588fae09ea126ae545a2191472986448dc807c6310b222)
  , NZ (F 0x24b6a954624f57f3dae8ded05b3e9b9073e00ac3197aeb220b77c8997f5d7995cac32c8d28F4cfddf8efc4690ffa21e54fa553752a37ecb87106623412691F17d44cb403a499d) (F 0x46086d0b649ea0f69c3f644503cba8541778dc28dede5bca58d82c4240d79a5cb802a6e1ba0ea330463c82f1d978a8d72b751e0c58391341d5d6a99058910b824F816e94848ae7)
  , NZ (F 0x41d98200a7f608f82772bcb00742fbe049dc2ebfcc6fdf24b05de18e2a4f27e573ce431e9ea51b6303a9694933d21d38c56a5a5bcc7d3081490c150762c031ae3cd47012ad26303) (F 0x7f4c2f1150234cec53c90442c392846e5b93a121a06f0c5f732c9255dc1e9da3a5aa3bbcc82215836cc2066952cbdd47fcd6c9398d0f310e5460784e9203d0a9b14e0aa9c3cc94b)
  , NZ (F 0x67723885aefd349610221f04e57620ab35bda2350c46f3bd077b68ab9fa9cd36cbf72950bd944c1ca47051ff24124067ebbf3591b7a48314f1b2ea6bb02097432c0d68e7da5c0f1) (F 0x6eb014b641d5a0bed8bb82dcf36177ed698a19900bf4c5a55f389767846aa76ce411f9d19b537e0cb5ea4a09abf963a43d5e9d48F0f45f7d3c63020aeb12077a07e4a34eaa9547)
  , NZ (F 0x7e00b9eb12918f71c45fbcaa3d9f0ea9ee4c3e73af523ab8a9c0b63cf6b317e560929dd72247dc68827819ee8719c0fa684f3c768f8cc4a29f8df5b6630d0ddabfd37b669679cf0) (F 0x48f8f577ae1e57437961c5d9f293ef44b3ceb230f356d9873915cf550654c42edc2db856e67b4f0b5e0fd99a271df8Fcf0991b4d1930d58951a8372c05348749c77f6039df6c3c)
  , NZ (F 0x5260d1736ac29a3f8d1fb5df7b2796f2975cfba0b1082b825df00dcae411b0db901720b680a4943525de5d92d720d291c96fcbcc84b0bff24ffca50b3377789deeaf679a7f8a04e) (F 0x3dbd74181b7b4c5913ac08ce6f6db84015678db413946c5022df24e4b359406070bd3f3d15b7116e454e25c2f7523a41d2c554e1b8921ab468004c44dcd655e919f40366607e9b6)
  , NZ (F 0x72ca28ea57c9f90628349d2a4f7ab70ff0cd6df7e744216ed774bc275cda176cebcd72e6f599579a9e009171d578da8ae03b2e0b9fb7438abaa64765025b548a18029886ae350a4) (F 0x55343e218a707698e9067b01fd3599db43121e4b6dbbc80eb46a001c88eb777f2105c96970df0cf1c5f64a5bc44ef09ed5185f6062e981e2d97b48bddcffd4e3bac3f05a7781302)
  , NZ (F 0x5c39b755a80009b5112273aad86ae4804cde8b3f39d2328025761df567c7ebaa791d897ba3ce6e64d4b2ca94beeae077dbf63202b1b9692d3b688108442475a3eaa0a7a35534da4) (F 0x29a789b84ccd65d20399cf5955ab267481bfbf73376bd037d702ba265c0c0e9732f6e84cf3f571135ba8b49f298463d1868e3990c44620576881ae79e308c2e40381a8def2f293f)
  , NZ (F 0x77aa364eeb14a6a95c9bdf044963e7e309a9d200a03ab92131d731f4842b8338fc62fcd842ac9f6a0b53a43a89df45ef61f9865f7e8f23b32a5c2fb2bc3d536dbf9be0a84ca1a35) (F 0x2b867eda0f44fa3a626c0866ecd1d95ecd76cda3da773ae1f58ef2Fcca0139f05c4bdfcdf0ce5752511dc6f2ba4a74fbc3ba517388fc70249a9391195cfb5270f9cb99f3b7abd8)
  , NZ (F 0x29dbb1450eaf97140924cbc124a327893909b94c4ed2300aca9778a7623e71504350c1f4731d87b6e4dd57250224be538c2909c10d68b272356b3068f43fcf328f937e365556bac) (F 0x383775ca885a5F0ce98da21552d1c7587e253f22026aead75e3f5906a396f4208ca8c82d5a5d514bec51f6857a91db6eaca2c0066f090af4f115f08cb7c5c4d5447b9b120685fc)
  , NZ (F 0x365c1397c9800d1735ad4480c67f7ecc4f93d41cd34459bb0d3d090c9d9cd8871cbb0cb664db2bd7d5d8bd238f091025d516b7d684470fd659cda0008181839173d549f2c587d64) (F 0x7cdcc4516bd725a44c0b3a1263ba7c4cab805bc7af704b7986acff38f006a9f6d2b10661faa4f207b36e9bbb9b95070a09ea007776791280bae5a15eab934c3abf6a47c11497431)
  , NZ (F 0x50b19f451b3acf6b6fb4325daad9e931a69461f103e9b3a0ca9c31e76980c5aff1e4fd65bb588b3b39b3df0bcde9be77563ef200e47f19fd51342d83d352b195d8cb024fa6abf06) (F 0x67b5174efa28a978dcac1bbe352f78bae99c6ccf2255f8cf2145b93a4f34e7ce7297Fe1e5c9e9ea28d11efc782fd92ecd86628ed05e8195afc500159f28a5a9ce63bc02694aea5)
  , NZ (F 0x747050c59587bef98e906842d0b15a54d2cd6f366420bd0a89b4bcc6bb992d238d19ebecc588cfd1965b093a36ae1d23fc0e435bc9167304627417959dd9bd9c2e18f4447244a73) (F 0x1709696ab745c52242876f6aef5679c02bdd0a4188f93db67a49e65b1ce6a7fbfb4adc30792f3c266318f722362d58ac2da66b2dc6de7d7f4acd384ec9b83ccec3487e1f82d49d4)
  , NZ (F 0x79ce46262c732b7ba821c97158e2718a46851034f8717ce8a7f37fff92e3c7be01e8969b356f7eb7879c9d9d7c99e6369751a86bcffd3ac62ead93e2d3909a47b4c213b98e0cbda) (F 0x0394746bd24cfa6d9b6bff64c6295c0F1ab7cb35efbb395cd920ac5de89a5db22471519c31db82ef544d105457bd159186a9e2ce46b61023dca5af2e9d50ad7b2924514bfd552a)
  , NZ (F 0x33dcbf154a2068d1f614da13ee5e7eb8d23691a2bc8c7ecfbcc6e05b0d339d9a168e7313b5a80ac5c355cdd1dcc505879d099d999321658a308a698eccf3a015e7540490cbb6b7a) (F 0x535ccfb1ff8009ae47ca0a2e8ac9f3b67d43e3a82f9532988a45f6f880035598e4b4bc9da5d5e357f89634098812d3994405a8578f15b9957760fc49ec28e96c0ec2d16a97ed7bb)
  , NZ (F 0x28c497b12c0aFa0e36f0e80223174f2e5f03837ff6c2e680f49fc662bdc0d88129b45af8a4611fc84006de92ce1dbeab075bd89f96e6d3fb0514d52630207401216a03ba8d292a) (F 0x5aff4f53228da53e47465aa923f715F809a70f16fc79d49c27b9880013ffac98cc862c6e4F6a1a9966c0a927662d5084affab8c67ba94f8a55dd0616a77b72d879cd80bfbcd06)
  , NZ (F 0x750a4923f6a4b633105ad651c4a29453dac455c4df65492530b4cfd718075e0e70f2aaec7a9f3089f6e574b2eddbf3895279f46ef4bb8b9fc9c4798f610643f6cd3a2b982bd13c6) (F 0x49dd266531ab0299ba7ac056498f9b79e5c8adc256daf1f13d31bb552ba208126a5784eb8e26436d941bf71e369bbb55444a1b4cf519c88c3b4a7700ca9f16fd1fbe5c352ea37be)
  , NZ (F 0x22c098429c6ba2f0508c5f9d64ad23ee8bFec827875f589b2c5b6420cc408a0ac5dff1dc91c989df650fb4aF66050ef86e4e4fd44a9c01e87e0a91269ce40c98Fb2ae44dab0c) (F 0x21a8c90fa744b668aa03144dcc6694db433ba5647483bbf525b06cf4a800c7eed07ec23b67c728512e369c1d923205b20cdba4fdf680aff02d90d20a928d146785347e87dbfca78)
  , NZ (F 0x126c35651bbe3999a1b9079e8d7a564d9a96dd6817cf189c83164dc32f22fb725d95e9866fdece0174c790a242c5124471c651afcf1cb7f012038bcc0ce7bdd4a3d43bf27384402) (F 0x3b70814dd3a4f39e7f37e7cd03387e9f137ed634858f43d8f61d9c4199F9c013f38291cc292f8ee8fc2d13f4972b2031726cf5eee8301580a2122becde190afa348e7092e2828e)
  , NZ (F 0x5a4672875411c110bec2e5426284a5d7478d9faaf7b0315F06b1dbf019939088eb3bc96c2be73e169c37d51516d2a46c368fa1cb69680ea28842195e5dcb1e4ed620ad95a0a0d1) (F 0x0b623cc8243747e8cb4c454c705520730ce270ab39988b563fa2a8ba2188fd434f0950779eecd17a3ce5b5dafc8ac7c8561cea85be2bfcd4ab8f351c4b76480814c44bc4e4f3b5b)
  , NZ (F 0x5c4122451a980ba946c38fde723472c1a94f6e8704b270510ee372c6b4b4c25fa3086a777b6bf7f4664e1bf5439ae807a278a0664eb890bd5e3f2ed74628607a02bb2dd8fb1cbd5) (F 0x34a4b8a0df3aeab5b08cfb8ac699cf6344dbc3dbfc8c4cba7e788f753ca6666a47b4ab27fd4a2950362ed6626eb92d9f59ff3f1ce81ef80c5c9095317185f5a567ad334d333c581)
  , NZ (F 0x796a712a63677c1e8e055de8b86c450ed73503b1b47182ed27b8bf6295f07161eb7c2083bb3a393b9e4f45043dd0aab9d488716297b313680e410fdd9b5a5219a1499458f9eae4f) (F 0x31d792d9f8fa7f2d1f7b2d4392c2acb88c43a8285acde12f8a3e0009b4f40f1640c0819839a1a64e6361b22def21992dc030abbee27aa25ef0ff15eF932950d952efbe4d7aae98)
  , NZ (F 0x25fdFc99d36097ede65569064f4a0e998de0f116d6843e215831e6a516a915343ef4b2ed151396c1725cea4876d8037efa00c394e26fa68160137540c7b3cc539d9e5791f7cec5) (F 0x11b9620e401f6c611b01827e6eca5e29b1af4759f63974ab8004b17f1782e63d3590bd5bb03c4a258f72c17F7adda55d309c24cd5f5dc8ef4528c73949bb0d3102d40e18bbf448)
  , NZ (F 0x5b2dbbf3920e84952a4b952cd7c470fbcfc37ec208c06fcd154692a603c35508883e9562a68ff09be6ed9a61239b3a1d883283b8f98830b0b60770379fc6b2538a21969c7de0e64) (F 0x2e019cc4cd532dd9cadb73a32c303a7971a94913160Fb3ba1943af1f0e059d03b2b1e5d0813951f957b6854f8475158c21e31ad314a25df9e80d73b8ae73acc88b477c36debdc4)
  , NZ (F 0x680b84661c08da860de17510df1b9ff4f557bf4050dc5bb19d0938ab594e23a4b1f9faf100d34ec9d63d75167022f46351de23eb48d7917984bc4e70983ae569bdd7f3ba2b14a46) (F 0x51aad1c1b5c454a8678fb46f088a8745c3eac254f199a5e327d5a4942e7d9570b38a3fa3bd7e7d665cd0f1d7d7f87887bfbe9f98e2bdefc81ceb7f7c8578b01ddfa598675651f10)
  , NZ (F 0x7937b9d5e6f334668d184f6270988ba4b0175f4bd1c911bcf26b9eac932aec286d2494b68425ec7e7298e21e1aa6fbf4cec1c47f10a9ebdb87f85e28a7ddbe346546ce6379fcf61) (F 0x3c842f9be1df9224f276c02917172562e0b8629ab77cca477e9e112fa97ee01c63ef316b10da5a905c840a41657ce1276e2680d6f131cc8b02ed023dacd259aec923035093f506e)
  , NZ (F 0x7d673b1e1571ae18b062af9209c377ca17942d91b5061bdbebe8bf05e3830506b9d441470640412c3cfdc20ce33c48813f2013da7293d687e2b725862c858ba15dc7b94f922f2e5) (F 0x65bd7c64773e4036ba2806f4861e7b79056ff08943d5dc85a3bdebe4c3c0b71a9fbad531ac3c0a04dc701304642e52a4f97001c4127aafded5acdcbea1c24eb76727f6e29bb1360)
  , NZ (F 0x36a7249bFb958de4f00712499123245fa91dcc0b612ada84c6e2d8ed309970454d6951383a0074478a4c27bc28fc2de4716064f114d9a2ce72bab7836a237760dc5e056704f817) (F 0x6b45842c54f371b86bb9bf91af9121402ea5eddeb175afcb59718d386e977d450735820b735bb6dd5fa002a8cb01545a3f7cb2767e3f9596905f63c4b4e8ae0c98363806aff98e5)
  , NZ (F 0x5eba5b2125c3a20c4774c38f2e0b3841a6b59442591044ccb9375f6fbcfcf96cde208412eeea4448669b67f0ec344a78b0497653fa79d1779fbdfbcf44a441971ec210cb138f7b4) (F 0x51755b6b79f8a2bb491d65d793a36ef3a203cfd9e4d547bcde659f6cbc1c9fff3c24b6150f29d2359dc9c036f8014387fb9b4018fd3b0c59923afd56029f4b7a405b7e37a283085)
  , NZ (F 0x45b33ff6cc6ec770853c5b7a22a281e0c93d749f26f65bb8861b310e3110f39848F98343727984b15b99dac424b23294c505895d83a3dfae92cf8ac5cade414757fa76609fab32) (F 0x7ddcd16f5702de9b76672847259933943b2b11a8887f4f1739c2a37e60628c7427bc220f4c7abf755e2b9a841dF8b42665e91727972bf7b90b60a3f9de87697fa9583c59e9d728)
  , NZ (F 0x671e996b99ed09e58f19673d53a6f5e7be412b550325ec31c04a1b77ae44f6e7eb65a2659f7251Fced42a8e936c5ef57d5f95734e4d3bcb3e9d00303a7f2cbb11377073a49303e) (F 0x7ca677f2e4c2564f6c0786fd29434c2aefba0bb6074c4f893bf3e56545dcf8dfc95d10c8bb4a7218e074247bd4c941d5f2f355b0c99697d1222361006edacd89f143287cf36797f)
  , NZ (F 0x5745a33ecac6de34a50f955b1ffc56ae7a4eb2fce18616f86beb1a3f2b91363a984422d915caee3da54c1e4c6a545054e80dfc3f3817d7fa472b00F9c5e0f0ddf50a333eb56dd9) (F 0x3d9d3f856d9a9Fa5a6b023b05c546dccad1a1f9110c1e6b6e243709ea012d548f64519dd7f315cd7d07868205eec038c0e735dbc4e430eeb53eaf12a0e4a8174e906c4e4a55b4b)
  , NZ (F 0x2cfae4592af570f38e541dec8dcca7cbeade7d892e3c18dee90d3e9b168351bdca76dbbf314a00a55dc85e6d382e42018b86cdd015959fdd570df48f06b23b23358db01212db87f) (F 0x648ea715e8b48bada7e967a4e03048c56174b19fb2e2988c01d2e94414de2c1afacf8ee93f06373072b600c9afbf73f7936c6809dbabb3d7695e80259dd97f2bb5f9ba1c5b7cfb1)
  , NZ (F 0x613f3ab3165fc71b004088117bceb41b3ac50dd7b446700011887a95b7c824faf76ac3404820762887ca179bf2d10a363fa3a20fa46ba2c76147be6b85f0f8c5f83Fb0e3a6488f) (F 0x2e52a4a35868f6702f312b627c7e8185352904698f54162718fc3c7d026e25cafd39e12ab306c16b341a35f7b37535f3cb1eb875d91c71be6d4dab6a248949f4db79fd02580bac8)
  , NZ (F 0x123c26e5e9680718c26e2eab0facd11727119816af987706036fb6b7aa175b1267f73ebb575d3c24a9041c67368e0771b324c30d12392f4f034225f3850bd74d13824b8e9e233b6) (F 0x62bfbb315897247b0547e62dcadee059c8074f6801dd5c0a3b43809c20de83797d61f3085c4097898ad8bfb1a73287ad4bb1ba75e701768a879304bde1c871d96b69ed26558a396)
  , NZ (F 0x14f26c7ffb565ffff35d1dfcdac4b26d3a17cc7a6b891ee80144b8635891517ba14e1a92a1363a4fb0a3a7bd42b7c7826191e8a9624122058ef67c035d433df86f69c7c0f20a932) (F 0x7b79b848a40ba4333473766579e698457a1c5b0288a7c66cc0ef9bc198199efa847c19297a04e7032665ab2cbc8c89eb28535a62410c9e63db3df03010c4714d7f7912b3e8ec1d0)
  , NZ (F 0x3b53b5b443F18f770bb7c999135f28271ab283a3674ef2fbe284399828b9b5f7788242cac75623b7d2b76bb7a4bda51abcd8149018269d7173cd3f08112b50f854ca5c30cb424c) (F 0x079af554472db5fb9c807281d3563aFfa13de9c895f03054ba9472aa951a5540ad0697576309b74f6ffdaf7fd3006f1c8d8e8d84399F9e885964d823cfbb5cdd8dadeeb02eea0)
  , NZ (F 0x105fdb39f97dc10cb83c3ed23f17e4d50189b87252c012d67dc1edb8af20aa91011943650d67c0709899a6c06f065f94fa3de9cdb2570779a51b7a4c50085d6446b7fc0f0fbc471) (F 0x2cfafce1d14283f59cd3c27493ec2b3c5aec5e173ac5a18a5f2946139c4fc373f8fcc95380c18abe21c037ce7f98c5106a88a54b3ab5d7a31d90abbb837931de66f625534803b63)
  , NZ (F 0x0962a184aab92f543807a625f590c180534d2706aaa1f75a42364e707285b3e5426ced41e7dc6d8a39db02b6d433714e931dc50fb928f3e9ddc4cdb67359db08dda399b6c1924f8) (F 0x71bba6c64295b24fc29ac4c2ebbbf6ad2c4c9e66a90c78462a90c731ddf5b0e46cef90c0a7cc0c3923ebc1f2984eb2d0a9cdea22e48a0369fcaf4e4e7e5252f38c2dd411866c57c)
  , NZ (F 0x1adc2f8701850d337327187a79350544d801a8dd8ad07a722a661c48b8633951b1c4061e8b58e33df7d1442cbfc6baa8310beabb5ec43cc2245345c6facd51939ed5e0cf6cf0183) (F 0x6ce927e2deee5079d4978707a27803888011d8453bd6adfbde5a1700d3545eae7b7fbd88939ee818ce0de0a3eaed668098c3ba4662ddc037796f510796b53c7df96c37f1eab82bc)
  , NZ (F 0x2ae01f9453f66cad96ce925d99241008de65b45bab8787cebeb3197eb14a9a4cc751a7d06f631a1bf5f2083bcc011684c5732d9a38675bf08da0675f62ac8a64ea26cf01557f893) (F 0x23652bc1ff40549F9275015064e55e7b4b7a18f5dc801e23dedc2e3d7bb98d56a30cad08a99057f49ca1bd4292af85230a7698d5d1cbab9977686416677d73f56c7ae26428f75c)
  , NZ (F 0x4985ed40c9e2d479ef810cd18159774c4645d248051b52a053cd4a3d3fbb51bd91a1ec7e5b542c052dbbcd63876968c474a0e31849867a27eb8b827c1fff4fc8a97e3b4ee515b65) (F 0x6bb1dd67e5d3d9371e3d981262e85543fa88701af825328bb36e29c601eb7de4a31b80eb79e5dbdf1f88ca73941cac2a8132890dfb0eb176e2da821f4f578323d79dbfb56d4f294)
  , NZ (F 0x2003b099d21cbb834990f878f0438798b8c6eb2edba0ff1bb2f78a6bb7e4863742daa9eF4f86de202064de38dc233f289a9d246515d33899b2a57abbfba48dbb15e2f71851786c) (F 0x45394371cb9534edb0605699841c12095344d233eb11868a16de07042e929beba5c832ea7228490c6f82d564c1d7697a70b6ae3ec9c8cdaacb4a24d5e88069b58daadb40c2def8e)
  , NZ (F 0x51dbF35c4e4f0db98cfa741ad10ec1ee95F257aa734d44d73c132da27dd7d1f2a5a44849a54c52836139660ac4ab3f38869724a64eed1cdc3a5f465fF73c644afbbf35047b31) (F 0x7bf1aabcaa2544e5b0c41c88b3f8e6c1eada67833436e4460b32863396b927ddaf56f6003758ea446190236775fc9ea2e6bb2354906c8258e2f847b0e7eb1f78358852453e154e6)
  , NZ (F 0x1c545ecfc87F687308879a5a2f704e89f71f522ee15413ebd4dfa0ca7cd38fff728df76aeeb92bd10169cda4709d47301b787f17e8f7f31d9acc35e21c73bee2c1e40e34f80f7d) (F 0x0417114ef4c3353c80c85a41e5199584dbf819fb4efc8071a78b2a8cf0898b589fce5abb37f274a4cfd521440981fba8219b0c77bc90651f6ea4bde41205e32a14552e749b1a6ef)
  , NZ (F 0x45282951813a86360a737f9477965cc4bd305862adc3601a0acad11322b7e1a5beaf0e4c79e4848b65c0aef27af528832ded33b268cc9d5443a9b8418d9e11e7d2eb27c2f00b6d0) (F 0x25ae41d2a6f4da08a9683c7f1fc862afa31a9ad782f34dbb28de2774799957afa1ea912e96db22b1e7966ca32f621da368e76d65c7111b81c22ed6f355a6a50586930cdf7d6db01)
  , NZ (F 0x08f3fb0878e600322ebadd5252d49c54518d5ec56225a6e6b30a2ce37d42eae0e4164a441a3a2b35d9442205125534ab55a731e27860a04df95a059347a86458300aea7e4ad2acc) (F 0x343a00618a92288c400f7e1537db087854d9FdeF7e5daa780048924497403aa847aed8df10d33bce8300fd94b6b4d400ecb7b80f7ccF1830c25edb545b7ddc4f6ea71f18cade)
  , NZ (F 0x5fc11a7570a7cabaa51d06a3459ed775ff37401286a800523630f27e6c40c72192790cae0fdbdf7b76cc602c063f2f71fccd7b5c49f9f698503b05a439466c0427ef243c098215b) (F 0x3cfF509824892aa939a8835368a1131c8e944fd4d7543999b6f67ffae815fc6786fff6e5d61b6e9e2688ffa96b46f869ea3be633b2ef90ce1e7e0e90f90b00ab59582c6958c2e5)
  , NZ (F 0x6c7a31663ee204389b3bb735bd596fbe0c1b2ca208aa29039bf5173Fadc932aff6996F1a8a778d11f2cfd500522ce5285f858c12eabb3ab1ad28ec409129335a7e5512d04df0b) (F 0x624ae2a1bcdf0ac2667b8f0d7baa59230eaf66d047363bd627c0170abd50e026a821156dde688000bc6416f4cc4eaade2f2167d53e8f7a65d4b5f4d2856eb73234bbcfbf1265ac7)
  , NZ (F 0x44d5144f422aa01f978690942398c036a4b52e1549d6114ea3fbd95436b32176f6c62ae132f8b7a86fa3361d7d78cc1ff9266d1b120752ca8009988563a1f132883c7b20ce70c39) (F 0x030270f5fc129e66490e3bb36730cbe2c4d3bd9a49c100017ed1c061ec6199df9b388b31773711cc8c31108dba3941832e5a92df80981854f9b1ee090eaa35e150486034e2cf76b)
  , NZ (F 0x71f120017609bac1bd5698c46f7a76b48e35ad80c444f45da764bb59db5fc4cdb522d10f5b1a69859dc990da9f52cf41eeb59354a50e39be818e053d9b91e8aa88665034ff25745) (F 0x5f9983b67aeaff7388bdd689b6188d007341fbf645e59d1d008c2e116ef712132d6b749a0b0622e76b8a028bd716d372d0434f780980993b883be2a64d4f37e27e021e1599115e2)
  , NZ (F 0x397aaaaddea38f915ae2957a63919e9b5bb621e464650a3d923722ce392fc9675c9069f8324e234c78434cdd3bc74b53e6aa31c55138418327a28549322d1935357ef3cd150bf9f) (F 0x6971e39e3305eda5f3a76c8c4a143a700a793f4130628e2b92987c2a18ea40e30538a656d231f7c0d52ff2fdf9264b0e36c51fc48d3308ef89bd96e18ff29cb2c86b5a2073ade60)
  , NZ (F 0x5d4303ece7d319b3d0087b23286c99546b0820c2e086ff2fc0897dea80af3e12097838e671cfa5ec60ac8f8ad6756bc22144d60685257b0666be692cdaf54404054f603e190ec39) (F 0x3c507596ef6dc86ef4f27a9d0497939d05f8d6a6bd0026bd79d8d941c694a887041c246128fc29211e70423a8ad5d738641ef2f05746c4c8ae0f80991a2181c59a7bb24facb94f2)
  , NZ (F 0x237dc5fb2c18aa357e982434c11a38390b932df0d91fce549d340c0b594ad53d2015b70f258e5940632bb3b1a4fdef6430ac377bb05a77eea6eb94e87f21b48b572178427800d01) (F 0x35d176ddff2190172dd5a0fb54f6e44e94cd8f76dd1b2ed60bcb114ae27c8e63bd40921bf6abcda5d76b1d891e0b6e00c69e48ea65d441346f93d802b5bc1523110eeafac36a342)
  , NZ (F 0x1b1a7629da0765d97f5f23f037ad384720d250150bf1cc1f206a20574553b32dd760a726955a5bfc4a32fc0a423516acd675a63d0dfab650fcbfc68232bd4e367d08a9c6a45f31f) (F 0x690c08f214407c90a073d39772f1f3a409c6c2a44640b002b48bbe76db3c5135c5fa4bf5697bd2bfa3f7ce78c1df292e8e341c072c8a17e99017f05a9c41613c1b569d8003be0db)
  , NZ (F 0x10ec53f59e1b9b72d0e8447d21b0b3427f64058a292ccfb65684403a153906adcd9e8ea9ade3521ca9be7e5d20796fff7a6d53f3e21bcd12f15a37bd14b3ff352f97c4e4f2f615a) (F 0x34fdb134c927026e4680909dc7f5a3bbf0207ed17f83d03904557a142aa7f5a987a9fd6e5152d99c56d0aeda6f3cce6cb0cd79452a8f88f055d030f95e0b9b31fb56d9cd2e9bb4e)
  , NZ (F 0x757e3a80f323c4bf54f5bd4798cdf34f94ec64bd2f1bce17fa4e6afc37e422fbd0792dd9287aacc4ad6892a2373b59112d4086cb64dc2083c389e7f93e359dd6389821ec53dfced) (F 0x1a7c7b0a4c752251455ad3cddf852e862fa3500a5046e8d7a52d723b207f0cf1681d321cb99b3e45fc935215460cde3251f0e91ebe1bb4de20071cd075b8225065eae2e10744177)
  , NZ (F 0x0de1cb1e08a3a48d04767c86861ef5bcf980900a884cd76283dc904d4de68758866e81fa05325cd67915a14453e16da06186abe91c3ee4fb496dbc57fc7b2c47ab1cd81556b22e4) (F 0x27732be84f1c278d73b97423ca06eadcca31bfFe9c1a7882431724fb6b54e11b72a7bc42f1f76fc6b7bc1c9599c28c7537ad25e642b4f40a2cae02c96779f0eaa9f76bbeb46227)
  , NZ (F 0x42fc65989d4e63c0cddde318fddf19c2384329e257c04f31cbec7e20d42f9c8b0f0805cf0647f677de6f96d49a78f9d0a29968f86a85d2a368638df1ea4086d12785301539b221e) (F 0x6a790daf1173ce89ce8167446e9246de56bc14b74d476b06be08e8b709691a44c74fb5dd0a93aa6274619f705a1ea90bcc29f59c1703f51a6877356deaec70a6b9fb86224880e9b)
  , NZ (F 0x71e30881ee50c7142e2c6f8b215933944d9081c6f894959a4247628c0adfcdf1d0ef6e61d9823346a8ab09c2dced825ecb04c931e927b992eb62a5506e5d2dF8b0eb103bc053b3) (F 0x429d926e8dc08d5b4a4b5c598c648b862de55dc5d5850a7b0e836cd5611dfd23587f8b7c34d8087aa17d469aa2a064ce2f8676f621b600d33851f71d084f6ed8e61daadd172433e)
  , NZ (F 0x0c726be16f5838d966631af9d0d77db0a411110f81bfb48f290b1acc6b01e41ee57d2dc674bffd3f4b7d2d9fb010b1eb1634453a31dbaca5dd011006760d61882622dcffd7c7b42) (F 0x7a727e7d4ee8b760825a2c689c0892938640ff6418ae69a863d3f5cb3eda2d5829830714d4f20f79155a377108a627b33397ff9e97db11f9893afbcb2a92fa92573935b95601715)
  , NZ (F 0x7f0cb44b7a6a440b487d81ac425e4004a1d0366bacf200fb0b81b682ac6b3484d5af2064d7264666a20ecF08a9F47acbc930c6fd8e15b5c9b535329da879eb19c1b120a7b1f6c) (F 0x54d4b68357bf2d86398c2fc43777c3e72a8d5a3fb0d979098cb62716227f5bd33df0ec6c328a13d21f63d1b2765f3094994e1ea6e31759b7c1c65806a59e35249696702321b67ea)
  , NZ (F 0x2d8685ae010ecbcb7d56a8ee200eba739cb352e598a7bf7539dd83a70f5813274d49850d726cc1eb2307bf837b7384485ac7f0a716743734dcbc2b68e2f3a16c229b319f37f2b7e) (F 0x5801b5f8e504754192869194F7ce06bd8de05d8474993401a762c011d0ddca38c92dc8a6f1fd510319bdd7e8a39f624884a8773aa1208f60e39f12d35bece1b6cf332c665e7232)
  , NZ (F 0x300da4a53800d1d14b90587a5a8560b1e41ae5d44ecb67d602780b42d9da5b4b5c4aa407b8e93f51e715cad060f2a7b2818a1b21001c3dc381f31605812d3740ec2f856af9f7e16) (F 0x560a13eaa55f9d1a60180bec949f9666ad38b77d89c188da060a688c91165c8d41c14728047f1e6f7622dfb866fabfc9055df147ebbdf3e96a70b49712f0219b7ce170564708290)
  , NZ (F 0x16ea93685a3bf520a830bcce7b19f8db6d292f187d85d79922e0e173f1fb3b52d714d72129da349420da1157898b6042b2587b248b053113c539cd01a60bf92b09ab057d3b348c0) (F 0x41e4f0af8cf2664b94951b23ceade60bb2b000d763539cfbe4Ffbf1f5bc904e5ae0f97fa6dfd8c29408546d74853460871979c10efc8dc5b6b5891a5c5c340a4f74329bed3a4ce)
  , NZ (F 0x7367f0F84730015544e16584da14a2de8a12632b3ebc2e2534e47e81346183e1fbe1f63aa5b91b2c583acaa4af2664941a0ad1210b2866a15698806bb5e70c9a807b92a3ced503) (F 0x3682714a6613e3733a5456d0f13368d8cf57cc0b19b6726d77dc216656b56ff2e69409f376698f4bead790eaead28b4975cad839803e9500fa0b495f31ca57ada1284ae2d70a217)
  , NZ (F 0x4b86d5b43bff8b053b7b62d3bbf2f302fb85ac0e4688a0d9c39524a76dba069b4093a93eed947e008f271f33c246105acf2aa5820b19bf8584e078d5aaddb11773196c6be802529) (F 0x6bd6dddb439b228dbF96fce77b8afb0236d0ec27da5552e9b80c0d60cce3ecf85cc7c0ad030caaf83500bdb286b7867ff289a0f138cddc8dac2d72d12ca3f90ae4088f65dd9a5f)
  , NZ (F 0x4f40e4b730a01211818049aa13812651accb63c4675b91b04dfc7776266e0ab03202181e788aad03b428e22e03edd9125c376b3276bd00c99b7afa315f31a1ba19a50c206a99a67) (F 0x5e44c275b165b33e9bdbeff684c639656c972299591703bb071ef7147e1073b43d941ab5ff57f122ae7ef70aa275312fdfb02704631e20d713c0a8228d89c364c81100d8cd366fc)
  , NZ (F 0x5b5a4ec714481f88796e9c753b73e026c52c90591165f83940b8c9b7c462fcf01304bbaf80b1816b01e9be137b707cba51da5957a493313dfdb2f40c33208d05bebdde3cb37b22f) (F 0x584edd65fcfddb222ba1b7fb670c6549c48de7fb8516ac02e19736fd9a3fb051994e337c1a1be261Fc80977652b4c7f9f7fd137511613204c002d3f164515e20298937e67d76c2)
  , NZ (F 0x12b7a4828e74be0837833a8b836f5c4e656c150e44de02aa689bc4442f772a0128dda9b7f8e08d1128305130821d9ac05a35477285ec8479ce9a1cb433eccbeb263c8475025bad6) (F 0x21b8713bd51c8206a6bb3c2e512be289ec5c88f51e923adca6ae92df07d3ce557dbbd3d04664c57fd15df9a0e0bfc470f36c82d8f4a7689d73878121a1c0017112218ada8f63fde)
  , NZ (F 0x7f84ced72a5ae052cecc85e316f7e0ff6d04735c4fb21500ae0f9384e9b33ffcdcd6Fca5321303b4324824d8983cbbf722ea48c914319dcc45781c3b0caceab513f45728c7219c) (F 0x4a601a6ec6be67ce19c126f4db9d27c02b08809bd70d589050177fddf85f6bd4776729bc7eeeceab8262928550df6e7d5084e17e2189362c10920b6a8d03b4c55642c2ef12e0dca)
  , NZ (F 0x5f167a4394a5a9e45c487d0c64ce498d73e39b12e723f41fceb7b32217d85ee605379864c326e5e1581c3f87530ca605caee02e522f3d3ec882588ca25cd97d54d3f692b76f7ed3) (F 0x62538ba829937d3eabf95cc9b34bF4536676a9f4a686f50a3fc7555236f39085ddf98de2ab5b61d22fc01053120799f40d7338d7e013cc430f68b51252e24cbeb0cb03d4a2525e)
  , NZ (F 0x257397db73f74d14577e1d076b0e155405b0f1e835ddcdcfb3294dee36bc6e927da03c7038754dca27e9f8a8c6476b4eba8fd036b45f58006ee04a2fd1a6c15ee87b8139398dd1d) (F 0x22e5cbe41b8171a82b43d309cc1ae3f16f136aa587d053f5887a5c113f18de3340bd9ea6ca82778728aff679d700814382e0bda7507428420251a739b097e449d79075d263b0f21)
  , NZ (F 0x73b0f85021385427ffad987247d1F21cF34e0c5f4ce1e137e935299add9d81d6a7a23fa4966ece686f0203cbbf23de64278407d4ceeee0b4d9b08e81609a789f494ddcdfa1a35) (F 0x7987392224e6e0f61439d3d18af6b09ad1a40d3b214393e54357f5bcf31a059dffc1f4fae3b91cb48ea52eb6b7d14f092475c0fc0ce4211Fe4aafa26d417d2e0387415d16dcb4f)
  , NZ (F 0x5359e30bbf71d2f4345f6a2758b7854506d3249427a640e31dc410c9d174b6f9bd49e52f8945b3225341bada70477ada3977434d0cdbe827b2992cf58a2f7b8beec1d8207fd0dcf) (F 0x2d576879c096a0b1191d438a3b96cd06bdd65b2496688e047b112c05ac885953bbcb1f46fa669191595731e856344493f9ab6887eae66a90fd6e41f6a8898Fa1ce48cbaf0a1caa)
  , NZ (F 0x315fba1881ccf4e9541eb3f3f54465a08995cf2a45df59b7f548a65bF78e8991c291d148f17e07d4cca24f49851307d81642e19025e9424fc0c6dd7ed8351416872dddf9cb7a68) (F 0x7236259b79e33f69fc330bf7353855e7624a0cd47d67e9538aedd99530da5b63b5353595a2759013c83d231e0d774fd129adc1Fe3e19c8f377d84bfaaacd5a28cab1e06e83cb3d)
  , NZ (F 0x5125d0728c41d4b530c099825be9c6441d16404e7cb5d5a53807bf1d9447e8a40d5f936a2457e602834570b35946c4cFd00061d1bdf357f2b5dbb17d362b4b452139df788455dc) (F 0x4f8cb683e98c3dcaf3a50d91f6bce371ab82c69a6125fb2497e935c74514dcf6623ea28407deee4e92698270f4527ee479b0b7ac2b1ab8b140a4ffd3c5257F8119811861269e4f)
  , NZ (F 0x18bdec8657f05873730bd489c03786dd9F5a5470e9a4437f9F087777ccda60db9ac57c4facb475ff5599236a38a1c7ad3ea494dcfdd0e0f04333347066e297d0a29bd535bf81c) (F 0x1e9a0c8e0777a5be3a323a218aa39ffacb28820942f0fd84a903e88482bf52ad22673396495fc7fca0bf70db65a347cd52f38a39a90a11cdb98691345b5ef367eaba30d5032cf26)
  , NZ (F 0x0f9ef22ef92ccebf033d68eee7b598eacf4c3d6e3204f206e0b0ff08bc7bebe9ee1f391b9c6ab94ac08a4963127a17a5aefc6ae440fb4f19a116e9b9b73d20b94acf187f6ebe441) (F 0x245ab22813d398528760bf627f48c744e861938d3cbc494c62932df73a98aa3a8de41393deaf8076ab64ca21e888f7ffaafa603b0ce6b4670a3e23b98b892522ec5a069cbe817fd)
  , NZ (F 0x25948137e36436b138efb771e5d19bb28dbfc1d07e8c48d38e7ea368765fd1ede5a56a1bc766167ea98dc58376dab41d3bc4f7bd20011b0389bd5f01111f0686c0bf1eab65fb25c) (F 0x5b3aab88c9163f1bb4666d5d001ca65a1ef619c9a5673336f9ceb800a1b7ee35ae03a6dde930c4098d566ae21706d74b55e51a6c1f22daf5e581b3b98d9b28530d360fc74f10232)
  , NZ (F 0x59de934bf3672a08b9bb2186a2e97603c7d0b0bee8eccdf032571db83c3bbd0329cd8bb03d5e01e1728bd8eebaddc3a300b0f72f7c684b6053e0975be44582ab969de73a0401017) (F 0x6d06948a0482d47a2c7c4128d5ee831a30b47314edc30180ce9aa7b9069671be93b1ee31f26411cccc7a57c39ea6271b03d9531c43769dd7b5cbaaed863fb41743804fd2a1c3166)
  , NZ (F 0x7a96ed1ac1d354bf97aefbce94310e45b8707c6150f77e3445e64a4f5cb98f10eb5a0125691d38d05ffc886f7aaa292ce52f915152e017da17266eadcb870f8e608e7626d24f4ae) (F 0x1c5a4e1e746f9bf97f64fac8f7a10813123f6ac47ac4b9df6825b1137d2dd6f251992e5d72974e871168e9536a5eb905faeeb014c056abf65bc762c8775e1f5776d707032aea19d)
  , NZ (F 0x790fcf9257801b28eaaa83c678fd5b941e2e96b06f19367de7df86f8d2f1b1f3400F8cac128e184b10c299a991ae350074b7636fbc380724190f8ec6e9d2d13aeb55e44804edb6) (F 0x797ba3b03729b69ece26f2c04173e615524554aa5c78690ae03c35761ca1b064204cc18f6038c664b75e4764e38f9ab31cf1585d4092d54681a0555a82f07c744bfafcdaecdafd7)
  , NZ (F 0x29e339be8251ad2dad6969d1a2fa1fb9a022a5bb36719d0b54c9c075ea93e128d054aabbeaf6b9f54ae98d97896d547b97821ddf399c00abf455e14e18bb79952587477ac0730c9) (F 0x23bc1c1b9eF60df0b63ed86cfa97d801d037c10c80f1f4e8c5ebd36abed3268dcacc05be80b057777119995830a36d548b79d3e50fa8d3d397f20effa4b3da9f174a5999Fcf71)
  , NZ (F 0x037e7587b5723638b315f0eb2a53e99558a387d0ae8be384792d523cf14e5c8cf4e9a2f032b4b055c589d590e681cc0563f1acf5aa63f41bf6bfd5e9c51781afdd0c509040d3442) (F 0x310b387eeb512951177de1a744c39b2ff195d08a536dbf11ddc691a51d3950cb869e4959cf2bb9a3a243c606279eac12870a3ff4c1f2e115918bf47dda6ea16b1b4cddbdeefb59b)
  , NZ (F 0x2b8910934e8639d37813f0291083bdf513be9b15941fbc33b2a3d76e673fa95e8d5f3a267f60333dde0504c8c70c2a7e98e53d4935c2ae0e78543c99f90432ad56cb9bad3278ed8) (F 0x01321f2fF1a5e6d955820776f356a2ac960606dc190d08f4991850c4a140106d9df3acf297f0f2d3c5a7c7e87e4b63f501142a07f18a4cebaadd3446dff48ea9a042e34336345b)
  , NZ (F 0x353b9c4e8296922b8eb3a3b00aaa3710cbf1ffb2ab92440e1d0553ec687a69c083aa53c7c31d410203aa17ccFbf9c4b13e5bfc6f8aec5bca70b387ce6d0e2f8d942dc3c94d1397) (F 0x4fb52c617e464b7f347f409a17665f664be51d500412a36561a29724f311cc576814e25fc62164913b5a33a45262fc5b243e146e4862f72870590175e2ebc515e57bd45760bc4aa)
  , NZ (F 0x24a41106c260b91e7c0946a118524c6974513a7a35b791551fa9ed9b6173fb8c7c263c9b1890a3d23890320c255cd3ebfcf53b100967F859d9271e37faaf1d389480f696bd4009) (F 0x172a786f79b09662dab998dcac611af3350fdc3a48a9972db13478f9193a2f2323a058239a940b57408ce8e693c533eeeb195880a38f28b886b416eaec10f503d757f7a3225d276)
  , NZ (F 0x0a153eaf7bb8ce1f7638a5506a68c19e021a853fadef1ed2a37f768a6ca9dd9757F2a2f36be51d4dacdcf4548f62b8778cdad6a4d05ef6b7278e3c907d254a9a022d411b1d67f3) (F 0x07a0073938686ff26a9c76647cedfa2411ed69e3e415ae037c336e0f8749dff038ef7e0aff59135f855b6c511b061ae9dF1b27fca5732340ec6e4db241af56e286a77bb661334b)
  , NZ (F 0x0250641ecbfd9920d0488621602244d1107b3caca40f4a32a48649841a851739087a4b6935dfcb658a4ef07b2df124697853361031b86f1b3c37b9116595fd2f81788e99ac4a845) (F 0x0996ae085ce20c495f5d0dcb82e370cecb223e2cde3d6634f6711563d5f750ce12aded72d02f9c94a61795d1930209d765ba554a45ffb59db30a3208408abe664b40b629afc9c54)
  , NZ (F 0x4e3cde035286577ba899f2fb9a95253afdeac1d7d4ea0e89c1a009d60bf79e4857e0ac0bfa89Ff521f3d329b257a712884cd27f7e2c039de9d37e2F92527ed8f7f9c777c5aadc) (F 0x6614467e06b22147927e68e5dbe3aaa0a710519cfccbcbaabe6d110d54b5ac6bb12f3b2c8c97d1a4cd5bdf4138eF3e8593f1ce63b01af6ab8704b479e5ce908e5ad0939c510d62)
  , NZ (F 0x1901ded9c7b65dc1068c84b6d5ac3cfa15e6e61b2788a2592094e2b4455cb2f6a99820aade15ea1e420a2e451ef3e385d7817149f02d42d27056ecbbfc5560e4421549cac29001b) (F 0x6cd583ad69c2f271bed8aea8efb077478d61ac4ec3a9f0b53fF406aec468dcce079a1dda0f12ef675dbc243d263ba642029214be28af9e4679989255831649a3ee8d4bc2cc2c16)
  , NZ (F 0x536ed0052e2cd4ced48fd29bF13826737bdfa1d5be65d3db9f93f8cf9c033b2add2aaa6d821296b6ed5f047a8b470f924e1d6e9255c5ac0f8760b79d43f2737e8f654e13f49c76) (F 0x226d8fbb38b22c259a86393002b3f690d3e13a480a093fad41058776cc69f72092dc5d078ee9b99294d9625a8755bF06695fd96e36e6a12da3c6769d676ca8db54cF0ee09eec2)
  , NZ (F 0x3028c14640c96c0a52f9bcb44e0c1230364fbfc1bb1aba5cdbe1905758f855843fa6e77a252037fb4c3e8954209c702b8d24F98b18b151492c3294be1f39253c14f316da0de161) (F 0x22acabd0e5ad23d55717ef7bed416d05722d15F04791c2f594d1fdff380c06a4ab230df22377e09d25037b62940424a38b949e8280ed3d7bb79c6d58ca45b385fc0c101721bdc5)
  , NZ (F 0x77cebf07cf8a559ebb581284fbd09ab13457b4e6e88ad4634961bdfde1d758f2c96089177b6f203e252bd42ee031f115c2a1663f3dc57d98106ef0d592ba7df2d5d0708d6b68380) (F 0x37be418360f056b1716d6c3bc6fF31bae88ae85cdead7b4e7250d36387d07e6c21d15e5a246721f9dd3a4322357ef9eae51394cbeea41708ab8f82de2b94fb35b2734be18e6147)
  , NZ (F 0x79fb365ef19a0a1c30199d42c838617250788efd04e6cd3c7cfcbab459e4e4fae99a11bd81f459127f2097a2a5485972c395d869eaceaff8c202390d79ed52dbc0ec4338f122083) (F 0x0e1a39a6650372eb224d912366fd08e5b3646081dd3b649f2fa0092696b2f17dece1cfd53e3576f2947901038460bd86f1aa05170938a2584b719f2a3ec16113445b33e6203c9d8)
  , NZ (F 0x55dd7b0ad66fa84c1b105253dd9b5026832add8a1da91bd93fc41260540f1d507df8aabbe560be5980ab93caaedb5a93705d43d6259576170077c6fd869e740c18c72865610b9eb) (F 0x2d72f9996c2d7b314176783755e5a40882d1bc6e8aa01de6886694a1c7e5522fb8a134abec7120c3227a840d5bc0fa913735c8a26edbba393897b81603F2F3982d4879dbba92a)
  , NZ (F 0x1cb04b224b85d42d1c72968168d76c8c9a14aa1f949c778ff9e372eac69a1144bc59139050c6d1ff62b3b32a4e0991cdc485793aba33be7cad4e217ed0b6a39507d216086c9b418) (F 0x6a6448a91d36c7275fcebfba56fa91d3370f1608f392d60683fa2b312be092dc1cb5c2df37ab2dee5c1e6609b38496b66c16e55e3301a5ef280876579fd9943d8d6eba21dd4f1e2)
  , NZ (F 0x672a396da1335476d238c634f24535737d09e4dcfc422844bea556d14ccbdec5cff6667d3ac10583f376d3432127c5ab0af2dbdb5e1ba68fcfa854c9df9969b16ed148388c115fd) (F 0x60aa824f7943223dbe55e6b2a0f5ab39eda93acd3bdd1ac91f8e4b1a825a00a8bd99335c25181a9eb2a2f00790728743a8d646baa3b5d0c6199fae797f41ae0662ec3295882ede2)
  , NZ (F 0x39e74efbd9db238531e833f6056ecf0c9b5320cd3a80caa236954ce84a742eca53f73d13cbe60477acc1b81e1bdaa2224ebc8424d839a21c395d2dad6c491d65bbcb1b7db12f1d3) (F 0x0abbb65ee27989d420f3392058a094f21bfb922c7b5ea5382bdb342d12675abf61a1f7fd11d8124d41a5c0609759e6e1262eabbb7b85e775e2bd97afa3e008200075213b3106b60)
  , NZ (F 0x0d2055d690b9397726ad8ec9de385a0fdf2141480cc29777b1e9ecb96eb44e03d0f310cdc9b7a8dF5784baaa3c63ac5ec056186b8ff669d8b7f542f0d280ff4500522a602365b4) (F 0x53526c91a2ab71fb76582151504c1a1c94cc6ebc197d018b1726641abce3218a2dc07f93d68c89914791c5f63284e735d9362fdf556327cb7231d7d8babedbc9b589b9450c8d4f4)
  , NZ (F 0x711ee90e2135581e784e24c2cf7896fc11aae34d02444f6e712a74235097bfc32105f0323bf3d688ecf6518631c4677ad518d68e61fb63e310e79c1f06312adcca30019f187d436) (F 0x5cd27ed00ea43d081b2e1e86c7af38e1879690e305f7a247ec64f53b566ea5a9d461587aa378644f410e50c1edbb4ecf6a284d787ef4734823865403872d78aaafd14f06c3e64a7)
  , NZ (F 0x4abdd808cf20bcad18cd4d2d792f1885154f264676e1651e0a22faccce55960411f601c7287a6ee9b149a533c07F517a38e2ac39c696f0b9707334a73a097bbd88b85396bc2710) (F 0x22f0a1a9fa3686b5cae144fb28e9f0711435ff294158581F430f7dc8f7c4b2a3956e4ee57286055dd40b91f7c4abc8ec23964f7dc329f85352Fd486204d708cfab08b1579a182)
  , NZ (F 0x5f258cf2aec6add6c043f7861f5ba200c40a7f15b5c0a7f7F356919e1dda3aa99d989c7336aaa51f5c2f708c05f9f676e74945262d4a70Fcef26Fc1eaf6de9cce952d9dd9956) (F 0x02522900bf9fff8e11ee9e6b5302134bad383999f2a6271f856ade8e935ae87f564d691a7759f48444d256a5c363ce235a39622f1f49389fc4f29f83d686405e35e41d71854e0cb)
  , NZ (F 0x504029f9701e433c11d4433b0dc1ea7ba5c88291c06d1fd4820dde01c24a4ce25b74304cb7e7d0381d5048cb6daf224c24034be60944276a53c3bb9a38664e6323504b438ba4c3b) (F 0x3bf0236364a982a9afad7648491cde3fbbd130e32a02becd75c043d3a8b4869028542065d6e2dd9eb16c28267d08bc5bba0428d5a307221e6595e6dc07df1dcc0e3774c706a9e76)
  , NZ (F 0x775589b5557ed1a20961d691a4ca07f0510512e87c16228b42212f9b4af3c49a380393db2e3106df06ea4c258a271d593356e5634956c061c17a5c52f7c44a296c21580f8e661d4) (F 0x38afca621805858f4bf9b47162ff98bF1960bedab935788f51251e4F8650b0b3ee5099c1b38e185ad673f1af27b002411c20fb6536Fd0ba702ee07e1b48da9307c484bae834e)
  , NZ (F 0x3f43a457db269562aa142da2b2466eb43efb7aF51cae1ff0c2f19157f5a5384081a404221e4005a69e839d16f77756475514c375fa715a9a3bf807bff3e2901052ba4fa989d72a) (F 0x6b5ac416681ac89312368f54209be6dfb64922ce7d1dc83d93f99096e974af1c9b7d72a87d60e6bf8ce6df0f10adbade4154c9c5b689481cb9ab1b5a6456681ecf9b5ba278cbaf6)
  , NZ (F 0x79d8e290b75a9ddc7a2c03eadedFe7f17164fac958cb0fdb7dcf1c0af6ac04a069d235a230cb789effa50d1b129fb8885e33814a793184108ea0d10600a9f4b79c553aa07aF74) (F 0x05a7a22330536e540e4a3a4e2c0305acc52420e0d9b6bebf123747426c11f46b7dbfc88ede95355d735261ca8ac350eba3e5a5e52879f0a16f843076fc2999a706b824f036bb9a6)
  , NZ (F 0x0b05665f487cb54d4f92a574c992c72d2d1e702ba7ebe79d9f01f8c4851a4a734ed32df1178338c9f3660965d90b09e403aafc30532dc10990e510f3646bcbbf77f148635f7a9d9) (F 0x323a6c0fb5e7214f60261be63a6655eda8254de575944c7d26Faab76ff6ee0221d24b3f33f9eaa27b7423013768cd65e668b32998fabd694ca482874fa6c1299d7873da57f02aa)
  , NZ (F 0x296e64b7c0c9311bedf3358ebbd28b212cc0c4945993477f549f3421a9533812c0d0aa7a45c5b415e29dea0877e5b1b0601bd111a18c16a5990e72a1dc4ce76f9d056652985ddf1) (F 0x0b81b340c3415a1cb9187004692a302bd6c53f089f4cfb8e76c865a17f56acb3bfddbcaf557156e769cbb98d5917ec0f606877c49561d310803bbc5d0ecff1946f3652a3407b495)
  , NZ (F 0x604231bd97187888281e3e49f38a7f103882c7ff2f466171f33da1da82d0013fdc9781575a4e4cdae3d7579e3cb46366bd1678e5e3782ba6151f36a8f1467d4c967192f13469a80) (F 0x240598810071c6115c842d21ec8ea1ef586a01c1752c3686700ca73f457202a731786b64b599ba7962ff8c3a4cd66cabd03ce4179fab19572b398d0716a00219ca90669b6904afb)
  , NZ (F 0x356c1067a64316558ec0f45a6ec0aea1d8e40442ddd47f2d1548f8be380e957d16865db62e5ebb20f0d4b27ee474414b15f67961a121496ef97503b13c62a3d09cf2c12bebe3f85) (F 0x64afcc31c2df0818567468384d637660d3da95bb35a9302dcec3abebf0594c59b2c969fcc0692eb0e9179368b971d98bc0399b420a225dcf7b9377cbb9008ee802f0738e88b9e19)
  , NZ (F 0x20b65e3F08c0538d3e77F92165c68daa29e995bb8da7bedac5681bf3e0f119bcaa6fdf64258765f12308b385bdeb9fa38da681F524a51f7a467e6b6c85360f88ddd95228b119) (F 0x11b8817e80ebc647d17fc073a1b1e58a5F0abcee81eb741aa4097afd85b44e70c54e88916bce95b5f0bd6fd0f4c03f781bd4c2b8d5c1648fb0754a2d3915999d728159eede24a3)
  , NZ (F 0x5ecc7cab08731d0c422095c03bb31b965591cd3f3166e211a7631089341a908d796376ec8e3db3810397624854b3b1e283d5e2f3e34370234ff3caa6a0ef6efd7690293ea9078a1) (F 0x15877b2c9687f5fd4496c7fdaea28c5d52fdd5aa3a95e30e92f9779ca40509a34615310ca76b313970f5a815d7c6babb7f2da11fb00dbd706de6000eaab639e760a7ab76bcac91e)
  , NZ (F 0x4bb68d4eb60a34edb8c8e6e8ad47c80c3deaa318f95e1a897caee0d3acb35ce3a4904eb71b290caa060e1d5db534272bf8f88d11d0b292592534cd778c7188e6946d98cacd5d8cc) (F 0x6548de54cb8eb2e8808946f093100575dbea3e7bbbcd9f93f380855fae6f4c116ca65fcb6e20d74ec50d8eF7c345d4b98fb411d09d061fde75Fcb92ea72d9aa815b02e9cd1c3a)
  , NZ (F 0x1116295e5d00f99a03bc646acc90e39a07178349228b322ef62ff5d98025ce1e59377fafa47a58271e377a545917c2e0392c690eed81eace986fa0c5d93ff1b559abbd902599ca5) (F 0x016112c3e8ec657a84b7cd6aa5f9e1539d329fbacf8317119745a902c0145ccb9252181c596ad8959a7fdb9cf6cd044dcba40e953e503f7957a106936922b4aa7e88f76d1cb1d85)
  , NZ (F 0x26b6a409c98e914e891c05e3f0f9c852f3af7a721f0a55c5df637d0434629eddff41702fd64f8f929ef99adcf562fd02348c930dd90c2b4a2a4f52b5d57dddcFd7c18d602300df) (F 0x49c4c9ac1a84eed4e45983de0cdb967920d5c63509ff8788782515c7842b4ab554238b0dead3a1a90f965aac8d22fc08179321eef7fd5f5a9e375389e568c0c91F34912029ce04)
  , NZ (F 0x75ee179a569388821bd0207d0662d289a8632db7a46af068cbeac0970F1620236fa6e5f9f7940e6e52651f027747f89e68f63160160cfc0dadbae05f69d8fa650a102f4ac6745f) (F 0x47e19717934e14aa64db8633b6e1cf660e3332bde7bb04e3404e8500410a36455041684ed13ac28c47a6c20e342b247a277963d74984a0b568eb3a4cdf1e807be3c49721d275a83)
  , NZ (F 0x07c7dfc167894ab06f21ebc8e74a6796fbadc457e1731e379e2cdff0c027113bf30c0e5bd53bb7f35e6ba448ae7b19a057e1aaa8ccbaaa917da6317cebd6b5a672346ad6a847fd5) (F 0x141d85c1a589ce727f7f44134aa32c07eaaa499dfac6efd83c229Ff8401aada72229372dd78d8d56b460473220573288f25c3b7facc5d6ab7b01368c68370e402a6c2a6d05c9d2)
  , NZ (F 0x63d5ac83e688fdb970c2aa61d4702ad326c63d6f888ada88e720142ba7c46206fc30e8954b43cff74271863bf166892d81270b18d8646a29e4920a086530b7321da7153584ff6ba) (F 0x5e6e68a734053e087d120323f009b2a8739e7f1ab01ed39457818564a2331b8f48a76b37Fbaa680ad3c361848cb0b46c8e7e62762b0e8f61a576d002ae5a0b493956b6f165e5df)
  , NZ (F 0x5d784a1aba718286cf487ea2b522c4e4d65ec0081d52e831850043d70ae884f693899f06de5b51b9ae06447c5fa9b9f700f245fd7e079c9fc9af08c785d0c807deb8f570482a2c8) (F 0x683b279d38d180Fc6480b54679ae33ebf1eaea474b6e1d15195fF4aacdd216716d508b584b9dcd96c0e258ff4c9a90a8d442ef8b0712dbb7d877b911fcba2bfd388b1fF5f287)
  , NZ (F 0x446c3b56323053c1faf9fb4f4cbccba4ebdd66d41b8095e715f35b9782c5d9513513a12185d3d8e11a654610ccd2eef1bc0b53886343d90eda3b8ff60511d3162e8eead6ba3ef40) (F 0x7221FFc0d05667b6db875c5043be112897e36c8014aedcd0ffa8b462be6e81b89f114ec682d32445923ed9187d25ffd63e6f2a6277930138a06770e1c4b7ca4b3c231a863ad4d)
  , NZ (F 0x2ed3ba283e9fd13ce5344c724b5bad55b0908741e3c2215a128ae52769150756b120f5dcf52f1a1097c5763ed62c9ae076851366e78acc96478d25a62aa38d5e2ea88742683e838) (F 0x267cb2663a53c07de79d38b0bca7e132b66eb73d0c200396b4f827ac6d2c492de485969bf432ccc484c6338a56d532930f65dc10b9e9f5e14bd01dbc736c9fc5b8eb6650f90dd27)
  , NZ (F 0x250dd047910bbe931d7f83e682bdfa87d3c7b2ac0dd4076ab77Fa05564f5f3be15fa940ae4ede244ca1d9946d1115e81a704a742748b676d35db4e17e442d718d6193c32fb3a24) (F 0x01e2840a9e7f386a33ff084f161054b96919482bd82dd34dd3e47760bf102be5014d875f40fFfb37caf48a4769f53a6e252d4f4b776a7317f37ec4F4396b7ce98644cdf5c9ba9)
  , NZ (F 0x69167eda02e1091edd7e9cf043d62Fe36372b396da48e761b8401fc9fd1b3a7cc1a69f0ee7fffc2debec125cb0363c889a239408e140eecce06b1674fa682ba18dd58dd33173d6) (F 0x152130d2445cdd78405dc049b093bf150303942990362e0b8f70551c2f85c22fbea744aca18a3a5d7ab16fF95381d455c5417ce1e3129ccba9551d7ed2b2603ffff21bc8dd5d8f)
  , NZ (F 0x28e3c50988240558c72b2977db81f2c5ebe52f4a75501e27ab5564222a70b7b61b6ca4866bfc21ac1ef994e4bc8ff326a941b06a8359c9ca988b7c652662a2207f379b77cd6a153) (F 0x6e478dab85ee60273b263365db59055f6eef13046df0e13443b7a3ee2835d7ac082d08bade5193080f686e15e2b92b7042cc2e02974f6adcfff21c34fcd081c9d7a3a16c412de2f)
  , NZ (F 0x72b043c6f3fd639c263edc39c3eab0e51b39556cf26f76801258fddc15fb739123c4efcc407b94a6f0c3a2424d25433a6037647160324da61bae400bc350d4089b362beb75f8b41) (F 0x5b7c97380810ed0652b9bfc1ed3d12d3941d75196af8b44129af6a1c3a4606b359126a995f51189efc5734b3cd3b9b670d3f1de7385b3f958b2e504Ffb00ffda2906baa659aeca)
  , NZ (F 0x546e349c35d9d3430b6178c50ff3f4fdd81924ae706d2e4339e37f88348531f4f9F03ecad409966ad01b660195fb5e38bd3ed6c5d0988cd8832749b5d07e4986b216734aa98692) (F 0x0649451ed92184ab690656112a815459030a9df5cf4595ab8da5f8c6c01c7ee5a6c7cb72f5ea21cf9753cf073f9bd33453825f4e5b93a2d1ceb134699b8e8a61a6aac81aecaa8c8)
  , NZ (F 0x45fc0750Fce3c935c933a57f6bf46bbdc8ab0a1cf7500a7e7aa900038ebf69fc4429b16a8f651c3ea86903185acd4b917c01e06db80b70f15fa505cd36473dc11c2766179949ac) (F 0x0f1db535af9fc8173a8335671209b9037508fab56d9125b4294cb08d7e1878f5a851ad15fc29c9c4c842481a1d578bd88c43cd7cac0109ab4ed56376f570a02cb765c52a10987e9)
  , NZ (F 0x365d16d6d1a64183bdefc7b7cac4996e68956fb8791061272b41258ad71d276491bf69b4d6534dfc00ad45917e0ab8b71c2a7581adb443917bf14e45aee0547aada7d697748b548) (F 0x2f83d51154f25f2c1a4676b86b9393b1262dbc8aabb5c63333a6141f1fF6ff47240a3642bc5218405f1ae03b60066bf334d8ab28606490e04b78317c470bb609ead54957627aef)
  , NZ (F 0x4e7fcebf36244eb3abc32283b9e4af9e193afd3f696678d18eb59f35592c1f44de4c1e8e6c5942f17fddeccefca1a3ce9e0f5e274dee18c152d679a9d70c4cfc0dFd4885d88580) (F 0x34cFc87868b6172f25038d9342ec5f75a6d5370f5530579512ec206e25c9130629036e2e3e6cefd9eaa7c2aff5517289caf298c4f142e07e8324025fdd80f3fb0d377db72a8045)
  , NZ (F 0x4f53671973d2c3d9edf26bd14e87117adf6287b8475b73f612282897fde65eddd0ae7c6fafd49661fd95e4220330bbaf597085ec4c5639dc3a9439a88c6c98e85fc7ee0e605f1b1) (F 0x5caac7d22d272aa197ef3368b65c942b505052466a0bcc53df2515af3fdfc3667020015b3e718ad982e1f8731F2aec54945a02433c7163a31100f38ba3b624575ef374a84f7854)
  , NZ (F 0x6d3b7b8b2d7d8227ea673366028e21a9008b04dbb40f5080483d7312b8fb31d8e4cbb020854d26f1cdf772de81a0f55Fd34a4a0193fc51db1ca429dda0618de157cbc5fbc0c7b5) (F 0x0cbe9c3e555cfbbc0533b8847481014c42cca111bce71aaa69744351e6e69860070028c5c65b023aef9cb2204814c23ba2868ce5e3b6f89110789c4708fc229f4b10e30e939fcc6)
  , NZ (F 0x0227b8ce16fdbcc9d128d566ae50bcaf838c06ccad3d9a14d6cc57e66d9e60afa72ca1840e4aa7a691d06398b33d8ddf9523bd25df334f01af000a0148f1b599ac4522a13e1daca) (F 0x2c5f05331b8db5b2128cd39859739b7f2e6e8435c98a4c826e7e8b5dd8ba05c447779d02cff1b1d034d3ee0088290645eea0c5613765f280b9bf231e5c0fc6ff8ae7ad1735ff517)
  , NZ (F 0x4359f7b432f9cc7a7174978c0dbe393d3422732f1b2c76a0e161b381fce0ca235e8c7ffc82c93c39a7cab198965ac015672111627eeb14d31b34b60de2ea358482db2c2a0656db5) (F 0x612bde975a69d09310c69d3165c910273b1d99666ceb475e5de328268445d1396246c5805c5ca501855ec2d02e91377e7ea4555ec0cb036312b2c081871ffa242dcd0bf57593627)
  , NZ (F 0x7ca892f5fa9d62d61b4366ddfdbce8c7743d7fd45b2290853ace2ee7bbfa3daaddce31197002d0ee882c3ffcccbaacdb1F617be29c588af2b0df1490379283af8fd291091f1547) (F 0x10d1d0bf3d4c3d5623c84ded0409078ad4134976fcc54deef03d4819e58367fcc544f61ec63078e92dd8ac729078d0212a3a3bc8a810e597285350d5b00fd9998ef1d46f82f0a78)
  , NZ (F 0x2eba3612b2805ddac9401bf62f968e7fafd73e72fc3F6124b823820e2c0cbbf0bbc576cb877536952ad16a0be29cfc75b2b5f4cbe3a9e929afa9b31e445861a7f70307bf547e7b) (F 0x15947eeaa139e6d327f5fc28474b4c43392c840a24d37516f551af0f088ca5d1ca24e489a4c386aa4df4efcc1a5d112Fe7eec379c76bFf77934a2365ab54903a6b860d60Ff41)
  , NZ (F 0x0af93eda366d4525f85ed1b988ff3c1d5db710e2ff3ca902a0f122d80f21e0e4eFb244de845908b1b0894f9daa83e12163f044242ca6b10173036b8bd5dcb1647f3731502be500) (F 0x331ae20aaee9bc061d40830a6a257e0bb523abb561b51bd8da2f3caf6ae7f3b71c9c6db5f1c9b081fc70c1b1e8068d31aafadeb5de98b056fc294afbd72300ebd72b6ce4bc18511)
  , NZ (F 0x78df234cc31ed548216c38f32ac3a5168097f63e22c2ff5c9db89d4b62dd84fddd459884da6b48f06afa8f077b698ec10e2d45a6f81df304063a094e67460e8962bbd184bc48cac) (F 0x5152497bf7950cd6e698c897f72ca62c4cc0ba0c62c9cbb49cadfa335d917168db5952bcca47d5c2681fb33b958c29a5e18c968206173caf01159f4764ae5cd8019df1cadaf7584)
  , NZ (F 0x1980ff1364cbaff6d59dbb67e5b9c441af672b13d938065e766ece91bdca8cab71aa4ffb9a61a92024e094685858d7922a261bceeb9b80e61f22b3f2a3a30a544da18d4Fef30ad) (F 0x116fa0cf7ae9b5615e5cbc5c82e2Fb024966c8ab10d459e758c62b43570fa1553bb4eb86207f216840882d3de4ea3a3c11998020c192d2b456abb5b75f1db482d79bb1dafbcaeb)
  , NZ (F 0x4bc9e353acddeb147142bb4b0338415aabd88ede94740f0bccbd2324e70882856c76299d6ddaa9edd72c4f4c5a4089e95bd087ef96ec109bdb3d9322a908edcff47bc3747d4eaad) (F 0x52a18c5949ef65bbd9ae6c7c7d2fd5c0772d64616bbf3b858c903a4b0427fcc9f1844da363949b421cddb4d8f27a700336cd304338fded128836162a1a0ee3ff16034589b9d0bfc)
  , NZ (F 0x45b3f71cd9613288a3d32F878cd8cd636327ed57268138d4cc9d11a560442ba9a7a20702a84358099f260b6e94f1837ad1100cbb4f72e8ab7e1bce6b3c4c867dddb19e22e57016) (F 0x4524cda3cdc9c022b1841d370083bd68bbdd11d5dcb9677fd47e24b4f73dd0bdf1d2dba255153a0d421f2f3e5246279b9ed70694e49a883e7700c664a10a268280de0b9afb91c09)
  , NZ (F 0x02840c70f63de4c8f1ef8519e071756bc5051ea20659F117979c95df7dace65370aaf894a1d3345cca79c09286bec986924a6F5523984ce5d6Fa9a2dddf033de9832821F80b) (F 0x295c63418faadfcbeaf1dcebd0bbf04c32da3dc8ee4d4e9d89c24486ac03e0a3805762ee8473ebcd7f362a027d1247e53e9aa7a5F017192c40b712dbea96af2e00bbe8a65408e0)
  , NZ (F 0x2355d72b024bc848c42c7cff7971a616cad27bd1172961a13d687affa6a69ebad48caee32b1dc3d93b6b74aad589b925ea6122a80462cb1b2c8c08eb267dc1c3ed240cb09a1e122) (F 0x548e1c088cc867a6683141a46a333b0c69678ea4efcd0208c15a6c0c4cbed75d2f5cfd14de7f4b4491b0b9cd02ee940e45a30634b52e3a14e7481ce887003a2bc8b70d6294a789e)
  , NZ (F 0x30420796fddd68c49c948b7d1f4fda59231d20c0546f3000d2ee663f765f0614485101d82a76b6c4fa1fc2fb5b4a897b2f430a435dbbb568843e11d159081d04c5e4dbd044940ac) (F 0x356c5c5e903021c1ffa6b7bb34f24ba07c072c6351a8eed1ce58d8fb422e63b24f1a14f1a01e9f10bab6c78805188d7b1bc6a0473F107dfa1790fcca63341144a12ddf4d8ae560)
  , NZ (F 0x6cb6029d26513e2ba68f750dfd7dff645d9390673eb9052b9878bba1ff3fccc87ed8f9d6632ddc8f5bd03a102edeacbe37c8a6936158f111e0d12a9cf7d425e991919413ea8dad7) (F 0x7c4ee05e79883e45c95beFc88fffa8c1cb615b3089c5b727c49c4c2675e4617ec7c9a4cee296ce13907321cc56a3cef574881314181565c7d686de34a2e9719c9446945F51983)
  , NZ (F 0x6c7aedf18b89bcc56e23ddc249dde79f58697c1c6252f939a270fb38b65aba99d3851a3359792cb6eebfca4561a80f541fc31a3d7f4cf5937e713e38af59f56cbbf2690014a3041) (F 0x244cea94c29Fe1a27f27beb4dc62e09bb629bd27f5706086fcd2678c0e105757048957ac24a561525346d2f36516a0bbcdd5c50281e68e77e2c77a9378bdb5fd3d808fde941298)
  , NZ (F 0x3603d5125fca1e87e6b1dcd3dd17d3cd86bb12f902eeac8fd02c3bcbbcf7f8bf6cbbe1366f9c8e25d949ddbaac7c27bf518121079bb8955e9a64659895df5684578b800a2c08c84) (F 0x4422a84d9f9de240ce0a8c6a55a3ffae5515c11492416cbb7017e9d5441be5a2b825339b42095e5ae98d135698e4c08f910f132a079d0b92211a08a91b1452b33d746e102ae764a)
  , NZ (F 0x414caa4f733e932553009d93d3251a42F2c580ab7d283e2d1e170726f5f9be5b7653408fa7572d3f009cf4ee802613aa3a31c2991dbdfaabccecd832c4e86c6a68f2e612739b7b) (F 0x23ada1bcbd3a506cfb3de390c21ec572a1c47173c0c81720c8464525c52a45cfd671762041dee2f16533dcda869caeeafc34891021cc2b2157d4f915e1d5bd8a2b57df9c24734f0)
  , NZ (F 0x57afce5cb571cc5760d1f0a4d90e91f5ac8391977d11bc37dcd85f5e01839d984e24a429e7df120a724a21949f1cac61495d3f1639e886024c21e04c46c69103522355b046d2cf6) (F 0x48e6ec239e955630bc6b80eb7d476fdcb853cefdd1a54e1dbc181de37ffcec38F02f8b5db392ee55d55b6bcf18836db8602fc27ca0e006aeca2c79e6635661b9ef392714bd3b16)
  , NZ (F 0x1546b20d6b24f309b7ae5c49949425b10350c72ef077f8988448bb7665c0fd3630c8d3f5c9e3e16106acf422f0149817f27dd80b2c66bbd4d92ddb663736649130b459ef2cb4d91) (F 0x0e0a7ccdd9f2e40c2509cb8759c31882c6f0af9082f9ae4c0eced3870Fd4f8d009c4de7e640F3ed4c8639deda22a6c3df4e57a6e3a7953cbe00867e5b40df37efadc6a45ec0dd)
  , NZ (F 0x08498134b0bc9e1b75cd4590d23e5b78faed9a4373c9a054ba5896243b0d589252ae5854d56199d8e3191b670e6dee2fd2669eab6e90cf1738e6042b7c85ecea74ad1bbf4daefc5) (F 0x090f572ab081f45c3ade75e3e2f359707b4c9dff7861adb0276b4590efad86056a666b5f8889447af7560f5e9b778eb8e8f55bbbb61d0502bdf7baab4352099f2310a43c163f168)
  , NZ (F 0x1db52c53c2b2f23fa8366c0b101aab1e67a7edf6b833d3a06b867fc4ad23ec3398ca5dc92a18821f6c3595c3f0c823929275c32e918c2cdf8be51019bb5a70f980cde3ce21a9ba2) (F 0x048764a0bdba152ba8574fa87c9364790068c39edb48a7a67da6357b6f057b4deaa6f086cea3bcc5861351bc77f076f2d56b7b464bb8a1e9fa8d0c3d2e514a702f6a14522afc6b4)
  , NZ (F 0x3ac0271c0670a3580320de9c16b540dc328f4e92ba7fda73ea7e324d30a41fa283734d0b9569c9b45466857ef84634fa46e178eb71d2579a05ad7bf92c5a9cff4b3117000095df4) (F 0x0ecd0510b9de90dd810dc2120cec126f92fcfa69b97e259bd59cb7bba690e221d0f07a4e43acae95fa333d7ab6fa7200b9b6eacf843cf3e523d9d3482d57df3f23efdbd55cae8d6)
  , NZ (F 0x73e43c002b75c7a4a4d93e49a754c1e221e79bd2cb4204a318492637f36112a9502b2e98118456337c751d9a4095adF9cd80e9f8504524055b60545b7f2a4e41203dbeff36e0fb) (F 0x328495a6175c9700da2e76d59c80b65d06202a3ae0fff5ab0eb06ba6031a30a29d7a846a8e19b615b15a996aa883e6b8e9107dec94f59daaa541ebd06a89577Fb57edabc453ddd)
  , NZ (F 0x1156a682ef64a1522a066b63389f0fadae4044b9f3F5b4307439c2867cfdcbc1ccd6ffd9ac2eba59cbb103571cbcf4fa1ac80ea3da683d146543225ff9685df780b0c7a7816a97) (F 0x434fc638e047abcdb92582ab47b8b4e41ce110f08248e460eaa8e72ca80cf48a312db80e5143d4513e5bce24d798e13b89ebf1cf14fdc431791880ddf13d8d06d5f522c6a8263ed)
  , NZ (F 0x0a1cc99a2250bc566dfd190c12a101d97832e3ba8f2692b6ce51fb5c68d8604bf92c146a02e9461054ce0378d2cdf8afd3f201d23575c867b04465a6ec6285807a1d672b9631511) (F 0x4707c15da62c0aecfa76e70d92c8a473b6f4bb0a671323b34bdd0fc80190547b8a5f7b5ac1d6f6169271b87770aa100e2c271db5f6696bc400166fc3bb5a81df3b6d8c4749427c0)
  , NZ (F 0x6288a3951452e5528074104b97fcb0adaab85ab3e74e2a14f5405b29c3d30084Fda236bafd981a19794dd83a3da847f456629dF8ec166ada2bfc183e1f18a24cea91f6b135faa) (F 0x1f179a306ee07b99d97fa2cd7751f8d29a994cc976a4f63422bf0b7f624360037585217a07a75ea7606b1cd64b46e3de3cee7af5cc133427c17a2faa4c36d03cce1465e5385b37c)
  , NZ (F 0x75e86c8d781dd1cd96c992575c1132550eed0b2ec272682c1e38a66cd24c1553e927318052439fd2eb613e2548ba64cdce738aaca67ec9eba2a6882ceeef458aac36eadfc55e115) (F 0x51d3c8569b6a3ef24982caddf1f34f35db9481574ad0eb493c52c312addaedce6959632ccf46831f3685dfc63eb050637797a048da937eec8c90c1bb5d39630e28d7db3e1a3a616)
  , NZ (F 0x33898307fb6fbd2f02e0fcf54a42cf7698f169a845521345fa97b2717287ee83c2d668f742577089b533a66c431ed1ec4ea7600b2b8c1bef0e725b23e584a600d1cf6bd58428158) (F 0x61220bc84633b9416f2de792f72a4b8b02b953001258bc09016aaaf9e25bd0b11a9c7723a602fb308f8d27c0F2c2a754ab1e0b413a2e2d361b901253bf90750fae2fadc718727b)
  , NZ (F 0x65135b6a2732e5483bea9f2dd9419393197da38965dc2c78bf0e1189670e58216b987dc0462a599F7956ec000f79636ef5abbf6f47b0c55fab0a357f74781291da65c1462883a8) (F 0x65675cb8229cb6a04dbbd21dbc99952df4dc91ceb0ee5b747347df2fa9a9d5f4e79c7c9bd0d2c45f8658b7d66a391482badc5a6251e1a5c9d3daf659f367334a7a7d3988cbf477f)
  , NZ (F 0x3467444a5d1c45959b22ce189325acbbF3ca3edab5175d0bf2a2f06d30bd5f6ac6229945cd4bbdaa2320257d172d66b0cbe1be188b9a59f15b9ca7449227dce5a9840e48c84e01) (F 0x2d484925b7550c182f02dc5274e30F4b56c6592afce7523f0895acab5dfdf76350a72390ff6fa4e368d9d6b4763acfFa3171e2a26c4c6bb75401732f8a1e17efa3c6de4dd80F)
  , NZ (F 0x0d6781da1f70c0ca0fa410e6f0899b4ea0c47d59285b1df883d2f6ecf7139cac789b70a606c56c06b88b7acf2f9c9c34bfadf14df00a086ef0a53dda4c30047da0b26ed67a0a6F) (F 0x0646552538e32e98b7103118d1763e95b8f34e6F298a185c6eb9ca13a958cbd3c2ec37ef5ac043678e83cf33229eF6a219f51696d0aac00e136b83d90625d901b92c2649cb7cb)
  , NZ (F 0x31e6f81edd6ad2dc707562a4ade661dace6e32675a01bee14cbed4f3eb285856340d046ce0672863850384839b0cfdf64635e5534d7a9db5a068938d67521cb5115cbfa9a4cd045) (F 0x2e208f01333b0dd205c7925f83bf1d7e56d1735a2da5d3900883dbe0b22cdde1f21d06179b0aad7c2ce3401a00c0ea7f55a999c456bf77b7679584db5e0b3e1d7a6253d13758d9c)
  , NZ (F 0x121c2ce5665c81d109b91f631012472c1c22dea3b5d99c7dd1ad0683370c74967e647cbba4613ca97a354353a6bf194672effbd69df8d4f7c4831d1f52bf8e0464a822a56b2970f) (F 0x1fc2b608661087e7eecc452815db4e675396ce72d8160f0c8ce25112178e649399cc410110a97bb42ebb3f41185797db97afbF5097d99f6e30c3e113d34d4b74946e705f4aa128)
  , NZ (F 0x2c897cf2767a245e48807d8af27bde6d6280df43c7e6800fdee0f4c03f3ca98e5c71159dc82018671dcb71cf039c2d7d259583022b8885ec82a66255704fa67c6c8d40617acc5ce) (F 0x173b84a48370a612bba01af96cfceff19c8f2368b3f24f8cac65a1e9d2de5b3427a28bb163a709ca120a62b0932cecae73e4a0c8e39678cF4790716254070c207cbb38379a2d56)
  , NZ (F 0x5f82dFe9093c66405f8ab0b558f03cec040710496047ec20190cef43b52e89149bec4c8c800e0edd5793191f2178bbc6d54847c0c6466b388d43c88707f3058fbdbb422187dd97) (F 0x0b60e0ef6d27780cc47a415d15d51643e545816bdb0fa9102bc6edfadd92443f3429ffbb2d1331b71a888f11bacf5680b99419216096a0f2bedFc396a26a708a9c1e457c631067)
  , NZ (F 0x3cd3476c6692ffdf6c2e5be56bb78f973d06405d5f7a5dae04b8220fa942fd8cae084b481a2c304fF897a915Fedb36af2ecf5246b847c0c535f3c2c8a6dc53e59825c1857a806) (F 0x7903aa449c8ad8b5b7497754ee146c81c73c550273283627b840bcff66f78bee549ef86a101ce1331ec2d658e0735f07f14e9ee887a181555b3fa93ae296383c60038dd6e21c2c1)
  , NZ (F 0x4477939d8d18b7f04aee584e7d578976906216ec92fd8df89479a58eF19c91a2a4d085319ca9a83293ee5c88ead2a4722e813f9c5a8781fc1137b4210b857b2eF96c3fb9c6b3a) (F 0x073d04a9373b661bcb729b10536beb3c4af77e10ecf8142cd0d61c015acdd035ca95aaf2db6cd00e60f4d41e78229f9c61e87e1ace08f4c02e5cb02b1f46be5929f6dd5ab3ec0a0)
  , NZ (F 0x06a0623a242da11c1Fce29c2f3924db45227585d9a91e415e87b145f2a5069379bc5466b5789eb8b54652188cd3536c91ac2e151b201cb0f7d1afF674253d3848734dc0626ce6) (F 0x1e075bf9c5b9ee8e61a97a2c494efdc37ee6581c9a58799a98de5e4f5817353c56b5397231a93b52b56626d21be6efda54347973dad055c76b6964d791bF92a72f96Fbf3e68a4)
  , NZ (F 0x28eb5f962270e554ca71d5b26db5554650fbe6d4c129a47b9379ae52d4a1c45df8c746ef7e7ef7cdf512cb647c9b9645e5584f31794c9d44b2299dd56e5f795154ae7d620be84e5) (F 0x69ec24eb14c2a7063250c7b5263e4ed1e6ab315dc144d25559f5dc15690af24db7647cb1df8bb67b07cf08f442b5d1ccb00a150910cf8fcef8cb561ffd7e0e53b2a8f130b833658)
  , NZ (F 0x586e5245095db75d43ac104e2b48b4d0Fb005ff002f25ea4ee3f006c3abf3764cd90a829a4cdd6076Ff57127e98a2b62f7305af2cdc776cd5d2fc6F6d5a2d609a38e18ffc7e8) (F 0x155528ce5ffb8f81a8291b9656b0ff93d5b0ae57e6da32231c92a81ee477e25399f06852241f497d04b4af730bd403a4a3ef46b6480d0010baf1ce3b4bad66f980a492f1511eae1)
  , NZ (F 0x6d1f4c4b82ce435345223934e912b35fd9f33266a7be7b95970aabe6ca57e87082b77b762a1732d68ca09cac496395d95a4d0c426b08b3901ef1e878ea6e6d009e12a14c1bc7f9c) (F 0x5d6b51b3dc41dbdefb9c37fadf5760bb67ed052cd9560892bf1a3efc4b9f2cc0027f7699694c363789d2cd16b7a6fa875aa42b9b23980aaa28ccf312025ace274188eab3fdfbe88)
  , NZ (F 0x0d112312ee88b90bfbef8fc5dc2867259f105aa43d57833337ffa2b98a0f28ba3a9200b36d29b85970a077a8dc4cc5d4f010ab8faa256649dbb7e82F35841e4096c47676dd5989) (F 0x66b5cbb08ca8667f942f4193ed11a2544069898e9d15c4cc165735f20ab5649bcb3560a29322216a72c875be7f91f5199b895adaa00adc3F0f596e97b222a4d9df72411b3e1e86)
  ]
