subroutine comm_discard(line,comm,error)
  use clean_def
  use clean_arrays
  use clean_types
  use gbl_message
  !
  use gkernel_interfaces, only : sic_delvariable
  use imager_interfaces, only : map_message
  !---------------------------------------------------------------------
  ! @ private
  !   Support for command DISCARD
  !
  ! Delete some internal buffer and its associated SIC variable
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line
  character(len=*), intent(in) :: comm
  logical, intent(out) :: error
  !
  character(len=32) :: key
  integer :: nk,ier
  !
  error = .false.
  !
  call sic_ke(line,0,1,key,nk,.true.,error)
  if (error) return
  !
  select case (key)
  case ('UVCONT')
    ! Delete the CONTINUUM array if defined
    call sic_delvariable ('UVCONT',.false.,error)
    if (allocated(duvc)) deallocate(duvc,stat=ier)
    huvc%loca%size = 0
  case ('UVSELF')
    !
    ! Delete the SELF array if defined
    call sic_delvariable ('UVSELF',.false.,error)
    if (allocated(duvself)) deallocate(duvself,stat=ier)
    hself%loca%size = 0
  case ('CONTINUUM')
    ! Delete the CONTINUUM image if defined
    save_data(code_save_cont) = .false.
    call sic_delvariable ('CONTINUUM',.false.,error)
    if (allocated(dcont)) deallocate(dcont,stat=ier)
    hcont%loca%size = 0
  case ('UV_MODEL')
    ! Free the previous zone
    call sic_delvariable ('UV_MODEL',.false.,error)
    if (allocated(duvm)) then
      deallocate(duvm,stat=ier)
      huvm%loca%size = 0
    endif
  case ('DIRTY')
    save_data(code_save_dirty) = .false.
    call sic_delvariable ('DIRTY',.false.,error)
    if (allocated(ddirty)) deallocate(ddirty,stat=ier)
  case ('RESIDUAL')
    save_data(code_save_resid) = .false.
    call sic_delvariable ('RESIDUAL',.false.,error)
    if (allocated(dresid)) deallocate(dresid,stat=ier)
  case ('CLEAN')
    save_data(code_save_clean) = .false.
    call sic_delvariable ('CLEAN',.false.,error)
    if (allocated(dclean)) deallocate(dclean,stat=ier)
  case ('SKY')
    save_data(code_save_sky) = .false.
    call sic_delvariable ('SKY',.false.,error)
    if (allocated(dsky)) deallocate(dsky,stat=ier)
  case ('MASK')
    save_data(code_save_mask) = .false.
    call sic_delvariable ('MASK',.false.,error)
    if (allocated(dmask)) deallocate(dmask,stat=ier)
  case ('PRIMARY')
    save_data(code_save_primary) = .false.
    call sic_delvariable ('PRIMARY',.false.,error)
    if (allocated(dprim)) deallocate(dprim,stat=ier)
    hprim%loca%size = 0
  case ('CCT')
    save_data(code_save_cct) = .false.
    call sic_delvariable ('CCT',.false.,error)
    if (allocated(dcct)) deallocate(dcct,stat=ier)
  case ('SINGLEDISH')
    save_data(code_save_single) = .false.
    call sic_delvariable ('SINGLE',.false.,error)
    call sic_delvariable ('SHORT',.false.,error)
  case default
    call map_message(seve%w,comm,'No code for '//key)
    error = .true.
    return
  end select
  if (ier.ne.0) then
    call map_message(seve%e,comm,trim(key)//' deallocation error')
    error = .true.
  endif
end subroutine comm_discard
