!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_sparange_types
  use cubetemplate_messaging
  use cubetools_axis_types
  !
  public :: sparange_prog_t
  private
  !
  type sparange_prog_t
     real(kind=coor_k) :: p(2) = 0d0         ! [pix] First and last values
     real(kind=coor_k) :: dp = 0d0           ! [pix] Step size
     real(kind=coor_k) :: n = 0d0            ! [---] Number of steps
     type(axis_t), pointer :: axis => null() ! [---] Associated axis
   contains
     procedure :: fromuser      => cubetemplate_sparange_prog_fromuser
     procedure :: def_substruct => cubetemplate_sparange_prog_def_substruct
     procedure :: get_offset    => cubetemplate_sparange_prog_get_offset
     procedure :: list          => cubetemplate_sparange_prog_list
     procedure :: to_pixe_k     => cubetemplate_sparange_prog_to_pixe_k
  end type sparange_prog_t
  !
contains
  !
  subroutine cubetemplate_sparange_prog_fromuser(range,iaxis,cube,progcenter,&
       usersizeval,usersizeunit,progsampval,progsampunit,error)
    use cubetools_unit
    use cubetools_user2prog
    use cubetools_header_methods
    use cube_types
    !----------------------------------------------------------------------
    ! 1. When the size is default, always use the natural axis direction as
    !    plotted direction
    ! 2. Else, the plotted direction depends on the sign of the user size
    !----------------------------------------------------------------------
    class(sparange_prog_t), intent(inout) :: range
    integer(kind=ndim_k),   intent(in)    :: iaxis
    type(cube_t),           intent(in)    :: cube
    real(kind=coor_k),      intent(in)    :: progcenter
    character(len=argu_l),  intent(in)    :: usersizeval
    character(len=argu_l),  intent(in)    :: usersizeunit
    real(kind=coor_k),      intent(in)    :: progsampval
    integer(kind=code_k),   intent(in)    :: progsampunit
    logical,                intent(inout) :: error
    !
    type(unit_user_t) :: progunit
    real(kind=coor_k) :: ofirst,olast,progsize
    real(kind=coor_k) :: pfirst,plast
    real(kind=coor_k), parameter :: default = 0d0
    integer(kind=4), parameter :: imin = 1
    integer(kind=4), parameter :: imax = 2
    character(len=*), parameter :: rname='SPARANGE>PROG>FROMUSER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_header_point2axis(iaxis,cube%head,range%axis,error)
    if (error) return
    if (range%axis%inc.ne.0.0) then
       select case(progsampunit)
       case(code_unit_fov)
          ! progsampval is here an angle
          range%dp = abs(progsampval/range%axis%inc)
          range%dp = max(range%dp,1.0) ! At least one pixel
       case(code_unit_pixe)
          ! progsampval is here a number of boxes
          ! => Compute the number of pixels per box
          if (usersizeval.ne.strg_star) then
             ! Use the user-defined size
             call cubetools_unit_get(usersizeunit,code_unit_fov,progunit,error)
             if (error) return
             call cubetools_user2prog_resolve_star(usersizeval,progunit,default,progsize,error)
             if (error) return
             range%dp = abs(progsize/progsampval/range%axis%inc)
          else
             ! Use the full field of view
             range%dp = abs(range%axis%n/progsampval)
          endif
          range%dp = max(1d0,min(real(range%axis%n,kind=coor_k),range%dp))
       case default
          call cubetemplate_message(seve%e,rname,'Unknown sampling unit')
          error = .true.
          return
       end select
    else
       call cubetemplate_message(seve%e,rname,'Zero valued axis increment')
       error = .true.
       return
    endif    
    if (usersizeval.ne.strg_star) then
       ! Use the user-defined range from his size and his center
       call cubetools_unit_get(usersizeunit,code_unit_fov,progunit,error)
       if (error) return
       call cubetools_user2prog_resolve_star(usersizeval,progunit,default,progsize,error)
       if (error) return       
       ofirst = progcenter-0.5*progsize
       olast  = progcenter+0.5*progsize
       call cubetools_axis_offset2pixel(range%axis,ofirst,pfirst,error)
       if (error) return    
       call cubetools_axis_offset2pixel(range%axis,olast,plast,error)
       if (error) return
       if (progsize*range%axis%inc.ge.0.0) then
          ! Plotted direction equal to axis natural direction
          range%dp = +sign(range%dp,range%axis%inc)
       else
          ! Plotted direction reverse to axis natural direction
          range%dp = -sign(range%dp,range%axis%inc)
       endif
       if (range%dp.ge.0.0) then
          range%p(imin) = min(pfirst,plast)
          range%p(imax) = max(pfirst,plast)
       else
          range%p(imin) = max(pfirst,plast)
          range%p(imax) = min(pfirst,plast)
       endif
    else
       ! Plotted direction always equal to axis natural direction
       !
       ! *** JP: This one breaks at least the EXTRACT and FFT commands. Revert
       ! *** JP: waiting for a better solution.
!!$       ! Default to full axis range, ie, don't use the center information in this case
!!$       range%p(imin) = 0.5d0               ! Left of first pixel
!!$       range%p(imax) = range%axis%n+0.5d0  ! Right of last pixel
       range%p(imin) = 1
       range%p(imax) = range%axis%n
       range%dp = abs(range%dp)
    endif
    range%n = abs((range%p(imax)-range%p(imin))/range%dp)
    !
  end subroutine cubetemplate_sparange_prog_fromuser
  !
  subroutine cubetemplate_sparange_prog_def_substruct(prog,name,struct,error)
    use cubetools_unit
    use cubetools_userstruct
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(sparange_prog_t), intent(in)    :: prog
    character(len=*),       intent(in)    :: name
    type(userstruct_t),     intent(inout) :: struct
    logical,                intent(inout) :: error
    !
    real(kind=coor_k) :: offset(3)
    type(unit_user_t) :: unit
    type(userstruct_t) :: rangesubstruct
    character(len=*), parameter :: rname='SPARANGE>PROG>DEF>SUBSTRUCT'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call struct%def_substruct(name,rangesubstruct,error)
    if (error) return
    !
    call prog%get_offset(offset,error)
    if (error) return
    call cubetools_unit_get(strg_star,code_unit_fov,unit,error)
    if (error) return
    offset = offset*unit%user_per_prog
    call rangesubstruct%set_member('first',offset(1),error)
    if (error) return
    call rangesubstruct%set_member('last',offset(2),error)
    if (error) return
    call rangesubstruct%set_member('step',offset(3),error)
    if (error) return
    call rangesubstruct%set_member('n',prog%n,error)
    if (error) return
    call rangesubstruct%set_member('unit',unit%name,error)
    if (error) return
  end subroutine cubetemplate_sparange_prog_def_substruct
  !
  subroutine cubetemplate_sparange_prog_get_offset(range,offset,error)
    use cubetools_axis_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(sparange_prog_t), intent(in)    :: range
    real(kind=coor_k),      intent(out)   :: offset(3)
    logical,                intent(inout) :: error
    !
    integer(kind=4) :: ip
    character(len=*), parameter :: rname='SPARANGE>PROG>GET>OFFSET'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    do ip=1,2
       call cubetools_axis_pixel2offset(range%axis,range%p(ip),offset(ip),error)
       if (error) return
    enddo ! ip
    offset(3) = range%dp*range%axis%inc
  end subroutine cubetemplate_sparange_prog_get_offset
  !
  subroutine cubetemplate_sparange_prog_list(range,error)
    use cubetools_unit
    use cubetools_format
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(sparange_prog_t), intent(in)    :: range
    logical,                intent(inout) :: error
    !
    type(unit_user_t) :: unit
    real(kind=coor_k) :: offset(3)
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='SPARANGE>PROG>LIST'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_format_range(range%axis%name,range%p,'pixel',mess,error)
    if (error) return
    call cubetemplate_message(seve%r,rname,mess)
    !
    call range%get_offset(offset,error)
    if (error) return
    call cubetools_unit_get(strg_star,code_unit_fov,unit,error)
    if (error) return
    offset = offset*unit%user_per_prog    
    call cubetools_format_range(range%axis%name,offset,unit%name,mess,error)
    if (error) return
    call cubetemplate_message(seve%r,rname,mess)
  end subroutine cubetemplate_sparange_prog_list
  !
  subroutine cubetemplate_sparange_prog_to_pixe_k(range,first,last,stride,error)
    !----------------------------------------------------------------------
    ! First and last are expected to be inclusive, We expect them to
    ! include the whole channels at the borders
    !----------------------------------------------------------------------
    class(sparange_prog_t), intent(in)    :: range
    integer(kind=pixe_k),   intent(out)   :: first
    integer(kind=pixe_k),   intent(out)   :: last
    integer(kind=pixe_k),   intent(out)   :: stride    
    logical,                intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPARANGE>PROG>TO>PIXE_K'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    first  = floor(minval(range%p))
    last   = ceiling(maxval(range%p))
    stride = nint(range%dp)
  end subroutine cubetemplate_sparange_prog_to_pixe_k
end module cubetemplate_sparange_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
