!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_spasize_types
  use cubetemplate_messaging
  use cubetools_structure
  use cubetools_keyword_arg
  !
  public :: spasize_opt_t,spasize_user_t,spasize_prog_t
  private
  !
  type spasize_opt_t
     type(option_t),      pointer :: opt
     type(keyword_arg_t), pointer :: unit_arg
   contains
     procedure :: register => cubetemplate_spasize_register
     procedure :: parse    => cubetemplate_spasize_parse
  end type spasize_opt_t
  !
  type spasize_user_t
     logical               :: do = .false.
     character(len=argu_l) :: x = strg_star
     character(len=argu_l) :: y = strg_star
     character(len=argu_l) :: unit  = strg_star
   contains
     procedure :: init          => cubetemplate_spasize_user_init
     ! procedure :: def_substruct => cubetemplate_spasize_user_def_substruct
     procedure :: toprog        => cubetemplate_spasize_user_toprog
     procedure :: list          => cubetemplate_spasize_user_list
  end type spasize_user_t
  !
  type spasize_prog_t
     real(kind=coor_k) :: x ! [rad]
     real(kind=coor_k) :: y ! [rad]
  end type spasize_prog_t
  !
contains
  !
  subroutine cubetemplate_spasize_register(size,abstract,error)
    use cubetools_unit
    !----------------------------------------------------------------------
    ! Register a /SIZE option according to a name and abstract
    ! provided by the command
    !----------------------------------------------------------------------
    class(spasize_opt_t), intent(out)   :: size      
    character(len=*),     intent(in)    :: abstract
    logical,              intent(inout) :: error
    !
    type(standard_arg_t) :: stdarg
    type(keyword_arg_t) :: keyarg
    !
    character(len=*), parameter :: rname='SPASIZE>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         'SIZE','sl [sm [unit]]',&
         abstract,&
         strg_id,&
         size%opt,error)
    if (error) return
    call stdarg%register( &
         'sl','Size in L coordinate', &
         '"*" or "=" mean previous value is kept',&
         code_arg_mandatory, &
         error)
    if (error) return
    call stdarg%register( &
         'sm','Size in M coordinate', &
         '= means unchanged, * means equal to sl',&
         code_arg_optional, &
         error)
    if (error) return
    call keyarg%register( &
         'unit',  &
         'Size unit', &
         '"*" or "=" means current unit is used',&
         code_arg_optional, &
         unit_fov_name, &
         .not.flexible, &
         size%unit_arg,&
         error)
    if (error) return
  end subroutine cubetemplate_spasize_register
  !
  subroutine cubetemplate_spasize_parse(size,line,user,error)
    !----------------------------------------------------------------------
    ! /SIZE x y [unit]
    !
    ! x and y size can be either an absolute sexagesimal
    ! string or a relative offset in arcseconds.
    ! ----------------------------------------------------------------------
    class(spasize_opt_t), intent(in)    :: size  
    character(len=*),     intent(in)    :: line
    type(spasize_user_t), intent(out)   :: user
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPASIZE>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call size%opt%present(line,user%do,error)
    if (error) return
    if (user%do) then
       call cubetools_getarg(line,size%opt,1,user%x,mandatory,error)
       if (error) return
       call cubetools_getarg(line,size%opt,2,user%y,.not.mandatory,error)
       if (error) return
       call cubetools_getarg(line,size%opt,3,user%unit,.not.mandatory,error)
       if (error) return
    endif
  end subroutine cubetemplate_spasize_parse
  !
  !------------------------------------------------------------------------
  !
  subroutine cubetemplate_spasize_user_init(size,error)
    !----------------------------------------------------------------------
    ! Initialize by setting the intent of size to out
    !----------------------------------------------------------------------
    class(spasize_user_t), intent(out)   :: size 
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPASIZE>USER>INIT'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
  end subroutine cubetemplate_spasize_user_init
  !
  ! subroutine cubetemplate_spasize_user_def_substruct(size,struct,error)
  !   use cubetools_userstruct
  !   !----------------------------------------------------------------------
  !   !
  !   !----------------------------------------------------------------------
  !   class(spasize_user_t), intent(in)    :: size
  !   type(userstruct_t),    intent(inout) :: struct
  !   logical,               intent(inout) :: error
  !   !
  !   type(userstruct_t) :: substruct
  !   character(len=*), parameter :: rname='SPASIZE>USER>DEF>SUBSTRUCT'
  !   !
  !   call cubetemplate_message(templateseve%trace,rname,'Welcome')
  !   !
  !   ! *** JP What happens if the sub-structure already exists?
  !   call struct%def_substruct('size',substruct,error)
  !   if (error) return
  !   call substruct%set_member('x',size%x,error)
  !   if (error) return
  !   call substruct%set_member('y',size%y,error)
  !   if (error) return
  !   call substruct%set_member('unit',size%unit,error)
  !   if (error) return
  ! end subroutine cubetemplate_spasize_user_def_substruct
  !
  subroutine cubetemplate_spasize_user_toprog(user,cube,prog,error)
    use cubetools_unit
    use cubetools_user2prog
    use cube_types
    use cubetemplate_spatial_coordinates
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spasize_user_t), intent(in)    :: user
    type(cube_t),          intent(in)    :: cube
    type(spasize_prog_t),  intent(out)   :: prog
    logical,               intent(inout) :: error
    !
    type(unit_user_t) :: unit
    real(kind=coor_k) :: rmin(2), rmax(2)
    character(len=*), parameter :: rname='SPASIZE>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_unit_get(user%unit,code_unit_fov,unit,error)
    if (error) return
    !
    call cubetemplate_spatial_relminrelmax(cube,rmin,rmax,error)
    if (error) return
    prog%x = rmax(1)-rmin(1)
    prog%y = rmax(2)-rmin(2)
    !
    call cubetools_user2prog_resolve_star(user%x,unit,prog%x,prog%x,error)
    if (error) return
    call cubetools_user2prog_resolve_star(user%y,unit,prog%x,prog%y,error)
    if (error) return
    ! *** JP This condition is strange as the size sign can encode information
!!$       if ((prog%x.le.0d0).or.(prog%y.le.0d0)) then
!!$          call cubetemplate_message(seve%e,rname,'Size must be positive')
!!$          error = .true.
!!$          return
!!$       endif
    ! *** JP
  end subroutine cubetemplate_spasize_user_toprog
  !
  subroutine cubetemplate_spasize_user_list(size,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spasize_user_t), intent(in)    :: size 
    logical,               intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='SPASIZE>USER>LIST'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    write(mess,'(6a)') &
         'Size  : (',trim(size%x),',',trim(size%y),') ',size%unit
    call cubetemplate_message(seve%r,rname,mess)
  end subroutine cubetemplate_spasize_user_list
end module cubetemplate_spasize_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
