!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_spechannel_types
  use cubetools_structure
  use cubetools_keyword_arg
  use cubetemplate_messaging
  !
  public :: spechannel_user_t,spechannel_prog_t, spechannel_opt_t
  private
  !
  type spechannel_opt_t
     type(option_t),      pointer :: opt
     type(keyword_arg_t), pointer :: coortype
     type(keyword_arg_t), pointer :: unit
   contains
     procedure :: register  => cubetemplate_spechannel_register
     procedure :: parse     => cubetemplate_spechannel_parse
  end type spechannel_opt_t
  !
  type spechannel_user_t
     character(len=argu_l) :: chan  = strg_unk ! Channel velocity
     character(len=argu_l) :: type  = strg_unk ! RELATIVE|ABSOLUTE channel velocity is absolute or relative
     character(len=argu_l) :: unit  = strg_unk ! Channel unit 
     logical               :: do    = .false.  ! Option was present
   contains
     procedure :: init   => cubetemplate_spechannel_user_init
     procedure :: toprog => cubetemplate_spechannel_user_toprog
  end type spechannel_user_t
  !
  type spechannel_prog_t
     integer(kind=chan_k) :: ic ! Nearest integer channel
  end type spechannel_prog_t
  !
contains
  !
  subroutine cubetemplate_spechannel_register(option,name,abstract,error)
    use cubetools_unit
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(spechannel_opt_t), intent(out)   :: option
    character(len=*),        intent(in)    :: name
    character(len=*),        intent(in)    :: abstract
    logical,                 intent(inout) :: error
    !
    type(standard_arg_t) :: stdarg
    type(keyword_arg_t)  :: keyarg
    character(len=*), parameter :: ctypes(2) = ['Absolute','Relative']
    character(len=*), parameter :: rname='CHANNEL>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         name,'velocity type [unit]',&
         abstract,&
         strg_id,&
         option%opt,error)
    if (error) return
    call stdarg%register(&
         'velocity',&
         'Velocity of the channel',&
         strg_id,&
         code_arg_mandatory,error)
    if (error) return
    call keyarg%register( &
         'type',  &
         'Velocity is absolute or relative to systemic velocity', &
         strg_id,&
         code_arg_mandatory,&
         ctypes, &
         .not.flexible, &
         option%coortype,&
         error)
    if (error) return
    call keyarg%register( &
         'unit',  &
         'Velocity unit', &
         strg_id,&
         code_arg_optional,&
         unit_velo_name, &
         .not.flexible, &
         option%unit,&
         error)
    if (error) return
  end subroutine cubetemplate_spechannel_register
  !
  subroutine cubetemplate_spechannel_parse(option,line,user,error)
    !----------------------------------------------------------------------
    ! /CHANNEL Vel type [unit]
    !----------------------------------------------------------------------
    class(spechannel_opt_t), intent(in)    :: option
    character(len=*),        intent(in)    :: line
    type(spechannel_user_t), intent(out)   :: user
    logical,                 intent(inout) :: error
    !
    character(len=*), parameter :: rname='CHANNEL>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    user%chan = strg_star
    user%type = strg_star
    user%unit = strg_star    
    !
    call option%opt%present(line,user%do,error)
    if (error) return
    if (user%do) then
       call cubetools_getarg(line,option%opt,1,user%chan,mandatory,error)
       if (error) return
       call cubetools_getarg(line,option%opt,2,user%type,mandatory,error)
       if (error) return
       call cubetools_getarg(line,option%opt,3,user%unit,.not.mandatory,error)
       if (error) return
    else
       ! Do nothing
    endif
  end subroutine cubetemplate_spechannel_parse
  !
  subroutine cubetemplate_spechannel_user_init(user,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spechannel_user_t), intent(in)    :: user
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter     :: rname='CHANNEL>USER>INIT'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
  end subroutine cubetemplate_spechannel_user_init
  !
  subroutine cubetemplate_spechannel_user_list(user,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spechannel_user_t), intent(in)    :: user 
    logical,                  intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='CHANNEL>USER>LIST'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    write(mess,'(2a,x,a,x,a)') &
         'Channel   : ',trim(user%chan),trim(user%type),trim(user%unit)
    call cubetemplate_message(seve%r,rname,mess)
  end subroutine cubetemplate_spechannel_user_list
  !
  subroutine cubetemplate_spechannel_user_toprog(user,option,cube,prog,error)
    use cube_types
    use cubetools_user2prog
    use cubetools_unit
    use cubetemplate_topology
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spechannel_user_t), intent(in)    :: user
    type(spechannel_opt_t),   intent(in)    :: option
    type(cube_t),             intent(in)    :: cube
    type(spechannel_prog_t),  intent(out)   :: prog
    logical,                  intent(inout) :: error
    !
    integer(kind=4) :: ikey
    character(len=12) :: type
    type(unit_user_t) :: velunit
    real(kind=coor_k) :: velo,default
    character(len=*), parameter     :: rname='CHANNEL>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_keyword_user2prog(option%coortype,user%type,ikey,type,error)
    if (error) return
    call cubetools_unit_get(user%unit,code_unit_velo,velunit,error)
    if (error) return
    select case(type)
    case('ABSOLUTE')
       default = cube%head%spe%ref%v
       call cubetools_user2prog_resolve_star(user%chan,velunit,default,velo,error)
       if (error) return
    case('RELATIVE')
       default = 0d0
       call cubetools_user2prog_resolve_star(user%chan,velunit,default,velo,error)
       if (error) return
       velo = velo+cube%head%spe%ref%v
    end select
    call cubetemplate_topo_velocity2channel(cube,velo,prog%ic,error)
    if (error) return
  end subroutine cubetemplate_spechannel_user_toprog
  !
end module cubetemplate_spechannel_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

