!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetools_topic
  use cubetools_parameters
  use cubetools_structure
  use cubetools_keyword_arg
  use cubetools_messaging
  !
  public :: topic_opt_t
  private
  !
  character(len=*), parameter :: onoff(2) = ['ON ','OFF']
  !
  type :: topic_opt_t
     type(option_t),      pointer :: opt
     type(keyword_arg_t), pointer :: onoff
     logical                      :: enabled
     logical                      :: do
   contains
     procedure, public :: register => cubetools_topic_register
     procedure, public :: parse    => cubetools_topic_parse
  end type topic_opt_t
  !
contains
  !
  subroutine cubetools_topic_register(topic,name,abstract,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(topic_opt_t), intent(inout) :: topic
    character(len=*),   intent(in)    :: name
    character(len=*),   intent(in)    :: abstract
    logical,            intent(inout) :: error
    !
    type(keyword_arg_t) :: keyarg
    character(len=*), parameter :: rname='TOPIC>REGISTER'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         name,'ON|OFF',&
         abstract,&
         strg_id,&
         topic%opt,error)
    if (error) return
    call keyarg%register(&
         'onoff', &
         'Timing messages ON or OFF',&
         strg_id,&
         code_arg_mandatory,&
         onoff,&
         .not.flexible,&
         topic%onoff,&
         error)
    if (error) return
  end subroutine cubetools_topic_register
  !
  subroutine cubetools_topic_parse(topic,line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(topic_opt_t), intent(inout) :: topic
    character(len=*),   intent(in)    :: line
    logical,            intent(inout) :: error
    !
    integer(kind=4) :: ikey
    character(len=16) :: keyword,argum
    character(len=*), parameter :: rname='TOPIC>PARSE'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call topic%opt%present(line,topic%do,error)
    if (error) return
    if (topic%do) then
       call cubetools_getarg(line,topic%opt,1,argum,mandatory,error)
       if (error) return
       call cubetools_keyword_user2prog(topic%onoff,argum,ikey,keyword,error)
       if (error) return
       topic%enabled = keyword.eq.'ON'
    else
       ! nothing to do
    endif
  end subroutine cubetools_topic_parse
end module cubetools_topic
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
