!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
subroutine clean_beam(line,error)
  use gkernel_interfaces
  use clean_def
  use clean_arrays
  use gbl_message
  use mapping_interfaces, except_this=>clean_beam
  !---------------------------------------------------------------------------
  ! @ private
  ! Support routine for command FIT [ifield]
  !---------------------------------------------------------------------------
  character(len=*), intent(in)    :: line
  logical,          intent(inout) :: error
  !
  integer(kind=4) :: ifield
  character(len=message_length) :: chain
  character(len=*), parameter :: rname = 'FIT'
  !
  if (hbeam%loca%size.eq.0) then
    call map_message(seve%e,rname,'No Dirty Beam')
    error = .true.
    return
  endif
  method%ibeam = beam_for_channel(method%iplane,hdirty,hbeam)
  ifield = 1
  call sic_i4(line,0,1,ifield,.false.,error)
  if (error) return
  ifield = min(hbeam%gil%dim(3),max(1,ifield))
  if (hbeam%gil%dim(3).gt.1) then
    write(chain,'(A,I4,A,I4)') 'Fitting beam # ',ifield,' /',hbeam%gil%dim(3)
    call map_message(seve%i,rname,chain)
  endif
  if (hbeam%gil%dim(4).gt.1) then
    write(chain,'(A,I4,A,I4)') 'Fitting plane # ',method%ibeam,' /',hbeam%gil%dim(4)
    call map_message(seve%i,rname,chain)
  endif
  method%major = 0.0
  method%minor = 0.0
  method%angle = 0.0
  method%thresh = 0.30
  call sic_get_real('THRESHOLD',method%thresh,error)
  !
  call get_clean(method,hbeam,dbeam(:,:,ifield,method%ibeam),error)
end subroutine clean_beam
!
subroutine new_dirty_beam
  use gkernel_interfaces
  use clean_def
  use clean_arrays
  !---------------------------------------------------------------------------
  ! Needed when a new dirty map is computed by command uv_map
  !---------------------------------------------------------------------------
  !
  logical :: error
  error = .false.
  !
  if (allocated(dclean)) deallocate(dclean)
  call sic_delvariable('CLEAN',.false.,error)
  hclean%loca%size = 0
  !
  if (allocated(dresid)) deallocate(dresid)
  call sic_delvariable('RESIDUAL',.false.,error)
  hresid%loca%size = 0
  !
  if (allocated(dcct)) deallocate(dcct)
  call sic_delvariable('CCT',.false.,error)
  hcct%loca%size = 0
  !
  if (allocated(dsky)) deallocate(dsky)
  call sic_delvariable('SKY',.false.,error)
  hsky%loca%size = 0
end subroutine new_dirty_beam
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
