subroutine display_buffer(comm,line,error)
  use gkernel_interfaces
  use imager_interfaces, only : display_buffer_sub, map_message
  use clean_arrays
  use clean_def
  use clean_types
  use clean_support
  use clean_default
  use uvfit_data
  use gbl_message
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING support routine for command
  !     SHOW Name
  !----------------------------------------------------------------------
  character(len=*), intent(in)  :: comm  ! Command (SHOW or VIEW)
  character(len=*), intent(in)  :: line  ! Command line
  logical,          intent(out) :: error ! Logical error flag
  !
  character(len=1), parameter :: question_mark='?'
  ! Local variables
  integer(kind=size_length) :: locasize
  type(sic_descriptor_t) :: descr
  logical :: found, do_insert, done
  integer, parameter :: mnoise=2
  integer ntype,nc,is,nnoise
  character(len=filename_length) :: argu,file,chain
  character(len=40) :: argu1,argu2
  character(len=12) :: dnoise,dtype
  character(len=6) :: vnoise(mnoise)=['DIRTY ', 'CLEAN ']
  !
  ! Parse input line
  call sic_ke(line,0,1,argu,nc,.true.,error)
  if (error) return
  if (argu(1:1).eq.question_mark) then
    argu1 = '@ i_'//comm
    call sic_lower(argu1)
    argu1 = trim(argu1) //' '//argu
    call exec_program(argu1) 
    call sic_ambigs_list(comm,seve%i,'Choices are:',vtype)
    return
  else if (argu.eq.'UV') then
    argu = 'UV_DATA'
  endif
  !
  ! Code for exact name matching
  dtype = argu
  ntype = 0
  do is=1,mtype
    if (argu.eq.vtype(is)) then
      ntype = is
      dtype = vtype(ntype)
      exit
    endif
  enddo
  if (ntype.eq.0) then
    call sic_descriptor (argu,descr,found)    ! Checked
    if (.not.found) then
      call sic_ch(line,0,1,argu,nc,.true.,error)
      found = sic_findfile(argu,file,' ',' ')
      if (found) then
        dtype = 'FILENAME'
      else
        call map_message(seve%e,comm, &
        'Cannot '//trim(comm)//' '//trim(argu)//' (no corresponding variable)')
        error = .true.
        return
      endif
    endif
  endif
  !
!
! Code for non-ambiguous abbreviations (dangerous with variables...)
!      
!  call sic_ambigs(comm,argu,dtype,ntype,vtype,mtype,error)
!  if (error) then
!    ! Fall back on any possible SIC variable
!    call map_message(seve%w,comm,'Attempting to use a SIC Image variable')
!    dtype = argu
!    error = .false.
!  endif
  !
  ! Special case first
  do_insert = sic_lire().eq.0
  done = .false.
  !
  select case (dtype)
  case ('UV_FIT')
    argu = ' '
    call sic_ch(line,0,2,argu,nc,.false.,error)
    if (error) return
    if (argu(1:1).eq.question_mark) then
      call exec_program('@ i_plotfit '//argu)
    else
      if (huvfit%loca%size.eq.0) then
        call map_message(seve%e,comm,'No UV_FIT performed')
        error = .true.
      else 
        call exec_program('@ p_plotfit UV_FIT')
      endif
    endif
    done = .true.
  case ('FLUX') 
    call exec_program('@ p_show_flux')
    done = .true.
  case ('COMPOSITE') 
    call exec_program('@ p_show_composite')
    done = .true.
  case ('FIELDS') 
    if (hprim%loca%size.eq.0 .or. comm.eq.'SHOW') then
      if (themap%nfields.eq.0) then
        call map_message(seve%e,comm,'No Mosaic loaded')
        error = .true.
      else
        call exec_program('@ p_plot_fields FIELDS')
        done = .true.
      endif
    else
      call create_fields(error)
      if (error) return
      dtype = 'FIELDS'
    endif
  case ('PRIMARY') 
    call create_fields(error)
    if (error) return
    dtype = 'FIELDS'
  case ('SELFCAL')
    is = sic_start(0,2)
    if (is.eq.0) then
      call exec_program('@ p_show_selfcal ')
    else
      call exec_program('@ p_show_selfcal '//line(is:))
    endif
    done = .true.
  case('MOMENTS') 
    call exec_program('@ p_show_moments ')
    done = .true.
  case ('NOISE')
    if (sic_present(0,2)) then
      call sic_ke(line,0,2,argu,nc,.true.,error)
      if (error) return
      call sic_ambigs(trim(comm)//' NOISE',argu,dnoise,nnoise,vnoise,mnoise,error)
      if (error) return
    else
      !
      ! Fall back on the last displayed or computed image
      if (last_shown.eq.'CLEAN' .or. last_shown.eq.'DIRTY') then
        dnoise = last_shown
      else  if (hclean%loca%size.ne.0) then
        dnoise = 'CLEAN'
      else if (hdirty%loca%size.ne.0) then
        dnoise = 'DIRTY'
      else
        call map_message(seve%e,comm,'No CLEAN or DIRTY image')
        error = .true.
        return
      endif
    endif
    !
    if (dnoise.eq.'CLEAN') then
      locasize = hclean%loca%size
    else
      locasize = hdirty%loca%size
    endif
    if (locasize.eq.0) then
      call map_message(seve%e,comm,'No '//trim(dnoise)//' image')
      error = .true.
    else if (comm.eq.'SHOW') then
      call exec_program('@ p_show_noise '//dnoise)
      done = .true.
    else if (comm.eq.'VIEW') then
      call exec_program('@ p_view_noise '//dnoise)
      done = .true.
    endif
  case ('SUPPORT') 
    if (supportpol%ngon.ge.2) call greg_poly_plot(supportpol,error) 
    done = .true.
  case ('SNR')
    if (method%mosaic) then
      call exec_program('@ p_snr '//comm)
      done = .true.
    else
      call map_message(seve%e,comm,trim(comm)//' SNR only available in Mosaic mode')
      error = .true.
    endif
  case ('SPECTRA') 
    argu = ' '
    call sic_ch(line,0,2,argu,nc,.false.,error)
    call exec_program('@ p_spectra '//argu)
    done = .true.
  case ('FILENAME') 
    !
    ! General [First [Last]] channel selection
    argu1 = ' '
    call sic_ch(line,0,2,argu1,nc,.false.,error)
    argu2 = argu1
    call sic_ch(line,0,3,argu2,nc,.false.,error)
    !
    chain = 'DEFINE IMAGE Temporary "'//trim(file)//'" READ /GLOBAL /TRIM 3'
    call exec_command(chain,error)
    if (error) return
    chain = 'Temporary '//trim(argu1)//' '//trim(argu2)
    if (comm.eq.'SHOW') then
       call exec_program('@ p_show_map '//chain)    
    else if (comm.eq.'INSPECT_3D') then
       call exec_program('@ p_3view_map '//chain)
    else
       call exec_program('@ p_view_map '//chain)
    endif
    chain = 'DELETE /VAR Temporary'
    call exec_command(chain,error)
    done = .true.
  case ('SOURCES') 
    call show_sources_comm(line,error)
    done = .true.
  case default
    continue
  end select
  !
  ! Check error status
  if (error) return
  !
  if (.not.done) then
    ! Display the buffer if not already done
    call display_buffer_sub(comm,ntype,dtype,line,error)
    if (dtype.eq.'CLEAN' .or. dtype.eq.'DIRTY') then
      last_shown = dtype
    endif
  endif
  !
  ! Insert command if needed
  if (do_insert) call sic_insert_log(line)
  !
end subroutine display_buffer
!
subroutine display_buffer_sub(comm,ntype,dtype,line,error)
  use gkernel_interfaces
  use imager_interfaces, only : display_uv
  use clean_types
  use clean_arrays
  use gbl_message
  !----------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER support routine for command
  !     SHOW or VIEW Name
  !
  !----------------------------------------------------------------------
  character(len=*), intent(in) :: comm
  integer, intent(in)  :: ntype ! Buffer type
  logical, intent(out) :: error ! Logical error flag
  character(len=*), intent(in) :: dtype
  character(len=*), intent(in) :: line
  !
  character(len=40) :: argu1,argu2,c_more,chain
  integer, parameter :: mlevel=15
  real :: levels(mlevel)
  real(kind=8) :: space
  integer :: nc,first,last,ic
  logical :: do_dirty
  character(len=12) :: xtype,ytype
  !
  levels = [-0.40,-0.30,-0.20,-0.15,-0.10,-0.05,-0.02,0.02,0.05,0.1,0.15,0.20,0.30,0.40,0.50]
  !
  ! Load into SIC buffer
  if (comm.eq.'SHOW' .and. ntype.eq.1) then
    !
    ! SHOW Coverage
    call sic_get_inte('FIRST',first,error)
    call sic_get_inte('LAST',last,error)
    call sic_get_char('XTYPE',xtype,nc,error)
    call sic_get_char('YTYPE',ytype,nc,error)
    call sic_let_char('XTYPE','u',error)
    call sic_let_char('YTYPE','v',error)
    if (first.eq.0 .and. last.eq.0) then
      ic = huv%gil%nchan/3
      call sic_let_inte('FIRST',ic,error)
      call sic_let_inte('LAST',ic,error)
    endif
    chain = 'UV'
    call display_uv (chain,error)
    call sic_let_char('XTYPE',xtype,error)
    call sic_let_char('YTYPE',ytype,error)
    call sic_let_inte('FIRST',first,error)
    call sic_let_inte('LAST',last,error)
    return
  endif
  !
  ! General [First [Last]] channel selection
  argu1 = ' '
  call sic_ch(line,0,2,argu1,nc,.false.,error)
  argu2 = argu1
  call sic_ch(line,0,3,argu2,nc,.false.,error)
  !
  ! Plot SIC buffer with adequate plotting procedure
  if (comm.eq.'SHOW' .or. comm.eq.'UV_FLAG') then
    if (dtype.eq.'UV_DATA') then
      if (argu1.eq."?" .and. argu2.eq.argu1) then
        call exec_program('@ i_show_uv')
        return
      endif
      chain = 'UV '//trim(argu1)//' '//trim(argu2)
      call display_uv(chain,error)
    else if (dtype.eq.'CCT') then
      if (hcct%loca%size.eq.0) then
        call map_message(seve%e,comm,'No CCT buffer')
        error = .true.
        return
      endif
      argu1 = ' '
      call sic_ch(line,0,2,argu1,nc,.false.,error)
      call exec_program('@ p_show_cct cct '//argu1)
    else if (dtype.eq.'BEAM') then
      if (hbeam%loca%size.eq.0) then
        call map_message(seve%e,comm,'No BEAM buffer')
        error = .true.
        return
      endif
      argu1 = ' '
      call sic_ch(line,0,2,argu1,nc,.false.,error)
      call sic_get_dble('SPACING',space,error)
      call sic_let_dble('SPACING',-1.0d0,error)
      call gr4_levels(mlevel,levels)
      call exec_program('@ p_show_map BEAM '//argu1)
      call sic_let_dble('SPACING',space,error)
    else
      c_more = ' '
      call sic_get_logi('DO_DIRTY',do_dirty,error)
      if (do_dirty) then
        c_more = 'BEAM'
      endif
      !
      chain = dtype//trim(c_more)//' '//trim(argu1)//' '//trim(argu2)
      call exec_program('@ p_show_map '//chain)
    endif
  else if (comm.eq.'VIEW') then
    if (dtype.eq.'UV_DATA') then
      continue
    else if (dtype.eq.'CCT') then
      if (hcct%loca%size.eq.0) then
        call map_message(seve%e,comm,'No CCT buffer')
        error = .true.
        return
      endif
      chain = dtype//trim(argu1)//' '//trim(argu2)
      call exec_program('@ p_view_cct '//chain)
    else
      chain = dtype//trim(argu1)//' '//trim(argu2)
      call exec_program('@ p_view_map '//chain)
    endif
  else if (comm.eq.'INSPECT_3D') then
    if (dtype.eq.'UV_DATA') then
      continue
    else if (dtype.eq.'CCT') then
      continue
    else
      chain = dtype//trim(argu1)//' '//trim(argu2)
      call exec_program('@ p_3view_map '//chain)
    endif
  endif
  !
end subroutine display_buffer_sub
!
subroutine create_fields(error)
  use gkernel_interfaces
  use clean_arrays
  use clean_types
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING internalroutine for command
  !     Create the FIELDS array (transposed version of the PRIMARY array)
  !----------------------------------------------------------------------
  logical, intent(out) :: error
  ! Local variables
  !
  character(len=4) :: code
  integer(kind=index_length) :: nfirst,nsecon,nmiddl,nelems,nlast,iblock(5)
  integer :: ier
  !
  if (hprim%loca%size.eq.0) then
    error = .true.
    return
  endif
  error = .false.
  !
  ! If it is allocated, it should be the right one, but play safe...
  if (allocated(dfields)) then
    if (hfields%loca%size.eq.hprim%loca%size) return
    call sic_delvariable('FIELDS',.false.,error)
    deallocate(dfields)
  endif
  call gildas_null(hfields)
  !
  code = '231'
  call gdf_transpose_header(hprim,hfields,code,error)
  ! Determine chunk sizes from code and dimensions.
  call transpose_getblock(hprim%gil%dim,gdf_maxdims,code,iblock,error)
  if (error) return
  !
  ! With only one beam per frequency so far
  if (.not.allocated(dfields)) then
    allocate(dfields(hprim%gil%dim(2),hprim%gil%dim(3),hprim%gil%dim(1),hprim%gil%dim(4)),stat=ier)
    if (ier.ne.0) then
      error = .true.
      return
    endif
  endif
  !
  nelems = iblock(1)
  nfirst = iblock(2)
  nmiddl = iblock(3)
  nsecon = iblock(4)
  nlast  = iblock(5)
  call trans4all(dfields,dprim,nelems,nfirst,nmiddl,nsecon,nlast)
  !
  ! Set Type of First Axis
  hfields%gil%inc(3) = 1.0
  hfields%char%code(3) = 'FIELD'
  call sic_mapgildas ('FIELDS',hfields,error,dfields)
  !
end subroutine create_fields
