subroutine asj45(p,t,d,ha)
  ! J CERNICHARO
  !
  !	ATMOSFERA STANDARD U.S. 1962 MES DE JULIO 45 GRADOS LATITUD NORTE
  !	HA === ALTURA EN KM DONDE SE DESEA CALCULAR P,T,D
  !	P  === PRESION EN MILIBARES
  !	D  === DENSIDAD EN GR/M**3
  !	T  === TEMPERATURA EN K
  !
  real p,t,d,ha
  real pr(91),te(91),den(91)
  integer i0,i1,i2,j
  real x1,x2,x3,y1,y2,y3,a,b,c
  !
  data te/294.15,289.65,285.154,279.156,273.168,267.174,261.186,   &
    254.702,248.215,241.734,235.254,228.773,222.299,215.825,   &
    215.650,215.650,215.650,215.650,216.789,217.982,219.174,   &
    220.367,221.559,222.750,223.942,225.132,226.323,227.513,   &
    229.492,231.573,233.654,235.735,237.814,240.225,242.697,   &
    245.170,247.642,250.115,252.585,255.055,257.525,259.992,   &
    262.460,264.927,267.395,269.860,272.325,274.787,275.650,   &
    275.650,275.650,275.650,275.650,274.245,271.787,269.330,   &
    266.872,264.417,261.960,259.507,257.052,254.600,252.147,   &
    248.931,244.521,240.111,235.701,231.295,226.890,222.484,   &
    218.079,213.678,209.277,204.880,200.484,196.087,191.691,   &
    187.299,182.907,178.515,174.150,174.150,174.150,174.150,   &
    174.150,174.150,174.150,174.150,174.150,174.150,174.150/
  data pr/  &
    .101350e+04,.902198e+03,.801594e+03,.710433e+03,.628063e+03,  &
    .553615e+03,.486632e+03,.426404e+03,.372351e+03,.324024e+03,  &
    .280904e+03,.242550e+03,.208581e+03,.178571e+03,.152506e+03,  &
    .130245e+03,.111251e+03,.950271e+02,.812140e+02,.694686e+02,  &
    .594726e+02,.509578e+02,.437053e+02,.375159e+02,.322292e+02,  &
    .277141e+02,.238504e+02,.205416e+02,.177123e+02,.152931e+02,  &
    .132216e+02,.114455e+02,.992199e+01,.861267e+01,.748802e+01,  &
    .651947e+01,.568409e+01,.496251e+01,.433891e+01,.379863e+01,  &
    .332989e+01,.292305e+01,.256908e+01,.226070e+01,.199169e+01,  &
    .175697e+01,.155167e+01,.137207e+01,.121431e+01,.107476e+01,  &
    .951246,.842033,.745358,.659666,.583315,.515225,.454565,      &
    .400635,.352641,.310106,.272332,.238893,.209295,.183112,      &
    .159876,.139244,.120964,.104821,.905822e-01,.780538e-01,      &
    .670582e-01,.574425e-01,.490475e-01,.417458e-01,.354072e-01,  &
    .299215e-01,.251894e-01,.211250e-01,.176426e-01,.146698e-01,  &
    .121421e-01,.100283e-01,.828248e-02,.684195e-02,.565195e-02,  &
    .466893e-02,.358689e-02,.318670e-02,.263297e-02,.217545e-02,  &
    .179779e-02/
  data den/  &
    .119194e04,.107953e04,.975726e03,.884585e03,.799782e03,         &
    .721113e03,.648694e03,.582972e03,.522462e03,.466877e03,         &
    .415928e03,.369346e03,.326869e03,.288235e03,.246363e03,         &
    .210402e03,.179719e03,.153510e03,.130507e03,.111022e03,         &
    .945290e02,.805568e02,.687200e02,.586725e02,.501363e02,         &
    .428845e02,.367119e02,.314533e02,.268872e02,.230062e02,         &
    .197129e02,.169141e02,.145345e02,.124899e02,.107483e02,         &
    .926367e01,.799602e01,.691194e01,.598427e01,.518837e01,         &
    .450452e01,.391664e01,.340998e01,.297272e01,.259482e01,         &
    .226811e01,.198495e01,.173947e01,.153465e01,.135829e01,         &
    .120219e01,.106417e01,.941988,.837960,.747673,.666424,.593377,  &
    .527834,.468961,.416292,.369075,.326876,.289163,.256257,        &
    .227775,.202024,.178786,.157877,.139080,.122217,.107121,        &
    .936510e-01,.816457e-01,.709824e-01,.615248e-01,.531584e-01,    &
    .457778e-01,.392916e-01,.336024e-01,.286279e-01,.242889e-01,    &
    .200605e-01,.165682e-01,.136866e-01,.113061e-01,.933969e-02,    &
    .717528e-02,.637464e-02,.526696e-02,.435175e-02,.359628e-02/
  !
  !	INTERPOLACION PARABOLICA ENTRE TRES PUNTOS
  !
  !	CALL POLI2
  !
  i1=ha+1
  i0=i1-1
  i2=i1+1
  if (i0.gt.0)  go to 10
  i1=i1+1
  i2=i2+1
  i0=i0+1
10 x1=i0-1
  x2=i1-1
  x3=i2-1
  do 3 j=1,3
    go to (5,6,7)j
5   y1=pr(i0)
    y2=pr(i1)
    y3=pr(i2)
    call poli2_4(x1,x2,x3,y1,y2,y3,a,b,c)
    p=a+b*ha+c*ha**2
    go to 3
6   y1=te(i0)
    y2=te(i1)
    y3=te(i2)
    call poli2_4(x1,x2,x3,y1,y2,y3,a,b,c)
    t=a+b*ha+c*ha*ha
    go to 3
7   y1=den(i0)
    y2=den(i1)
    y3=den(i2)
    call poli2_4(x1,x2,x3,y1,y2,y3,a,b,c)
    d=a+b*ha+c*ha**2
3   continue
  return
end subroutine asj45
