!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cube_debug
  use cubetools_structure
  use cubetools_keyword_arg
  use cubetools_parameters
  use cubeset_messaging
  use cubeadm_setup
  !
  public :: cube_debug_command,cube_debug_register
  private
  !
  type :: debug_comm_t
     type(option_t),      pointer :: debug
     type(keyword_arg_t), pointer :: topic_arg
     type(keyword_arg_t), pointer :: subtopic_arg
     type(keyword_arg_t), pointer :: onoff_arg
     type(option_t),      pointer :: messages
  end type debug_comm_t
  type(debug_comm_t) :: comm
  !
contains
  !
  subroutine cube_debug_register(error)    
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    type(keyword_arg_t) :: keyarg
    character(len=*), parameter :: comm_abstract = &
         'Set which debugging messages are displayed'
    character(len=*), parameter :: comm_help = &
         'DEBUG without any topic or subtopic will display which&
         & debug or trace messages are active. All debug messages&
         & for a topic can be turned ON or OFF at once if no subtopic&
         & is provided, Also all debug messages for all topics can be&
         & turned ON or OFF if no topic is given'
    character(len=*), parameter :: topics(9) = &
         ['ADM    ','CUBE   ','COMPUTE','EDIT   ','FIT    ','GO     ','IO     ','SET    ','TOOLS  ']
    character(len=*), parameter :: subtopics(5) = &
         [strg_star//'            ','ALLOCATION   ','TRANSPOSITION','TRACE        ','OTHERS       ']
    character(len=*), parameter :: onoff(2)  = ['ON ','OFF']
    
    character(len=*), parameter :: rname='DEBUG>REGISTER'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'DEBUG','[[Topic [Subtopic]] ON|OFF]',&
         comm_abstract,&
         comm_help,&
         cube_debug_command,&
         comm%debug,error)
    if (error) return
    call keyarg%register( &
         'topic',  &
         'Select topic for debug messages', &
         strg_id,&
         code_arg_optional, &
         topics, &
         .not.flexible, &
         comm%topic_arg,&
         error)
    if (error) return
    call keyarg%register( &
         'subtopic',  &
         'Select subtopic for debug messages', &
         strg_id,&
         code_arg_optional, &
         subtopics, &
         .not.flexible, &
         comm%subtopic_arg, &
         error)
    if (error) return   
    call keyarg%register( &
         'onoff',  &
         'Debug messages ON or OFF', &
         strg_id,&
         code_arg_optional, &
         onoff, &
         .not.flexible, &
         comm%onoff_arg,&
         error)
    if (error) return    
    !
    call cubetools_register_option(&
         'MESSAGES','ON|OFF',&
         'Enable or disable messages in debug mode',&
         'If enabled, messages in debug mode will also show the calling &
         &subroutine name',&
         comm%messages,error)
    if (error) return
    call keyarg%register( &
         'ONOFF',  &
         'Debug messages ON or OFF', &
         strg_id,&
         code_arg_mandatory, &
         onoff, &
         .not.flexible, &
         comm%onoff_arg,&
         error)
    if (error) return
    !
  end subroutine cube_debug_register
  !
  subroutine cube_debug_command(line,error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: rname='DEBUG>COMMAND'
    !
    call cube_debug_parse(line,error)
    if (error) return
  end subroutine cube_debug_command
  !
  subroutine cube_debug_parse(line,error)
    use cubeadm_messaging
    use cubecompute_messaging
    use cubedag_messaging
    use cubeedit_messaging
    use cubefit_messaging
    use cubego_messaging
    use cubeio_messaging
    use cubemain_messaging
    use cubeset_messaging
    use cubetools_messaging
    !---------------------------------------------------------------------
    ! Support routine for command
    ! DEBUG [Topic] [subtopic] ON|OFF
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    ! Topics
    logical :: domessages,turnon
    integer(kind=4) :: iswitch,ikey
    character(len=argu_l) :: keyword,argum
    type(option_t), pointer :: opt
    character(len=*), parameter :: rname='DEBUG>PARSE'
    !
    ! /MESSAGES ?
    call comm%messages%present(line,domessages,error)
    if (error) return
    !
    ! Parse the ON|OFF switch
    if (domessages) then
      opt => comm%messages
      iswitch = comm%messages%getnarg()
    else
      opt => comm%debug
      iswitch = comm%debug%getnarg()
      if (iswitch.eq.0) then
        call cube_debug_print(error)
        return
      elseif (iswitch.gt.3) then
        call cubeset_message(seve%e,rname,  &
              'Syntax should be: DEBUG [Topic [Subtopic]] ON|OFF')
        error = .true.
        return
      endif
    endif
    !
    call cubetools_getarg(line,opt,iswitch,argum,mandatory,error)
    if (error) return
    call cubetools_keyword_user2prog(comm%onoff_arg,argum,ikey,keyword,error)
    if (error) return
    !
    turnon = keyword.eq.'ON'
    !
    ! DEBUG ON|OFF
    if (associated(opt,comm%debug).and.iswitch.eq.1) then
       call cube_debug_all(error)
       if(error) return
       return
    endif
    !
    if (domessages) then
      ! DEBUG /MESSAGES ON|OFF
      keyword = 'MESSAGES'
    else
      ! DEBUG Topic [Subtopic] ON|OFF => Parse the topic
      call cubetools_getarg(line,comm%debug,1,argum,mandatory,error)
      if (error) return
      call cubetools_keyword_user2prog(comm%topic_arg,argum,ikey,keyword,error)
      if (error) return
    endif
    !
    select case (keyword)
    case('ADM')
       call cube_debug_adm_parse(line,error)
    case('COMPUTE')
       call cube_debug_compute_parse(line,error)
    case('CUBE')
       call cube_debug_main_parse(line,error)
    case('DAG')
       call cube_debug_dag_parse(line,error)
    case('EDIT')
       call cube_debug_edit_parse(line,error)       
    case('FIT')
       call cube_debug_fit_parse(line,error)       
    case('GO')
       call cube_debug_go_parse(line,error)
    case('IO')
       call cube_debug_io_parse(line,error)
    case('SET')
       call cube_debug_set_parse(line,error)
    case('TOOLS')
       call cube_debug_tools_parse(line,error)
    case('MESSAGES')
       call cube_debug_messages_parse(line,error)
    case default
       call cubeset_message(seve%e,rname,'Unknown topic '//keyword)
       error = .true. 
    end select
    if (error)  return
    !
  contains
    !
    subroutine cube_debug_all(error)
      use cubetools_cmessaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG  ON|OFF
      !---------------------------------------------------------------------
      logical, intent(inout) :: error
      !
      call cubeset_message_set_trace(turnon)
      call cubeset_message_set_others(turnon)
      !
!!$    call cubedag_message_set_trace(turnon)
!!$    call cubedag_message_set_others(turnon)
      !
      call cubego_message_set_trace(turnon)
      call cubego_message_set_others(turnon)
      !
      call cubeio_message_set_alloc(turnon)
      call cubeio_message_set_trans(turnon)
      call cubeio_message_set_trace(turnon)
      call cubeio_message_set_others(turnon)
      !
      call cubeadm_message_set_trace(turnon)
      call cubeadm_message_set_others(turnon)
      !
      call cubemain_message_set_alloc(turnon)
      call cubemain_message_set_trace(turnon)
      call cubemain_message_set_others(turnon)
      !
      call cubeset_message_set_trace(turnon)
      call cubeset_message_set_others(turnon)
      !
      call cubetools_message_set_alloc(turnon)
      call cubetools_message_set_trace(turnon)
      call cubetools_message_set_others(turnon)
      !
      call cubefit_message_set_alloc(turnon)
      call cubefit_message_set_trace(turnon)
      call cubefit_message_set_others(turnon)
      !
      call cubeedit_message_set_trace(turnon)
      call cubeedit_message_set_others(turnon)
      !
      call cubetools_cmessaging_debug(turnon)
    end subroutine cube_debug_all
    !
    subroutine cube_debug_adm_parse(line,error)
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG ADM [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
      select case (keyword)
      case (strg_star)
         call cubeadm_message_set_trace(turnon)
         call cubeadm_message_set_alloc(turnon)
         call cubeadm_message_set_others(turnon)
      case('ALLOCATION')
         call cubeadm_message_set_alloc(turnon)
      case ('TRACE')
         call cubeadm_message_set_trace(turnon)
      case ('OTHERS')
         call cubeadm_message_set_others(turnon)
      case default
         call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
      end select
      if (error)  return 
    end subroutine cube_debug_adm_parse
    !
    subroutine cube_debug_compute_parse(line,error)
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG COMPUTE [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
      select case (keyword)
      case (strg_star)
         call cubecompute_message_set_trace(turnon)
         call cubecompute_message_set_alloc(turnon)
         call cubecompute_message_set_others(turnon)
      case('ALLOCATION')
         call cubecompute_message_set_alloc(turnon)
      case ('TRACE')
         call cubecompute_message_set_trace(turnon)
      case ('OTHERS')
         call cubecompute_message_set_others(turnon)
      case default
         call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
      end select
      if (error)  return 
    end subroutine cube_debug_compute_parse
    !
    subroutine cube_debug_dag_parse(line,error)
      use cubedag_messaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG DAG [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
!!$    select case (keyword)
!!$    case (strg_star)
!!$       call cubedag_message_set_trace(turnon)
!!$       call cubedag_message_set_others(turnon)
!!$    case ('TRACE')
!!$       call cubedag_message_set_trace(turnon)
!!$    case ('OTHERS')
!!$       call cubedag_message_set_others(turnon)
!!$    case default
!!$       call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
!!$    end select
!!$    if (error)  return 
    end subroutine cube_debug_dag_parse
    !
    subroutine cube_debug_go_parse(line,error)
      use cubego_messaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG GO [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
      select case (keyword)
      case (strg_star)
         call cubego_message_set_trace(turnon)
         call cubego_message_set_others(turnon)
      case ('TRACE')
         call cubego_message_set_trace(turnon)
      case ('OTHERS')
         call cubego_message_set_others(turnon)
      case default
         call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
      end select
      if (error)  return 
    end subroutine cube_debug_go_parse
    !   
    subroutine cube_debug_io_parse(line,error)
      use cubeio_messaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG IO [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
      select case (keyword)
      case (strg_star)
         call cubeio_message_set_alloc(turnon)
         call cubeio_message_set_trans(turnon)
         call cubeio_message_set_trace(turnon)
         call cubeio_message_set_others(turnon)
      case ('ALLOCATION')
         call cubeio_message_set_alloc(turnon)
      case ('TRANSPOSITION')
         call cubeio_message_set_trans(turnon)
      case ('TRACE')
         call cubeio_message_set_trace(turnon)
      case ('OTHERS')
         call cubeio_message_set_others(turnon)
      case default
         call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
      end select
      if (error)  return 
    end subroutine cube_debug_io_parse
    !   
    subroutine cube_debug_main_parse(line,error)
      use cubemain_messaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG CUBE [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
      select case (keyword)
      case (strg_star)
         call cubemain_message_set_alloc(turnon)
         call cubemain_message_set_trace(turnon)
         call cubemain_message_set_others(turnon)
      case ('ALLOCATION')
         call cubemain_message_set_alloc(turnon)
      case ('TRACE')
         call cubemain_message_set_trace(turnon)
      case ('OTHERS')
         call cubemain_message_set_others(turnon)
      case default
         call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
      end select
      if (error)  return 
    end subroutine cube_debug_main_parse
    !
    subroutine cube_debug_fit_parse(line,error)
      use cubefit_messaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG FIT [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
      select case (keyword)
      case (strg_star)
         call cubefit_message_set_alloc(turnon)
         call cubefit_message_set_trace(turnon)
         call cubefit_message_set_others(turnon)
      case ('ALLOCATION')
         call cubefit_message_set_alloc(turnon)
      case ('TRACE')
         call cubefit_message_set_trace(turnon)
      case ('OTHERS')
         call cubefit_message_set_others(turnon)
      case default
         call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
      end select
      if (error)  return 
    end subroutine cube_debug_fit_parse
    !
    subroutine cube_debug_edit_parse(line,error)
      use cubeedit_messaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG EDIT [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
      select case (keyword)
      case (strg_star)
         call cubeedit_message_set_trace(turnon)
         call cubeedit_message_set_others(turnon)
      case ('TRACE')
         call cubeedit_message_set_trace(turnon)
      case ('OTHERS')
         call cubeedit_message_set_others(turnon)
      case default
         call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
      end select
      if (error)  return 
    end subroutine cube_debug_edit_parse
    !
    subroutine cube_debug_set_parse(line,error)
      use cubeset_messaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG SET [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
      select case (keyword)
      case (strg_star)
         call cubeset_message_set_trace(turnon)
         call cubeset_message_set_others(turnon)
      case ('TRACE')
         call cubeset_message_set_trace(turnon)
      case ('OTHERS')
         call cubeset_message_set_others(turnon)
      case default
         call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
      end select
      if (error)  return 
    end subroutine cube_debug_set_parse
    !   
    subroutine cube_debug_tools_parse(line,error)
      use cubetools_messaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG TOOLS [subtopic] ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      if (iswitch.eq.2) then
         keyword = strg_star
      else
         call cubetools_getarg(line,comm%debug,iswitch-1,argum,mandatory,error)
         if (error) return
         call cubetools_keyword_user2prog(comm%subtopic_arg,argum,ikey,keyword,error)
         if (error) return
      endif
      select case (keyword)
      case (strg_star)
         call cubetools_message_set_alloc(turnon)
         call cubetools_message_set_trace(turnon)
         call cubetools_message_set_others(turnon)
      case ('ALLOCATION')
         call cubetools_message_set_alloc(turnon)
      case ('TRACE')
         call cubetools_message_set_trace(turnon)
      case ('OTHERS')
         call cubetools_message_set_others(turnon)
      case default
         call cubeset_message(seve%w,rname,"Subtopic "//trim(keyword)//" not available for this topic")
      end select
      if (error)  return 
    end subroutine cube_debug_tools_parse
    !
    subroutine cube_debug_messages_parse(line,error)
      use cubetools_cmessaging
      !---------------------------------------------------------------------
      ! Support routine for command
      ! DEBUG /MESSAGES ON|OFF
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: line
      logical,          intent(inout) :: error
      !
      call cubetools_cmessaging_debug(turnon)
    end subroutine cube_debug_messages_parse
    !
    subroutine cube_debug_print(error)
      !---------------------------------------------------------------------
      !
      !---------------------------------------------------------------------
      logical, intent(inout) :: error
      !
      character(len=*), parameter :: rname='DEBUG>PRINT'
      character(len=mess_l) :: mess
      !
      call cubeset_message(seve%r,rname,'  Debug')
      write(mess,'(A,4(A,L))')  '    IO    : ',  &
           'Allocation ',cubeio_message_get_alloc(),  &
           ', Transposition ',cubeio_message_get_trans(), &
           ', Trace ',cubeio_message_get_trace(), &
           ', Others ',cubeio_message_get_others()
      call cubeset_message(seve%r,rname,mess)
      write(mess,'(3(A,L))')  '    ADM   : Trace ',cubeadm_message_get_trace(),  &
           ', Allocation ',cubeadm_message_get_alloc(),', Others ',cubeadm_message_get_others()
      call cubeset_message(seve%r,rname,mess)
      write(mess,'(3(A,L))')  '    TOOLS : Allocation ',cubetools_message_get_alloc(),  &
           ', Trace ',cubetools_message_get_trace(), &
           ', Others ',cubetools_message_get_others()
      call cubeset_message(seve%r,rname,mess)
      !
      write(mess,'(3(A,L))')  '    CUBE  : Allocation ',cubemain_message_get_alloc(),  &
           ', Trace ',cubemain_message_get_trace(), &
           ', Others ',cubemain_message_get_others()
      call cubeset_message(seve%r,rname,mess)
      !
      write(mess,'(3(A,L))')  '    FIT   : Allocation ',cubefit_message_get_alloc(),  &
           ', Trace ',cubefit_message_get_trace(), &
           ', Others ',cubefit_message_get_others()
      call cubeset_message(seve%r,rname,mess)
      !
      write(mess,'(2(A,L))')  '    EDIT  : Trace ',cubeedit_message_get_trace(),  &
           ', Others ',cubeedit_message_get_others()
      call cubeset_message(seve%r,rname,mess)
      !
      write(mess,'(2(A,L))')  '    SET   : Trace ',cubeset_message_get_trace(),  &
           ', Others ',cubeset_message_get_others()
      call cubeset_message(seve%r,rname,mess)
      !
      write(mess,'(2(A,L))')  '    GO    : Trace ',cubego_message_get_trace(),  &
           ', Others ',cubego_message_get_others()
      call cubeset_message(seve%r,rname,mess)
      !
      ! write(mess,'(2(A,L))')  '    DAG: Trace ',cubedag_message_get_trace(),  &
      !      ', Others ',cubedag_message_get_others()
      ! call cubeset_message(seve%r,rname,mess)
    end subroutine cube_debug_print
  end subroutine cube_debug_parse
end module cube_debug
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
