!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_visi_types
  use cubetools_array_types
  use cube_types
  use cubeadm_messaging
  !
  public :: visi_t
  private
  !
  type, extends(cplx_2d_t) :: visi_t
     logical :: uvkind = .true.              ! uv or lm plane?
     type(cube_t), pointer :: cube => null() ! Associated cube
   contains
     procedure, public :: allocate  => cubeadm_visi_allocate
     procedure, public :: associate => cubeadm_visi_associate
     procedure, public :: get       => cubeadm_visi_get
     procedure, public :: put       => cubeadm_visi_put
     procedure, public :: put_in    => cubeadm_visi_put_in
  end type visi_t
  !
contains
  !
  subroutine cubeadm_visi_allocate(visi,name,cube,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(visi_t),        intent(out)   :: visi
    character(len=*),     intent(in)    :: name
    type(cube_t), target, intent(in)    :: cube
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='VISI>ALLOCATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (.not.cube%iscplx()) then
       call cubeadm_message(seve%e,rname,  &
            'Invalid attempt to get a C*4 image from a R*4 cube')
       error = .true.
       return
    endif
    !
    call visi%reallocate(name,&
         cube%tuple%current%desc%nx,&
         cube%tuple%current%desc%ny,&
         error)
    if (error) return
    visi%cube => cube
  end subroutine cubeadm_visi_allocate
  !
  subroutine cubeadm_visi_associate(visi,name,cube,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(visi_t),        intent(out)   :: visi
    character(len=*),     intent(in)    :: name
    type(cube_t), target, intent(in)    :: cube
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='VISI>ASSOCIATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (.not.cube%iscplx()) then
       call cubeadm_message(seve%e,rname,  &
            'Invalid attempt to get a C*4 image from a R*4 cube')
       error = .true.
       return
    endif
    !
    call visi%prepare_association(name,&
         cube%tuple%current%desc%nx,&
         cube%tuple%current%desc%ny,&
         error)
    if (error) return
    visi%cube => cube
  end subroutine cubeadm_visi_associate
  !
  !------------------------------------------------------------------------
  !
  subroutine cubeadm_visi_get(visi,ient,error)
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Get the ient image from the cube.
    ! When visi%val is an allocated pointer, we make a copy.
    ! In all other cases (associated or null), we make it point to the data.
    !---------------------------------------------------------------------
    class(visi_t),        intent(inout) :: visi
    integer(kind=entr_k), intent(in)    :: ient
    logical,              intent(inout) :: error
    ! 
    type(cube_chan_t) :: entry
    character(len=*), parameter :: rname='GET>VISI'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubetuple_get_chan(visi%cube%user,visi%cube%prog,visi%cube,ient,entry,error)
    if (error) return
    !
    if (visi%pointeris.eq.code_pointer_allocated) then
       visi%val(:,:) = entry%c4(:,:)
    else
       visi%val => entry%c4
       visi%pointeris = code_pointer_associated
    endif
    visi%nx = entry%nx
    visi%ny = entry%ny
    visi%uvkind = .true.
    !
    call cubeio_free_chan(entry,error)
    if (error) return
  end subroutine cubeadm_visi_get
  !
  subroutine cubeadm_visi_put(visi,ient,error)
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Put the ient image to the cube
    ! Only use pointers => Nothing to free
    !---------------------------------------------------------------------
    class(visi_t),        intent(in)    :: visi
    integer(kind=entr_k), intent(in)    :: ient
    logical,              intent(inout) :: error
    !
    type(cube_chan_t) :: entry
    character(len=*), parameter :: rname='VISI>PUT>ARRAY'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    entry%allocated = code_pointer_associated
    entry%nx = visi%nx
    entry%ny = visi%ny
    entry%c4 => visi%val
    entry%iscplx = .true.
    !
    call cubetuple_put_chan(visi%cube%user,visi%cube%prog,visi%cube,ient,entry,error)
    if (error) return
  end subroutine cubeadm_visi_put
  !
  subroutine cubeadm_visi_put_in(visi,cube,ient,error)
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Put the ient visi to the cube.
    ! Only use pointers => Nothing to free.
    !
    ! This flavor, which explicitely states the output cube, should be used
    ! when the input visi needs to be written in another cube without
    ! copy. See, eg, the copy tool. This should an exotic use compare to
    ! cubeadm_visi_put.
    ! ---------------------------------------------------------------------
    class(visi_t),        intent(in)    :: visi
    type(cube_t),         intent(inout) :: cube
    integer(kind=entr_k), intent(in)    :: ient
    logical,              intent(inout) :: error
    !
    type(cube_chan_t) :: entry
    character(len=*), parameter :: rname='VISI>PUT>IN'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    entry%allocated = code_pointer_associated
    entry%nx = visi%nx
    entry%ny = visi%ny
    entry%c4 => visi%val
    entry%iscplx = .true.
    !
    call cubetuple_put_chan(cube%user,cube%prog,cube,ient,entry,error)
    if (error) return
  end subroutine cubeadm_visi_put_in
end module cubeadm_visi_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
