!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_fft
  use cubetools_parameters
  use cubetools_structure
  use cube_types
  use cubeadm_cubeid_types
  use cubecompute_messaging
  use cubecompute_fft_visi_tool
  use cubetemplate_sperange_types
  !
  public :: fft
  public :: cubecompute_fft_command
  private
  !
  type :: fft_comm_t
     type(option_t), pointer :: comm
     type(fft_visi_opt_t)    :: direction
     type(sperange_opt_t)    :: range
   contains
     procedure, public  :: register => cubecompute_fft_register
     procedure, private :: parse    => cubecompute_fft_parse
     procedure, private :: ima      => cubecompute_fft_ima
  end type fft_comm_t
  type(fft_comm_t) :: fft
  !
  integer(kind=4), parameter :: icube = 1
  type fft_user_t
     type(cubeid_user_t)   :: cubeids
     type(fft_visi_user_t) :: direction
     type(sperange_user_t) :: range
   contains
     procedure, private :: toprog => cubecompute_fft_user_toprog
  end type fft_user_t
  !
  type fft_prog_t
     integer(kind=code_k)  :: fftdirection
     type(sperange_prog_t) :: range     ! 
     type(cube_t), pointer :: incube    ! Input cube
     type(cube_t), pointer :: oucube    ! Output cube
     integer(kind=chan_k)  :: first = 0 ! [---] First channel
     integer(kind=chan_k)  :: last  = 0 ! [---] Last  channel
     !
     procedure(cubecompute_fft_prog_image2visi_loop), private, pointer :: loop => null()
     procedure(cubecompute_fft_prog_image2visi_act),  private, pointer :: act  => null()
   contains
     procedure, private :: header => cubecompute_fft_prog_header
     procedure, private :: data   => cubecompute_fft_prog_data
  end type fft_prog_t
  !
contains
  !
  subroutine cubecompute_fft_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(fft_user_t) :: user
    character(len=*), parameter :: rname='FFT>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    call fft%parse(line,user,error)
    if (error) return
    call fft%ima(user,error)
    if (error) continue
  end subroutine cubecompute_fft_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_fft_register(fft,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fft_comm_t), intent(inout) :: fft
    logical,           intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: comm_abstract=&
         'Fourier transform a real or complex cube'
    character(len=*), parameter :: comm_help=&
         'The output will be either real or complex.'
    character(len=*), parameter :: rname='FFT>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'FFT','[cube]',&
         comm_abstract,&
         comm_help,&
         cubecompute_fft_command,&
         fft%comm,error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Input data',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         error)
    if (error) return
    !
    call fft%direction%register(error)
    if (error) return
    !
    call fft%range%register('RANGE',&
         'Define velocity range over which to compute the FFT',&
         error)
    if (error) return
  end subroutine cubecompute_fft_register
  !
  subroutine cubecompute_fft_parse(fft,line,user,error)
    use cubetools_parse
    !----------------------------------------------------------------------
    ! FFT cubeid [/DIRECT | /INVERSE] [/RANGE vfirst vlast]
    !----------------------------------------------------------------------
    class(fft_comm_t), intent(in)    :: fft
    character(len=*),  intent(in)    :: line
    type(fft_user_t),  intent(out)   :: user
    logical,           intent(inout) :: error
    !
    character(len=*), parameter :: rname='FFT>PARSE'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,fft%comm,user%cubeids,error)
    if (error) return
    call fft%direction%parse(line,user%direction,error)
    if (error) return
    call fft%range%parse(line,user%range,error)
    if (error) return
  end subroutine cubecompute_fft_parse
  !
  subroutine cubecompute_fft_ima(fft,user,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fft_comm_t), intent(in)    :: fft
    type(fft_user_t),  intent(in)    :: user
    logical,           intent(inout) :: error
    !
    type(fft_prog_t) :: prog
    character(len=*), parameter :: rname='FFT>IMA'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubecompute_fft_ima
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_fft_user_toprog(user,prog,error)
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fft_user_t), intent(in)    :: user
    type(fft_prog_t),  intent(out)   :: prog
    logical,           intent(inout) :: error
    !
    character(len=*), parameter :: rname='FFT>USER>TOPROG'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(fft%comm,icube,user%cubeids,&
         code_access_imaset,code_read,prog%incube,error)
    if (error) return
    call user%direction%toprog(prog%incube,prog%fftdirection,error)
    if (error) return
    call user%range%toprog(prog%incube,prog%range,error)
    if (error) return
  end subroutine cubecompute_fft_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_fft_prog_header(prog,error)
    use cubetools_axis_types
    use cubetools_header_methods
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fft_prog_t), intent(inout) :: prog
    logical,           intent(inout) :: error
    !
    type(axis_t) :: axis
    integer(kind=chan_k) :: stride
    character(len=*), parameter :: rname='FFT>PROG>HEADER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%incube,flag_fft,prog%oucube,error)
    if (error) return
    ! *** JP I only code two cases making the assumption that visi is hermitian.
    ! *** JP To be generic, we should also considers the cases where visi is not!
    if (prog%incube%iscplx()) then
       prog%loop => cubecompute_fft_prog_visi2image_loop
       prog%act  => cubecompute_fft_prog_visi2image_act
       call cubecompute_fft_visi_prog_header_visi2image(prog%incube%head,prog%oucube%head,error)
       if (error) return
    else
       prog%loop => cubecompute_fft_prog_image2visi_loop
       prog%act  => cubecompute_fft_prog_image2visi_act
       call cubecompute_fft_visi_prog_header_image2visi(prog%incube%head,prog%oucube%head,error)
       if (error) return
    endif
    !
    ! Apply range selection to header
    call cubetools_header_get_axis_head_f(prog%oucube%head,axis,error)
    if (error) return
    call prog%range%to_chan_k(prog%first,prog%last,stride,error)
    if (error) return
    axis%n = prog%last-prog%first+1
    axis%ref = axis%ref-prog%first+1
    call cubetools_header_update_frequency_from_axis(axis,prog%oucube%head,error)
    if (error) return
  end subroutine cubecompute_fft_prog_header
  !
  subroutine cubecompute_fft_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fft_prog_t), intent(inout) :: prog
    logical,           intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='FFT>PROG>DATA'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error) exit
       !$OMP TASK SHARED(prog,error) FIRSTPRIVATE(iter)
       if (.not.error) call prog%loop(iter%first,iter%last,error)
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubecompute_fft_prog_data
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_fft_prog_image2visi_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fft_prog_t),    intent(inout) :: prog
    integer(kind=entr_k), intent(in)    :: first
    integer(kind=entr_k), intent(in)    :: last    
    logical,              intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(visi_t) :: visi
    type(image_t) :: image
    type(fft_visi_prog_t) :: fft
    character(len=*), parameter :: rname='FFT>PROG>IMAGE2VISI>LOOP'
    !
    call image%associate('image',prog%incube,error)
    if (error) return
    call visi%allocate('visi',prog%oucube,error)
    if (error) return
    call fft%init(prog%fftdirection,image,visi,error)
    if (error) return
    !
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error) return
      call prog%act(fft,ie,error)
      if (error) return
    enddo
  end subroutine cubecompute_fft_prog_image2visi_loop
  !
  subroutine cubecompute_fft_prog_image2visi_act(prog,fft,ie,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fft_prog_t),     intent(inout) :: prog
    type(fft_visi_prog_t), intent(inout) :: fft
    integer(kind=entr_k),  intent(in)    :: ie
    logical,               intent(inout) :: error
    !
    integer(kind=entr_k) :: oe
    character(len=*), parameter :: rname='FFT>PROG>IMAGE2VISI>ACT'
    !
    if (ie.gt.prog%first.or.ie.le.prog%last) then
       call fft%image%get(ie,error)
       if (error) return
       call fft%image2visi(error)
       if (error) return
       call fft%compute(error)
       if (error) return
       call fft%normalize(error)
       if (error) return
       oe = ie-prog%first+1
       call fft%visi%put(oe,error)
       if (error) return
    else
       ! Nothing to be done
    endif
  end subroutine cubecompute_fft_prog_image2visi_act
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_fft_prog_visi2image_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fft_prog_t),    intent(inout) :: prog
    integer(kind=entr_k), intent(in)    :: first
    integer(kind=entr_k), intent(in)    :: last    
    logical,              intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(visi_t) :: visi
    type(image_t) :: image
    type(fft_visi_prog_t) :: fft
    character(len=*), parameter :: rname='FFT>PROG>VISI2IMAGE>LOOP'
    !
    call visi%associate('visi',prog%incube,error)
    if (error) return
    call image%allocate('image',prog%oucube,error)
    if (error) return
    call fft%init(prog%fftdirection,image,visi,error)
    if (error) return
    !
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error) return
      call prog%act(fft,ie,error)
      if (error) return
    enddo
  end subroutine cubecompute_fft_prog_visi2image_loop
  !
  subroutine cubecompute_fft_prog_visi2image_act(prog,fft,ie,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(fft_prog_t),     intent(inout) :: prog
    type(fft_visi_prog_t), intent(inout) :: fft
    integer(kind=entr_k),  intent(in)    :: ie
    logical,               intent(inout) :: error
    !
    integer(kind=entr_k) :: oe
    character(len=*), parameter :: rname='FFT>PROG>VISI2IMAGE>ACT'
    !
    if (ie.gt.prog%first.or.ie.le.prog%last) then
       call fft%visi%get(ie,error)
       if (error) return
       call fft%compute(error)
       if (error) return
       call fft%normalize(error)
       if (error) return
       call fft%visi2image(error)
       if (error) return
       oe = ie-prog%first+1
       call fft%image%put(oe,error)
       if (error) return
    else
       ! Nothing to be done
    endif
  end subroutine cubecompute_fft_prog_visi2image_act
end module cubecompute_fft
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
