!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! *** JP For historical reasons, center is still used in some places
! *** JP As a matter of fact, this is a more generic notion of spatial position
! *** JP It could be a center or something else.
! *** JP Where center is still hardtyped, we should have the possibility to customize
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_spapos_types
  use cubetools_structure
  use cubetools_keyword_arg
  use cubetemplate_messaging
  !
  public :: spapos_opt_t,spapos_user_t,spapos_prog_t
  private
  !
  character(len=8), parameter :: ctypes(3) = [strg_star//'       ','Relative','Absolute']
  !
  type spapos_opt_t
     type(option_t),      pointer :: opt
     type(keyword_arg_t), pointer :: coortype
   contains
     procedure :: register  => cubetemplate_spapos_register
     procedure :: parse     => cubetemplate_spapos_parse
  end type spapos_opt_t
  !
  type spapos_user_t
     logical               :: do = .false.     ! Option was present
     character(len=argu_l) :: l = strg_star    ! [RA |LII] Position
     character(len=argu_l) :: m = strg_star    ! [DEC|BII] Position
     character(len=argu_l) :: type = strg_star ! RELATIVE|ABSOLUTE position is absolute or relative
     character(len=argu_l) :: unit = strg_star ! Position unit, context dependent
   contains
     procedure :: init          => cubetemplate_spapos_user_init
     ! procedure :: def_substruct => cubetemplate_spapos_user_def_substruct
     procedure :: from_line     => cubetemplate_spapos_user_from_line
     procedure :: toprog        => cubetemplate_spapos_user_toprog
     procedure :: list          => cubetemplate_spapos_user_list
  end type spapos_user_t
  !
  type spapos_prog_t
     real(kind=coor_k)    :: abso(2) = (/ 0d0,0d0 /) ! [rad]
     real(kind=coor_k)    :: rela(2) = (/ 0d0,0d0 /) ! [rad]
     real(kind=coor_k)    :: frac(2)                 ! Pixel fractional position
     integer(kind=pixe_k) :: pixe(2)                 ! Nearest integer pixel
     integer(kind=entr_k) :: ie                      ! Closest Matching entry
  end type spapos_prog_t
  !
contains
  !
  subroutine cubetemplate_spapos_register(option,name,abstract,error)
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(spapos_opt_t), intent(out)   :: option
    character(len=*),    intent(in)    :: name
    character(len=*),    intent(in)    :: abstract
    logical,             intent(inout) :: error
    !
    type(standard_arg_t) :: stdarg
    type(keyword_arg_t)  :: keyarg
    character(len=*), parameter :: rname='SPAPOS>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         name,'lpos mpos type [unit]',&
         abstract,&
         "Describe a position in terms of relative or absolute&
         & coordinates. In case of relative coordinates they are&
         & relative to the current projection center, the possible&
         & units for a relative position are FOV units. Absolute&
         & positions can be given in three possible units: Equatorial&
         & (sexagesimal strings in the current spatial frame), Radian&
         & or Degree",&
         option%opt,error)
    if (error) return
    call stdarg%register(&
         'lpos',&
         'Position in L coordinate',&
          '"*" or "=" mean current projection center',&
          code_arg_mandatory,error)
    if (error) return
    call stdarg%register(&
         'mpos',&
         'Position in m coordinate',&
         '"*" or "=" mean current projection center',&
         code_arg_mandatory,&
         error)
    if (error) return
    call keyarg%register(&
         'type',&
         'Coordinates type',&
         strg_id,&
         code_arg_mandatory,&
         ctypes,&
         .not.flexible,&
         option%coortype,&
         error)
    if (error) return
    call stdarg%register(&
         'unit',&
         'Unit for lpos and mpos',&
         'Available units depend on center type:'//strg_cr//&
         '- FOV units for relative,'//strg_cr//&
         '- equatorial (i.e. sexagesimal hour angles and degrees if &
         &equatorial system, both sexagesimal degrees if galactic system), &
         &degrees or radians for absolute.',&
         code_arg_optional, error)
    if (error) return
  end subroutine cubetemplate_spapos_register
  !
  subroutine cubetemplate_spapos_parse(option,line,user,error)
    !----------------------------------------------------------------------
    ! /POS l m type [unit]
    !----------------------------------------------------------------------
    class(spapos_opt_t), intent(in)    :: option
    character(len=*),    intent(in)    :: line
    type(spapos_user_t), intent(out)   :: user
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPAPOS>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    user%l = strg_star
    user%m = strg_star
    user%type = strg_star
    user%unit = strg_star    
    !
    call option%opt%present(line,user%do,error)
    if (error) return
    if (user%do) then
       call cubetools_getarg(line,option%opt,1,user%l,mandatory,error)
       if (error) return
       call cubetools_getarg(line,option%opt,2,user%m,mandatory,error)
       if (error) return
       call cubetools_getarg(line,option%opt,3,user%type,mandatory,error)
       if (error) return
       call cubetools_getarg(line,option%opt,4,user%unit,.not.mandatory,error)
       if (error) return
    endif
  end subroutine cubetemplate_spapos_parse
  !
  !------------------------------------------------------------------------
  !
  subroutine cubetemplate_spapos_user_init(user,error)
    !----------------------------------------------------------------------
    ! Initialize by setting the intent of user to out
    !----------------------------------------------------------------------
    class(spapos_user_t), intent(out)   :: user 
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPAPOS>USER>INIT'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
  end subroutine cubetemplate_spapos_user_init
  !
  ! subroutine cubetemplate_spapos_user_def_substruct(user,struct,error)
  !   use cubetools_userstruct
  !   !----------------------------------------------------------------------
  !   !
  !   !----------------------------------------------------------------------
  !   class(spapos_user_t), intent(in)    :: user
  !   type(userstruct_t),   intent(inout) :: struct
  !   logical,              intent(inout) :: error
  !   !
  !   type(userstruct_t) :: substruct
  !   character(len=*), parameter :: rname='SPAPOS>USER>DEF>SUBSTRUCT'
  !   !
  !   call cubetemplate_message(templateseve%trace,rname,'Welcome')
  !   !
  !   ! *** JP What happens if the sub-structure already exists?
  !   call struct%def_substruct('position',substruct,error)
  !   if (error) return
  !   call substruct%set_member('x',user%l,error)
  !   if (error) return
  !   call substruct%set_member('y',user%m,error)
  !   if (error) return
  !   call substruct%set_member('unit',user%unit,error)
  !   if (error) return
  !   call substruct%set_member('type',user%type,error)
  !   if (error) return
  ! end subroutine cubetemplate_spapos_user_def_substruct
  !
  subroutine cubetemplate_spapos_user_from_line(user,line,error)
    use gkernel_interfaces
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spapos_user_t), intent(out)   :: user
    character(len=*),     intent(in)    :: line
    logical,              intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=100) :: reline
    integer(kind=4) :: pos,len,nc
    character(len=*), parameter :: rname='SPAPOS>USER>FROM_LINE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    pos = 1
    reline=trim(adjustl(line))
    len = len_trim(reline)
    if (len.eq.0) then
       call cubetemplate_message(seve%e,rname,'Line is empty')
       error = .true.
       return
    endif
    call sic_next(reline(pos:len),user%l,nc,pos)
    if (pos.ge.len) then
       error = .true.
       mess = 'Only 1 argument, at least 3 expected'
       goto 10
    endif
    call sic_next(reline(pos:len),user%m,nc,pos,dotab=.true.)
    if (pos.ge.len) then
       error = .true.
       mess = 'Only 2 arguments, at least 3 expected'
       goto 10
    endif
    if (pos.lt.len) call sic_next(reline(pos:len),user%type,nc,pos,dotab=.true.)
    if (pos.lt.len) call sic_next(reline(pos:len),user%unit,nc,pos,dotab=.true.)
10  if (error) then
       call cubetemplate_message(seve%e,rname,mess)
       call cubetemplate_message(seve%e,rname,'Offending line:')
       call cubetemplate_message(seve%r,rname,'  '//line)
       return
    endif
    user%do = .true.
  end subroutine cubetemplate_spapos_user_from_line
  !
  subroutine cubetemplate_spapos_user_toprog(user,cube,prog,error)
    use cube_types
    use cubetools_header_methods
    use cubetools_disambiguate
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spapos_user_t), intent(in)    :: user
    type(cube_t),         intent(in)    :: cube
    type(spapos_prog_t),  intent(out)   :: prog
    logical,              intent(inout) :: error
    !
    integer(kind=4) :: ikey
    character(len=12) :: type
    character(len=*), parameter :: rname='SPAPOS>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    if (user%do) then
       call cubetools_disambiguate_strict(user%type,ctypes,ikey,type,error)
       if (error) return
       select case(type)
       case('ABSOLUTE')
          call cubetemplate_spapos_user_toprog_absolute(user,cube,prog,error)
          if (error) return
       case(strg_star,'RELATIVE')
          call cubetemplate_spapos_user_toprog_relative(user,cube,prog,error)
          if (error) return
       end select      
    else
       prog%rela(:) = 0d0
       call cubetemplate_spapos_user_toprog_relative(user,cube,prog,error)
       if (error) return
    endif
    !
    ! Get pixel values
    call cubetools_header_spatial_offset2pixel(cube%head,prog%rela,prog%frac,error)
    if (error) return
    prog%pixe(:) = nint(prog%frac(:))
    prog%ie      = prog%pixe(1)+(prog%pixe(2)-1)*cube%head%arr%n%l
  end subroutine cubetemplate_spapos_user_toprog
  !
  subroutine cubetemplate_spapos_user_toprog_absolute(user,cube,prog,error)
    use gkernel_interfaces
    use gkernel_types
    use cube_types
    use cubetools_header_interface
    use cubetools_user2prog
    use cubetools_disambiguate
    use cubetools_unit
    use cubetools_spapro_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(spapos_user_t), intent(in)    :: user
    type(cube_t),        intent(in)    :: cube
    type(spapos_prog_t), intent(out)   :: prog
    logical,             intent(inout) :: error
    !
    type(unit_user_t) :: posunit
    character(len=unit_l) :: unit
    integer(kind=4) :: ikey
    type(projection_t) :: gproj
    character(len=*), parameter :: units(4)=&
         [strg_star//'         ','Equatorial','Radian    ','Degree    ']
    character(len=*), parameter :: rname='SPAPOS>USER>TOPROG>ABSOLUTE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_disambiguate_strict(user%unit,units,ikey,unit,error)
    if (error) return
    select case(unit)
    case(strg_star,'EQUATORIAL') ! Use sic_decode
       select case(cube%head%spa%fra%code)
       case(code_spaframe_equatorial,code_spaframe_icrs)
          call sic_decode(user%l,prog%abso(1),24,error)
          if (error) return
       case (code_spaframe_galactic)
          call sic_decode(user%l,prog%abso(1),360,error)
          if (error) return
       case default
          call cubetemplate_message(seve%e,rname,'Unknown spatial frame code')
          error = .true.
          return
       end select
       call sic_decode(user%m,prog%abso(2),360,error)
       if (error) return
    case('RADIAN','DEGREE')
       ! Unit is Pang because we need either Radian or Degree
       call cubetools_unit_get(unit,unit_pang%id,posunit,error)
       if (error) return
       call cubetools_user2prog_resolve_star(user%l,posunit,cube%head%spa%pro%l0,prog%abso(1),error)
       if (error) return
       call cubetools_user2prog_resolve_star(user%m,posunit,cube%head%spa%pro%m0,prog%abso(2),error)
       if (error) return      
    end select
    !
    ! Convert to relative
    if (prog%abso(1).eq.cube%head%spa%pro%l0 .and.  &
        prog%abso(2).eq.cube%head%spa%pro%m0) then
      ! Straightforward, and support any projection including non supported ones, or NONE.
      prog%rela(1) = 0.d0
      prog%rela(2) = 0.d0
    else
      call cubetools_spapro_gwcs(cube%head%spa%pro,gproj,error)
      if (error) return
      call abs_to_rel(gproj,prog%abso(1),prog%abso(2),prog%rela(1),prog%rela(2),1)
    endif
  end subroutine cubetemplate_spapos_user_toprog_absolute
  !
  subroutine cubetemplate_spapos_user_toprog_relative(user,cube,prog,error)
    use gkernel_interfaces
    use gkernel_types
    use cube_types
    use cubetools_header_methods
    use cubetools_unit
    use cubetools_user2prog
    use cubetools_spapro_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(spapos_user_t), intent(in)    :: user
    type(cube_t),        intent(in)    :: cube
    type(spapos_prog_t), intent(out)   :: prog
    logical,             intent(inout) :: error
    !
    integer(kind=4), parameter :: ix = 1
    integer(kind=4), parameter :: iy = 2
    real(kind=coor_k) :: default
    type(unit_user_t) :: unit
    type(projection_t) :: gproj
    character(len=*), parameter :: rname='SPAPOS>USER>TOPROG>RELATIVE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_unit_get(user%unit,unit_fov%id,unit,error)
    if (error) return
    !
    ! Default position is (0,0) if it is covered by the cube, center of
    ! the coverage otherwise
    if (cube%head%spa%l%inside(0.d0)) then
      default = 0d0
    else
      default = (cube%head%spa%l%get_min()+cube%head%spa%l%get_max())/2.d0
    endif
    call cubetools_user2prog_resolve_star(user%l,unit,default,prog%rela(ix),error)
    if (error) return
    if (cube%head%spa%m%inside(0.d0)) then
      default = 0d0
    else
      default = (cube%head%spa%m%get_min()+cube%head%spa%m%get_max())/2.d0
    endif
    call cubetools_user2prog_resolve_star(user%m,unit,default,prog%rela(iy),error)
    if (error) return
    !
    ! Convert to absolute
    if (prog%rela(1).eq.0.d0 .and. prog%rela(2).eq.0.d0) then
      ! Straightforward, and support any projection including non supported ones, or NONE.
      prog%abso(1) = cube%head%spa%pro%l0
      prog%abso(2) = cube%head%spa%pro%m0
    else
      call cubetools_spapro_gwcs(cube%head%spa%pro,gproj,error)
      if (error) return
      call rel_to_abs(gproj,prog%rela(1),prog%rela(2),prog%abso(1),prog%abso(2),1)
    endif
  end subroutine cubetemplate_spapos_user_toprog_relative
  !
  subroutine cubetemplate_spapos_user_list(user,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spapos_user_t), intent(in)    :: user 
    logical,              intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='SPAPOS>USER>LIST'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    write(mess,'(6a,x,a)') &
         'Position  : (',trim(user%l),',',trim(user%m),') ',&
         trim(user%type),trim(user%unit)
    call cubetemplate_message(seve%r,rname,mess)
  end subroutine cubetemplate_spapos_user_list
end module cubetemplate_spapos_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
