!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_sum
  use cubecompute_two2one_real_template
  use cubecompute_messaging
  !
  public :: cubecompute_sum_register
  private
  !
  type(two2one_real_comm_t) :: sum
  !
contains
  !
  subroutine cubecompute_sum_register(error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    character(len=*), parameter :: rname='SUM>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call sum%register_syntax(&
         'SUM','summand1','summand2',&
         [flag_sum],cubecompute_sum_command,error)
    if (error) return
    call sum%register_act(cubecompute_sum_prog_act,error)
    if (error) return
  end subroutine cubecompute_sum_register
  !
  subroutine cubecompute_sum_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(two2one_real_user_t) :: user
    character(len=*), parameter :: rname='SUM>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call sum%parse(line,user,error)
    if (error) return
    call sum%main(user,error)
    if (error) continue
  end subroutine cubecompute_sum_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_sum_prog_act(prog,ie,summand1,summand2,sum,error)
    use cubetools_parameters
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_real_prog_t), intent(inout) :: prog
    integer(kind=entr_k),       intent(in)    :: ie
    type(image_t),              intent(inout) :: summand1
    type(image_t),              intent(inout) :: summand2
    type(image_t),              intent(inout) :: sum
    logical,                    intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    integer(kind=pixe_k) :: jx,jy
    character(len=*), parameter :: rname='SUM>PROG>ACT'
    !
    call summand1%get(ie,error)
    if (error) return
    call summand2%get(ie,error)
    if (error) return
    do iy=prog%region%iy%first,prog%region%iy%last
       jy = iy-prog%region%iy%first+1
       do ix=prog%region%ix%first,prog%region%ix%last
          jx = ix-prog%region%ix%first+1
          sum%val(jx,jy) = summand1%val(ix,iy)+summand2%val(ix,iy)
       enddo ! ix
    enddo ! iy
    call sum%put(ie-prog%region%iz%first+1,error)
    if (error) return
  end subroutine cubecompute_sum_prog_act
end module cubecompute_sum
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
