!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_one2one_act
  use cubetools_parameters
  use cubecompute_messaging

  public :: one2one_act_comm_t,one2one_act_prog_t
  private
  !
  type one2one_act_comm_t
    procedure(cubecompute_one2one_act_r4), pointer, nopass, public :: r4 => null()
    procedure(cubecompute_one2one_act_c4), pointer, nopass, public :: c4 => null()
  contains
    procedure, public :: register_r4 => cubecompute_one2one_act_register_r4
    procedure, public :: register_c4 => cubecompute_one2one_act_register_c4
  end type one2one_act_comm_t
  !
  type one2one_act_prog_t
    procedure(cubecompute_one2one_act_r4), pointer, nopass, public :: r4 => null()
    procedure(cubecompute_one2one_act_c4), pointer, nopass, public :: c4 => null()
  end type one2one_act_prog_t
  !
contains
  !
  subroutine cubecompute_one2one_act_r4(ie,incube,oucube,error)
    use cubeadm_image_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  R*4 = R*4
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: incube
    type(image_t),        intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_one2one_act_r4
  !
  subroutine cubecompute_one2one_act_c4(ie,incube,oucube,error)
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  C*4 = C*4
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: incube
    type(visi_t),         intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_one2one_act_c4
  !
  subroutine cubecompute_one2one_act_register_r4(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_act_comm_t),            intent(inout) :: comm
    procedure(cubecompute_one2one_act_r4)               :: act
    logical,                              intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2ONE>ACT>REGISTER>R4'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%r4 => act
  end subroutine cubecompute_one2one_act_register_r4
  !
  subroutine cubecompute_one2one_act_register_c4(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_act_comm_t),            intent(inout) :: comm
    procedure(cubecompute_one2one_act_c4)               :: act
    logical,                              intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2ONE>ACT>REGISTER>C4'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%c4 => act
  end subroutine cubecompute_one2one_act_register_c4

end module cubecompute_one2one_act
!
module cubecompute_two2one_act
  use cubetools_parameters
  use cubecompute_messaging

  public :: two2one_act_comm_t,two2one_act_prog_t
  private
  !
  type two2one_act_comm_t
    procedure(cubecompute_two2one_act_r4r4), pointer, nopass, public :: r4r4 => null()
    procedure(cubecompute_two2one_act_r4c4), pointer, nopass, public :: r4c4 => null()
    procedure(cubecompute_two2one_act_c4r4), pointer, nopass, public :: c4r4 => null()
    procedure(cubecompute_two2one_act_c4c4), pointer, nopass, public :: c4c4 => null()
  contains
    procedure, public :: register_r4r4 => cubecompute_two2one_act_register_r4r4
    procedure, public :: register_r4c4 => cubecompute_two2one_act_register_r4c4
    procedure, public :: register_c4r4 => cubecompute_two2one_act_register_c4r4
    procedure, public :: register_c4c4 => cubecompute_two2one_act_register_c4c4
  end type two2one_act_comm_t
  !
  type two2one_act_prog_t
    procedure(cubecompute_two2one_act_r4r4), pointer, nopass, public :: r4r4 => null()
    procedure(cubecompute_two2one_act_r4c4), pointer, nopass, public :: r4c4 => null()
    procedure(cubecompute_two2one_act_c4r4), pointer, nopass, public :: c4r4 => null()
    procedure(cubecompute_two2one_act_c4c4), pointer, nopass, public :: c4c4 => null()
  end type two2one_act_prog_t
  !
contains
  !
  subroutine cubecompute_two2one_act_r4r4(ie,incube1,incube2,oucube,error)
    use cubeadm_image_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  R*4 + R*4 = R*4
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: incube1
    type(image_t),        intent(inout) :: incube2
    type(image_t),        intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_two2one_act_r4r4
  !
  subroutine cubecompute_two2one_act_r4c4(ie,incube1,incube2,oucube,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  R*4 + C*4 = C*4
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: incube1
    type(visi_t),         intent(inout) :: incube2
    type(visi_t),         intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_two2one_act_r4c4
  !
  subroutine cubecompute_two2one_act_c4r4(ie,incube1,incube2,oucube,error)
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  C*4 + R*4 = C*4
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: incube1
    type(image_t),        intent(inout) :: incube2
    type(visi_t),         intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_two2one_act_c4r4
  !
  subroutine cubecompute_two2one_act_c4c4(ie,incube1,incube2,oucube,error)
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    ! Provides the interface for the operation
    !  C*4 + C*4 = C*4
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: incube1
    type(visi_t),         intent(inout) :: incube2
    type(visi_t),         intent(inout) :: oucube
    logical,              intent(inout) :: error
  end subroutine cubecompute_two2one_act_c4c4
  !
  subroutine cubecompute_two2one_act_register_r4r4(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_act_comm_t),              intent(inout) :: comm
    procedure(cubecompute_two2one_act_r4r4)               :: act
    logical,                                intent(inout) :: error
    !
    character(len=*), parameter :: rname='TWO2ONE>ACT>REGISTER>R4R4'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%r4r4 => act
  end subroutine cubecompute_two2one_act_register_r4r4
  !
  subroutine cubecompute_two2one_act_register_r4c4(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_act_comm_t),              intent(inout) :: comm
    procedure(cubecompute_two2one_act_r4c4)               :: act
    logical,                                intent(inout) :: error
    !
    character(len=*), parameter :: rname='TWO2ONE>ACT>REGISTER>R4C4'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%r4c4 => act
  end subroutine cubecompute_two2one_act_register_r4c4
  !
  subroutine cubecompute_two2one_act_register_c4r4(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_act_comm_t),              intent(inout) :: comm
    procedure(cubecompute_two2one_act_c4r4)               :: act
    logical,                                intent(inout) :: error
    !
    character(len=*), parameter :: rname='TWO2ONE>ACT>REGISTER>C4R4'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%c4r4 => act
  end subroutine cubecompute_two2one_act_register_c4r4
  !
  subroutine cubecompute_two2one_act_register_c4c4(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_act_comm_t),              intent(inout) :: comm
    procedure(cubecompute_two2one_act_c4c4)               :: act
    logical,                                intent(inout) :: error
    !
    character(len=*), parameter :: rname='TWO2ONE>ACT>REGISTER>C4C4'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    comm%c4c4 => act
  end subroutine cubecompute_two2one_act_register_c4c4

end module cubecompute_two2one_act
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
