module cubeadm_taskloop_iteration
  use cubetools_parameters
  !
  ! Description of one image iteration
  type image_iteration_t
    ! Dimensions
    integer(kind=indx_k) :: mx,my,mz  ! Dimensions of the whole subset
    integer(kind=indx_k) :: nx,ny,nz  ! Dimensions of the image
    ! Leading dimensions (in case of subset)
    integer(kind=indx_k) :: inxf,inxl ! X range for input cubes (get)
    integer(kind=indx_k) :: inyf,inyl ! Y range for input cubes (get)
  ! integer(kind=indx_k) :: ouxf,ouxl ! X range for output cubes (put) => always put full axis
  ! integer(kind=indx_k) :: ouyf,ouyl ! Y range for output cubes (put) => always put full axis
    ! Trailing dimension (iterated)
    integer(kind=indx_k) :: inz       ! Z plane for input cubes (get)
    integer(kind=indx_k) :: ouz       ! Z plane for output cubes (put)
  end type image_iteration_t
  !
  ! Description of one spectrum iteration
  type spectrum_iteration_t
    ! Dimensions
    integer(kind=indx_k) :: mx,my,mz  ! Dimensions of the whole subset
    integer(kind=indx_k) :: nx,ny,nz  ! Dimensions of the spectrum
    ! Leading dimension (in case of subset)
    integer(kind=indx_k) :: inzf,inzl ! Z range for input cubes (get)
  ! integer(kind=indx_k) :: ouzf,ouzl ! Z range for output cubes (put) => always put full axis
    ! Trailing dimensions (iterated)
    integer(kind=indx_k) :: inx,iny   ! (X,Y) pixel for input cubes (get)
    integer(kind=indx_k) :: oux,ouy   ! (X,Y) pixel for output cubes (put)
  end type spectrum_iteration_t
  !
  ! Description of one subcube iteration
  type subcube_iteration_t
    ! Dimensions
    integer(kind=indx_k) :: m1,m2,m3  ! Dimensions of the whole subset
    integer(kind=indx_k) :: n1,n2,n3  ! Dimensions of the subcube
    ! Leading dimensions (in case of subset)
    integer(kind=indx_k) :: in1f,in1l ! 1st range for input cubes (get)
    integer(kind=indx_k) :: in2f,in2l ! 2nd range for input cubes (get)
  ! integer(kind=indx_k) :: ou1f,ou1l ! 1st range for output cubes (put) => always put full axis
  ! integer(kind=indx_k) :: ou2f,ou2l ! 2nd range for output cubes (put) => always put full axis
    ! Trailing dimension (iterated)
    integer(kind=indx_k) :: in3f,in3l ! 3rd range for input cubes (get)
    integer(kind=indx_k) :: ou3f,ou3l ! 3rd range for output cubes (put)
  end type subcube_iteration_t
  !
  ! Description of one task iteration
  type taskloop_iteration_t
    integer(kind=entr_k)      :: num         ! This task number
    integer(kind=entr_k)      :: ie          ! The entry number iterated in this task
    integer(kind=data_k)      :: firstdata   ! First data  to be processed
    integer(kind=data_k)      :: lastdata    ! Last  data  to be processed
    integer(kind=entr_k)      :: firstplane  ! First plane to be processed
    integer(kind=entr_k)      :: lastplane   ! Last  plane to be processed
    integer(kind=entr_k)      :: first       ! First entry to be processed (kept for backward compatibility)
    integer(kind=entr_k)      :: last        ! Last  entry to be processed (kept for backward compatibility)
    type(subcube_iteration_t) :: subcube     ! Current subcube iteration (if relevant)
  end type taskloop_iteration_t
  !
  public :: image_iteration_t,spectrum_iteration_t,subcube_iteration_t
  public :: taskloop_iteration_t
  private
  !
end module cubeadm_taskloop_iteration
