!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_directory
  use cubetools_structure
  use cubeadm_messaging
  use cubeadm_directory_type
  use cubetools_keyword_arg
  !
  public :: directory
  public :: cubeadm_directory_command
  private
  !
  type :: directory_comm_t
     type(option_t), pointer :: comm
     type(dir_opt_t)         :: raw
     type(dir_opt_t)         :: tmp
     type(dir_opt_t)         :: red
     type(option_t), pointer :: defaults
   contains
     procedure, public  :: register => cubeadm_directory_register
     procedure, private :: parse    => cubeadm_directory_parse
  end type directory_comm_t
  type(directory_comm_t) :: directory
  !
contains
  !
  subroutine cubeadm_directory_command(line,error)
    use gkernel_interfaces
    !----------------------------------------------------------------------
    ! DIRECTORY [RAW|TMP|RED dirname]
    !----------------------------------------------------------------------
    character(len=*), intent(in)  :: line
    logical,          intent(out) :: error
    !
    call directory%parse(line,error)
    if (error) return
  end subroutine cubeadm_directory_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubeadm_directory_register(directory,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(directory_comm_t), intent(inout) :: directory
    logical,                 intent(out)   :: error
    !
    character(len=*), parameter :: comm_abstract = &
         'Define directories where CUBE looks for files'
    character(len=*), parameter :: comm_help = &
         'Define the directories where CUBE looks for and/or stores&
         & raw (/RAW), temporary (/TMP) or reduced (/RED) cubes.&
         & Defaults are ./raw/, ./tmp/, and ./red/ respectively.'&
         & //strg_cr//strg_cr//&
         &'Without argument, display the current values.&
         & The current values are also visible in the SIC structure&
         & CUBE%DIR%.'
    character(len=*), parameter :: rname='DIRECTORY>REGISTER'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'DIRECTORY','',&
         comm_abstract,&
         comm_help,&
         cubeadm_directory_command,&
         directory%comm,error)
    if (error) return
    !
    call directory%raw%register('RAW',&
         'Define directory containing raw data',error)
    if (error) return
    !
    call directory%tmp%register('TMP',&
         'Define directory containing temporary data',error)
    if (error) return
    !
    call directory%red%register('RED',&
         'Define directory to contain reduced data',error)
    if (error) return
    !
    call cubetools_register_option(&
         'DEFAULTS','',&
         'Reset directories to defaults',&
         strg_id,&
         directory%defaults,error)
    if (error) return
  end subroutine cubeadm_directory_register
  !
  subroutine cubeadm_directory_parse(directory,line,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(directory_comm_t), intent(inout) :: directory
    character(len=*),        intent(in)    :: line
    logical,                 intent(out)   :: error
    !
    logical :: dodefaults
    character(len=*), parameter :: rname='DIRECTORY>PARSE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (cubetools_nopt().eq.0) then
       call dir%list(error)
       if (error)  return
    else
       call directory%defaults%present(line,dodefaults,error)
       if (error) return
       if (dodefaults) then
          call dir%init(error)
          if (error) return
       endif
       !
       call directory%raw%parse(line,error)
       if (error) return
       call directory%tmp%parse(line,error)
       if (error) return
       call directory%red%parse(line,error)
       if (error) return
    endif
  end subroutine cubeadm_directory_parse
end module cubeadm_directory
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
