!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetools_access
  use cubetools_parameters
  !
  public :: cubetools_accessname,cubetools_ordername
  public :: cubetools_order2ext,cubetools_access2ext,cubetools_access2order,cubetools_order2access
  public :: cubetools_transpose_order,cubetools_transpose_access,cubetools_transpose_operator
  private
  !
contains
  !
  function cubetools_accessname(access)
    !---------------------------------------------------------------------
    ! Return the name of the access given its code
    !---------------------------------------------------------------------
    character(len=7) :: cubetools_accessname
    integer(kind=code_k), intent(in) :: access
    !
    select case (access)
    case (code_access_imaset)
      cubetools_accessname = 'ImaSet'
    case (code_access_speset)
      cubetools_accessname = 'SpeSet'
    case (code_access_subset)
      cubetools_accessname = 'SubSet'
    case (code_access_blobset)
      cubetools_accessname = 'BlobSet'
    case (code_access_fullset)
      cubetools_accessname = 'FullSet'
    case default
      cubetools_accessname = '???'
    end select
  end function cubetools_accessname
  !
  function cubetools_ordername(order)
    !---------------------------------------------------------------------
    ! Return the name of the order given its code
    !---------------------------------------------------------------------
    character(len=6) :: cubetools_ordername
    integer(kind=code_k), intent(in) :: order
    !
    select case (order)
    case (code_cube_unkset)
      cubetools_ordername = 'UnkSet'
    case (code_cube_speset)
      cubetools_ordername = 'SpeSet'
    case (code_cube_imaset)
      cubetools_ordername = 'ImaSet'
    case default
      cubetools_ordername = '???'
    end select
  end function cubetools_ordername
  !
  function cubetools_order2ext(order)
    !---------------------------------------------------------------------
    ! Return the default extension suited for the input order mode.
    !---------------------------------------------------------------------
    character(len=exte_l) :: cubetools_order2ext
    integer(kind=code_k), intent(in) :: order
    !
    select case (order)
    case (code_cube_imaset)
       cubetools_order2ext = '.lmv'
    case (code_cube_speset)
       cubetools_order2ext = '.vlm'
    case default
       cubetools_order2ext = '.unk'
    end select
  end function cubetools_order2ext
  !
  function cubetools_access2ext(access)
    !---------------------------------------------------------------------
    ! Return the default extension suited for the input access mode.
    !---------------------------------------------------------------------
    character(len=exte_l) :: cubetools_access2ext
    integer(kind=4), intent(in) :: access
    !
    select case (access)
    case (code_access_imaset)
       cubetools_access2ext = '.lmv'
    case (code_access_speset)
       cubetools_access2ext = '.vlm'
    case default
       cubetools_access2ext = '.unk'
    end select
  end function cubetools_access2ext
  !
  function cubetools_access2order(access)
    !--------------------------------------------------------------------- 
    ! Return the order suited for the input access mode.
    !---------------------------------------------------------------------
    integer(kind=4) :: cubetools_access2order
    integer(kind=4), intent(in) :: access  ! code_access_*
    !
    select case (access)
    case (code_access_imaset)
       cubetools_access2order = code_cube_imaset
    case (code_access_speset)
       cubetools_access2order = code_cube_speset
    case default
       cubetools_access2order = code_null
    end select
  end function cubetools_access2order
  !
  function cubetools_order2access(order)
    use cubetools_parameters
    !---------------------------------------------------------------------
    ! Return the access mode suited for the input order.
    !---------------------------------------------------------------------
    integer(kind=4) :: cubetools_order2access  ! code_cube_*
    integer(kind=4), intent(in) :: order
    !
    select case (order)
    case (code_cube_imaset)
       cubetools_order2access = code_access_imaset
    case (code_cube_speset)
       cubetools_order2access = code_access_speset
    case (code_cube_unkset)
       cubetools_order2access = code_access_any
    case default
       cubetools_order2access = code_null
    end select
  end function cubetools_order2access
  !
  !------------------------------------------------------------------------
  !
  function cubetools_transpose_order(code_order)
    !----------------------------------------------------------------------
    ! Transpose the data order:  LMV <-> VLM
    !----------------------------------------------------------------------
    integer(kind=4)             :: cubetools_transpose_order
    integer(kind=4), intent(in) :: code_order
    !
    select case (code_order)
    case (code_cube_imaset)
      cubetools_transpose_order = code_cube_speset
    case (code_cube_speset)
      cubetools_transpose_order = code_cube_imaset
    case default
      cubetools_transpose_order = code_null
    end select
    !
  end function cubetools_transpose_order
  !
  function cubetools_transpose_access(code_access)
    !----------------------------------------------------------------------
    ! Transpose the data access mode: spectrum <-> image
    !----------------------------------------------------------------------
    integer(kind=4)             :: cubetools_transpose_access  ! code_access_*
    integer(kind=4), intent(in) :: code_access                 ! code_access_*
    !
    select case (code_access)
    case (code_access_imaset)
      cubetools_transpose_access = code_access_speset
    case (code_access_speset)
      cubetools_transpose_access = code_access_imaset
    case default
      cubetools_transpose_access = code_null
    end select
    !
  end function cubetools_transpose_access
  !
  subroutine cubetools_transpose_operator(inorder,ouorder,operator,error)
    use cubetools_messaging
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    integer(kind=4),         intent(in)    :: inorder
    integer(kind=4),         intent(in)    :: ouorder
    character(len=trop_l),   intent(out)   :: operator
    logical,                 intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=*), parameter  :: rname='TRANSPOSE>OPERATOR'
    !
    if (inorder.eq.code_cube_imaset .and.  &
        ouorder.eq.code_cube_speset) then
       operator = '312'
    elseif (inorder.eq.code_cube_speset .and.  &
            ouorder.eq.code_cube_imaset) then
       operator = '231'
    else
       write(mess,'(2(a,i0))')  &
         'Do not know how to transpose from code ',inorder,' to code ',ouorder
       call cubetools_message(seve%e,rname,mess)
       error = .true.
       return
    endif
    !  
  end subroutine cubetools_transpose_operator
end module cubetools_access
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
