!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cube_types  ! ZZZ to be renamed...
  use cubetools_parameters
  use cubedag_types
  use cubetuple_messaging
  use cubetuple_format
  !
  public :: cube_t
  public :: cube_allocate_new,cubetuple_cube_ptr,cubetuple_cube_ptr_from_format
  private
  !
  type, extends(format_t) :: cube_t
    ! No more
  contains
    procedure :: access  => cube_get_access
    procedure :: iscplx  => cube_get_iscplx
    procedure :: haskind => cube_has_filekind
    procedure :: nbytes  => cube_get_nbytes
    procedure :: ndata   => cube_get_ndata
    procedure :: nentry  => cube_get_nentry
    procedure :: free    => cube_free
  end type cube_t
  !
  ! Fortran compiler says these are ambiguous, but on the other hand
  ! I can not call cubetuple_cube_ptr_from_node with a format_t pointer...
  ! interface cubetuple_cube_ptr
  !   module procedure cubetuple_cube_ptr_from_node
  !   module procedure cubetuple_cube_ptr_from_format
  ! end interface cubetuple_cube_ptr
  !
contains
  !
  function cube_allocate_new(setup,error)
    use gkernel_interfaces
    use cubetools_setup_types
    !-------------------------------------------------------------------
    ! Allocate and initialize a new cube_t in memory and return a
    ! pointer to this allocation
    !-------------------------------------------------------------------
    type(cube_t), pointer :: cube_allocate_new
    type(cube_setup_t), intent(in), target :: setup
    logical,            intent(inout)      :: error
    !
    integer(kind=4) :: ier
    character(len=*), parameter :: rname='ALLOCATE>NEW'
    !
    allocate(cube_allocate_new,stat=ier)
    if (failed_allocate(rname,'object',ier,error)) return
    call cube_allocate_new%init(setup,error)
    if (error)  return
    !
    ! Override the node_t methods with cube_t specific ones
    cube_allocate_new%ltype    => cube_ltype
    cube_allocate_new%memsize  => cube_memsize
    cube_allocate_new%disksize => cube_disksize
    cube_allocate_new%datasize => cube_datasize
  end function cube_allocate_new
  !
  function cube_get_access(cub)
    !-------------------------------------------------------------------
    ! Return the CURRENT access mode.
    !-------------------------------------------------------------------
    integer(kind=code_k) :: cube_get_access
    class(cube_t), intent(in) :: cub
    cube_get_access = cub%tuple%access()
  end function cube_get_access
  !
  function cube_get_iscplx(cub)
    !-------------------------------------------------------------------
    ! Return .true. if the cube data is complex*4
    !-------------------------------------------------------------------
    logical :: cube_get_iscplx
    class(cube_t), intent(in) :: cub
    cube_get_iscplx = cub%tuple%iscplx()
  end function cube_get_iscplx
  !
  function cube_has_filekind(cub,code_filekind)
    !-------------------------------------------------------------------
    ! Return .true. if the cube provides the given kind description
    !-------------------------------------------------------------------
    logical :: cube_has_filekind
    class(cube_t),        intent(in) :: cub
    integer(kind=code_k), intent(in) :: code_filekind
    cube_has_filekind = cub%tuple%haskind(code_filekind)
  end function cube_has_filekind
  !
  function cube_get_nbytes(cub)
    !-------------------------------------------------------------------
    ! Return the number of bytes per data value
    !-------------------------------------------------------------------
    integer(kind=4) :: cube_get_nbytes
    class(cube_t), intent(in) :: cub
    cube_get_nbytes = cub%tuple%nbytes()
  end function cube_get_nbytes
  !
  function cube_get_ndata(cub)
    !-------------------------------------------------------------------
    ! Return the number of data values in the cube
    !-------------------------------------------------------------------
    integer(kind=data_k) :: cube_get_ndata
    class(cube_t), intent(in) :: cub
    cube_get_ndata = cub%tuple%ndata()
  end function cube_get_ndata
  !
  function cube_get_nentry(cub)
    !-------------------------------------------------------------------
    ! Return the number of entries (Nchan/NPix) for the CURRENT access
    ! mode.
    !-------------------------------------------------------------------
    integer(kind=entr_k) :: cube_get_nentry
    class(cube_t), intent(in) :: cub
    cube_get_nentry = cub%tuple%nentry()
  end function cube_get_nentry
  !
  subroutine cube_free(cub,error)
    use cubedag_tuple
    !---------------------------------------------------------------------
    ! Free the memory-consuming components of a 'cube_t' instance. The
    ! cube_t remains useable after this free. It is the responsibility of
    ! the caller to ensure the data remains available elsewhere (most
    ! likely on disk).
    ! Use cube_final to free consistently all the object.
    !---------------------------------------------------------------------
    class(cube_t), intent(inout) :: cub
    logical,       intent(inout) :: error
    !
    call cub%tuple%free(error)
    if (error)  return
    call cubedag_tuple_rmmemo(cub%node%tuple,error)
    if (error)  return
  end subroutine cube_free
  !
  function cubetuple_cube_ptr(dno,error)
    !-------------------------------------------------------------------
    ! Check if the input class is strictly a 'cube_t', and return a
    ! pointer to it if relevant.
    !-------------------------------------------------------------------
    type(cube_t), pointer :: cubetuple_cube_ptr  ! Function value on return
    class(cubedag_node_object_t), pointer       :: dno
    logical,                      intent(inout) :: error
    !
    character(len=*), parameter :: rname='CUBE>PTR'
    !
    select type(dno)
    type is (cube_t)
      cubetuple_cube_ptr => dno
    class default
      cubetuple_cube_ptr => null()
      call cubetuple_message(seve%e,rname,'Internal error: object is not a cube_t')
      error = .true.
      return
    end select
  end function cubetuple_cube_ptr
  !
  function cubetuple_cube_ptr_from_format(format,error)
    !-------------------------------------------------------------------
    ! Check if the input class is strictly a 'cube_t', and return a
    ! pointer to it if relevant.
    !-------------------------------------------------------------------
    type(cube_t), pointer :: cubetuple_cube_ptr_from_format  ! Function value on return
    class(format_t), pointer       :: format
    logical,         intent(inout) :: error
    !
    character(len=*), parameter :: rname='CUBE>PTR>FROM>FORMAT'
    !
    select type(format)
    type is (cube_t)
      cubetuple_cube_ptr_from_format => format
    class default
      cubetuple_cube_ptr_from_format => null()
      call cubetuple_message(seve%e,rname,'Internal error: object is not a cube_t')
      error = .true.
      return
    end select
  end function cubetuple_cube_ptr_from_format
  !
  function cube_ltype(obj)
    use cubetools_axset_types
    character(len=2) :: cube_ltype
    class(cubedag_node_object_t), intent(in) :: obj
    select type (obj)
    type is (cube_t)
      write(cube_ltype,'(I1,A1)')  cubetools_axset_count_genuine(obj%head%set),'D'
    class default
      cube_ltype = '??'
    end select
  end function cube_ltype

  function cube_memsize(obj)
    integer(kind=size_length) :: cube_memsize
    class(cubedag_node_object_t), intent(in) :: obj
    select type (obj)
    type is (cube_t)
      cube_memsize = obj%tuple%memsize()
    class default
      cube_memsize = 0
    end select
  end function cube_memsize

  function cube_disksize(obj)
    use cubedag_tuple
    integer(kind=size_length) :: cube_disksize
    class(cubedag_node_object_t), intent(in) :: obj
    select type (obj)
    type is (cube_t)
      cube_disksize = obj%node%tuple%disksizes()
    class default
      cube_disksize = 0
    end select
  end function cube_disksize

  function cube_datasize(obj)
    integer(kind=size_length) :: cube_datasize
    class(cubedag_node_object_t), intent(in) :: obj
    logical :: error
    select type (obj)
    type is (cube_t)
      error = .false.
      call obj%head%arr%datasize(cube_datasize,error)
    class default
      cube_datasize = 0
    end select
  end function cube_datasize
end module cube_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
