!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubego_browse
  use cubetools_structure
  use cubetools_topic
  use cubeadm_cubeid_types
  use cubemain_spapos_types
  use cubego_messaging
  !
  public :: browse,cubego_browse_command
  private
  !
  type :: browse_comm_t
     type(option_t), pointer :: comm
     type(spapos_opt_t)      :: pixel
     type(topic_opt_t)       :: inter
   contains
     procedure, public  :: register => cubego_browse_register
     procedure, private :: parse    => cubego_browse_parse
     procedure, private :: main     => cubego_browse_main
  end type browse_comm_t
  type(browse_comm_t) :: browse
  !
  integer(kind=4), parameter :: icube = 1
  type :: browse_user_t
     type(cubeid_user_t) :: cubeids
     type(spapos_user_t) :: pixel
     logical :: dointer = .true.
   contains
     procedure, private :: toprog => cubego_browse_user_toprog
  end type browse_user_t
  !
  type browse_prog_t
     logical :: dointer = .true.
   contains
     procedure, private :: act => cubego_browse_prog_act
  end type browse_prog_t
  !
contains
  !
  subroutine cubego_browse_command(line,error)
    use gkernel_interfaces
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(browse_user_t) :: user
    character(len=*),parameter :: rname='BROWSE>COMMAND'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call browse%parse(line,user,error)
    if (error) return
    call browse%main(user,error)
    if (error) return
    ! Force insertion in SIC stack ! *** JP Why?
    if (sic_lire().eq.0) call sic_insert(line)
  end subroutine cubego_browse_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubego_browse_register(browse,error)
    use cubedag_allflags
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(browse_comm_t), intent(inout) :: browse
    logical,            intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: comm_abstract = &
         'Interactive browse of a cube spectrum'
    character(len=*), parameter :: comm_help = &
         strg_id
    character(len=*), parameter :: rname='BROWSE>REGISTER'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'BROWSE','[cube]',&
         comm_abstract,&
         comm_help,&
         cubego_browse_command,&
         browse%comm,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         'Cube to be viewed',  &
         strg_id,&
         code_arg_optional,  &
         [flag_any], &
         error)
    if (error) return
    !
    call browse%pixel%register(&
         'PIXEL',&
         'Define the position of the pixel to be gotten',&
         error)
    if (error) return
    !
    call browse%inter%register(&
         'INTERACTIVE',&
         'Enable or disable the interactive mode',&
         error)
    if (error) return
  end subroutine cubego_browse_register
  !
  subroutine cubego_browse_parse(browse,line,user,error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(browse_comm_t), intent(inout) :: browse
    character(len=*),   intent(in)    :: line
    type(browse_user_t),  intent(out)   :: user
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='BROWSE>PARSE'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,browse%comm,user%cubeids,error)
    if (error) return
    call browse%pixel%parse(line,user%pixel,error)
    if (error) return
    call browse%inter%parse(line,error)
    if (error) return
  end subroutine cubego_browse_parse
  !
  subroutine cubego_browse_main(browse,user,error)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(browse_comm_t), intent(in)    :: browse
    type(browse_user_t),  intent(in)    :: user
    logical,            intent(inout) :: error
    !
    type(browse_prog_t) :: prog
    character(len=*), parameter :: rname='BROWSE>MAIN'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call user%toprog(browse,prog,error)
    if (error) return
    call prog%act(error)
    if (error) return
  end subroutine cubego_browse_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubego_browse_user_toprog(user,browse,prog,error)
    use cubetools_user2prog
    use cubego_buffer
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(browse_user_t), intent(in)    :: user
    type(browse_comm_t),  intent(in)    :: browse    
    type(browse_prog_t),  intent(out)   :: prog
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='BROWSE>USER>TOPROG'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_user2prog(browse%comm,user%cubeids,cubes,error)
    if (error) return
    call cubes%defstruct(cubego,error)
    if (error) return
    call cubego_browse_struct_pixel(user%pixel,error)
    if (error) return
    if (browse%inter%do) then
       prog%dointer = browse%inter%enabled
    else
       prog%dointer = .true.
    endif
  end subroutine cubego_browse_user_toprog
  !
  subroutine cubego_browse_struct_pixel(pixel,error)
    use gkernel_interfaces
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    type(spapos_user_t), intent(in)    :: pixel
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='CUBEID>DEFSTRUCT'
    character(len=128) :: line
    !
    ! ZZZ This is to be implemented properly!!!
    !
    if (sic_varexist('cubego%pixel')) then
      line = 'sic\delete /var cubego%pixel'
      call exec_command(line,error)
      if (error) return
    endif
    line = 'sic\define structure cubego%pixel /global'
    call exec_command(line,error)
    if (error) return
    line = 'sic\define character*64 cubego%pixel%l cubego%pixel%m /global'
    call exec_command(line,error)
    if (error) return
    line = 'sic\define character*64 cubego%pixel%type cubego%pixel%unit /global'
    call exec_command(line,error)
    if (error) return
    !
    if (pixel%l.eq.strg_star) then
      line = 'let cubego%pixel%l 0'
      call exec_command(line,error)
      if (error) return
      line = 'let cubego%pixel%m 0'
      call exec_command(line,error)
      if (error) return
      line = 'let cubego%pixel%type relative'
      call exec_command(line,error)
      if (error) return
    else
      line = 'let cubego%pixel%l '//pixel%l
      call exec_command(line,error)
      if (error) return
      line = 'let cubego%pixel%m '//pixel%m
      call exec_command(line,error)
      if (error) return
      line = 'let cubego%pixel%type '//pixel%type
      call exec_command(line,error)
      if (error) return
    endif
    line = 'let cubego%pixel%unit '//pixel%unit
    call exec_command(line,error)
    if (error) return
  end subroutine cubego_browse_struct_pixel
  !
  !----------------------------------------------------------------------
  !
  subroutine cubego_browse_prog_act(prog,error)
    use gkernel_interfaces
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(browse_prog_t), intent(in)    :: prog
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='BROWSE>PROG>ACT'
    !
    call cubego_message(goseve%trace,rname,'Welcome')
    !
    call exec_program('@ q-browse.cube')
    if (prog%dointer) call exec_program('@ l-ctrl-master-loop')
  end subroutine cubego_browse_prog_act
end module cubego_browse
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
