!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_auxiliary
  use cubetools_parameters
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubemain_messaging
  !
  public :: auxiliary_user_t
  public :: cubemain_auxiliary_register,cubemain_auxiliary_parse,cubemain_auxiliary_user2prog
  private
  !
  integer(kind=4), parameter :: icube = 1
  !
  type auxiliary_user_t
     logical             :: do =.false.
     type(cubeid_user_t) :: id
  end type auxiliary_user_t
  !
contains
  !
  subroutine cubemain_auxiliary_register(name,abstract,help,argabs,flags,status,option,error)
    use cubedag_flag
    !----------------------------------------------------------------------
    ! Register a /SUPPLEMENT option according to a name, help and abstract
    ! provided by the command
    !----------------------------------------------------------------------
    character(len=*),        intent(in)    :: name
    character(len=*),        intent(in)    :: abstract
    character(len=*),        intent(in)    :: help
    character(len=*),        intent(in)    :: argabs
    type(flag_t),            intent(in)    :: flags(:)
    integer(kind=code_k),    intent(in)    :: status
    type(option_t), pointer, intent(out)   :: option
    logical,                 intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    !
    character(len=*), parameter :: rname='CENTER>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    select case(name)
    case("MASK","LIKE","INITIAL")
       continue
    case default
       call cubemain_message(seve%e,rname,"Don't know what to do if option is not /LIKE or /MASK")
       error = .true.
       return
    end select
    call cubetools_register_option(&
         name,'cube',&
         abstract,&
         help,&
         option,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         argabs,  &
         strg_id,&
         status,  &
         flags, &
         error)
    if (error) return
  end subroutine cubemain_auxiliary_register
  !
  subroutine cubemain_auxiliary_parse(line,opt,user,error)
    !----------------------------------------------------------------------
    ! /SUPPLEMENT cub
    !----------------------------------------------------------------------
    character(len=*),       intent(in)    :: line
    type(option_t),         intent(in)    :: opt
    type(auxiliary_user_t), intent(out)   :: user
    logical,                intent(inout) :: error
    !
    character(len=*),parameter :: rname='AUXILIARY>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call opt%present(line,user%do,error)
    if (error) return
    if (user%do) then
       call cubeadm_cubeid_parse(line,opt,user%id,error)
       if (error) return
    endif
  end subroutine cubemain_auxiliary_parse
  !
  subroutine cubemain_auxiliary_user2prog(opt,access,user,oucube,error)
    use cube_types
    use cubeadm_get
    !----------------------------------------------------------------------
    ! Resolve cubeid into a cube
    !----------------------------------------------------------------------
    type(option_t),         intent(in)    :: opt
    integer(kind=code_k),   intent(in)    :: access      ! Per spectrum/image/any?
    type(auxiliary_user_t), intent(in)    :: user
    type(cube_t), pointer,  intent(out)   :: oucube
    logical,                intent(inout) :: error
    !
    integer(kind=code_k) :: action
    character(len=*),parameter :: rname='AUXILIARY>USER2PROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    select case(opt%name)
    case("MASK","INITIAL")
       action = code_read
    case("LIKE")
       action = code_read_head
    case default
       call cubemain_message(seve%e,rname,"Don't know what to do if option is not /LIKE or /MASK")
       error = .true.
       return
    end select
    if (user%do) then
       call cubeadm_cubeid_get_header(opt,icube,user%id,access,action,oucube,error)
       if (error) return
    endif
  end subroutine cubemain_auxiliary_user2prog
end module cubemain_auxiliary
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_auxiliary_types
  use cubetools_parameters
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubemain_messaging
  !
  public :: auxiliary_opt_t,auxiliary_user_t
  private
  !
  type auxiliary_opt_t
     type(option_t), pointer :: opt
     logical                 :: present = .false.
   contains
     procedure, public :: register => cubemain_auxiliary_opt_register
     procedure, public :: parse    => cubemain_auxiliary_opt_parse
  end type auxiliary_opt_t
  !
  integer(kind=4), parameter :: icube = 1
  type auxiliary_user_t
     type(cubeid_user_t) :: id
   contains
     procedure, public :: toprog => cubemain_auxiliary_user_toprog
  end type auxiliary_user_t
  !
contains
  !
  subroutine cubemain_auxiliary_opt_register(auxiliary,&
       optname,optsyntax,optabstract,opthelp,&
       cubename,cubeabstract,cubeflags,cubemandatory,error)
    use cubedag_flag
    !----------------------------------------------------------------------
    ! Register a "/NAME cubeid" option
    !----------------------------------------------------------------------
    class(auxiliary_opt_t), intent(inout) :: auxiliary
    character(len=*),       intent(in)    :: optname
    character(len=*),       intent(in)    :: optsyntax
    character(len=*),       intent(in)    :: optabstract
    character(len=*),       intent(in)    :: opthelp
    character(len=*),       intent(in)    :: cubename
    character(len=*),       intent(in)    :: cubeabstract
    type(flag_t),           intent(in)    :: cubeflags(:)
    integer(kind=code_k),   intent(in)    :: cubemandatory
    logical,                intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: rname='AUXILIARY>OPT>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         optname,&
         optsyntax,&
         optabstract,&
         opthelp,&
         auxiliary%opt,&
         error)
    if (error) return
    call cubearg%register(&
         cubename,&
         cubeabstract,&
         strg_id,&
         cubemandatory,&
         cubeflags,&
         error)
    if (error) return
  end subroutine cubemain_auxiliary_opt_register
  !
  subroutine cubemain_auxiliary_opt_parse(auxiliary,line,user,error)
    !----------------------------------------------------------------------
    ! /NAME cubeid
    !----------------------------------------------------------------------
    class(auxiliary_opt_t), intent(inout) :: auxiliary
    character(len=*),       intent(in)    :: line
    type(auxiliary_user_t), intent(inout) :: user
    logical,                intent(inout) :: error
    !
    character(len=*),parameter :: rname='AUXILIARY>OPT>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call auxiliary%opt%present(line,auxiliary%present,error)
    if (error) return
    if (auxiliary%present) then
       call cubeadm_cubeid_parse(line,auxiliary%opt,user%id,error)
       if (error) return
    endif
  end subroutine cubemain_auxiliary_opt_parse
  !
  subroutine cubemain_auxiliary_user_toprog(user,auxiliary,access,action,oucube,oustatus,error)
    use cube_types
    use cubeadm_get
    !----------------------------------------------------------------------
    ! Resolve cubeid into a cube
    !----------------------------------------------------------------------
    class(auxiliary_user_t), intent(in)    :: user
    type(auxiliary_opt_t),   intent(in)    :: auxiliary
    integer(kind=code_k),    intent(in)    :: access
    integer(kind=code_k),    intent(in)    :: action
    type(cube_t), pointer,   intent(inout) :: oucube
    logical,                 intent(out)   :: oustatus
    logical,                 intent(inout) :: error
    !
    integer(kind=4), parameter :: ioucube = 1
    character(len=*),parameter :: rname='AUXILIARY>USER>TOPROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    oustatus = auxiliary%present
    if (oustatus) then
       call cubeadm_cubeid_get_header(auxiliary%opt,ioucube,user%id,&
            access,action,oucube,error)
       if (error) return
    endif
  end subroutine cubemain_auxiliary_user_toprog
end module cubemain_auxiliary_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
