!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
subroutine sub_clean (line,error)
  use gkernel_interfaces
  use mapping_interfaces, except_this=>sub_clean
  use clean_def
  use clean_arrays
  use clean_types
  use gbl_message
  !$  use omp_lib
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING Internal routine
  !     Implementation of all standard CLEAN deconvolution algorithms,
  !----------------------------------------------------------------------
  character(len=*), intent(in)    :: line
  logical,          intent(inout) :: error
  !
  real(8), parameter :: pi=3.14159265358979323846d0
  character(len=*), parameter :: rname='SUB_CLEAN'
  !
  integer ier, ipen, nx, ny, np
  integer(kind=size_length) mtot
  logical limits
  real ylimn,ylimp
  logical :: clean_extrema=.true.
  integer :: mthread, plot_case, nc
  !
  call sic_get_logi('CLEAN_EXTREMA',clean_extrema,error)
  call sic_get_inte('FIRST',method%first,error)
  call sic_get_inte('LAST',method%last,error)
  call sic_i4(line,0,1,method%first,.false.,error)
  call sic_i4(line,0,2,method%last,.false.,error)
  method%thresh = 0.30
  call sic_get_real('THRESHOLD',method%thresh,error)
  if (method%first.eq.0) method%first = 1
  if (method%last.eq.0) method%last = hdirty%gil%dim(3)
  method%first = max(1,min(method%first,hdirty%gil%dim(3)))
  method%last = max(method%first,min(method%last,hdirty%gil%dim(3)))
  !
  call check_area(method,hdirty,.false.)
  call check_mask(method,hdirty)
  user_method%do_mask = method%do_mask
  !
  nc = hdirty%gil%dim(3)
  call cct_prepare(line,nc,method,rname,error)
  !
  ! Set the pointers for use in subroutines
  hdirty%r3d => ddirty
  hclean%r3d => dclean
  hbeam%r4d  => dbeam
  hresid%r3d => dresid
  hprim%r4d  => dprim
  hmask%r3d => dmask
  !
  limits = sic_present(1,0)
  if (limits) then
    call sic_r4 (line,1,1,ylimn,.true.,error)
    if (error) return
    call sic_r4 (line,1,2,ylimp,.true.,error)
    if (error) return
  else
    ylimp = sqrt (float(method%m_iter+200) *   &
     &      log(float(method%m_iter+1)) ) * method%gain
    if (-hdirty%gil%rmin.gt.1.3*hdirty%gil%rmax) then
      ! Probably negative
      ylimn = ylimp*hdirty%gil%rmin
      ylimp = 0.0
    elseif (-1.3*hdirty%gil%rmin.gt.hdirty%gil%rmax) then
      ! Probably positive
      ylimn = 0.0
      ylimp = ylimp*hdirty%gil%rmax
    else
      ! Don't know...,
      ylimn = ylimp*hdirty%gil%rmin
      ylimp = ylimp*hdirty%gil%rmax
    endif
  endif
  ! Usefull variables
  nx = hdirty%gil%dim(1)
  ny = hdirty%gil%dim(2)
  np = max(1,hprim%gil%dim(1))
  !
  ! Beam patch according to Method
  if (method%method.eq.'CLARK'.or.   &
     &    method%method.eq.'MRC') then
    if (user_method%patch(1).ne.0) then
      method%patch(1) = min(user_method%patch(1),nx)
    else
      method%patch(1) = min(nx,max(32,nx/4))
    endif
    if (user_method%patch(2).ne.0) then
      method%patch(2) = min(user_method%patch(2),ny)
    else
      method%patch(2) = min(ny,max(32,ny/4))
    endif
  elseif (method%method.eq.'SDI') then
    if (user_method%patch(1).ne.0) then
      method%patch(1) = min(user_method%patch(1),nx/4)
    else
      method%patch(1) = min(nx/2,max(16,nx/8))
    endif
    if (user_method%patch(2).ne.0) then
      method%patch(2) = min(user_method%patch(2),ny/4)
    else
      method%patch(2) = min(ny,max(16,ny/8))
    endif
  endif
  !
  ! Disable Plotting in Parallel mode
  mthread = 1
  !$  mthread = omp_get_max_threads()
  if (mthread.gt.1 .and. method%last.ne.method%first) then
    if (method%pcycle .or. method%pflux) then
      call map_message(seve%w,rname,'Ignoring /PLOT and /FLUX option in Parallel mode')
      method%pcycle = .false.
      method%pflux = .false.
    endif
    plot_case = 1
  else
    plot_case = 0
  endif
  !
  if (method%pflux) call init_flux90(method,hdirty,ylimn,ylimp,ipen)
  !
  ! Delete CCT variable
  call sic_delvariable('CCT',.false.,error)
  !
  ! Avoid array constructors (too touchy about Kind)
  method%bzone(1:2) = 1
  method%bzone(3:4) = hdirty%gil%dim(1:2)
  if (method%method.eq.'MRC') then
    call sub_mrc('MRC',method,hdirty,hresid,hclean,hbeam,hprim,d_mask, &
      &   error, plot_mrc)
  else
    if (plot_case.eq.1) then
      call sub_major(method,hdirty,hresid,hclean,hbeam,hprim,hmask, &
        &   dcct,d_mask,d_list,error, no_major_plot, no_next_flux)
    else
      call sub_major(method,hdirty,hresid,hclean,hbeam,hprim,hmask, &
        &   dcct,d_mask,d_list,error, major_plot90, next_flux90)
    endif
  endif
  !
  if (method%pflux .and. method%method.ne.'MRC') then
    call close_flux90(ipen,error)
  else
    call gr_execl('CHANGE DIRECTORY <GREG')
  endif
  !
  ! Reset extrema
  if (clean_extrema) then
    call map_message(seve%i,rname,'Computing extrema')
    hresid%loca%addr = locwrd(dresid)
    call gdf_get_extrema (hresid,error)
    hresid%gil%extr_words = def_extr_words
    !
    hclean%loca%addr = locwrd(dclean)
    call gdf_get_extrema (hclean,error)
    hclean%gil%extr_words = def_extr_words
  else
    hresid%gil%extr_words = 0
    hclean%gil%extr_words = 0
  endif
  !
  ! Specify clean beam parameters
  hclean%gil%reso_words = 3
  hclean%gil%majo = method%major
  hclean%gil%mino = method%minor
  hclean%gil%posa = pi*method%angle/180.0
  save_data(code_save_clean) = .true.
  save_data(code_save_resid) = .true.
  if (method%method.ne.'MRC') save_data(code_save_cct) = .true.
  !
  ! Save general parameters...
  user_method%ibeam = method%ibeam
  user_method%nlist = method%nlist
  !
  hsky%loca%size = 0 ! Reset the Sky (primary beam corrected) image
  call sic_delvariable ('SKY',.false.,error)
  !
  call sic_mapgildas ('CCT',hcct,error,dcct)
end subroutine sub_clean
!
subroutine clean_data(error)
  use gkernel_interfaces
  use mapping_interfaces, except_this=>clean_data
  use clean_def
  use clean_arrays
  use gbl_message
  !--------------------------------------------------------
  ! @ private
  !
  ! MAPPING
  !    Prepare Clean parameters
  !--------------------------------------------------------
  logical, intent(out) :: error
  !
  integer nx,ny,nc,nb,m_iter,ier
  logical :: reallocated
  character(len=*), parameter :: rname = 'CLEAN'
  !
  error = .false.
  if (hdirty%loca%size.eq.0) then
    call map_message(seve%e,rname,'No dirty image')
    error = .true.
  endif
  if (hbeam%loca%size.eq.0) then
    call map_message(seve%e,rname,'No dirty beam')
    error = .true.
  endif
  if (user_method%mosaic) then
    if (hprim%loca%size.eq.0) then
      call map_message(seve%e,rname,'No primary beam')
      error = .true.
    endif
  endif
  if (error) return
  !
  ! Create clean image if needed
  nx = hdirty%gil%dim(1)
  ny = hdirty%gil%dim(2)
  nc = hdirty%gil%dim(3)
  !
  call gildas_null(hclean)
  call gdf_copy_header(hdirty,hclean,error)       ! Define header in all cases...
  if (error)  return
  call map_reallocate('CLEAN',dclean,nx,ny,nc,reallocated,error)
  if (error)  return
  if (reallocated) then
    call sic_delvariable('CLEAN',.false.,error)
    if (error)  return
    call sic_mapgildas('CLEAN',hclean,error,dclean)
    if (error)  return
  endif
  !
  call map_reallocate('RESIDUAL',dresid,nx,ny,nc,reallocated,error)
  if (error)  return
  if (reallocated) then
    hresid = hdirty
    call sic_delvariable('RESIDUAL',.false.,error)
    if (error)  return
    call sic_mapgildas('RESIDUAL',hresid,error,dresid)
    if (error)  return
  endif
  !
  call map_reallocate('LIST',d_list,nx*ny,reallocated,error)
  if (error)  return
  call map_reallocate('MASK',d_mask,nx,ny,reallocated,error)
  if (error)  return
  if (reallocated) then
    call sic_delvariable('THEMASK',.false.,error)
    if (error)  return
    call sic_def_inte_addr('THEMASK',d_mask,2,hdirty%gil%dim,.true.,error)
    if (error)  return
    user_method%do_mask = .true.
  endif
  if (user_method%do_mask) then
    user_method%nlist = 0
  endif
  !
  ! Clean Component Table
  !
  ! Must define M_ITER before allocating space
  m_iter = user_method%m_iter
  if (m_iter.eq.0) then
     call beam_unit_conversion(user_method)
     call copy_method(user_method,method)
     call check_area(method,hdirty,.true.)
     m_iter = method%m_iter
  else
     call copy_method(user_method,method)
  endif
  !
  ! Allocate weight and check beam/image compatibility
  !
  if (user_method%mosaic) then
    !  Mosaic mode check...
    if (hbeam%gil%dim(3).ne.hprim%gil%dim(1)) then
      call map_message(seve%e,rname, &
      & 'MOSAIC mode: Beam and Primary have different pointings')
      error = .true.
    endif
    !
    if (hbeam%gil%dim(4).ne.hprim%gil%dim(4)) then
      call map_message(seve%e,rname, &
      & 'MOSAIC mode: Beam and Primary have different frequencies')
      error = .true.
    endif
    if (error) return
    nb = hbeam%gil%dim(4)
    !
    call map_reallocate('WEIGHT',weight,nx,ny,nb,reallocated,error)
    if (error)  return
    if (reallocated) then
      user_method%weight => weight
    endif
    !
  elseif (hbeam%gil%dim(3).ne.1) then
!! Currently, ordering is unclear...
    if (hbeam%gil%dim(3).ne.hdirty%gil%dim(3)) then
      call map_message(seve%w,rname,'Different beam and image spectral resolution, '// &
      'not fully tested yet')
      !! error = .true.
      ! Single field verification
    endif
    !!
    call map_message(seve%e,rname,'More than 1 pointing, and Mosaic mode OFF')
    error = .true.
  endif
  !
  ! Frequency matching case
  if (hbeam%gil%dim(4).le.1) then
    continue
  elseif (hbeam%gil%dim(4).ne.hdirty%gil%dim(3)) then
    call map_message(seve%w,rname,'Different beam and image spectral resolution, '// &
    'not fully tested yet')
    !! error = .true.
  endif
end subroutine clean_data
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
