!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module mapping_dump
  use gbl_message
  !
  public :: dump_comm
  private
  !
contains
  !
  subroutine dump_comm(line,error)
    use gkernel_interfaces
    use uv_buffer_tool, only: uv_dump_buffers
    use clean_def
    use clean_arrays
    use clean_types
    use mapping_default_types
    use mapping_interfaces, only: mapping_print_debug
    use uv_map, only: uv_clean_sizes
    !----------------------------------------------------------------------
    ! Dump debug information
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    character(len=4) meth
    integer :: n,nc,ier
    integer, allocatable :: mic(:)
    !
    call sic_ke(line,0,1,meth,n,.false.,error)
    if (error) return
    if (meth.eq.'USER') then
       call mapping_print_debug(user_method)
    else if (meth.eq.'METH') then
       call mapping_print_debug(method)
    else if (meth.eq.'BUFF') then
       call uv_dump_buffers('DUMP')
    else if (meth.eq.'SG') then
       !
       nc = huv%gil%nchan
       if (nc.ne.hcct%gil%dim(2)) then
          print *,'Mismatch number of channels between HUV ',nc,' and CCT ',hcct%gil%dim(2)
       endif
       !
       allocate(mic(nc),stat=ier)
       call uv_clean_sizes(hcct,dcct,mic,1,nc)
       print *,'DEBUG -- MIC ',mic
       deallocate(mic)
    else
       print *,'DEBUG  BUFFers|METHod|SG|USER'
    endif
  end subroutine dump_comm
end module mapping_dump
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
