subroutine com_modify(line,error)
  use gkernel_interfaces
  use imager_interfaces, only : map_message 
  use phys_const
  use clean_arrays
  use clean_types
  use gbl_message
  !-----------------------------------------------------
  ! @ private
  !
  ! MAPPING  Support for command
  !   SPECIFY KeyWord Value
  !-----------------------------------------------------
  character(len=*), intent(inout) :: line
  logical, intent(out) :: error
  !
  character(len=*), parameter :: rname = 'SPECIFY'
  integer, parameter :: icode_uv=1, icode_dirty=2, icode_clean=3, icode_sky=4
  !
  integer, parameter :: nterm=4
  character(len=12) :: term(nterm),chain,key,cline,clines(4)
  data term/'FREQUENCY', 'LINENAME', 'TELESCOPE', 'VELOCITY' /
  integer :: i, iterm, narg, nc
  real(8) :: freq, freq_a,freq_b,value(3)
  real(4) :: velo
  real(8) :: freqs(4)
  real(4) :: velos(4)
  logical :: do_freq, do_line, do_velo
  !
  freq = 0.d0
  velo = -1.e8
  do_freq = .false.
  do_line = .false.
  do_velo = .false.
  !
  if (hdirty%loca%size.ne.0) then
    freq = hdirty%gil%freq
    velo = hdirty%gil%voff
    cline = hdirty%char%line
    clines(icode_dirty) = hdirty%char%line
    freqs(icode_dirty) = freq
    velos(icode_dirty) = velo
  endif
  if (hclean%loca%size.ne.0) then
    freq = hclean%gil%freq
    velo = hclean%gil%voff
    cline = hclean%char%line
    clines(icode_clean) = hclean%char%line
    freqs(icode_clean) = freq
    velos(icode_clean) = velo
  endif
  if (hsky%loca%size.ne.0) then
    freq = hsky%gil%freq
    velo = hsky%gil%voff
    cline = hsky%char%line
    clines(icode_sky) = hsky%char%line
    freqs(icode_sky) = freq
    velos(icode_sky) = velo
  endif
  !
  ! UV data must be last, to be pre-dominant in case
  ! a new UV table is read, but Images are not recomputed.
  !
  ! Some warning should be given then
  if (huv%loca%size.ne.0) then
    if (freq.ne.0 .and. abs(freq-huv%gil%freq).gt.1.d0) then  ! MHz
      call map_message(seve%w,rname,'Images and UV data have different frequencies')
    endif
    freq = huv%gil%freq
    if (velo.ne.1.e8 .and. abs(velo-huv%gil%voff).gt.1.d-3) then ! km/s
      call map_message(seve%w,rname,'Images and UV data have different velocity frames')
    endif
    velo = huv%gil%voff
    cline = huv%char%line
    clines(icode_uv) = huv%char%line
    freqs(icode_uv) = freq
    velos(icode_uv) = velo
  endif
  !
  narg = sic_narg(0)
  do i = 1, narg, 2
    call sic_ke(line,0,i,chain,nc,.true.,error)
    if (error) return
    call sic_ambigs(rname,chain,key,iterm,term,nterm,error)
    if (error) return
    !
    select case (key)
    case ('FREQUENCY')
      ! Modify velocity scale according to new rest frequency [MHz]
      call sic_r8(line,0,i+1,freq,.true.,error)
      do_freq = .true.
      !
    case ('VELOCITY')
      ! Modify Frequency scale according to new velocity (km/s)
      call sic_r4(line,0,i+1,velo,.true.,error)
      do_velo = .true.
      !
    case ('LINENAME')
      call sic_ch(line,0,i+1,cline,nc,.true.,error)
      do_line = .true.
    case ('TELESCOPE')
      call sic_ke(line,0,i+1,chain,nc,.true.,error)
      if (error) return
      !
      ! Update current UV and Initial UV data set
      if (huv%loca%size.ne.0) then
        if (huv%gil%nteles.ge.1) then
          if (huv%gil%teles(1)%ctele .ne. chain(1:nc)) then
            call map_message(seve%i,rname,'Telescope ' &
            & //trim(huv%gil%teles(1)%ctele) &
            & //' in UV data overwritten by /TELESCOPE '//chain(1:nc)) 
            ! Undefine the telescope so that all characteristics
            ! are re-defined by gdf_addteles after
            huv%gil%teles(1)%ctele = ' '
            huvi%gil%teles(1)%ctele = ' '
          endif
        endif
        call gdf_addteles(huv,'TELE',chain(1:nc),value,error)
        call gdf_addteles(huvi,'TELE',chain(1:nc),value,error)
      endif
    end select
    if (error) return
  enddo
  !
  ! Now which ones ...
  if (do_freq) freqs = freq
  if (do_velo) velos = velo
  if (do_line) clines = cline
  !
  if (huv%loca%size.ne.0) then
    freq_b = gdf_uv_frequency(huv,1.d0)
    call gdf_modify(huv,velos(icode_uv),freqs(icode_uv),error=error)
    freq_a = gdf_uv_frequency(huv,1.d0)
    if (abs(freq_a-freq_b).gt.10.0) then
      Print *,'Frequency Before ',freq_b
      Print *,'Frequency After ',freq_a
      Print *,'Frequency Difference ',freq_a-freq_b
    endif
    huv%char%line = clines(icode_uv)
  endif
  if (hdirty%loca%size.ne.0) then
    call gdf_modify(hdirty,velos(icode_dirty),freqs(icode_dirty),error=error)
    hdirty%char%line = clines(icode_dirty)
  endif
  if (hclean%loca%size.ne.0) then
    call gdf_modify(hclean,velos(icode_clean),freqs(icode_clean),error=error)
    hclean%char%line = clines(icode_clean)
  endif
  if (hsky%loca%size.ne.0) then
    call gdf_modify(hsky,velos(icode_sky),freqs(icode_sky),error=error)
    hsky%char%line = clines(icode_sky)
  endif
  !
end subroutine com_modify

