!
! Definitions used by UV_INVERT / UV_MAP
!
module uvmap_def
  type par_uvmap
     real taper(4)    ! UV taper
     character(len=4) mode  ! Weighting mode
     real field(2)     ! Field of view
     integer size(2)   ! Image size
     real xycell(2)    ! Image cell
     real uniform(2)   ! Robust weighting parameter
     real support(2)   ! Support size in meters
     real uvcell(2)    ! Cell size in meters
     integer channels(3)  ! First, Last and Weight channels
     integer ctype     ! Convolution type
     integer beam      ! One beam every N channels
     logical shift     ! Shift phase center
     logical blocked   ! Use blocking factor, or not (Debug)
     character(len=16) ra_c
     character(len=16) dec_c
     real(kind=8) new(3)     ! New position and angle of shift/rotation
     real(kind=8) off(3)     ! Offset and angle of shift/rotation
     real(kind=8) xy(2)      ! Phase rotation ! R*4 for SortUV
     real(kind=8) cs(2)      ! Angle offsets  ! R*4 for LoadUV
     real(kind=8) freq       ! Frequency for U,V values
     integer uvcode    ! UVT or TUV order ?
  end type
  !
  type gridding
     real ubias            ! Bias of U coordinates
     real ubuff(4096)      ! Grid of values of the convolution
     real vbias            ! Bias of V coordinates
     real vbuff(4096)      ! Grid of values of the convolution
  end type gridding
  integer, parameter :: code_uvt=1  ! This MUST NOT be changed
  integer, parameter :: code_tuv=2  ! This MUST NOT be changed
end module uvmap_def
!
! Used by Mapping CLEAN tools
!
module clean_def
  !------------------------------------------------------------------------------
  ! Parameters of CLEAN deconvolution.
  !------------------------------------------------------------------------------
  !
  type gridding
     real ubias            ! Bias of U coordinates
     real ubuff(4096)      ! Grid of values of the convolution
     real vbias            ! Bias of V coordinates
     real vbuff(4096)      ! Grid of values of the convolution
  end type gridding
  !
  type uvmap_par
    real taper(4)              ! UV Taper
    integer size(2)            ! Map size
    real xycell(2)             ! Map cell
    real uvcell(2)             ! UV cell
    real uniform(2)            ! Weighting parameters
    integer wcol               ! Weighting channel
    integer ctype              ! Convolution mode
    real support(2)            ! Support of gridding function
    integer beam               ! One beam every N channels
    real field(2)              ! Field of view in arcsecond
    real precis                ! Precision at map edges
    real truncate              ! Truncation level in %
    character mode*8           ! Weighting mode
    logical shift              ! Shift or rotate UV data
    character ra_c*16          ! Right ascension
    character dec_c*16         ! Declination
    real angle                 ! New position angle of UV data
    integer nfields            ! Number and type of fields (<0 = phase, >0 = pointing)
    real, allocatable :: offxy(:,:)    ! Pointing or Phase offsets
    integer, allocatable :: ifields(:) ! start and end of fields
    ! real, pointer :: uvdata(:,:)       ! UV Data (not used)
  end type
  !-----
  type clean_par
    sequence
    integer first,last         ! First & Last plane
    integer nlist              ! List size
    integer iplane             ! Current image plane
    integer ibeam              ! Current beam plane
    integer imask              ! Current mask plane 
    !
    real thresh                ! Threshold for beam fit
    real gain                  ! Loop gain
    real fres                  ! Fractional residual
    real ares                  ! Absolute residual
    real ratio                 ! Smoothing ratio for MRC
    real spexp                 ! Speed up factor in Clark
    real phat                  ! Prussian hat
    real flux                  ! Cleaned Flux
    real smooth                ! Multi-Scale smoothing factor
    real search                ! Threshold for searching
    real restor                !           for restoration
    real trunca                ! Beam truncation value
    real worry                 ! Worry factor in MultiScale
    integer nker(3)            ! Kernel for Multi-Scale clean
    real gains(3)              ! Clean gains
    integer ninflate           ! Component "inflation" factor
    integer ngoal              ! Maximum number of minor cycle components
    logical keep               ! Convergence criterium 
    integer m_iter             ! Maximum number of iterations
    integer n_iter             ! Current number of iterations
    integer p_iter             ! Positive number of iterations
    integer n_major            ! Maximum number of major cycle
    !
    real major                 ! Major axis
    real minor                 ! Minor axis
    real angle                 ! Clean beam angle
    real beam_min              ! Beam minimum
    real beam_max              ! Beam maximum
    real bgain                 ! Outer sidelobe
    !
    integer blc(2)             ! Bottom Left Corner
    integer trc(2)             ! Top Right Corner
    integer box(4)             ! Cleaning Box
    integer beam0(2)           ! Beam center X,Y
    integer patch(2)           ! Beam patch sizes
    integer bzone(4)           ! Beam patch
    integer bshift(3)          ! Beam shift
    !
    logical mosaic             ! Mosaic flag
    logical pflux              ! Flux display
    logical pcycle             ! Residual display in cycle
    logical pmrc               ! MRC display in cycle
    logical qcycle             ! Query mode
    logical pclean             ! Clean display in cycle
    logical do_mask            ! Re-compute the mask ?
    logical verbose            ! Lots of printout ?
    character method*12        ! METHOD
    real, pointer :: weight(:,:,:) ! Mosaic weights (as function of freq)
!    integer, pointer :: list(:)    ! List of selected pixels
!    logical, pointer :: mask(:,:)  ! Selection mask
  end type
  !-----
  type cct_par                 ! Clean Component definition
    real influx                ! Current flux
    real value                 ! Component value
    integer ix                 ! X pixel
    integer iy                 ! Y pixel
    integer type               ! Component kernel number
  end type
end module clean_def
!
module mod_fitbeam
  integer :: nv                ! Number of values
  real :: par(6)  ! Fitted parameters
  real :: err(6)  ! Errorbars
  real :: spar(6) ! Last fitted values
  real :: sigbas  ! rms on baseline
  real :: sigrai  ! rms on line
  integer :: kpar(6)  ! Code for parameter
  real, allocatable :: ip_values(:)    ! Values
  real, allocatable :: ip_coords(:,:)  ! Coordinates
end module mod_fitbeam


