subroutine display_buffer(comm,line,error)
  use gkernel_interfaces
  use mapping_interfaces, only : display_buffer_sub, map_message
  use clean_arrays
  use clean_def
  use clean_types
  use gbl_message
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING support routine for command
  !     SHOW Name
  !----------------------------------------------------------------------
  character(len=*), intent(in)  :: comm  ! Command (SHOW or VIEW)
  character(len=*), intent(in)  :: line  ! Command line
  logical,          intent(out) :: error ! Logical error flag
  ! Local variables
  integer ntype,nc
  character argu*12,dtype*12
  !
  ! Parse input line
  call sic_ke(line,0,1,argu,nc,.true.,error)
  if (error) return
  if (argu.eq.'?') argu = ' '
  call sic_ambigs(comm,argu,dtype,ntype,vtype,mtype,error)
  if (error) return
  !
  ! Special case for FIELDS
  if (dtype.eq.'FIELDS') then
    if (hprim%loca%size.eq.0 .or. comm.eq.'SHOW') then
      if (themap%nfields.eq.0) then
        call map_message(seve%e,comm,'No Mosaic loaded')
        error = .true.
      else
        call exec_program('@ p_plot_fields.map FIELDS')
      endif
      return
    endif
  endif
  !
  ! Display the buffer
  call display_buffer_sub(comm,ntype,line,error)
  if (sic_lire().eq.0) call sic_insert(line)
  !
end subroutine display_buffer
!
subroutine display_buffer_sub(comm,ntype,line,error)
  use gkernel_interfaces
  use mapping_interfaces, only : display_uv, buffer_copy
  use clean_types
  use clean_arrays
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING support routine for command
  !     SHOW Name
  !
  !----------------------------------------------------------------------
  character(len=*), intent(in) :: comm
  integer, intent(in)  :: ntype ! Buffer type
  logical, intent(out) :: error ! Logical error flag
  character(len=*), intent(in) :: line
  !
  character(len=40) :: argu1,argu2,chain,c_more
  integer :: nc
  logical :: do_dirty
  character(len=12) :: xtype,ytype
  !
  ! Load into SIC buffer
  if (comm.eq.'SHOW' .and. ntype.eq.1) then
    call sic_get_char('XTYPE',xtype,nc,error)
    call sic_get_char('YTYPE',ytype,nc,error)
    call buffer_copy('UV','W',w_plot,error)
    call sic_let_char('XTYPE','u',error)
    call sic_let_char('YTYPE','v',error)
    chain = 'UV'
    call display_uv (chain,error)
    call sic_let_char('XTYPE',xtype,error)
    call sic_let_char('YTYPE',ytype,error)
    return
  endif
  !
  call buffer_copy(vtype(ntype),'W',w_plot,error)
  if (error) return
  ! Plot SIC buffer with adequate plotting procedure
  if (comm.eq.'SHOW' .or. comm.eq.'UV_FLAG') then
    if (vtype(ntype).eq.'UV') then
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       argu2 = ' '
       call sic_ch(line,0,3,argu2,nc,.false.,error)
       chain = vtype(ntype)//' '//trim(argu1)//' '//trim(argu2)
       call display_uv(chain,error)
    else if (vtype(ntype).eq.'CCT') then
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       call exec_program('@ p_cct_w.map w '//argu1)
    else
       c_more = ' '
       call sic_get_logi('DO_DIRTY',do_dirty,error)
       if (do_dirty) then
         call buffer_copy('BEAM','BPLOT',b_plot,error)
         c_more = 'BPLOT'
       endif
       !
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       argu2 = ' '
       call sic_ch(line,0,3,argu2,nc,.false.,error)
       chain = vtype(ntype)//' W '//trim(c_more)//' '//trim(argu1)//' '//trim(argu2)
       call exec_program('@ p_plot_w.map '//chain)
    endif
  else if (comm.eq.'VIEW') then
    if (vtype(ntype).eq.'UV') then
       continue
    else if (vtype(ntype).eq.'CCT') then
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       argu2 = ' '
       call sic_ch(line,0,3,argu2,nc,.false.,error)
       chain = vtype(ntype)//' W '//trim(argu1)//' '//trim(argu2)
       call exec_program('@ p_cct_vue.map '//chain)
    else
       argu1 = ' '
       call sic_ch(line,0,2,argu1,nc,.false.,error)
       argu2 = ' '
       call sic_ch(line,0,3,argu2,nc,.false.,error)
       chain = vtype(ntype)//' W '//trim(argu1)//' '//trim(argu2)
       call exec_program('@ p_view_w.map '//chain)
    endif
  endif
  !
end subroutine display_buffer_sub
!
subroutine load_buffer(line,error)
  use gkernel_interfaces
  use mapping_interfaces, only : buffer_copy
  use clean_types
  use clean_default
  use clean_arrays
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING support routine for command
  !     LOAD Name
  !----------------------------------------------------------------------
  character(len=*), intent(in)  :: line  ! Command line
  logical,          intent(out) :: error ! Logical error flag
  !
  ! Local variables
  integer :: ntype,nc
  character(len=12) :: argu, d_type
  !
  ! Parse input line
  call sic_ke(line,0,1,argu,nc,.true.,error)
  if (error) return
  if (argu.eq.'?') argu = ' '
  call sic_ambigs('LOAD',argu,d_type,ntype,vtype,mtype,error)
  if (error) return
  ! Load into SIC buffer
  call buffer_copy(d_type,'W',w_plot,error)
  if (error) return
  !
end subroutine load_buffer
!
subroutine buffer_copy(atype,namew,gw,error)
  use image_def
  use gkernel_interfaces
  use mapping_interfaces, only : map_message
  use clean_def
  use gbl_message
  use clean_arrays
  use clean_types
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING support routine for commands
  !     LOAD and SHOW Name
  !----------------------------------------------------------------------
  character(len=*), intent(in) :: atype
  character(len=*), intent(in) :: namew
  type(gildas), intent(inout) :: gw
  logical, intent(out) :: error
  ! Global
  include 'gbl_memory.inc'
  ! Local
  character(len=*), parameter :: rname='LOAD'
  integer(kind=address_length) :: ipw
  integer(kind=index_length) :: dim(4)
  !
  ! Read header
  gw%loca%size = 0
  select case (atype)
  case ('UV')
    call gdf_copy_header(huv,gw,error)
    gw%loca%addr = locwrd(duv)
  case ('BEAM')
    call gdf_copy_header(hbeam,gw,error)
    gw%loca%addr = locwrd(dbeam)
  case ('DIRTY')
    call gdf_copy_header(hdirty,gw,error)
    gw%loca%addr = locwrd(ddirty)
  case ('CLEAN')
    call gdf_copy_header(hclean,gw,error)
    gw%loca%addr = locwrd(dclean)
  case ('MASK')
    call gdf_copy_header(hmask,gw,error)
    gw%loca%addr = locwrd(dmask)
  case ('RESIDUAL')
    call gdf_copy_header(hresid,gw,error)
    gw%loca%addr = locwrd(dresid)
  case ('CCT')
    call gdf_copy_header(hcct,gw,error)
    gw%loca%addr = locwrd(dcct)
  case ('SKY')
    call gdf_copy_header(hsky,gw,error)
    gw%loca%addr = locwrd(dsky)
  case ('FIELDS','PRIMARY')
    call create_fields(error)
    if (.not.error) then
      call gdf_copy_header(hfields,gw,error)
      gw%loca%addr = locwrd(dfields)
    endif
  case default
    call map_message(seve%e,rname,'Unsupported type '//atype)
    error = .true.
    return
  end select
  !
  ! Pass table address to SIC buffer
  if (gw%loca%size.eq.0) then
    call map_message(seve%e,rname,'Image not defined '//atype)
    error =.true.
    return
  endif
  call sic_delvariable(namew,.false.,error)
  ipw = gag_pointer(gw%loca%addr,memory)
  !
  if (atype.eq.'BEAM') then
    ! Squeeze degenerate dimensions for Beams
    if (gw%gil%dim(3).eq.1) then
      gw%gil%dim(3) = max(1,gw%gil%dim(4))
      gw%gil%dim(4) = 1
      gw%gil%ndim = 3
    endif
  endif
  dim(1:4) = gw%gil%dim(1:4)
  call sic_def_real_addr(namew,memory(ipw),gw%gil%ndim,dim,.true.,error)
  !
end subroutine buffer_copy
!
subroutine create_fields(error)
  use gkernel_interfaces
  use clean_arrays
  use clean_types
  !----------------------------------------------------------------------
  ! @ private
  !
  ! MAPPING internalroutine for command
  !     Create the FIELDS array (transposed version of the PRIMARY array)
  !----------------------------------------------------------------------
  logical, intent(out) :: error
  ! Local variables
  !
  character(len=4) :: code
  integer(kind=index_length) :: nfirst,nsecon,nmiddl,nelems,nlast,iblock(5)
  integer :: ier
  !
  if (hprim%loca%size.eq.0) then
    error = .true.
    return
  endif
  error = .false.
  !
  ! If it is allocated, it should be the right one, but play safe...
  if (allocated(dfields)) then
    if (hfields%loca%size.eq.hprim%loca%size) return
    deallocate(dfields)
  endif
  call gildas_null(hfields)
  !
  code = '231'
  call gdf_transpose_header(hprim,hfields,code,error)
  ! Determine chunk sizes from code and dimensions.
  call transpose_getblock(hprim%gil%dim,gdf_maxdims,code,iblock,error)
  if (error) return
  !
  ! With only one beam per frequency so far
  if (.not.allocated(dfields)) then
    allocate(dfields(hprim%gil%dim(2),hprim%gil%dim(3),hprim%gil%dim(1),hprim%gil%dim(4)),stat=ier)
    if (ier.ne.0) then
      error = .true.
      return
    endif
  endif
  !
  nelems = iblock(1)
  nfirst = iblock(2)
  nmiddl = iblock(3)
  nsecon = iblock(4)
  nlast  = iblock(5)
  call trans4all(dfields,dprim,nelems,nfirst,nmiddl,nsecon,nlast)
  !
  ! Set Type of First Axis
  hfields%gil%inc(3) = 1.0
  hfields%char%code(3) = 'FIELD'
end subroutine create_fields
