subroutine clean_beam (line,error)
  use gkernel_interfaces
  use clean_def
  use clean_arrays
  use gbl_message
  use imager_interfaces, only : map_message, get_clean
  !-------------------------------------------------------------
  ! FIT [First Last] [PLANE|CHANNEL|FIELD First Last] [PLANE|CHANNEL|FIELD First Last]
  !-------------------------------------------------------------
  character(len=*), intent(in) :: line
  logical, intent(inout) :: error
  real, parameter :: sec=acos(-1.0)/180./3600.
  !
  character(len=*), parameter :: rname = 'FIT'
  integer, parameter :: o_thresh=1
  integer :: jplane, nfield, cfirst, clast, ffirst, flast, nchan, jfield, k, iarg, itype, narg
  real, save, target :: fit_major, fit_minor, fit_angle
  integer, parameter :: mtype=3
  character(len=12) :: name
  !
  logical, save :: first_call=.True.
  character(len=8) :: ctype(mtype), argum, ktype
  data ctype /'CHANNEL','PLANE','FIELD'/
  !
  if (huv%loca%size.eq.0) then
    call map_message(seve%e,rname,'No UV data')
    error = .true.
    return
  endif
  !
  if (hbeam%loca%size.eq.0) then
    call map_message(seve%e,rname,'No Dirty Beam')
    error = .true.
    return
  endif
  !
  nchan = hbeam%gil%dim(hbeam%gil%faxi)
  !
  nfield = 1
  if (hbeam%char%code(3).eq.'FIELD') then
    nfield = hbeam%gil%dim(3)
  endif
  if (hbeam%gil%ndim.gt.3) then
    if (hbeam%char%code(4).eq.'FIELD') then
      nfield = hbeam%gil%dim(4)
    endif
  endif
  !
  ffirst = 1
  flast = 0
  cfirst = 1
  clast = 0
  narg = sic_narg(0)
  !
  if ((nfield.gt.1).and.(nchan.gt.1)) then
    !
    ! Required Keyword FIELD or PLANE or CHANNEL
    iarg = 1
    do while (iarg.le.narg)
      argum = ' '
      call sic_ke(line,0,1,argum,k,.true.,error)
      if (error) return
      call sic_ambigs('FIT',argum,ktype,itype,ctype,mtype,error)
      if (error) return
      iarg = iarg+1
      !
      if (itype.eq.3) then ! FIELD
        ffirst = 1
        call sic_i4 (line,0,iarg,ffirst,.false.,error)
        if (iarg.eq.narg) then
          flast = ffirst
        else
          iarg = iarg+1
          flast = 0
          call sic_i4 (line,0,iarg,flast,.false.,error)
          if (error) return
        endif
      else
        cfirst = 1
        call sic_i4 (line,0,iarg,cfirst,.false.,error)
        if (iarg.eq.narg) then
          clast = cfirst
        else
          iarg = iarg+1
          clast = 0
          call sic_i4 (line,0,iarg,clast,.false.,error)
          if (error) return
        endif
        if (error) return
      endif
      iarg = iarg+1
    enddo
    !
  else if (narg.gt.0) then     
    ! Here, keywords are optional
    argum = ' '
    call sic_ke(line,0,1,argum,k,.false.,error)
    if (nchan.gt.1) then
      !  only CHANNEL or PLANE is allowed
      if ((argum(1:1).ne.'P').and.(argum(1:1).ne.'C')) then
        iarg = 1
      else
        call sic_ambigs(' ',argum,ktype,itype,ctype,2,error)
        if (.not.error) iarg = 2
        error = .false.
      endif
      cfirst = 1
      call sic_i4 (line,0,iarg,cfirst,.false.,error)
      iarg = iarg+1
      clast = 0
      call sic_i4 (line,0,iarg,clast,.false.,error)
      if (error) return
    else
      ! only FIELD is allowed
      if (argum(1:1).ne.'F') then
        iarg = 1
      else
        call sic_ambigs(' ',argum,ktype,itype,ctype(3),1,error)
        if (.not.error) iarg = 2
        error = .false.
      endif
      ffirst = 1
      call sic_i4 (line,0,iarg,ffirst,.false.,error)
      iarg = iarg+1
      flast = 0
      call sic_i4 (line,0,iarg,flast,.false.,error)
      if (error) return
    endif    
    !
  endif
  if (flast.le.0) flast = nfield+flast
  if (clast.le.0) clast = nchan+clast
  !
  cfirst = min(max(1,cfirst),nchan)
  clast = max(cfirst,min(clast,nchan))
  ffirst = min(max(1,ffirst),nfield)
  flast = max(ffirst,min(flast,nfield))
  !
  method%thresh = user_method%thresh
  call sic_r4(line,o_thresh,1,method%thresh,.false.,error)
  if (error) return
  !
  fit_major = 0
  fit_minor = 0
  fit_angle = 0
  k = 0
  !
  name = method%method
  method%method = '  '
  do jfield = ffirst, flast
    do jplane = cfirst, clast
      method%major = 0.0
      method%minor = 0.0
      method%angle = 0.0
      !
      if (hbeam%gil%faxi.eq.3) then
        call get_clean (method, hbeam, dbeam(:,:,jplane,jfield),error)
      else
        call get_clean (method, hbeam, dbeam(:,:,jfield,jplane),error)
      endif
      call pribeam('FIT',method%major,method%minor,method%angle,jfield,jplane)
      !
      fit_major = fit_major + method%major/sec
      fit_minor = fit_minor + method%minor/sec
      fit_angle = fit_angle + method%angle ! In Degree ?
      k = k+1
    enddo
  enddo
  method%method = name
  fit_major = fit_major/k
  fit_minor = fit_minor/k
  fit_angle = fit_angle/k
  !
  if (first_call) then
    call sic_def_real('BEAM_MAJOR',fit_major,0,0,.true.,error)
    call sic_def_real('BEAM_MINOR',fit_minor,0,0,.true.,error)
    call sic_def_real('BEAM_ANGLE',fit_angle,0,0,.true.,error)
    first_call = .false.
  endif
end subroutine clean_beam
!
subroutine new_dirty_beam
  use gkernel_interfaces
  use clean_def
  use clean_arrays
  !
  ! needed when a new dirty map is computed by command uv_map:
  logical :: error
  error = .false.
  !
  if (allocated(dclean)) deallocate(dclean)
  call sic_delvariable ('CLEAN',.false.,error)
  hclean%loca%size = 0
  !
  if (allocated(dresid)) deallocate(dresid)
  call sic_delvariable ('RESIDUAL',.false.,error)
  hresid%loca%size = 0
  !
  if (allocated(dcct)) deallocate(dcct)
  call sic_delvariable ('CCT',.false.,error)
  hcct%loca%size = 0
  !
  if (allocated(dsky)) deallocate(dsky)
  call sic_delvariable ('SKY',.false.,error)
  hsky%loca%size = 0
end subroutine new_dirty_beam
