module cubeedit_show
  use cubetools_structure
  use cubeedit_messaging
  !
  public :: show
  public :: cubeedit_show_command
  private
  !
  type :: show_comm_t
     type(option_t), pointer :: comm
   contains
     procedure, public  :: register => cubeedit_show_register
     procedure, private :: parse    => cubeedit_show_parse 
     procedure, private :: main     => cubeedit_show_main  
  end type show_comm_t
  type(show_comm_t) :: show
  !
  type show_user_t
     character(len=varn_l) :: edid
  end type show_user_t
  !
contains
  !
  subroutine cubeedit_show_command(line,error)
    !-------------------------------------------------------------------
    ! Support routine for command SHOW
    !-------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(show_user_t) :: user
    character(len=*), parameter :: rname='SHOW>COMMAND'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call show%parse(line,user,error)
    if (error) return
    call show%main(user,error)
    if (error) return
  end subroutine cubeedit_show_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubeedit_show_register(show,error)
    !-------------------------------------------------------------------
    ! Register EDIT\SHOW and its options
    !-------------------------------------------------------------------
    class(show_comm_t), intent(inout) :: show
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: comm_abstract = &
         'Show the header of a cube in editing mode'
    character(len=*), parameter :: comm_help = strg_id
    !
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: rname='SHOW>REGISTER'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'SHOW','[newid]',&
         comm_abstract,&
         comm_help,&
         cubeedit_show_command,&
         show%comm,error)
    if (error) return
    call stdarg%register(&
         'NewId', &
         'Editing Identifier', &
         strg_id,&
         code_arg_optional, error)
    if (error) return
    !
  end subroutine cubeedit_show_register
  !
  subroutine cubeedit_show_parse(show,line,user,error)
    !-------------------------------------------------------------------
    ! Parse routine for command SHOW
    !-------------------------------------------------------------------
    class(show_comm_t), intent(in)    :: show
    character(len=*),   intent(in)    :: line
    type(show_user_t),  intent(out)   :: user
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='SHOW>PARSE'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    user%edid = strg_star
    call cubetools_getarg(line,show%comm,1,user%edid,.not.mandatory,error)
    if (error) return
    !
  end subroutine cubeedit_show_parse
  !
  subroutine cubeedit_show_main(show,user,error)
    use cubeedit_cube_buffer
    !-------------------------------------------------------------------
    ! Main routine for command SHOW
    !-------------------------------------------------------------------
    class(show_comm_t), intent(in)    :: show
    type(show_user_t),  intent(in)    :: user
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='SHOW>MAIN'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call cubeedit_bufferlist_show(user%edid,error)
    if (error) return
  end subroutine cubeedit_show_main
end module cubeedit_show
