!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubefield_gradient
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubemain_sperange_types
  use cubefield_messaging
  ! 
  public :: cubefield_gradient_register,cubefield_gradient_command
  private
  !
  type :: gradient_comm_t
     type(option_t), pointer :: gradient  
     type(option_t), pointer :: factor
     type(sperange_opt_t)    :: range
   contains
     procedure, private :: parse => cubefield_gradient_parse
     procedure, private :: main  => cubefield_gradient_main
  end type gradient_comm_t
  type(gradient_comm_t) :: comm
  !
  integer(kind=4), parameter :: icube = 1
  type gradient_user_t
     type(cubeid_user_t)   :: cube
     type(sperange_user_t) :: range
     character(len=argu_l) :: factor
     logical               :: dofactor = .false.
   contains
     procedure, private :: toprog => cubefield_gradient_user_toprog
  end type gradient_user_t
  type gradient_prog_t
     type(sperange_prog_t) :: range
     real(kind=sign_k)     :: factor
     type(cube_t), pointer :: incube
     type(cube_t), pointer :: oucube
   contains
     procedure, private :: header => cubefield_gradient_prog_header
     procedure, private :: data   => cubefield_gradient_prog_data
     procedure, private :: loop   => cubefield_gradient_prog_loop
     procedure, private :: act    => cubefield_gradient_prog_act
  end type gradient_prog_t
  !
contains
  !
  subroutine cubefield_gradient_register(error)
    use cubedag_parameters
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract = 'Field command for working image wise'
    character(len=*), parameter :: comm_help = &
         'Input and output cube ares real'
    character(len=*), parameter :: rname='GRADIENT>REGISTER'
    !
    call cubefield_message(fieldseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'GRADIENT','[cube]',&
         comm_abstract,&
         comm_help,&
         cubefield_gradient_command,&
         comm%gradient,error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Signal cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         error)
    if (error) return
    !
    call comm%range%register(&
         'RANGE',&
         'Define velocity range(s)',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'FACTOR','factor',&
         'Multiply data by a factor',&
         strg_id,&
         comm%factor,error)
    if (error) return
    call stdarg%register(&
         'factor',&
         'factor',&
         'default is 1',&
         code_arg_mandatory, error)
    if (error) return
  end subroutine cubefield_gradient_register
  !
  subroutine cubefield_gradient_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(gradient_user_t) :: user
    character(len=*), parameter :: rname='GRADIENT>COMMAND'
    !
    call cubefield_message(fieldseve%trace,rname,'Welcome')
    !
    call comm%parse(line,user,error)
    if (error) return
    call comm%main(user,error)
    if (error) continue
  end subroutine cubefield_gradient_command
  !
  subroutine cubefield_gradient_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! GRADIENT cubname
    ! /RANGE vfirst vlast
    ! /FACTOR factor
    !----------------------------------------------------------------------
    class(gradient_comm_t), intent(in)    :: comm
    character(len=*),      intent(in)    :: line
    type(gradient_user_t),  intent(out)   :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='GRADIENT>PARSE'
    !
    call cubefield_message(fieldseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,comm%gradient,user%cube,error)
    if (error) return
    call comm%range%parse(line,user%range,error)
    if (error) return
    call cubefield_gradient_parse_factor(line,comm%factor,user%factor,user%dofactor,error)
    if (error) return
  end subroutine cubefield_gradient_parse
  !
  subroutine cubefield_gradient_parse_factor(line,opt,user,dofactor,error)
    !----------------------------------------------------------------------
    ! /FACTOR factor
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    character(len=*), intent(out)   :: user
    logical,          intent(out)   :: dofactor
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: rname='GRADIENT>PARSE>FACTOR'
    !
    call cubefield_message(fieldseve%trace,rname,'Welcome')
    !
    call opt%present(line,dofactor,error)
    if (error) return
    if (dofactor) then
       call cubetools_getarg(line,opt,1,user,mandatory,error)
       if (error) return
    endif
  end subroutine cubefield_gradient_parse_factor
  !
  subroutine cubefield_gradient_main(comm,user,error)    
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(gradient_comm_t), intent(in)    :: comm
    type(gradient_user_t),  intent(inout) :: user
    logical,                intent(inout) :: error
    !
    type(gradient_prog_t) :: prog
    character(len=*), parameter :: rname='GRADIENT>MAIN'
    !
    call cubefield_message(fieldseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubefield_gradient_main
  !
  subroutine cubefield_gradient_user_toprog(user,prog,error)
    use cubetools_user2prog
    use cubetools_unit
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(gradient_user_t), intent(in)    :: user
    type(gradient_prog_t),  intent(out)   :: prog
    logical,                intent(inout) :: error
    !
    type(unit_user_t) :: nounit
    character(len=*), parameter :: rname='GRADIENT>USER>TOPROG'
    !
    call cubefield_message(fieldseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(comm%gradient,icube,user%cube,&
         code_access_imaset,code_read,prog%incube,error)
    if (error) return
    !
    call user%range%toprog(prog%incube,prog%range,error)
    if (error) return
    !
    if (user%dofactor) then
       call cubetools_unit_get(strg_star,code_unit_unk,nounit,error)
       if (error) return
       call cubetools_user2prog_resolve_star(user%factor,nounit,1.0,prog%factor,error)
       if (error) return
    else
       prog%factor = 1.0
    endif
  end subroutine cubefield_gradient_user_toprog
  !
  subroutine cubefield_gradient_prog_header(prog,error)
    use cubedag_parameters
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(gradient_prog_t), intent(inout) :: prog
    logical,                intent(inout) :: error
    !
    character(len=*), parameter :: rname='GRADIENT>PROG>HEADER'
    !
    call cubefield_message(fieldseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%incube,flag_field,prog%oucube,error)
    if (error) return
  end subroutine cubefield_gradient_prog_header
  !
  subroutine cubefield_gradient_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(gradient_prog_t), intent(inout) :: prog
    logical,                intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='GRADIENT>PROG>DATA'
    !
    call cubefield_message(fieldseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error)  exit
       !$OMP TASK SHARED(prog) FIRSTPRIVATE(iter,error)
       if (.not.error)  &
         call prog%loop(iter%first,iter%last,error)
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubefield_gradient_prog_data
  !   
  subroutine cubefield_gradient_prog_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubemain_image_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(gradient_prog_t), intent(inout) :: prog
    integer(kind=entr_k),   intent(in)    :: first
    integer(kind=entr_k),   intent(in)    :: last
    logical,                intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(image_t) :: inima,ouima
    character(len=*), parameter :: rname='GRADIENT>PROG>LOOP'
    !
    call inima%init(prog%incube,error)
    if (error) return
    call ouima%reallocate('ouima',prog%oucube%head%arr%n%l,prog%oucube%head%arr%n%m,error)
    if (error) return
    !
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error)  return
      call prog%act(ie,inima,ouima,error)
      if (error)  return
    enddo
  end subroutine cubefield_gradient_prog_loop
  !   
  subroutine cubefield_gradient_prog_act(prog,ie,inima,ouima,error)
    use cubemain_image_real
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(gradient_prog_t), intent(inout) :: prog
    integer(kind=entr_k),   intent(in)    :: ie
    type(image_t),          intent(inout) :: inima
    type(image_t),          intent(inout) :: ouima
    logical,                intent(inout) :: error
    !
    integer(kind=pixe_k) :: il,im
    character(len=*), parameter :: rname='GRADIENT>PROG>ACT'
    !
    call inima%get(prog%incube,ie,error)
    if (error)  return
    do il=1,prog%incube%head%arr%n%l
       do im=1,prog%incube%head%arr%n%m
          ouima%z(il,im) = prog%factor*inima%z(il,im)
       enddo ! im
    enddo ! il
    call ouima%put(prog%oucube,ie,error)
    if (error)  return
  end subroutine cubefield_gradient_prog_act
end module cubefield_gradient
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
