!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeio_interface
  use cubetools_header_interface
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! Support module for IO-specific actions on cube_header_interface_t
  !---------------------------------------------------------------------
  !
  public :: cubeio_interface_transpose
  private
  !
contains
  !
  subroutine cubeio_interface_transpose(interface,oorder,error)
    !-------------------------------------------------------------------
    ! Transpose, if needed, the interface to the requested order
    !-------------------------------------------------------------------
    type(cube_header_interface_t), intent(inout) :: interface
    integer(kind=code_k),          intent(in)    :: oorder
    logical,                       intent(inout) :: error
    !
    integer(kind=code_k) :: iorder
    integer(kind=ndim_k) :: tr(3)
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='INTERFACE>TRANSPOSE'
    !
    if (oorder.eq.code_access_any)  return  ! No particular access requested
    !
    iorder = cubeio_interface_order(interface)
    if (iorder.eq.oorder)  return  ! Already in correct access
    !
    if (iorder.eq.code_cube_imaset .and. &
        oorder.eq.code_cube_speset) then
      tr(:) = (/ 3,1,2 /)
    elseif (iorder.eq.code_cube_speset .and. &
            oorder.eq.code_cube_imaset) then
      tr(:) = (/ 2,3,1 /)
    else
      write(mess,'(A,I0,A,I0)')  &
        'Do not know how to transpose from order ',iorder,' to order',oorder
      call cubeio_message(seve%e,rname,mess)
      error = .true.
      return
    endif
    !
    call interface%transpose(tr,error)
    if (error)  return
  end subroutine cubeio_interface_transpose
  !
  function cubeio_interface_order(interface)
    integer(kind=code_k) :: cubeio_interface_order
    type(cube_header_interface_t), intent(in) :: interface
    !
    if (interface%axset_ix.eq.1 .and. &
        interface%axset_iy.eq.2) then
      cubeio_interface_order = code_cube_imaset
    elseif (interface%axset_ic.eq.1) then
      cubeio_interface_order = code_cube_speset
    else
      cubeio_interface_order = code_cube_unkset
    endif
  end function cubeio_interface_order
end module cubeio_interface
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
